package asteroid.ui;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JComponent;
import javax.swing.border.Border;

public abstract class ABaseBox {
	public static void addBorder( JComponent target, Border border) {
		if (target.getBorder() != null) {
			target.setBorder( BorderFactory.createCompoundBorder( border, target.getBorder()));
		}
		else {
			target.setBorder( border);
		}
	}

	public static void addColorBorder( JComponent comp, Color color) {
		addBorder( comp, BorderFactory.createLineBorder( color));
	}

	public static void addEmptyBorder( JComponent target, int top, int left, int bottom, int right) {
		addBorder( target, BorderFactory.createEmptyBorder( top, left, bottom, right));
	}

	public static Box createHorizontalBox( boolean fix) {
		return new FixBox( BoxLayout.X_AXIS, fix);
	}

	public static Box createHorizontalBox( Color co) {
		return new FixBox( BoxLayout.X_AXIS, co, false);
	}

	public static Box createHorizontalBox( boolean fix, Color co) {
		return new FixBox( BoxLayout.X_AXIS, co, fix);
	}

	public static JComponent createHorizontalGlue( Color color) {
		JComponent result = (JComponent) Box.createHorizontalGlue();
		addColorBorder( result, color);
		return result;
	}

	public static JComponent createHorizontalStrut( int width, Color color) {
		JComponent result = (JComponent) Box.createHorizontalStrut( width);
		addColorBorder( result, color);
		return result;
	}

	public static Box createVerticalBox( boolean fix) {
		return new FixBox( BoxLayout.Y_AXIS, fix);
	}

	public static Box createVerticalBox( Color co) {
		return new FixBox( BoxLayout.Y_AXIS, co, false);
	}

	public static Box createVerticalBox( boolean fix, Color co) {
		return new FixBox( BoxLayout.Y_AXIS, co, fix);
	}

	public static JComponent createVerticalGlue( Color color) {
		JComponent result = (JComponent) Box.createVerticalGlue();
		addColorBorder( result, color);
		return result;
	}

	public static JComponent createVerticalStrut( int height, Color color) {
		JComponent result = (JComponent) Box.createVerticalStrut( height);
		addColorBorder( result, color);
		return result;
	}

	private static class FixBox extends Box {
		private static final long serialVersionUID = -7704265742906467223L;
		private Color mColor;
		private boolean mFixHigh;
		private boolean mFixWidth;

		public FixBox( int axis, boolean fix) {
			super( axis);
			if (fix) {
				if (axis == BoxLayout.X_AXIS) {
					mFixHigh = true;
				}
				else {
					mFixWidth = true;
				}
			}
		}

		public FixBox( int axis, Color co, boolean fix) {
			this( axis, fix);
			mColor = co;
		}

		public Dimension getMaximumSize() {
			if (mFixHigh) {
				return new Dimension( super.getMaximumSize().width, getPreferredSize().height);
			}
			if (mFixWidth) {
				return new Dimension( getPreferredSize().width, super.getMaximumSize().height);
			}
			return super.getMaximumSize();
		}

		protected void paintComponent( Graphics g) {
			if (mColor != null) {
				g.setColor( mColor);
				g.fillRect( 0, 0, getWidth(), getHeight());
			}
			super.paintComponent( g);
		}
	}
}
