package asteroid.ui;

import java.awt.Color;
import java.awt.Dimension;

import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

import asteroid.SimpleLogging;
import asteroid.model.Angle;
import asteroid.model.GameModel;
import asteroid.statistic.GameValues;

class StatusView extends JPanel {
	private static final long serialVersionUID = 8102741931793581425L;
	private static final int GAP = 10;
	private GameValues mGame;
	private GameModel mModel;
	private JLabel[] mMsg = new JLabel[SimpleLogging.MAX_Message];
	private JLabel mTxtCalc = createLabelBox();
	private JLabel mTxtForward = createLabelBox();
	private JLabel mTxtFrame = createLabelBox();
	private JLabel mTxtHits = createLabelBox();
	private JLabel mTxtLevel = createLabelBox();
	private JLabel mTxtLifes = createLabelBox();
	private JLabel mTxtPoints = createLabelBox();
	private JLabel mTxtRates = createLabelBox();
	private JLabel mTxtScore = createLabelBox();
	private JLabel mTxtShots = createLabelBox();
	private JLabel mTxtTime = createLabelBox();

	public StatusView( GameModel model, GameValues game, int width, int height) {
		mModel = model;
		mGame = game;
		for (int i = 0; i < SimpleLogging.MAX_Message; ++i) {
			JLabel label = new JLabel();
			mMsg[i] = label;
			label.setAlignmentX( LEFT_ALIGNMENT);
			label.setForeground( Color.getHSBColor( 0f, 0f, (float) i / SimpleLogging.MAX_Message));
		}
		Dimension size = new Dimension( width, height);
		setMinimumSize( size);
		setPreferredSize( size);
		ABaseBox.addBorder( this, BorderFactory.createLineBorder( getBackground().darker()));
		setOpaque( true);
		setLayout( new BoxLayout( this, BoxLayout.X_AXIS));
		add( createStatusBox());
//		add( Box.createHorizontalStrut( GAP));
		add( createStatisticBox());
//		add( Box.createHorizontalStrut( GAP));
		add( Box.createHorizontalGlue());
		add( createMessageBox());
	}

	private static JLabel createLabelBox() {
		JLabel lbl = new JLabel();
		lbl.setAlignmentX( RIGHT_ALIGNMENT);
//		ABaseBox.addColorBorder( lbl, Color.BLUE);
		return lbl;
	}

	private Box createMessageBox() {
		Box box = Box.createVerticalBox();
		ABaseBox.addEmptyBorder( box, 0, GAP, 0, GAP);
		ABaseBox.addBorder( box, BorderFactory.createTitledBorder( "Nachrichten"));
		box.setPreferredSize( new Dimension( 240, 100));
		for (int i = 0; i < SimpleLogging.MAX_Message; ++i) {
			box.add( mMsg[i]);
		}
		box.add( Box.createVerticalGlue());
		return box;
	}

	private Box createStatisticBox() {
		Box lbl = Box.createVerticalBox();
		lbl.add( new JLabel( "Punkte/min"));
		lbl.add( new JLabel( "Schuss"));
		lbl.add( new JLabel( "Treffer"));
		lbl.add( new JLabel( "Vorhalten"));
		lbl.add( new JLabel( "Framerate"));
		lbl.add( new JLabel( "Rechenzeit"));
		lbl.add( Box.createVerticalGlue());
		Box txt = Box.createVerticalBox();
		txt.add( mTxtPoints);
		txt.add( mTxtShots);
		txt.add( mTxtHits);
		txt.add( mTxtForward);
		txt.add( mTxtRates);
		txt.add( mTxtCalc);
		txt.add( Box.createVerticalGlue());
		Box box = Box.createHorizontalBox();
		ABaseBox.addEmptyBorder( box, 0, GAP, 0, GAP);
		ABaseBox.addBorder( box, BorderFactory.createTitledBorder( "Statistik"));
		box.add( lbl);
		box.add( Box.createHorizontalStrut( GAP));
		box.add( txt);
		return box;
	}

	private Box createStatusBox() {
		Box lbl = Box.createVerticalBox();
		lbl.add( new JLabel( "Level"));
		lbl.add( new JLabel( "Frame"));
		lbl.add( new JLabel( "Zeit"));
		lbl.add( new JLabel( "Punkte"));
		lbl.add( new JLabel( "Leben"));
		lbl.add( Box.createVerticalGlue());
		Box txt = Box.createVerticalBox();
		txt.add( mTxtLevel);
		txt.add( mTxtFrame);
		txt.add( mTxtTime);
		txt.add( mTxtScore);
		txt.add( mTxtLifes);
		txt.add( Box.createVerticalGlue());
		Box box = Box.createHorizontalBox();
		ABaseBox.addEmptyBorder( box, 0, GAP, 0, GAP);
		ABaseBox.addBorder( box, BorderFactory.createTitledBorder( "Status"));
		box.add( lbl);
		box.add( Box.createHorizontalStrut( GAP));
		box.add( txt);
		return box;
	}

	private String getTimeText( long played) {
		played /= 100;
		long milli = played % 10;
		played /= 10;
		long sec = played % 60;
		played /= 60;
		long min = played % 60;
		played /= 60;
		StringBuffer sb = new StringBuffer();
		if (played > 0) {
			sb.append( played);
			sb.append( ':');
			if (min < 10) {
				sb.append( '0');
			}
		}
		sb.append( min);
		sb.append( ':');
		if (sec < 10) {
			sb.append( '0');
		}
		sb.append( sec);
		sb.append( '.');
		sb.append( milli);
		return sb.toString();
	}

	void updateView() {
		mTxtLevel.setText( Integer.toString( mModel.getLevel()));
		mTxtTime.setText( getTimeText( mGame.getPlayTime()));
		mTxtFrame.setText( Integer.toString( mModel.getPlayFrame()));
		mTxtScore.setText( Integer.toString( mModel.getScore()));
		mTxtLifes.setText( Integer.toString( mModel.getLives()));
		for (int i = 0; i < SimpleLogging.MAX_Message; ++i) {
			mMsg[i].setText( SimpleLogging.getLog( i));
		}
		mTxtRates.setText( Double.toString( Math.round( 10.0 * mGame.getAverageFrames()) / 10.0));
		mTxtPoints.setText( (mModel.getPlayFrame() > 50) ? Long.toString( 3600L * mModel.getScore() / mModel.getPlayFrame()) : "0");
		mTxtShots.setText( Integer.toString( mModel.getShots()));
		int rate = (mModel.getShots() > 0) ? ((100 * mModel.getHits()) / mModel.getShots()) : 0;
		mTxtHits.setText( "(" + Integer.toString( rate) + "%)  " + Integer.toString( mModel.getHits()));
		mTxtForward.setText( Integer.toString( Angle.sForward));
		mTxtCalc.setText( Double.toString( Math.round( 10.0 * mGame.getCalcTime()) / 10.0) + "ms");
	}
}
