package asteroid;

import junit.framework.TestCase;

/*
 * Test Integer Square Root function
 */
public class SquareRootTest extends TestCase {
	public void testAccuracy() {
		for (int i = 0; i < 10000000; ++i) {
			int exp = (int) (Math.sqrt( i) + 0.5);
			int c = SquareRoot.sqrt( i);
			int d = SquareRoot.fastSqrt( i);
			int akt = SquareRoot.accurateSqrt( i);
			if (exp != exp) {
				fail( "N:" + i + " - Math.sqrt+:" + exp + " - accurateSqrt:" + akt + " - fastSqrt:" + d + " - sqrt:" + c);
			}
		}
	}

	public void testSpeed() {
		// SquareRoot.fast_sqrt()...
		long oldtime = System.currentTimeMillis();
		for (int i = 0; i < 10000000; i++) {
			SquareRoot.fastSqrt( i);
		}
		long newtime = System.currentTimeMillis();
		System.out.println( "SquareRoot.fast_sqrt:" + (newtime - oldtime));
		// SquareRoot.sqrt()...
		oldtime = System.currentTimeMillis();
		for (int i = 0; i < 10000000; i++) {
			SquareRoot.sqrt( i);
		}
		newtime = System.currentTimeMillis();
		System.out.println( "SquareRoot.sqrt:" + (newtime - oldtime));
		// SquareRoot.accurateSqrt()...
		oldtime = System.currentTimeMillis();
		for (int i = 0; i < 10000000; i++) {
			SquareRoot.accurateSqrt( i);
		}
		newtime = System.currentTimeMillis();
		System.out.println( "SquareRoot.accurateSqrt:" + (newtime - oldtime));
		// Math.sqrt()...
		oldtime = System.currentTimeMillis();
		for (int i = 0; i < 10000000; i++) {
			Math.sqrt( i);
		}
		newtime = System.currentTimeMillis();
		System.out.println( "Math.sqrt:" + (newtime - oldtime));
	}
}
