package asteroid.model;

import junit.framework.TestCase;

public class ColliderTest extends TestCase {
	private static final int SIZE_SHIP = 80;

	public ColliderTest( String name) {
		super( name);
	}

	private void distance( FlyInfo ship, FlyInfo ast, int min) {
		double dx = ship.mX8 - ast.mX8;
		double dy = ship.mY8 - ast.mY8;
		double ds2 = (dx * dx) + (dy * dy);
		System.out.print( "Dist=" + Math.sqrt( ds2));
		min += SIZE_SHIP;
		double dr2 = min * min;
		double dvx = ship.mMoveX8 - ast.mMoveX8;
		double dvy = ship.mMoveY8 - ast.mMoveY8;
		double dv2 = (dvx * dvx) + (dvy * dvy);
		double da = (dx * dvy) - (dy * dvx);
		double temp2 = Math.sqrt( (dr2 * dv2) - (da * da));
		double db = (dx * dvx) + (dy * dvy);
		double t1 = (-db + temp2) / dv2;
		double t2 = (-db - temp2) / dv2;
		System.out.print( "  t1=" + t1);
		System.out.print( "  t2=" + t2);
		System.out.print( "  ds1=" + Math.sqrt( ((dx + (t1 * dvx)) * (dx + (t1 * dvx))) + ((dy + (t1 * dvy)) * (dy + (t1 * dvy)))));
		System.out.print( "  ds2=" + Math.sqrt( ((dx + (t2 * dvx)) * (dx + (t2 * dvx))) + ((dy + (t2 * dvy)) * (dy + (t2 * dvy)))));
		System.out.println();
	}

	void hitNear( FlyInfo ship, FlyInfo fly, int sizeF) {
		int det = (fly.mMoveY8 * fly.mMoveY8) + (fly.mMoveX8 * fly.mMoveX8);
		if (det == 0) {
			System.out.println( "fly und ship stehen");
		}
		int dx = ship.mX8 - fly.mX8;
		int dy = ship.mY8 - fly.mY8;
		int c = (dy * fly.mMoveX8) - (dx * fly.mMoveY8);
		int x = ship.mX8 + (c * fly.mMoveY8 / det);
		int y = ship.mY8 - (c * fly.mMoveX8 / det);
		boolean hitShip = hitShip( ship, fly, x, y, sizeF);
		System.out.println( "x=" + x + " y=" + y + " isHit=" + hitShip);
	}

	boolean hitShip( FlyInfo ship, FlyInfo fly, int x, int y, int sizeF) {
		// (ship - SIZE/2) bis (ship + moveS + SIZE/2)
		// (fly - SIZE/2)  bis (fly + moveF + SIZE/2)
		int size = (sizeF + SIZE_SHIP) >> 1;
		if (isOutside( ship.mX8, ship.mMoveX8, x, size)) {
			return false;
		}
		if (isOutside( ship.mY8, ship.mMoveY8, y, size)) {
			return false;
		}
		if (isOutside( fly.mX8, fly.mMoveX8, x, size)) {
			return false;
		}
		if (isOutside( fly.mY8, fly.mMoveY8, y, size)) {
			return false;
		}
		return true;
	}

	boolean isOutside( int p0, int move, int p, int size) {
		int dp;
		if (move < 0) {
			dp = p0 - p;
			move = -move;
		}
		else {
			dp = p - p0;
		}
		return (dp < -size) || (dp > (move + size));
	}

	public void testB() {
		hitNear( new FlyInfo( 4192, 4192, 12, 0, 0), new FlyInfo( 3640, 3960, 0, 6, 6), 320);
		hitNear( new FlyInfo( 4192, 4192, 12, 0, 0), new FlyInfo( 3700, 4020, 0, 6, 6), 320);
		hitNear( new FlyInfo( 4192, 4192, 12, 0, 0), new FlyInfo( 3760, 4080, 0, 6, 6), 320);
		hitNear( new FlyInfo( 4192, 4192, 12, 0, 0), new FlyInfo( 3816, 4136, 0, 6, 6), 320);
		hitNear( new FlyInfo( 4192, 4192, 12, 0, 0), new FlyInfo( 3840, 4160, 0, 6, 6), 320);
		hitNear( new FlyInfo( 4192, 4192, 12, 0, 0), new FlyInfo( 3848, 4168, 0, 6, 6), 320);
	}

	public void xtestA() {
		distance( new FlyInfo( 4192, 4192, 12, 0, 0), new FlyInfo( 3700, 4020, 0, 6, 6), 320);
		distance( new FlyInfo( 4192, 4192, 12, 0, 0), new FlyInfo( 3760, 4080, 0, 6, 6), 320);
		distance( new FlyInfo( 4192, 4192, 12, 0, 0), new FlyInfo( 3784, 4104, 0, 6, 6), 320);
		distance( new FlyInfo( 4192, 4192, 12, 0, 0), new FlyInfo( 3800, 4120, 0, 6, 6), 320);
		distance( new FlyInfo( 4192, 4192, 12, 0, 0), new FlyInfo( 3808, 4128, 0, 6, 6), 320);
		distance( new FlyInfo( 4192, 4192, 12, 0, 0), new FlyInfo( 3816, 4136, 0, 6, 6), 320);
		distance( new FlyInfo( 4192, 4192, 12, 0, 0), new FlyInfo( 3840, 4160, 0, 6, 6), 320);
		distance( new FlyInfo( 4192, 4192, 12, 0, 0), new FlyInfo( 3848, 4168, 0, 6, 6), 320);
		distance( new FlyInfo( 4192, 4192, 12, 0, 0), new FlyInfo( 3864, 4184, 0, 6, 6), 320);
		distance( new FlyInfo( 4192, 4192, 12, 0, 0), new FlyInfo( 3864, 4192, 0, 6, 6), 320); // hit
	}
}
