package asteroid.model;

import junit.framework.TestCase;

public class JumpTest extends TestCase {
	private GameModel mModel = new GameModel( null);

	public JumpTest( String name) {
		super( name);
	}

	public void testA() {
		Collider coll = mModel.mCollider;
        mModel.parse( "Frame 2788    2       S:4192,4192,12,0,0,..       u:1312,2008,15,16,0,..      a0:6088,5832,0,-4,-7,..     A1:7368,1880,15,-6,11,..    a2:6040,5920,0,-8,10,..     A3:7064,1736,14,-7,-6,..    A4:4552,6624,14,-13,6,..    a5:6080,5872,0,-14,11,..    A6:5944,1720,14,-10,-6,..   A7:6744,6632,14,6,6,..      E8:4920,6392,0,-15,7,..     a9:4960,6272,0,-15,6,..     a10:2456,3088,0,6,-6,..     a11:1952,2568,0,-18,25,..   E12:1968,4472,13,6,6,..     a13:5832,2408,0,-18,17,..   A14:7280,4496,15,-6,-10,..  a15:3184,3136,0,-13,-10,..  a16:0,0,0,0,0,..            a17:0,0,0,0,0,..            a18:0,0,0,0,0,..            a19:0,0,0,0,0,..            a20:0,0,0,0,0,..            a21:0,0,0,0,0,..            a22:0,0,0,0,0,..            a23:0,0,0,0,0,..            a24:0,0,0,0,0,..            a25:0,0,0,0,0,..            a26:0,0,0,0,0,..            m0:2016,4392,15,-63,6,..    m1:4984,6224,15,23,59,..    m2:4848,6416,15,18,61,..    M3:5424,2224,15,18,61,..    M4:3984,4296,15,43,-58,..   m5:6640,1352,15,-47,-7,..   ");
		coll.detect( Angle.sForward);
		assertEquals( ICompute.KEY_HYPERSPACE, coll.getKey());
        mModel.parse( "Frame 17739 2 s:3680,5216,12,0,0,..       u:2504,2544,14,-16,0,..     a0:6616,6808,0,-9,6,..      a1:6160,6816,0,-8,-6,..     A2:6104,6544,0,-6,-15,..    A3:6104,2032,0,-6,-6,..     a4:3808,5384,0,-17,-10,..   A5:3824,3872,0,11,-6,..     A6:7456,3336,0,-6,-11,..    A7:3128,3360,0,9,-10,..     a8:6800,2152,0,-12,6,..     A9:2784,2352,0,8,-6,..      A10:4496,1944,0,12,-15,..   A11:0,6536,14,9,-11,..      a12:6800,2120,0,-7,-8,..    A13:1296,3384,14,-24,-16,.. A14:2064,4008,14,-7,8,..    A15:2312,5064,14,-6,31,..   A16:1712,1072,14,-8,18,..   A17:2792,2744,15,-22,12,..  A18:4016,5784,15,-15,-6,..  a19:6776,2184,0,-7,8,..     A20:4912,4512,14,-12,-24,.. A21:7696,3112,14,6,6,..     a22:6736,2192,0,-15,7,..    a23:3976,5448,0,-8,17,..    a24:5288,1792,0,6,13,..     a25:0,0,0,0,0,..            a26:0,0,0,0,0,..            m0:3760,5344,15,32,56,..    m1:6672,2144,15,61,17,..    m2:6672,2144,15,61,17,..    m3:6656,2208,15,60,21,..    m4:6896,7136,15,44,-22,..   m5:6472,2408,15,47,-2,..    ");
		coll.detect( Angle.sForward);
		assertEquals( 0, coll.getKey());
//		initModel( "Frame 2501	S:4192,4192,12,0,0,..	    u:1280,5064,15,16,0,..	A0:6488,1440,0,-6,-7,..	    E1:2512,5456,13,8,-16,..	A2:6664,3000,0,-12,7,..	    A3:3112,1352,0,11,-15,..	A4:6488,3824,0,-6,-14,..    A5:1760,3352,14,30,6,..	E6:2488,5536,14,11,-6,..    A7:5616,2720,0,-14,6,..	E8:2504,5472,13,1,-9,..	    A9:7128,3768,14,10,9,..	E10:2568,5432,12,9,-8,..    A11:2568,5528,14,8,7,..	A12:3936,6232,14,15,-29,..  A13:2552,5280,14,7,-30,..	A14:2648,5296,14,23,-26,..  a15:2928,2720,0,14,-14,..	a16:0,0,0,0,0,..	    a17:0,0,0,0,0,..		a18:0,0,0,0,0,..	    a19:0,0,0,0,0,..		a20:0,0,0,0,0,..	    a21:0,0,0,0,0,..		a22:0,0,0,0,0,..	    a23:0,0,0,0,0,..		a24:0,0,0,0,0,..	    a25:0,0,0,0,0,..		a26:0,0,0,0,0,..	    M0:4192,4720,15,0,63,..	m1:2648,5448,15,-49,40,..   m2:2648,5448,15,-49,40,..	m3:2592,5488,15,-49,40,..   m4:6496,1040,15,-40,30,..	m5:0,0,0,0,0,..		    ");
//		mColl.detect( mForward);
//		assertEquals( 0, mColl.getKey());
//		initModel( "Frame 2502	S:4192,4192,12,0,0,..	    u:1280,5064,15,16,0,..	A0:6488,1432,0,-6,-7,..	    E1:2512,5456,13,8,-16,..	A2:6648,3008,0,-12,7,..	    A3:3120,1336,0,11,-15,..	A4:6488,3808,0,-6,-14,..    A5:1792,3352,14,30,6,..	E6:2488,5536,14,11,-6,..    A7:5600,2728,0,-14,6,..	E8:2504,5472,13,1,-9,..	    A9:7136,3776,14,10,9,..	E10:2568,5432,12,9,-8,..    A11:2576,5528,14,8,6,..	A12:3952,6200,14,15,-29,..  A13:2560,5248,14,7,-30,..	A14:2672,5264,14,23,-27,..  a15:2928,2720,0,14,-14,..	a16:0,0,0,0,0,..	    a17:0,0,0,0,0,..		a18:0,0,0,0,0,..	    a19:0,0,0,0,0,..		a20:0,0,0,0,0,..	    a21:0,0,0,0,0,..		a22:0,0,0,0,0,..	    a23:0,0,0,0,0,..		a24:0,0,0,0,0,..	    a25:0,0,0,0,0,..		a26:0,0,0,0,0,..	    M0:4192,4784,15,0,63,..	m1:2648,5448,15,-49,40,..   m2:2648,5448,15,-49,40,..	m3:2592,5488,15,-49,40,..   m4:6496,1040,15,-40,30,..	m5:0,0,0,0,0,..		    ");
//		mColl.detect( mForward);
//		assertEquals( 0, mColl.getKey());
//		assertEquals( ICompute.KEY_HYPERSPACE, mColl.getKey());
	}
}
