package asteroid.model;

import asteroid.Operation;
import asteroid.PrintWriterFormat;

import junit.framework.TestCase;

public class OptimalTest extends TestCase {
	private PrintWriterFormat mOut = new PrintWriterFormat( System.out);

	public OptimalTest( String name) {
		super( name);
	}

	static int minDist2( int dx0, int dy0, AEnemy enemy, int shotDir, int rotTime) {
		int dx = dx0 + (rotTime * enemy.mMoveX8) - Angle.posShotX( shotDir);
		int dy = dy0 + (rotTime * enemy.mMoveY8) - Angle.posShotY( shotDir);
		int dvx = enemy.mMoveX8 - Angle.vShotX( shotDir);
		int dvy = enemy.mMoveY8 - Angle.vShotY( shotDir);
		int k1 = (dy * dvx) - (dx * dvy);
		int k2 = (dvx * dvx) + (dvy * dvy);
		return k1 * k1 / k2;
	}

	static double nextAlpha( int dx0, int dy0, AEnemy enemy, double alpha, double shipRad, boolean left) {
		int shotDir = Angle.getAngle( alpha);
		double sr = alpha - shipRad;
		if (left) {
			if (sr < -Angle.PI_05) {
				sr += Angle.PI_2;
			}
		}
		else {
			if (sr > Angle.PI_05) {
				sr -= Angle.PI_2;
			}
		}
		double stepsRad = Angle.toAngle( sr) / 3.0;
		double rotTime = Math.abs( stepsRad);
		double dx = dx0 + (rotTime * enemy.mMoveX8) - Angle.posShotX( shotDir);
		double dy = dy0 + (rotTime * enemy.mMoveY8) - Angle.posShotY( shotDir);
		double shotSpeed8 = Angle.vShot( shotDir);
		double gamma = Math.atan2( dy, dx);
		double dBG = enemy.mBetha - gamma;
		double dAG = Math.asin( enemy.mVelocity * Math.sin( dBG) / shotSpeed8);
		if (dAG > Angle.PI_05) {
			dAG = Math.PI - dAG;
		}
		else if (dAG < -Angle.PI_05) {
			dAG = -Math.PI - dAG;
		}
		return dAG + gamma;
	}

	int printAll( AEnemy enemy, Ship ship, int shipDir, int time, int hx, int hy) {
		int signDir = Angle.signRot( shipDir);
		mOut.savePos();
		mOut.print( enemy.getIdent());
		mOut.fill( 6);
		mOut.print( time);
		mOut.fill( 6);
		int dx0 = Operation.signX8( enemy.getX8( time) - ship.mX8) + hx;
		int dy0 = Operation.signY8( enemy.getY8( time) - ship.mY8) + hy;
		double shipRad = Angle.toRadiant( signDir);
		double alpha = printAlpha( dx0, dy0, enemy, shipRad);
		int steps = printStep( dx0, dy0, enemy, alpha, shipRad);
		int rotTime = Math.abs( steps);
		int shotDir = shipDir + (3 * steps);
		mOut.print( shotDir);
		mOut.fill( 8);
		mOut.print( timeColl( dx0, dy0, enemy, shotDir, rotTime));
		mOut.fill( 8);
		int timeWait = timeWait( dx0, dy0, enemy, shotDir, rotTime);
		mOut.print( timeWait);
		mOut.fill( 8);
		mOut.print( minDist2( dx0, dy0, enemy, shotDir, rotTime + timeWait));
		mOut.fill( 8);
		mOut.println();
		return shotDir;
	}

	int printAllList( AEnemy enemy, Ship ship, int shipDir, int time, int hx, int hy) {
		int signDir = Angle.signRot( shipDir);
		mOut.savePos();
		mOut.print( enemy.getIdent());
		mOut.fill( 6);
		mOut.print( time);
		mOut.fill( 6);
		int dx0 = Operation.signX8( enemy.getX8( time) - ship.mX8) + hx;
		int dy0 = Operation.signY8( enemy.getY8( time) - ship.mY8) + hy;
		double shipRad = Angle.toRadiant( signDir);
		double alpha = Math.atan2( dy0, dx0);
		double stepsRad = Angle.toAngle( Angle.signRot( alpha - shipRad)) / 3.0;
		int[] steps = new int[43];
		int[] timeShot = new int[43];
		int[] timeEnemy = new int[43];
		boolean left = (dx0 * enemy.mMoveY8) > (dy0 * enemy.mMoveX8);
		if (left) {
			stepsRad = Math.ceil( stepsRad);
			int step = (int) stepsRad - 1;
			for (int i = 0; i < steps.length; ++i) {
				steps[i] = step;
				int shotDir = (shipDir + (3 * step)) & 0xFF;
				int rotTime = Math.abs( step);
				timeShot[i] = timeShot( dx0, dy0, enemy, shotDir, rotTime);
				timeEnemy[i] = timeEnemy( dx0, dy0, enemy, shotDir, rotTime);
				++step;
			}
		}
		else {
			stepsRad = Math.floor( stepsRad);
			int step = (int) stepsRad + 1;
			for (int i = 0; i < steps.length; ++i) {
				steps[i] = step;
				int shotDir = (shipDir + (3 * step)) & 0xFF;
				int rotTime = Math.abs( step);
				timeShot[i] = timeShot( dx0, dy0, enemy, shotDir, rotTime);
				timeEnemy[i] = timeEnemy( dx0, dy0, enemy, shotDir, rotTime);
				--step;
			}
		}
		for (int i = 0; i < steps.length; ++i) {
			mOut.print( (shipDir + (3 * steps[i])));
			mOut.print( ",");
			mOut.print( timeShot[i]);
			mOut.print( ",");
			mOut.print( timeEnemy[i]);
			mOut.fill( 16);
		}
		mOut.println();
		mOut.println();
		return 0;
	}

	double printAlpha( int dx0, int dy0, AEnemy enemy, double shipRad) {
		double alpha = Math.atan2( dy0, dx0);
//		mOut.print( round( Angle.toRoute( alpha)));
		mOut.print( Angle.getAngle( alpha));
		mOut.fill( 8);
		boolean left = Angle.signRot( alpha - shipRad) > 0;
		mOut.print( left);
		mOut.fill( 10);
		for (int i = 0; i < 3; ++i) {
			alpha = nextAlpha( dx0, dy0, enemy, alpha, shipRad, left);
//			mOut.print( round( Angle.toRoute( alpha)));
			mOut.print( Angle.getAngle( alpha));
			mOut.fill( 8);
		}
		return alpha;
	}

	void printColl( AEnemy enemy, Ship ship, int shipDir, int shotDir, int time, int hx, int hy) {
		int dx0 = Operation.signX8( enemy.getX8( time) - ship.mX8) + hx;
		int dy0 = Operation.signY8( enemy.getY8( time) - ship.mY8) + hy;
		int steps = (shipDir - shotDir) / 3;
		int rotTime = Math.abs( steps);
		int ox = Angle.vShotX( shotDir);
		int oy = Angle.vShotY( shotDir);
		int xa0 = dx0 + (rotTime * enemy.mMoveX8) - Angle.posShotX( shotDir);
		int ya0 = dy0 + (rotTime * enemy.mMoveY8) - Angle.posShotY( shotDir);
		for (int i = 0; i < 50; ++i) {
			mOut.savePos();
			int xa = xa0 + (i * enemy.mMoveX8);
			int ya = ya0 + (i * enemy.mMoveY8);
			int xo = (i * ox);
			int yo = (i * oy);
			mOut.print( xa);
			mOut.fill( 10);
			mOut.print( ya);
			mOut.fill( 10);
			mOut.print( xo);
			mOut.fill( 10);
			mOut.print( yo);
			mOut.fill( 10);
			int dx = xa - xo;
			int dy = ya - yo;
			int s2 = (dx * dx) + (dy * dy);
			mOut.print( s2);
			mOut.fill( 10);
			mOut.println();
		}
		mOut.print( minDist2( dx0, dy0, enemy, shotDir, rotTime));
		mOut.fill( 8);
		mOut.println();
	}

	void printQuadrant( Ship ship, int dx, int dy, int shipDir) {
		AEnemy ast0 = new Asteroid( 0, ship.mX8 + dx, ship.mY8 + dy, 14, 5, -10);
		printAll( ast0, ship, shipDir, 0, 0, 0);
		AEnemy ast1 = new Asteroid( 1, ship.mX8 + dx, ship.mY8 + dy, 14, 5, 10);
		printAll( ast1, ship, shipDir, 0, 0, 0);
		AEnemy ast2 = new Asteroid( 2, ship.mX8 + dx, ship.mY8 + dy, 14, -5, 10);
		printAll( ast2, ship, shipDir, 0, 0, 0);
		AEnemy ast3 = new Asteroid( 3, ship.mX8 + dx, ship.mY8 + dy, 14, -5, -10);
		printAll( ast3, ship, shipDir, 0, 0, 0);
		mOut.println();
	}

	int printStep( int dx0, int dy0, AEnemy enemy, double alpha, double shipRad) {
		boolean left = (dx0 * enemy.mMoveY8) > (dy0 * enemy.mMoveX8);
		mOut.print( left);
		mOut.fill( 10);
		double stepsRad = Angle.toAngle( Angle.signRot( alpha - shipRad)) / 3.0;
		mOut.print( round( stepsRad));
		mOut.fill( 8);
		if (stepsRad < 0) {
			if (left) {
				stepsRad = Math.ceil( stepsRad);
			}
			else {
				stepsRad = Math.floor( stepsRad);
			}
		}
		else {
			if (left) {
				stepsRad = Math.ceil( stepsRad);
			}
			else {
				stepsRad = Math.floor( stepsRad);
			}
		}
		return (int) stepsRad;
	}

	private static double round( double value) {
		return Math.round( 100.0 * value) / 100.0;
	}

	public void testA1() {
		int shipDir = 112;
		Ship ship = new Ship( 4192, 4192, 12, 0, 0);
		AEnemy ast = new Asteroid( 0, 904, 3616, 14, 6, -10);
		for (int i = 100; i < 200; i += 1) {
			printAll( ast, ship, shipDir, i, 0, 0);
			printAllList( ast, ship, shipDir, i, 0, 0);
//			print( ast, ship, i, shipDir, hx, hy);
		}
	}

	public void testA2() {
//		int shipDir = 112;
//		int hx = 0;
//		int hy = 0;
//		int time = 17;
//		int steps = -71;
//		Ship ship = new Ship( 4192, 4192, 12, 0, 0);
//		AEnemy enemy = new Asteroid( 0, 904, 3616, 14, 6, -10);
//		for (int i = 0; i < 15; ++i) {
//			int dx0 = Operation.signX8( enemy.getX8( time) - ship.mX8) + hx;
//			int dy0 = Operation.signY8( enemy.getY8( time) - ship.mY8) + hy;
//			int shotDir = shipDir + (3 * steps);
//			int rotTime = Math.abs( steps) + i;
//			int minDist2 = minDist2( dx0, dy0, enemy, shotDir, rotTime);
//			int timeColl = timeColl( dx0, dy0, enemy, shotDir, rotTime);
//			int timeWait = timeWait( dx0, dy0, enemy, shotDir, rotTime);
//			System.out.println( i + ": dist=" + minDist2 + " coll=" + timeColl + " wait=" + timeWait);
//		}
	}

	public void testB2() {
//		int shipDir = 112;
//		int time = 250;
//		Ship ship = new Ship( 4192, 4192, 12, 0, 0);
//		AEnemy ast = new Asteroid( 0, 904, 3616, 14, 6, -10);
//		int shotDir = printAll( ast, ship, shipDir, time, 0, 0);
//		printColl( ast, ship, shipDir, shotDir, time, 0, 0);
	}

	public void testQuadrantA() {
		int shipDir = 64;
		int dx = 1000;
		int dy = 1000;
		Ship ship = new Ship( 4192, 4192, 12, 0, 0);
		printQuadrant( ship, dx, dy, shipDir);
	}

	public void testQuadrantB() {
		int shipDir = 64;
		int dx = -1000;
		int dy = 1000;
		Ship ship = new Ship( 4192, 4192, 12, 0, 0);
		printQuadrant( ship, dx, dy, shipDir);
	}

	public void testQuadrantC() {
		int shipDir = 64;
		int dx = -1000;
		int dy = -1000;
		Ship ship = new Ship( 4192, 4192, 12, 0, 0);
		printQuadrant( ship, dx, dy, shipDir);
	}

	public void testQuadrantD() {
		int shipDir = 64;
		int dx = 1000;
		int dy = -1000;
		Ship ship = new Ship( 4192, 4192, 12, 0, 0);
		printQuadrant( ship, dx, dy, shipDir);
	}

	static int timeColl( int dx0, int dy0, AEnemy enemy, int shotDir, int rotTime) {
		int dx = dx0 + (rotTime * enemy.mMoveX8) - Angle.posShotX( shotDir);
		int dy = dy0 + (rotTime * enemy.mMoveY8) - Angle.posShotY( shotDir);
		int dvx = enemy.mMoveX8 - Angle.vShotX( shotDir);
		int dvy = enemy.mMoveY8 - Angle.vShotY( shotDir);
		int k1 = (dx * dvx) + (dy * dvy);
		if (k1 > 0) {
			return Short.MAX_VALUE;
		}
		int k2 = (dvx * dvx) + (dvy * dvy);
		return -k1 / k2;
	}

	static int timeEnemy( int dx0, int dy0, FlyInfo enemy, int shotDir, int rotTime) {
		int dx = dx0 + (rotTime * enemy.mMoveX8) - Angle.posShotX( shotDir);
		int dy = dy0 + (rotTime * enemy.mMoveY8) - Angle.posShotY( shotDir);
		int ox = Angle.vShotX( shotDir);
		int oy = Angle.vShotY( shotDir);
		int te = ((dx * oy) - (dy * ox)) / ((enemy.mMoveY8 * ox) - (enemy.mMoveX8 * oy));
		return (te >= 0) ? te : Short.MAX_VALUE;
	}

	static int timeShot( int dx0, int dy0, FlyInfo enemy, int shotDir, int rotTime) {
		int dx = dx0 + (rotTime * enemy.mMoveX8) - Angle.posShotX( shotDir);
		int dy = dy0 + (rotTime * enemy.mMoveY8) - Angle.posShotY( shotDir);
		int ox = Angle.vShotX( shotDir);
		int oy = Angle.vShotY( shotDir);
		int ts = ((dx * enemy.mMoveY8) - (dy * enemy.mMoveX8)) / ((enemy.mMoveY8 * ox) - (enemy.mMoveX8 * oy));
		return (ts >= 0) ? ts : Short.MAX_VALUE;
	}

	static int timeWait( int dx0, int dy0, AEnemy enemy, int shotDir, int rotTime) {
		int dx = dx0 + (rotTime * enemy.mMoveX8) - Angle.posShotX( shotDir);
		int dy = dy0 + (rotTime * enemy.mMoveY8) - Angle.posShotY( shotDir);
		int dvx = enemy.mMoveX8 - Angle.vShotX( shotDir);
		int dvy = enemy.mMoveY8 - Angle.vShotY( shotDir);
		int k2 = (enemy.mMoveX8 * dvy) - (enemy.mMoveY8 * dvx);
		if (k2 == 0) {
			return Short.MAX_VALUE;
		}
		int k1 = (dy * dvx) - (dx * dvy);
		int min = k1 / k2;
		if (min < 0) {
			return 0;
		}
		return min;
	}
}
