package asteroid.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.util.StringTokenizer;

import asteroid.Player;
import asteroid.printer.Position;

import junit.framework.TestCase;

public class ShotTest extends TestCase {
	private int mFireDirection;
	private BufferedReader mIS;
	private int mLastFrame;
	private Ship mShip = new Ship();
	private Ufo mUfo = new Ufo( mShip);
	private AsteroidVector mAsts = new AsteroidVector( mShip, mUfo);
	private Position mInfo = new Position( null, System.out);
	private ShotVector mShots = new ShotVector( mShip, mUfo);

	public ShotTest( String name) {
		super( name);
	}

	void printInfo() {
		mShip.doIt( mInfo);
		mInfo.getOut().print( '-');
		mUfo.doIt( mInfo);
		mInfo.getOut().print( '-');
		mShots.forAll( mInfo);
		mInfo.getOut().println();
	}

	private String readLine() {
		try {
			return mIS.readLine();
		}
		catch (Exception ex) {
			fail( ex.getMessage());
		}
		return null;
	}

	protected void tearDown() throws Exception {
		mIS.close();
	}

	public void testA() {
		String s = null;
		while ((s = readLine()) != null) {
			mAsts.prepare();
			mShip.prepare();
			mUfo.prepare();
			mShots.prepare();
			StringTokenizer st = new StringTokenizer( s);
			if (!st.hasMoreTokens()) {
				continue;
			}
			st.nextToken(); // "Frame"
			int frame = Integer.parseInt( st.nextToken().trim()); // frameNr
			if (mLastFrame < 0) {
				mLastFrame = frame;
			}
			else {
				++mLastFrame;
//				assertEquals( mLastFrame, frame);
				GameModel.sFrame = frame;
			}
			mFireDirection = Integer.parseInt( st.nextToken().trim()); // direction
			st.nextToken(); // "AAAA....."
			while (st.hasMoreTokens()) {
				String detect = st.nextToken();
				StringTokenizer dd = new StringTokenizer( detect, ":,");
				String type = dd.nextToken();
				int x = Integer.parseInt( dd.nextToken().trim()) >> 3;
				int y = Integer.parseInt( dd.nextToken().trim()) >> 3;
				int z = Integer.parseInt( dd.nextToken().trim());
				if ("S".equals( type)) {
					mShip.addShip( x, y, 10, 10);
					mShip.addShip( x, y, 20, 20);
				}
				else if ("U".equals( type)) {
					mUfo.addUfo( x, y, z);
				}
				else if ("X".equals( type)) {
				}
				else if ("A1".equals( type)) {
//					mAsts.addExplosion( x, y, z, Operation.ASTEROID_1);
				}
				else if ("A2".equals( type)) {
//					mAsts.addAsteroid( x, y, z, Operation.ASTEROID_2);
				}
				else if ("A3".equals( type)) {
//					mAsts.addAsteroid( x, y, z, Operation.ASTEROID_3);
				}
				else if ("A4".equals( type)) {
//					mAsts.addAsteroid( x, y, z, Operation.ASTEROID_4);
				}
				else if ("E0".equals( type)) {
//					mAsts.addExplosion( x, y, z, Operation.EXPLOSION_0);
				}
				else if ("E1".equals( type)) {
//					mAsts.addExplosion( x, y, z, Operation.EXPLOSION_1);
				}
				else if ("E2".equals( type)) {
//					mAsts.addExplosion( x, y, z, Operation.EXPLOSION_2);
				}
				else if ("E3".equals( type)) {
//					mAsts.addExplosion( x, y, z, Operation.EXPLOSION_3);
				}
				else if ("M".equals( type)) {
					mShots.addShot( x, y, z);
				}
				else {
					fail( "missing type: " + type);
				}
			}
			if (frame >= 815) {
				mShip.detect();
				mAsts.detect();
				mUfo.detect();
				mShots.detect( mFireDirection);
//				printInfo();
			}
			else {
				mShip.detect();
				mAsts.detect();
				mUfo.detect();
				mShots.detect( mFireDirection);
			}
//			assertFalse( mAsts.isError());
		}
	}

	protected void setUp() throws Exception {
		File f = new File( Player.POSITION);
		mIS = new BufferedReader( new FileReader( f.getAbsoluteFile()));
		mShip.mState = AFlyable.STATE_HIDDEN;
		mUfo.mState = AFlyable.STATE_HIDDEN;
		mShots.clearAll();
		mLastFrame = -1;
	}
}
