package asteroid.model;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;

import asteroid.Player;

import junit.framework.TestCase;

public class VelocityTest extends TestCase {
	private BufferedReader mIS;
	private GameModel mModel = new GameModel( null);
	private int[][] mVelos = new int[128][128];

	public VelocityTest( String name) {
		super( name);
	}

	private String readLine() {
		try {
			return mIS.readLine();
		}
		catch (Exception ex) {
			fail( ex.getMessage());
		}
		return null;
	}

	protected void tearDown() throws Exception {
		mIS.close();
	}

	public void testA() {
		assertEquals( 5, 15 / 3);
		assertEquals( 5, 16 / 3);
		assertEquals( 5, 17 / 3);
		assertEquals( -5, -15 / 3);
		assertEquals( -5, -16 / 3);
		assertEquals( -5, -17 / 3);
		assertEquals( 0, 15 % 3);
		assertEquals( 1, 16 % 3);
		assertEquals( 2, 17 % 3);
		assertEquals( 0, -15 % 3);
		assertEquals( -1, -16 % 3);
		assertEquals( -2, -17 % 3);
		assertEquals( 2, (int) 2.1);
		assertEquals( -2, (int) -2.1);
		assertEquals( 2.0, Math.rint( 2.1), 0.0);
		assertEquals( -2.0, Math.rint( -2.1), 0.0);
		assertEquals( 2.0, Math.rint( 1.9), 0.0);
		assertEquals( -2.0, Math.rint( -1.9), 0.0);
	}

	protected void setUp() throws Exception {
		File f = new File( Player.POSITION);
		mIS = new BufferedReader( new FileReader( f.getAbsoluteFile()));
	}

	public void xtestB() {
		String s = null;
		while ((s = readLine()) != null) {
            mModel.parse( s);
			for (int i = 0; i < AsteroidVector.MAX_ASTEROIDS; ++i) {
				Asteroid ast = mModel.mAsts.get( i);
				if (ast.isVisible() && (ast.getModify() == 8)) {
					int mx = 64 + ast.getMoveX8();
					int my = 64 + ast.getMoveY8();
					++mVelos[mx][my];
				}
			}
		}
		for (int mx = 0; mx < 128; ++mx) {
			for (int my = 0; my < 128; ++my) {
				int count = mVelos[mx][my];
				if (count > 0) {
					System.out.println( "move: " + (mx - 64) + "," + (my - 64) + "," + count);
				}
			}
		}
	}
}
