package asteroid.strategy;

import asteroid.model.Angle;
import asteroid.model.Shot;

import junit.framework.TestCase;

public class ChargeTest extends TestCase {
	public ChargeTest( String name) {
		super( name);
	}

//	Ship (524,524) Flyable (261,842) delta (-263,318) gamma=2.2618113809778175 move(-17,6) v2=325 betha=2.8023000391357487 alpha2.4072655005526764
	public void tesA() {
		int shipX = 524;
		int shipY = 524;
		int astX = 932;
		int astY = 164;
		int moveX = -16;
		int moveY = -10;
//		int dx = astX - shipX + vx;
//		int dy = astY - shipY + vy;
//		double alpha = Math.atan2( dy, dx);
//		System.out.println( "alpha = " + alpha);
		double betha = Math.atan2( moveY, moveX);
		System.out.println( "betha = " + betha);
		double gamma = Math.atan2( astY - shipY, astX - shipX);
		System.out.println( "gamma = " + gamma);
		double v = Math.sqrt( (moveX * moveX) + (moveY * moveY)) / 8.0;
		System.out.println( "v = " + v);
//		double vv = v * Math.sin( gamma - betha);
//		System.out.println( "vv = " + vv);
//		double oo = Operation.SHOT_SPEED * Math.sin( gamma - alpha);
//		System.out.println( "oo = " + oo);
		double hh = v * Math.sin( betha - gamma) / Shot.SHIP_SHOT_SPEED;
		System.out.println( "hh = " + hh);
		double ah = Math.asin( hh);
		System.out.println( "ah = " + ah);
		double a1 = gamma + ah;
		System.out.println( "alpha1 = " + a1);
		double a2 = gamma - ah + Math.PI;
		System.out.println( "alpha1 = " + a2);
	}

	public void testAttackSector1() {
		int shipX = 0;
		int shipY = 0;
		int astX = 100;
		int astY = 100;
		int moveX = -10;
		int moveY = 2;
		double d = Math.sqrt( ((astX - shipX) * (astX - shipX)) + ((astY - shipY) * (astY - shipY)));
		double v = Math.sqrt( (moveX * moveX) + (moveY * moveY)) / 8.0;
		assertEquals( 1.27475, v, 0.0001);
		double betha = Math.atan2( moveY, moveX);
		assertEquals( 120.0, Angle.getAngle( betha), 0.0001);
		double gamma = Math.atan2( astY - shipY, astX - shipX);
		assertEquals( 32.0, Angle.getAngle( gamma), 0.0001);
		double temp = v * Math.sin( betha - gamma) / Shot.SHIP_SHOT_SPEED;
		assertEquals( 0.13258, temp, 0.0001);
		//
		double dg1 = Math.asin( temp);
		assertEquals( 5.0, Angle.getAngle( dg1), 0.0001);
		double alpha1 = gamma + dg1;
		assertEquals( 37.0, Angle.getAngle( alpha1), 0.0001);
		double t1 = d * Math.cos( gamma) / ((Shot.SHIP_SHOT_SPEED * Math.cos( alpha1)) - (v * Math.cos( betha)));
		assertEquals( 16.37488, t1, 0.0001);
		double dt1 = (Shot.SHIP_SHOT_SPEED * Math.cos( dg1)) - (v * Math.cos( betha - gamma));
		assertEquals( 8.6365, dt1, 0.0001);
		//
		double dg2 = Math.PI - dg1;
		assertEquals( 123.0, Angle.getAngle( dg2), 0.0001);
		double alpha2 = gamma + dg2;
		assertEquals( 155.0, Angle.getAngle( alpha2), 0.0001);
		double t2 = d * Math.cos( gamma) / ((Shot.SHIP_SHOT_SPEED * Math.cos( alpha2)) - (v * Math.cos( betha)));
		assertEquals( -19.58129, t2, 0.0001);
		double dt2 = (Shot.SHIP_SHOT_SPEED * Math.cos( dg2)) - (v * Math.cos( betha - gamma));
		assertEquals( -7.22227, dt2, 0.0001);
	}

	public void testB() {
		int shipX = 524;
		int shipY = 524;
		int astX = 368;
		int astY = 453;
		int moveX = -7;
		int moveY = 11;
		int dax = astX - shipX;
		int day = astY - shipY;
		double gamma = Math.atan2( day, dax);
		assertEquals( -2.7145, gamma, 0.0001);
		assertEquals( -155.52838, Angle.toRoute( gamma), 0.0001);
		double betha = Math.atan2( moveY, moveX);
		assertEquals( 2.1375, betha, 0.0001);
		assertEquals( 122.47119, Angle.toRoute( betha), 0.0001);
		double db = betha - gamma;
		double astV = Math.sqrt( (moveX * moveX) + (moveY * moveY)) / 8.0;
		double temp1 = Math.asin( Math.sin( db) * astV / Shot.SHIP_SHOT_SPEED);
		assertEquals( -2.91762, gamma + temp1, 0.0001);
		assertEquals( -167.16726, Angle.toRoute( gamma + temp1), 0.0001);
		double dt1 = (Shot.SHIP_SHOT_SPEED * Math.cos( temp1)) - (astV * Math.cos( db));
		assertTrue( dt1 > 0);
		double temp2 = Math.PI - temp1;
		assertEquals( 0.6302, gamma + (temp2), 0.0001);
		assertEquals( 36.11050, Angle.toRoute( gamma + temp2), 0.0001);
		double dt2 = (Shot.SHIP_SHOT_SPEED * Math.cos( temp2)) - (astV * Math.cos( db));
		assertTrue( dt2 < 0);
	}

	public void testC() {
		int x1 = 524;
		int y1 = 524;
		int ox = 4;
		int oy = 7;
		int o = (x1 * oy) - (y1 * ox);
		System.out.println( "o=" + o);
		int x2 = 1024;
		int y2 = 750;
		int sx = 2;
		int sy = -3;
		int s = (x2 * sy) - (y2 * sx);
		System.out.println( "s=" + s);
		int dd = (ox * sy) - (oy * sx);
		System.out.println( "dd=" + dd);
		int x0 = ((s * ox) - (o * sx)) / dd;
		int y0 = ((s * oy) - (o * sy)) / dd;
		System.out.println( "x0=" + x0);
		System.out.println( "y0=" + y0);
		int dx = x2 - x1;
		int dy = y2 - y1;
		int ko = ((dx * sy) - (dy * sx)) / dd;
		int ks = ((dx * oy) - (dy * ox)) / dd;
		System.out.println( "ko=" + ko);
		System.out.println( "ks=" + ks);
		System.out.println( "x0=" + (x1 + (ko * ox)));
		System.out.println( "y0=" + (y1 + (ko * oy)));
		System.out.println( "x0=" + (x2 + (ks * sx)));
		System.out.println( "y0=" + (y2 + (ks * sy)));
	}

	public void testLeaveSector1() {
		int shipX = 0;
		int shipY = 0;
		int astX = 100;
		int astY = 100;
		int moveX = 10;
		int moveY = 2;
		double d = Math.sqrt( ((astX - shipX) * (astX - shipX)) + ((astY - shipY) * (astY - shipY)));
		double v = Math.sqrt( (moveX * moveX) + (moveY * moveY)) / 8.0;
		assertEquals( 1.27475, v, 0.0001);
		double betha = Math.atan2( moveY, moveX);
		assertEquals( 8.0, Angle.getAngle( betha), 0.0001);
		double gamma = Math.atan2( astY - shipY, astX - shipX);
		assertEquals( 32.0, Angle.getAngle( gamma), 0.0001);
		double temp = v * Math.sin( betha - gamma) / Shot.SHIP_SHOT_SPEED;
		assertEquals( -0.08839, temp, 0.0001);
		//
		double dg1 = Math.asin( temp);
		assertEquals( 252.0, Angle.getAngle( dg1), 0.0001);
		double alpha1 = gamma + dg1;
		assertEquals( 28.0, Angle.getAngle( alpha1), 0.0001);
		double t1 = d * Math.cos( gamma) / ((Shot.SHIP_SHOT_SPEED * Math.cos( alpha1)) - (v * Math.cos( betha)));
		assertEquals( 20.47203, t1, 0.0001);
		double dt1 = (Shot.SHIP_SHOT_SPEED * Math.cos( dg1)) - (v * Math.cos( betha - gamma));
		assertEquals( 6.90803, dt1, 0.0001);
		//
		double dg2 = Math.PI - dg1;
		assertEquals( 132.0, Angle.getAngle( dg2), 0.0001);
		double alpha2 = gamma + dg2;
		assertEquals( 164.0, Angle.getAngle( alpha2), 0.0001);
		double t2 = d * Math.cos( gamma) / ((Shot.SHIP_SHOT_SPEED * Math.cos( alpha2)) - (v * Math.cos( betha)));
		assertEquals( -15.66241, t2, 0.0001);
		double dt2 = (Shot.SHIP_SHOT_SPEED * Math.cos( dg2)) - (v * Math.cos( betha - gamma));
		assertEquals( -9.02935, dt2, 0.0001);
	}
}
