package asteroid.strategy;

import asteroid.PrintWriterFormat;
import asteroid.model.AEnemy;
import asteroid.model.Angle;
import asteroid.model.AsteroidVector;
import asteroid.model.GameModel;
import asteroid.model.TargetInfo;

import junit.framework.TestCase;

public class GenomTest extends TestCase {
	private Genom mGenom;
	private int mLast;
	private GameModel mModel = new GameModel( null);
	private PrintWriterFormat mOut = new PrintWriterFormat( System.out);

	public GenomTest( String name) {
		super( name);
	}

	private void printGen( Gen akt, int time) {
		mOut.print( akt.mEnemy.getID());
		mOut.print( ':');
		mOut.print( akt.mEnemy);
		mOut.print( ':');
		mOut.print( time);
		mOut.print( ':');
		mOut.print( TargetInfo.getX0( akt.mEnemy, mModel.getShip(), time, 0));
		mOut.print( ':');
		mOut.print( TargetInfo.getY0( akt.mEnemy, mModel.getShip(), time, 0));
		mOut.print( ':');
		mOut.print( akt.mInfo.getFrameHit());
		mOut.print( ':');
		mOut.println();
	}

	private void printGenom() {
		mOut.savePos();
		mOut.print( mGenom.getEndFrame());
		mOut.fill( 8);
		for (int i = 0; i < mLast; ++i) {
			Gen gen = mGenom.get( i);
			mOut.print( gen.mEnemy.getID());
			mOut.print( ':');
			mOut.print( gen.mInfo);
			mOut.fill( 18);
		}
		mOut.println();
	}

	public void testA1() {
		int dir = Angle.sDirection;
		int endFrame = GameModel.sFrame;
		for (int i = 0; i < mLast; ++i) {
			int primalShot = mGenom.primalShotFrame( i, endFrame);
			Gen akt = mGenom.get( i);
			akt.mInfo.calculate(akt.mEnemy, mModel.getShip(), dir, endFrame, primalShot);
			printGen( akt, endFrame - GameModel.sFrame);
			endFrame += akt.mInfo.getRot();
			endFrame += akt.mInfo.getWait();
			dir = akt.mInfo.getDirection();
		}
	}

	public void testAll() {
		mGenom.calculate( 0, mLast);
		printGenom();
	}

	public void testPerm() {
		int count = 0;
		int min = Integer.MAX_VALUE;
		long start = System.currentTimeMillis();
		do {
			GameModel.sFrame = 550;
			Angle.sDirection = 61;
			mGenom.calculate( 0, mLast);
			if (min > mGenom.getEndFrame()) {
				printGenom();
				min = mGenom.getEndFrame();
			}
			++count;
		}
		while (mGenom.next( 0, mLast));
		start = System.currentTimeMillis() - start;
		start *= 1000;
		start /= count;
		mOut.println( start + "ns");
	}

	protected void setUp() throws Exception {
		mGenom = new Genom( mModel);
		mModel.parse( "550,___R__,038,039,058,1,060,063    S:4192,4192,12,+00,+00,..   M0:2512,3720,15,-61,-17,..        _1:0000,0000,15,+00,+00,..        M2:3096,4632,15,-59,+24,..        M3:0968,2464,15,-56,-30,..        _4:0000,0000,00,+00,+00,..        _5:0000,0000,00,+00,+00,..        a0:0000,0000,00,+00,+00,..  A1:0904,3616,14,+06,-10,..  E2:1832,6392,00,+00,+00,..  A3:2056,6584,14,+08,+08,..  A4:0904,2544,14,+06,-20,..  A5:6008,4936,15,-14,-17,..  A6:7720,3904,15,-16,+08,..  E7:1808,6352,00,+00,+00,..  A8:0648,6568,14,+11,-27,..  A9:0200,7016,14,+06,-22,..  E10:0992,3760,15,+00,+00,.. A11:0328,1672,14,+12,-28,.. A12:7152,4680,15,+06,-21,.. a13:0000,0000,14,+00,+00,.. a14:0000,0000,14,+00,+00,.. a15:0000,0000,14,+00,+00,.. a16:0000,0000,15,+00,+00,.. a17:0000,0000,15,+00,+00,.. a18:0000,0000,14,+00,+00,.. a19:0000,0000,14,+00,+00,.. a20:0000,0000,14,+00,+00,.. a21:0000,0000,00,+00,+00,.. a22:0000,0000,00,+00,+00,.. a23:0000,0000,00,+00,+00,.. a24:0000,0000,00,+00,+00,.. a25:0000,0000,00,+00,+00,.. a26:0000,0000,00,+00,+00,.. u:0000,0000,00,+00,+00,..   ");
		for (int i = 0; i <= AsteroidVector.MAX_ASTEROIDS; ++i) {
			AEnemy enemy = mModel.getEnemy( i);
			if (enemy.isVisible()) {
				mGenom.setEnemy( mLast++, enemy);
			}
		}
		Angle.sDirection = 61;
	}
}
