#define NO_LOCAL_START

using System;
using System.Collections.Generic;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;

namespace ct.Asteroid
{
    /// <summary>
    /// Eine mehr oder wenige 1 zu 1 Konvertierung des Beispielprogramms von Harald Bögeholz
    /// </summary>
    static class Program
    {
        /// <summary>
        /// The main entry point for the application.
        /// </summary>
        [STAThread]
        static void Main ()
        {
            String[] args = Environment.GetCommandLineArgs();
            IPAddress server_ip = null;
#if NO_LOCAL_START
            if (args.Length == 1 && args[0].Length > 10)
            {
              // HOME_SCHLEO server_ip = IPAddress.Parse("127.0.0.1"); 
              // EVA_LAPTOP WLAN: IPAddress server_ip = IPAddress.Parse("192.168.178.27");
              server_ip = IPAddress.Parse("192.168.178.26");// EVA_LAPTOP LAN: 
              // SCHLEO-FS: IPAddress server_ip = IPAddress.Parse("192.168.178.44");
              // Dieter Laptop: IPAddress server_ip = IPAddress.Parse("192.168.178.21");
              Console.WriteLine("Aufruf aus Programm");
            }
            else if (args.Length == 2)
            {
              server_ip = IPAddress.Parse(args[1]);
              if (server_ip == null)
              {
                Console.WriteLine("Ungueltige IP-Adresse: '" + args[1] + "'\n");
                Environment.Exit(1);
              }
            }
            else if (args.Length != 2)
            {
              Console.WriteLine("Aufruf: asteroid <IP-Adresse>\n");
              Environment.Exit(1);
            }
#else
            IPAddress server_ip = IPAddress.Parse("127.0.0.1");// HOME_SCHLEO 
            // EVA_LAPTOP WLAN: IPAddress server_ip = IPAddress.Parse("192.168.178.27");
            // EVA_LAPTOP LAN: IPAddress server_ip = IPAddress.Parse("192.168.178.26");
            // SCHLEO-FS: IPAddress server_ip = IPAddress.Parse("192.168.178.44");
            // Dieter Laptop: IPAddress server_ip = IPAddress.Parse("192.168.178.21");
#endif

            EndPoint myLocalEndpoint = new IPEndPoint(IPAddress.Any, 0);

            Socket sd = new Socket(AddressFamily.InterNetwork, SocketType.Dgram, ProtocolType.Udp);

            sd.ReceiveBufferSize = 2048;
            sd.Blocking = false;
            sd.Bind(myLocalEndpoint);

            Player player = new Player(sd, server_ip);
            player.Run();
            Console.ReadLine();
        }
    }
}
