using System;
using System.Collections.Generic;
using System.Text;
using System.Xml;
using System.Collections;


namespace ct.Asteroid
{
  public static class TargetData
  {
    #region PRIVATE VARIABLES
    private static Hashtable cls_TargetObjects = new Hashtable();
    private static Hashtable cls_NewTargetObjects = new Hashtable();
    private static Hashtable cls_CollisionObjects = new Hashtable();
    private static Hashtable cls_SaucerObjects = new Hashtable();
    private static Hashtable cls_DrehungHash = new Hashtable();
    private static Hashtable cls_FlugWinkel = new Hashtable();
    private static Drehungen cls_drehung;
    private static Punkt cls_ship_Position;
    private static Punkt_new cls_saucer_Position;
    private static bool cls_saucer_present;
    private static int[,] cls_DrehPaare = {  
                           {0,152,296,440,584,720,856,976,1088,1192,1280,1360,1416,1472,1504,1528,1536,1528,
                               1504,1472,1416,1360,1280,1192,1088,976,856,720,584,440,296,152,0,-152,-296,-440,
                               -584,-720,-856,-976,-1088,-1192,-1280,-1360,-1416,-1472,-1504,-1528,-1536,-1528,
                               -1504,-1472,-1416,-1360,-1280,-1192,-1088,-976,-856,-720,-584,-440,-296,-152},
                           {1536,1528,1504,1472,1416,1360,1280,1192,1088,976,856,720,584,440,296,152,0,-152,
                               -296,-440,-584,-720,-856,-976,-1088,-1192,-1280,-1360,-1416,-1472,-1504,-1528,
                               -1536,-1528,-1504,-1472,-1416,-1360,-1280,-1192,-1088,-976,-856,-720,-584,-440,
                               -296,-152,0,152,296,440,584,720,856,976,1088,1192,1280,1360,1416,1472,1504,1528}
        };
    //
    private static int cls_ship_Radius = 27;
    private static int cls_ship_x = -1, cls_ship_y = -1, cls_ship_x1 = -1, cls_ship_y1 = -1;
    private static int cls_ship_dx = -1, cls_ship_dy = -1, cls_ship_dx1 = -1, cls_ship_dy1 = -1;
    private static int cls_shipWinkelNumber = -1;
    private static int cls_actualFrameNumber = -1, cls_lastFrameNumber = -1, cls_frameRate = 0;
    private static double cls_shotSpeed = 7.88, cls_shipSpeed = 0.0, cls_shipWinkel = -1.0;
    private static bool initialized = false;
    #endregion
    public static void setTargetData ( ref Target target )
    {
      bool colllisionCourse = false;
      int dx = cls_ship_x - target.object_x;
      int dy = cls_ship_y - target.object_y;
      //Diese Felder werden vom Objekt vorher belegt
      //object_x, object_y, object_speed, object_radius, object_direction, object_m, object_b
      target.object_distance = Math.Sqrt(dx * dx + dy * dy);
      //Drehung zum target berechnen
      getTargetDrehung(ref target);
      //Kollision berechnen
      colllisionCourse = setShipCollisionFrame(ref target);
      if (colllisionCourse) cls_CollisionObjects.Add((cls_CollisionObjects.Keys.Count + 1), target);
      else
      {
        //Jetzt wird's etwas komplizierter....
        //Hashtable cls_TargetObjects mit Zielen füllen
        setDrehungHitFrame(target);
      }



    }
    private static bool setShipCollisionFrame ( ref Target target )
    {
      bool returnValue = false;
      double diskriminante;
      int Collision_Radius = cls_ship_Radius + target.object_radius;
      Kreis kreis = new Kreis(cls_ship_Position, Collision_Radius);
      Gerade gerade = new Gerade(target.objectPosition_start, target.objectPosition_now);
      diskriminante = gerade.schneidet_Kreis(kreis);
      if (diskriminante < 0) return false; //Fliegt dran vorbei - kein Schnittpunkt der Flugbahn mit Kreisradius
      returnValue = true;
      target.ship_collision_frame = (int)(target.object_distance / target.object_speed);
      setDeltaHitFrame(ref target);
      return returnValue;
    }
    private static void setDeltaHitFrame ( ref Target target )
    {
      double diskriminante;
      double x_hit = (double)(target.hit_drehung_ship.dx + cls_ship_Position.x_dbl);
      double y_hit = (double)(target.hit_drehung_ship.dy + cls_ship_Position.y_dbl);

      Punkt hit_Point = new Punkt(x_hit, y_hit);
      Gerade gerade = new Gerade(cls_ship_Position, hit_Point);
      Kreis kreis = new Kreis(target.objectPosition_now, target.object_radius);
      diskriminante = gerade.schneidet_Kreis(kreis);
      if (diskriminante < 0) target.delta_hit_frame = 1; //Fliegt dran vorbei - kein Schnittpunkt der Flugbahn mit Kreisradius
      else target.delta_hit_frame = -1;
    }
    private static void setDrehungHitFrame ( Target target )
    {
      Punkt schnittPunkt, shipDrehungPosition;
      Gerade geradeAsteroid, geradeShot;
      Drehungen drehung;
      Target newTarget, previousTarget;
      Kreis zielkreis;

      double target_distance;
      int old_delta_Drehung;
      int asteroid_erreicht_Punkt, shot_erreicht_Punkt;
      int ship_erreicht_Zieldrehung, verbleibende_Frames_bis_Ziel_ausserhalb_der_Zieldrehung;
      geradeAsteroid = new Gerade(target.objectPosition_start, target.objectPosition_now);
      int drehungNumber = target.hit_drehung_ship.Nummer;
      for (int i = 1; i < 65; i++)
      {
        if (cls_DrehungHash.ContainsKey(i))
        {
          drehung = (Drehungen)cls_DrehungHash[i];
          shipDrehungPosition = Punkt.DeltaPunkt(cls_ship_Position, drehung.dx, drehung.dy);
          geradeShot = new Gerade(cls_ship_Position, shipDrehungPosition);
          schnittPunkt = geradeShot.schneidet_Gerade(geradeAsteroid, 1024, 768);
          if (schnittPunkt != null)
          {
            #region CONSOLE OUTPUT
            //Console.WriteLine(string.Format(
            //    "Start:{0};{1} Now:{2};{3} Schnitt:{4};{5}\nStart:{6};{7} Ziel:{8};{9} Winkel:{10:#.0} A-S:{11}-{12}\n",
            //    target.objectPosition_start.x_int, 
            //    target.objectPosition_start.y_int,
            //    target.objectPosition_now.x_int, 
            //    target.objectPosition_now.y_int,
            //    schnittPunkt.x_int,
            //    schnittPunkt.y_int,
            //    shipPosition.x_int,
            //    shipPosition.y_int,
            //    shipDrehungPosition.x_int,
            //    shipDrehungPosition.y_int,
            //    drehung.Winkel,
            //    geradeAsteroid.Punkt_verlaengert_Gerade(schnittPunkt),
            //    geradeShot.Punkt_Richtung_Gerade_Richtung(schnittPunkt)));
            #endregion
            if (geradeAsteroid.Punkt_verlaengert_Gerade(schnittPunkt) &&
                geradeShot.Punkt_auf_Gerade(schnittPunkt))
            {
              asteroid_erreicht_Punkt =
                  (int)(Punkt.Distance(target.objectPosition_now, schnittPunkt) / target.object_speed);
              shot_erreicht_Punkt =
                  (int)(Punkt.Distance(cls_ship_Position, schnittPunkt) / cls_shotSpeed);
              ship_erreicht_Zieldrehung =
                  i - shipWinkelNumber;
              while (ship_erreicht_Zieldrehung < -32) ship_erreicht_Zieldrehung += 64; // dx normalisieren auf -512 ... 511
              while (ship_erreicht_Zieldrehung > 31) ship_erreicht_Zieldrehung -= 64;
              verbleibende_Frames_bis_Ziel_ausserhalb_der_Zieldrehung =
                  asteroid_erreicht_Punkt - shot_erreicht_Punkt;
              if (verbleibende_Frames_bis_Ziel_ausserhalb_der_Zieldrehung > 0 &&
                  verbleibende_Frames_bis_Ziel_ausserhalb_der_Zieldrehung >= ship_erreicht_Zieldrehung)
              {
                newTarget = new Target();
                newTarget.hit_drehung_ship = drehung;
                newTarget.objectPosition_now = target.objectPosition_now;
                newTarget.object_speed = target.object_speed;
                newTarget.hit_point = schnittPunkt;
                newTarget.delta_Drehung = ship_erreicht_Zieldrehung;
                newTarget.asteroid_erreicht_Ziel = asteroid_erreicht_Punkt;
                newTarget.shot_erreicht_Ziel = shot_erreicht_Punkt;
                target_distance = Punkt.Distance(schnittPunkt, target.objectPosition_now);
                newTarget.delta_hit_frame =
                    asteroid_erreicht_Punkt - shot_erreicht_Punkt;
                if (target.asteroidObject == AsteroidObject.Saucer)
                {
                  cls_TargetObjects.Add(99999, newTarget);
                  return;
                }
                if (newTarget.delta_hit_frame < 35)
                {
                  zielkreis = new Kreis(newTarget.objectPosition_now, newTarget.object_radius);
                  if (Gerade.Schnittpunkte_Gerade_mit_Kreis(geradeShot, zielkreis) != null)
                  {
                    newTarget.delta_hit_frame = 0;
                  }

                  if (cls_TargetObjects.ContainsKey(newTarget.delta_hit_frame))
                  {
                    old_delta_Drehung = ((Target)cls_TargetObjects[newTarget.delta_hit_frame]).delta_Drehung;
                    if (newTarget.delta_Drehung < old_delta_Drehung)
                    {
                      cls_TargetObjects.Remove(newTarget.delta_hit_frame);
                      cls_TargetObjects.Add(newTarget.delta_hit_frame, newTarget);
                    }
                  }
                  else
                    cls_TargetObjects.Add(newTarget.delta_hit_frame, newTarget);
                }
              }
            }
          }
        }
      }
    }
    private static int cls_winkel_step = 2;
    public static double Winkel ( Punkt start, Punkt ziel )
    {
      double dx, dy, winkel;
      dx = ziel.x_dbl - start.x_dbl;
      dy = ziel.y_dbl - start.y_dbl;
      winkel = Math.Atan2(dy, dx) * cls_bogenmass;
      if (winkel <= 90) winkel = 90 - winkel;
      else winkel = 450 - winkel;
      return winkel;
    }
    public static double Winkel ( Punkt_new start, Punkt_new ziel )
    {
      double dx, dy, winkel;
      dx = ziel.x_dbl - start.x_dbl;
      dy = ziel.y_dbl - start.y_dbl;
      winkel = Math.Atan2(dy, dx) * cls_bogenmass;
      if (winkel <= 90) winkel = 90 - winkel;
      else winkel = 450 - winkel;
      return winkel;
    }
    public static double Drehwinkel ( Punkt_new target_point )
    {
      // Ship wird immer P(0,0) angenommen !!!!
      double winkel;
      winkel = Math.Atan2(target_point.y_dbl, target_point.x_dbl) * cls_bogenmass;
      if (winkel <= 90) winkel = 90 - winkel;
      else winkel = 450 - winkel;
      return winkel;
    }
    public static Drehungen getDrehung ( double Winkel1 )
    {
      Drehungen returnDrehung = new Drehungen();
      bool winkel_optimieren;
      double min_delta, winkel_delta = 360.0;
      int actualWinkel, winkelNummer = (int)(Winkel1 / 360 * 64) - 2;
      actualWinkel = winkelNummer;
      do
      {
        if (winkelNummer > 64) winkelNummer = 1;
        else if (winkelNummer < 1) winkelNummer += 64;
        min_delta = winkel_delta;
        returnDrehung = (Drehungen)cls_DrehungHash[winkelNummer];
        winkel_delta = Winkel1 - returnDrehung.Winkel;
        if (winkel_delta > 300) winkel_delta -= 360;
        if (winkel_delta < -300) winkel_delta += 360;
        winkel_delta = Math.Abs(winkel_delta);
        winkel_optimieren = (winkel_delta < min_delta);
        if (winkel_optimieren) actualWinkel = winkelNummer;
        winkelNummer++;
      }
      while (winkel_optimieren);
      returnDrehung = (Drehungen)cls_DrehungHash[actualWinkel];
      return returnDrehung;
    }
    private static Drehungen getTargetDrehung ( ref Target target )
    {
      Drehungen drehung = new Drehungen();
      double dx, dy, winkel, winkel_neu, dist, min_dist = 360.0; //min_dist beliebig aber groß genug gewählt
      int winkelNummer, optimierterWinkel;
      dx = (double)target.object_x - cls_ship_x;
      dy = (double)target.object_y - cls_ship_y;
      winkel = Math.Atan2(dy, dx) * cls_bogenmass;
      if (winkel <= 90) winkel = 90 - winkel;
      else winkel = 450 - winkel;
      winkel_neu = TargetData.Winkel(cls_ship_Position, target.objectPosition_now);
      if (winkel != winkel_neu)
      {
        Console.WriteLine(string.Format("<getTargetDrehung> Winkel: {0:#.000} - {1:#.000}", winkel, winkel_neu));
      }
      winkelNummer = (int)(winkel / 360 * 64) + 1;
      if (!cls_DrehungHash.ContainsKey(winkelNummer))
      {
        Console.WriteLine(string.Format("Fehler in getTargetDrehung: Winkel {0} nicht gefunden", winkelNummer));
      }
      else
      {
        optimierterWinkel = winkelNummer;
        winkelNummer -= cls_winkel_step; //gehe zwei Winkelschritte zurück
        if (winkelNummer < 1) winkelNummer += 64;
        for (int i = 0; i < (cls_winkel_step * 2); i++)
        {
          drehung = (Drehungen)cls_DrehungHash[winkelNummer];
          dist = Math.Abs(winkel - drehung.Winkel);
          if (dist < min_dist)
          {
            min_dist = dist;
            optimierterWinkel = winkelNummer;
          }
          else
            break;
          winkelNummer++;
          if (winkelNummer == 65) winkelNummer = 1;
        }
        drehung = (Drehungen)cls_DrehungHash[optimierterWinkel];
        target.hit_drehung_ship = drehung;
      }
      return drehung;
    }
    public static double cls_bogenmass = 0.0;
    public static bool init ()
    {
      string hashKey;
      double dx_dbl, dy_dbl;
      cls_bogenmass = (double)(180 / Math.PI);
      Drehungen drehung;
      cls_ship_Position = new Punkt(0.0, 0.0);
      cls_saucer_Position = new Punkt_new(0.0, 0.0);
      cls_saucer_present = false;
      for (int i = 0; i < 64; i++)
      {
        drehung = new Drehungen();
        drehung.Nummer = i + 1;
        drehung.dx = cls_DrehPaare[0, i];
        drehung.dy = cls_DrehPaare[1, i];
        hashKey = drehung.dx.ToString() + " " + drehung.dy.ToString();
        dx_dbl = (double)drehung.dx;
        dy_dbl = (double)drehung.dy;
        #region DIVISION durch 0 vermeiden -> Wert 0 auf Wert 1 erhöhen - Ungenauigkeit im 1000tel Bereich
        if (drehung.dx == 0) drehung.dx = 1;
        else if (drehung.dy == 0) drehung.dy = 1;
        #endregion
        drehung.G1_Drehung = new Gerade_new(0, 0, drehung.dx, drehung.dy);
        drehung.G2_Drehung = new Gerade_new(0, 0, -drehung.dy, drehung.dx);
        drehung.m_Drehung = drehung.G1_Drehung.m;
        drehung.Winkel = Math.Atan2(dy_dbl, dx_dbl) * cls_bogenmass;
        if (i <= 47) drehung.Winkel = 90.0 - drehung.Winkel;
        else drehung.Winkel = 450.0 - drehung.Winkel;
        cls_DrehungHash.Add(hashKey, drehung);
        cls_DrehungHash.Add(drehung.Nummer, drehung);
        if (i == 0) cls_DrehungHash.Add(65, drehung);
      }
      initialized = true;
      return initialized;
    }
    private static void setShipSpeed ()
    {
      double wegstrecke = 0.0, dx, dy;
      if (cls_lastFrameNumber > 0)
      {
        cls_frameRate = cls_actualFrameNumber - cls_lastFrameNumber;
        if (cls_frameRate < 0) cls_frameRate += 255;
        if (cls_ship_x == cls_ship_x1 && cls_ship_y == cls_ship_y1) cls_shipSpeed = 0.0;
        else if (cls_ship_x == cls_ship_x1)
        {
          wegstrecke = cls_ship_y - cls_ship_y1;
          if (wegstrecke < 0) wegstrecke *= -1;
          cls_shipSpeed = (double)(wegstrecke / cls_frameRate);
        }
        else if (cls_ship_y == cls_ship_y1)
        {
          wegstrecke = cls_ship_x - cls_ship_x1;
          if (wegstrecke < 0) wegstrecke *= -1;
          cls_shipSpeed = (double)(wegstrecke / cls_frameRate);
        }
        else
        {
          dx = (double)(cls_ship_x - cls_ship_x1);
          dy = (double)(cls_ship_y - cls_ship_y1);
          wegstrecke = Math.Sqrt(dx * dx + dy * dy);
          cls_shipSpeed = (double)(wegstrecke / cls_frameRate);
        }
      }
    }
    public static void setShipPosition ( int ship_x, int ship_y, char frameNo )
    {
      cls_ship_Position.x_int = ship_x;
      cls_ship_Position.y_int = ship_y;
      if (cls_ship_x1 == -1) cls_ship_x1 = ship_x;
      else cls_ship_x1 = cls_ship_x;
      cls_ship_x = ship_x;
      if (cls_ship_y1 == -1) cls_ship_y1 = ship_y;
      else cls_ship_y1 = cls_ship_y;
      cls_ship_y = ship_y;
      actualFrameNumber = frameNo;
      setShipSpeed();
      cls_TargetObjects.Clear();
      cls_CollisionObjects.Clear();
    }
    public static void setShipDirection ( int ship_dx, int ship_dy )
    {
      string hashKey;
      cls_ship_dx1 = cls_ship_dx;
      cls_ship_dx = ship_dx;
      cls_ship_dy1 = cls_ship_dy;
      cls_ship_dy = ship_dy;
      hashKey = cls_ship_dx.ToString() + " " + cls_ship_dy.ToString();
      if (!cls_DrehungHash.ContainsKey(hashKey)) Console.WriteLine("Hashvalue in 'Drehung' nicht gefunden!! ");
      else
      {
        cls_drehung = (Drehungen)cls_DrehungHash[hashKey];
        cls_shipWinkelNumber = cls_drehung.Nummer;
        cls_shipWinkel = cls_drehung.Winkel;
      }

    }
    public static void setSaucerPosition ( int saucer_x, int saucer_y )
    {
      cls_saucer_Position.Set(saucer_x, saucer_y);
    }
    public static void ConsoleWriteLine ( string strValue, params object[] args )
    {
      Console.WriteLine(string.Format(strValue, args));
    }
    public static void ConsoleWrite ( string strValue, params object[] args )
    {
      Console.Write(string.Format(strValue, args));
    }
    #region PROPERTIES
    public static Hashtable TargetObjects { get { return cls_TargetObjects; } }
    public static Hashtable NewTargetObjects { get { return cls_NewTargetObjects; } }
    public static Hashtable CollisionObjects { get { return cls_CollisionObjects; } }
    public static Hashtable SaucerObjects { get { return cls_SaucerObjects; } }
    public static Hashtable Flugwinkel { get { return cls_FlugWinkel; } }
    public static Hashtable DrehungHash
    {
      get
      {
        if (!initialized) init();
        return cls_DrehungHash;
      }
    }
    public static int ship_x { get { return cls_ship_x; } }
    public static int ship_y { get { return cls_ship_y; } }
    public static int ship_dx { get { return cls_ship_dx; } }
    public static int ship_dy { get { return cls_ship_dy; } }
    public static int ship_radius { get { return cls_ship_Radius; } }
    public static int shipWinkelNumber { get { return cls_shipWinkelNumber; } }
    public static double shipWinkel { get { return cls_shipWinkel; } }
    public static int actualFrameNumberInt
    {
      get { return (0 + cls_actualFrameNumber); }
    }
    public static char actualFrameNumber
    {
      get { return (char)cls_actualFrameNumber; }
      set
      {
        cls_lastFrameNumber = cls_actualFrameNumber;
        cls_actualFrameNumber = value;
      }
    }
    public static double shotSpeed { get { return cls_shotSpeed; } set { cls_shotSpeed = value; } }
    public static double shipSpeed { get { return cls_shipSpeed; } set { cls_shipSpeed = value; } }
    public static Punkt shipPosition { get { return cls_ship_Position; } }
    public static Punkt_new saucerPosition { get { return cls_saucer_Position; } }
    public static bool saucerPresent { get { return cls_saucer_present; } set { cls_saucer_present = value; } }
    #endregion
  }
  #region NEW CLASSES
  public class Gerade_new
  {
    private double cls_m;
    private double cls_b;
    //bei Steigung m==0 wird der Wert cls_fxy gesetzt
    private double cls_fxy;
    private double cls_dx, cls_dy;
    private DIRECTION direction = DIRECTION.UNKNOWN;
    private Punkt_new cls_startPoint, cls_endPoint;
    private bool parallele_X_Achse;
    private bool parallele_Y_Achse;
    public Gerade_new ( int start_x, int start_y, int end_x, int end_y )
    {
      cls_startPoint = new Punkt_new(start_x, start_y);
      cls_endPoint = new Punkt_new(end_x, end_y);
      Set(cls_startPoint, cls_endPoint);
    }
    public Gerade_new ( Punkt_new start_punkt, Punkt_new end_punkt )
    {
      cls_startPoint = new Punkt_new(start_punkt.x, start_punkt.y);
      cls_endPoint = new Punkt_new(end_punkt.x, end_punkt.y);
      Set(cls_startPoint, cls_endPoint);
    }
    public void Set ( int start_x, int start_y, int end_x, int end_y)
    {
      Set( (double) start_x, (double) start_y, (double) end_x, (double) end_y);
    }
    public void Set ( Punkt_new start_punkt, Punkt_new end_punkt )
    {
      double x1, y1, x2, y2;
      x1 = start_punkt.x_dbl; x2 = end_punkt.x_dbl;
      y1 = start_punkt.y_dbl; y2 = end_punkt.y_dbl;
      Set(x1, y1, x2, y2);

    }
    public void Set ( double start_x, double start_y, double end_x, double end_y )
    {
      cls_dx = end_x - start_x; cls_dy = end_y - start_y;
      //if (cls_dx < 0) direction |= DIRECTION.RIGHT_TO_LEFT;
      //else if (cls_dx > 0) direction |= DIRECTION.LEFT_TO_RIGHT;
      //if (cls_dy < 0) direction |= DIRECTION.DOWN_UP;
      //else if (cls_dy > 0) direction |= DIRECTION.UP_DOWN;
      parallele_X_Achse = (cls_dy == 0);
      parallele_Y_Achse = (cls_dx == 0);
      if (parallele_X_Achse)
      {
        cls_m = 0.0;
        cls_b = end_y;
        cls_fxy = end_y;
      }
      else if (parallele_Y_Achse)
      {
        cls_m = double.NaN;
        cls_b = double.NaN;
        cls_fxy = end_x;
      }
      else
      {
        cls_m = cls_dy / cls_dx;
        cls_b = end_y - (cls_m * end_x);
      }
    }
    #region PUBLIC FUNCTIONS
    /// <summary>
    /// Prüft ob Gerade diesen Kreis schneidet
    /// </summary>
    /// <param name="kreis">Kreis mit Mittelpunkt(x;y) und Radius r</param>
    /// <returns>0==kein Schnittpunkt, 1==ein Schnittpunkt, 2==zwei Schnittpunkte</returns>
    public double schneidet_Kreis ( Kreis kreis )
    {
      return Diskriminante(this, kreis);
    }
    public static Punkt[] Schnittpunkte_Gerade_mit_Kreis ( Gerade gerade, Kreis kreis )
    {
      double b0, b2, m1, r2_m1, diskriminante, diskriminante_rad;
      Punkt[] returnValue = null;
      b0 = gerade.y(kreis.mittelpunkt.x_dbl) - kreis.mittelpunkt.y_dbl;
      b2 = b0 * b0;
      m1 = 1 + (gerade.m * gerade.m);
      r2_m1 = (kreis.radius * kreis.radius) * m1;
      diskriminante = r2_m1 - b2;
      if (diskriminante < 0) return null;
      double x1, y1, x2, y2;
      if (diskriminante == 0)
      {
        y1 = b0 / m1;
        x1 = -gerade.m * y1;
        x1 += kreis.mittelpunkt.x_dbl;
        y1 += kreis.mittelpunkt.y_dbl;
        returnValue = new Punkt[1];
        returnValue[0] = new Punkt(x1, y1);
      }
      else
      {
        diskriminante_rad = Math.Sqrt(diskriminante);
        x1 = (-gerade.m * b0 + diskriminante_rad) / m1;
        y1 = (b0 + gerade.m * diskriminante_rad) / m1;
        x2 = (-gerade.m * b0 - diskriminante_rad) / m1;
        y2 = (b0 - gerade.m * diskriminante_rad) / m1;
        x1 += kreis.mittelpunkt.x_dbl;
        y1 += kreis.mittelpunkt.y_dbl;
        x2 += kreis.mittelpunkt.x_dbl;
        y2 += kreis.mittelpunkt.y_dbl;
        returnValue = new Punkt[2];
        returnValue[0] = new Punkt(x1, y1);
        returnValue[1] = new Punkt(x2, y2);
      }
      return returnValue;

    }
    public bool Punkt_verlaengert_Gerade ( Punkt point )
    {
      bool returnValue;
      double dx_point, dy_point, dm_point;
      dx_point = point.x_dbl - cls_endPoint.x_dbl;
      dy_point = point.y_dbl - cls_endPoint.y_dbl;
      //dm_point = dy_point / dx_point;
      returnValue = (dx_point * cls_dx) >= 0 && (dy_point * cls_dy) >= 0;
      return returnValue;
    }
    public bool Punkt_auf_Gerade ( Punkt point )
    {
      bool returnValue;
      double dx_point, dy_point;
      dx_point = point.x_dbl - cls_startPoint.x_dbl;
      dy_point = point.y_dbl - cls_startPoint.y_dbl;
      returnValue = (dx_point * cls_dx) >= 0 && (dy_point * cls_dy) >= 0;
      return returnValue;
    }
    /// <summary>
    /// Liefert Schnittpunkt, wenn Schnittpunkt 0 >= x < 1024 und 0 >= y < 768  
    /// </summary>
    /// <param name="gerade"></param>
    /// <returns></returns>
    public Punkt_new schneidet_Gerade ( Gerade_new gerade )
    {
      double schnittpunkt_x, schnittpunkt_y, delta_b, delta_m;
      delta_b = this.b - gerade.b;
      delta_m = gerade.m - this.m;
      if (delta_b == 0 || delta_m == 0) return null;
      schnittpunkt_x = (delta_b) / (delta_m);
      schnittpunkt_y = y(schnittpunkt_x);
      return new Punkt_new(schnittpunkt_x, schnittpunkt_y);
    }
    public Punkt_new schneidet_Gerade ( Gerade_new gerade, int x_max, int y_max )
    {
      Punkt_new returnPoint;
      double schnittpunkt_x, schnittpunkt_y, delta_b, delta_m;
      schnittpunkt_x = 0.0;
      schnittpunkt_y = 0.0;
      //Fallunterscheidung
      if (gerade.m == this.m) return null; //Parallele
      else if (this.b == gerade.b) //Schneiden sich in x=0 also auf der Y-Achse
      {
        schnittpunkt_x = 0.0;
        schnittpunkt_y = this.b;
      }
      else if (this.parallele_X_Achse || this.parallele_Y_Achse
        || gerade.parallele_X_Achse || gerade.parallele_Y_Achse)
      {
        if (this.parallele_X_Achse && gerade.parallele_Y_Achse)
        {
          schnittpunkt_x = gerade.cls_startPoint.x_dbl;
          schnittpunkt_y = this.cls_startPoint.y_dbl;
        }
        else if (this.parallele_Y_Achse && gerade.parallele_X_Achse)
        {
          schnittpunkt_x = this.cls_startPoint.x_dbl;
          schnittpunkt_y = gerade.cls_startPoint.y_dbl;
        }
        else if (this.parallele_X_Achse)
        {
          schnittpunkt_y = this.cls_startPoint.y_dbl;
          schnittpunkt_x = gerade.x(schnittpunkt_y);
        }
        else if (this.parallele_Y_Achse)
        {
          schnittpunkt_x = this.cls_startPoint.x_dbl;
          schnittpunkt_y = gerade.y(schnittpunkt_x);
        }
        else if (gerade.parallele_X_Achse)
        {
          schnittpunkt_y = gerade.cls_startPoint.y_dbl;
          schnittpunkt_x = this.x(schnittpunkt_y);
        }
        else if (gerade.parallele_Y_Achse)
        {
          schnittpunkt_x = gerade.cls_startPoint.x_dbl;
          schnittpunkt_y = this.y(schnittpunkt_x);
        }
      }
      else
      {
        delta_b = this.b - gerade.b;
        delta_m = gerade.m - this.m;
        schnittpunkt_x = (delta_b) / (delta_m);
        schnittpunkt_y = y(schnittpunkt_x);
      }
      if (x_max != 0 && y_max != 0)
      {
        if (schnittpunkt_x < 0 || schnittpunkt_y < 0 ||
            schnittpunkt_x > x_max || schnittpunkt_y > y_max) return null;
      }
      returnPoint = new Punkt_new(schnittpunkt_x, schnittpunkt_y);
      return returnPoint;
    }
    #endregion
    #region PRIVATE FUNCTIONS
    /// <summary>
    /// Berechnen der Diskriminante
    /// </summary>
    /// <param name="kreis">Kreis mit Mittelpunkt(x;y) und Radius r</param>
    /// <returns>negativ==kein Schnittpunkt, 0==ein Schnittpunkt, positiv==zwei Schnittpunkte</returns>
    public static double Diskriminante ( Gerade_new gerade, Kreis kreis )
    {
      double b0, b2, m1, r2, r2_m1;
      double returnValue;
      b0 = gerade.y(kreis.mittelpunkt.x_dbl) - kreis.mittelpunkt.y_dbl;
      b2 = b0 * b0;
      m1 = 1 + (gerade.m * gerade.m);
      r2 = kreis.radius * kreis.radius;
      r2_m1 = r2 * m1;
      returnValue = r2_m1 - b2;
      return returnValue;
    }

    /// <summary>
    /// x-Wert an der Stelle y
    /// </summary>
    /// <param name="y"></param>
    /// <returns></returns>
    public double x ( int y )
    {
      double y_dbl = (double)y;
      return x(y_dbl);
    }
    /// <summary>
    /// x-Wert an der Stelle y
    /// </summary>
    /// <param name="y"></param>
    /// <returns></returns>
    public double x ( double y )
    {
      double fx_dbl;
      if (parallele_Y_Achse) return cls_fxy;
      else if (parallele_X_Achse) return double.NaN;
      fx_dbl = (double)(y - cls_b) / cls_m;
      return fx_dbl;
    }
    /// <summary>
    /// y-Wert an der Stelle x
    /// </summary>
    /// <param name="y"></param>
    /// <returns></returns>
    public double y ( int x )
    {
      double x_dbl = (double)x;
      return y(x_dbl);
    }
    /// <summary>
    /// y-Wert an der Stelle x
    /// </summary>
    /// <param name="y"></param>
    /// <returns></returns>
    public double y ( double x )
    {
      double fy_dbl;
      if (parallele_X_Achse) return cls_fxy;
      if (parallele_Y_Achse) return double.NaN;
      fy_dbl = (double)((x * cls_m) + cls_b);
      return fy_dbl;
    }
    #endregion

    #region PROPERTIES
    public double m { get { return cls_m; } }
    public double b { get { return cls_b; } }
    public double dx { get { return cls_dx; } }
    public double dy { get { return cls_dy; } }
    #endregion
  }
  public class Punkt_new
  {
    int cls_x, cls_y, frameNumber;
    double cls_x_dbl, cls_y_dbl;
    public Punkt_new ( double x, double y )
    {
      cls_x = (int)x;
      cls_y = (int)y;
      cls_x_dbl = x;
      cls_y_dbl = y;
    }
    public Punkt_new ( int x, int y )
    {
      cls_x = x;
      cls_y = y;
      cls_x_dbl = (double)x;
      cls_y_dbl = (double)y;
    }
    public double Distance ( Punkt point )
    {
      double dx, dy;
      dx = point.x_int - this.x; dy = point.y_int - this.y;
      return Math.Sqrt(dx * dx + dy * dy);
    }
    public double Distance ( Punkt_new point )
    {
      double dx, dy;
      dx = point.x - this.x; dy = point.y - this.y;
      return Math.Sqrt(dx * dx + dy * dy);
    }
    public double Distance ()
    {
      double dx, dy;
      dx = this.x; dy = this.y;
      return Math.Sqrt(dx * dx + dy * dy);
    }
    public double delta_x ( Punkt_new Bezugspunkt )
    {
      return (this.cls_x_dbl - Bezugspunkt.x_dbl);
    }
    public double delta_y ( Punkt_new Bezugspunkt )
    {
      return (this.cls_y_dbl - Bezugspunkt.y_dbl);
    }
    public void Set ( int new_x, int new_y, ref Punkt_new point_last )
    {
      point_last.Set(this.x, this.y);
      cls_x = new_x;
      cls_y = new_y;
      cls_x_dbl = (double)cls_x;
      cls_y_dbl = (double)cls_y;
    }
    public void Set ( int x, int y )
    {
      cls_x = x;
      cls_y = y;
      cls_x_dbl = (double)cls_x;
      cls_y_dbl = (double)cls_y;
    }
    public void CopyToPoint ( Punkt_new point )
    {
      point.Set(this.x, this.y);
    }
    public void Move ( int dx, int dy )
    {
      cls_x += dx;
      cls_y += dy;
      cls_x_dbl = (double)cls_x;
      cls_y_dbl = (double)cls_y;
    }
    public int x { get { return cls_x; } }
    public int y { get { return cls_y; } }
    public double x_dbl { get { return cls_x_dbl; } }
    public double y_dbl { get { return cls_y_dbl; } }
  }
  public class Target_new
  {
    private const int ASTEROID_DELTA_HIT_FRAME = 100; //maximale Frames bis Asteroid auf Drehung-n im Ziel 
    // 32 ist die maximale Drehgeschwindigkeit des Ship - sollte immer reichen

    private Flugbahn cls_Flugbahn = null;
    public FLUGOBJECT cls_flugobject;
    public ArrayList Hitlist = new ArrayList(64);
    public bool CollisionCourse = false;
    public int radius, start_frame, now_frame, last_frame;
    public Target_new ( int start_x, int start_y, int frameNumber, FLUGOBJECT flugobject, int object_radius )
    {
      cls_flugobject = flugobject;
      radius = object_radius;
      if (cls_flugobject == FLUGOBJECT.Ship)
      {
        if (start_x == 0) start_x = 1; //Division durch 0 vermeiden
        if (start_y == 0) start_y = 1; //Division durch 0 vermeiden
      }
      else  //Flugbahn abhängig von Schiffposition(0,0) berechnen
      {
        start_x = start_x - TargetData.ship_x;
        start_y = start_y - TargetData.ship_y;
      }
      //if ( cls_flugobject == FLUGOBJECT.Saucer ) 
      cls_Flugbahn = new Flugbahn(start_x, start_y, frameNumber, flugobject);
    }
    public void MoveTarget ( int new_x, int new_y, int frameNumber )
    {
      if (new_x == 0) new_x = 1; //Division durch 0 vermeiden
      if (new_y == 0) new_y = 1; //Division durch 0 vermeiden
      cls_Flugbahn.Flugposition(new_x,
                                new_y,
                                frameNumber);
      if (this.Flugbahn != null)
      {
        if (this.cls_flugobject == FLUGOBJECT.Saucer)
        {
          setHitDrehung();
        }
        else if (this.cls_flugobject == FLUGOBJECT.Asteroid)
        {
          setHitDrehung();
        }
      }
    }
    private Punkt_new getClossedPoint ( Gerade_new G0, Punkt referencePoint )
    {
      Punkt_new return_Punkt = new Punkt_new(0, 0);
      double h_x, h_y, h_m, h_b, delta_b, delta_m;
      h_m = -(1 / G0.m);
      h_b = referencePoint.y_dbl - h_m * referencePoint.x_dbl;
      delta_b = G0.b - h_b;
      delta_m = h_m - G0.m;
      if (delta_b == 0) return_Punkt.Set(referencePoint.x_int + 1, referencePoint.y_int + 1); 
      h_x = delta_b / delta_m;
      h_y = G0.y(h_x);
      return_Punkt = new Punkt_new(h_x, h_y);
      return return_Punkt;
    }
    private Punkt_new getClossedPoint ( Gerade_new G0 )
    {
      Punkt_new return_Punkt;
      double h_x, h_y, h_m;
      if (G0.b == 0) return_Punkt = new Punkt_new(0, 0);
      else
      {
        h_m = -(1 / G0.m);
        h_x = G0.b / (h_m - G0.m);
        h_y = G0.y(h_x);
        return_Punkt = new Punkt_new(h_x, h_y);
      }
      return return_Punkt;
    }
    private void setHitDrehung ()
    {

      if (TargetData.shotSpeed == 0 || Flugbahn.Geschwindigkeit == 0)
      {
        //TargetData.ConsoleWriteLine("Es fehlt was! Shot:{0:0.00} Flugbahn:{1:0.00}",
        //    TargetData.shotSpeed, Flugbahn.Geschwindigkeit);
        return;
      }
      bool hit_found = false, Feuer_frei = false;
      int Feuer_Dauer;
      Gerade_new G0 = cls_Flugbahn.Flugroute;
      Punkt_new P1, P2, P4, P5, P6, P7, P_close;
      Punkt ship_Position;
      ship_Position = TargetData.shipPosition;
      P_close = getClossedPoint(G0, ship_Position);
      Drehung_Target drehung_target = new Drehung_Target();
      Drehungen tmp_Drehung;
      double P0_P1, P0_P2, P0_P4, P0_P5;
      double Object_P1, Object_P6, Object_P7;
      double ship_hit_P1, ship_hit_P4, ship_hit_P5;
      int P1_hit_P1, P4_hit_P6, P5_hit_P7;
      int delta_hit_min = 0x1FFFFF, tmp_int;
      double object_hit_P1, object_hit_P6, object_hit_P7;
      double delta_m, tmp_dbl, tmp_x, tmp_y;
      CollisionCourse = (P_close.Distance(ship_Position) < (TargetData.ship_radius + this.radius));
      Hitlist.Clear();
      for (int i = 1; i < 65; i++)
      {
        if (TargetData.DrehungHash.ContainsKey(i))
        {
          tmp_Drehung = (Drehungen)TargetData.DrehungHash[i];
          delta_m = G0.m / tmp_Drehung.G1.m; // wenn delta_m nahe 1 dann sind die Geraden parallel
          // wenn delta_m nahe -1 dann sind die Geraden Senkrechte
          P1 = G0.schneidet_Gerade(tmp_Drehung.G1);
          if (P1 == null) continue;
          tmp_dbl = P1.x_dbl / tmp_Drehung.G1.dx;
          if (tmp_dbl < 0) continue; // Ziel liegt in entgegengesetzter Richtung
          else
          {
            tmp_dbl = P1.delta_x(Flugbahn.Aktuelleposition);
            if ((tmp_dbl <= 0 && G0.dx > 0) ||
                 (tmp_dbl > 0 && G0.dx <= 0))
            {
              P0_P1 = 2;
              continue;
            }
            else
            {
              #region Berrechnung P1_hit_P1, P4_hit_P6, P5_hit_P7
              P2 = G0.schneidet_Gerade(tmp_Drehung.G2);
              if (P2 == null) // kommt vor bei m == 1 oder m == -1
              {
                continue;
              }
              P0_P1 = P1.Distance(ship_Position);
              P0_P2 = P2.Distance(ship_Position);
              Object_P1 = P1.Distance(Flugbahn.Aktuelleposition);
              tmp_dbl = this.radius / P0_P2;
              // P4 / P5 berrechnen
              tmp_x = (P1.x_dbl * tmp_dbl);
              tmp_y = (P1.y_dbl * tmp_dbl);
              P4 = new Punkt_new(P1.x_dbl - tmp_x, P1.y_dbl - tmp_y);
              P5 = new Punkt_new(P1.x_dbl + tmp_x, P1.y_dbl + tmp_y);
              P0_P4 = P4.Distance(ship_Position);
              P0_P5 = P5.Distance(ship_Position);
              // P6 / P7 berrechnen
              tmp_x = P1.delta_x(P2) * tmp_dbl;
              tmp_y = P1.delta_y(P2) * tmp_dbl;
              P6 = new Punkt_new(P1.x_dbl - tmp_x, P1.y_dbl - tmp_y);
              P7 = new Punkt_new(P1.x_dbl + tmp_x, P1.y_dbl + tmp_y);
              Object_P6 = P6.Distance(Flugbahn.Aktuelleposition);
              Object_P7 = P7.Distance(Flugbahn.Aktuelleposition);
              object_hit_P1 = Object_P1 / Flugbahn.Geschwindigkeit;
              object_hit_P6 = Object_P6 / Flugbahn.Geschwindigkeit;
              object_hit_P7 = Object_P7 / Flugbahn.Geschwindigkeit;
              P0_P1 -= 20;
              P0_P4 -= 20;
              P0_P5 -= 20;
              ship_hit_P1 = P0_P1 / TargetData.shotSpeed;
              ship_hit_P4 = P0_P4 / TargetData.shotSpeed;
              ship_hit_P5 = P0_P5 / TargetData.shotSpeed;
              P1_hit_P1 = (int)(object_hit_P1 - ship_hit_P1);
              P4_hit_P6 = (int)(object_hit_P6 - ship_hit_P4);
              P5_hit_P7 = (int)(object_hit_P7 - ship_hit_P5);
              #endregion

              if (P4_hit_P6 <= 0 && P5_hit_P7 <= 0) continue; // zu spät
              tmp_int = P4_hit_P6 < P5_hit_P7 ? P4_hit_P6 : P5_hit_P7;
              Feuer_frei = (P4_hit_P6 < 0 || P5_hit_P7 < 0); //drauf oder hinterher schiessen
              Feuer_Dauer = P4_hit_P6 > P5_hit_P7 ? P4_hit_P6 - P5_hit_P7 : P5_hit_P7 - P4_hit_P6;
              switch (this.cls_flugobject)
              {
                case FLUGOBJECT.Asteroid:
                  #region Asteroid
                  //ASTEROID_DELTA_HIT_FRAME == 32 
                  if (P0_P1 < 400)
                  {
                    Drehung_Target asteroid_Drehung = new Drehung_Target();
                    asteroid_Drehung.Feuer_frei = Feuer_frei;
                    asteroid_Drehung.Wartezeit = tmp_int;
                    asteroid_Drehung.Drehung_Nummer = i;
                    asteroid_Drehung.P1_hit_P1 = P1_hit_P1;
                    asteroid_Drehung.P4_hit_P6 = P4_hit_P6;
                    asteroid_Drehung.P5_hit_P7 = P5_hit_P7;
                    asteroid_Drehung.Zieldauer = Feuer_Dauer;
                    asteroid_Drehung.Winkel = tmp_Drehung.Winkel;
                    asteroid_Drehung.Distance = P0_P1;
                    Hitlist.Add(asteroid_Drehung);
                  }
                  break;
                  #endregion
                case FLUGOBJECT.Saucer:
                  #region SAUCER
                  if (tmp_int < delta_hit_min)
                  {
                    if (drehung_target.Feuer_frei && !Feuer_frei) continue;
                    else if (drehung_target.Feuer_frei && Feuer_frei && drehung_target.Zieldauer > Feuer_Dauer) continue;
                    delta_hit_min = tmp_int;
                    drehung_target.Feuer_frei = (P4_hit_P6 < 0 || P5_hit_P7 < 0); //drauf oder hinterher schiessen
                    drehung_target.Drehung_Nummer = i;
                    drehung_target.P1_hit_P1 = P1_hit_P1;
                    drehung_target.P4_hit_P6 = P4_hit_P6;
                    drehung_target.P5_hit_P7 = P5_hit_P7;
                    drehung_target.Zieldauer = P4_hit_P6 > P5_hit_P7 ? P4_hit_P6 : P5_hit_P7;
                    drehung_target.Winkel = tmp_Drehung.Winkel;
                    hit_found = true;
                  }
                  break;
                  #endregion
              }
            }
          }
        }
        else
        {
          TargetData.ConsoleWriteLine("Drehung nicht gefunden: {0}", i);
        }
      }
      if (hit_found && this.cls_flugobject == FLUGOBJECT.Saucer)
      {
        //Hitlist.Clear();
        //Console.Write("H({0}) ", Hitlist.Count);
        Hitlist.Add(drehung_target);
      }
              //VORHER
              //P0_P1 = P1.Distance();
              //P0_P2 = P2.Distance();
              //Object_P1 = P1.Distance(Flugbahn.Aktuelleposition);
              //tmp_dbl = this.radius / P0_P2;
              //// P4 / P5 berrechnen
              //tmp_x = (P1.x_dbl * tmp_dbl);
              //tmp_y = (P1.y_dbl * tmp_dbl);
              //P4 = new Punkt_new(P1.x_dbl - tmp_x, P1.y_dbl - tmp_y);
              //P5 = new Punkt_new(P1.x_dbl + tmp_x, P1.y_dbl + tmp_y);
              //P0_P4 = P4.Distance();
              //P0_P5 = P5.Distance();
              //// P6 / P7 berrechnen
              //tmp_x = P1.delta_x(P2) * tmp_dbl;
              //tmp_y = P1.delta_y(P2) * tmp_dbl;
              //P6 = new Punkt_new(P1.x_dbl - tmp_x, P1.y_dbl - tmp_y);
              //P7 = new Punkt_new(P1.x_dbl + tmp_x, P1.y_dbl + tmp_y);
              //P0_P4 = P4.Distance(); P0_P5 = P5.Distance();
              //Object_P6 = P6.Distance(Flugbahn.Aktuelleposition);
              //Object_P7 = P7.Distance(Flugbahn.Aktuelleposition);
              //object_hit_P1 = Object_P1 / Flugbahn.Geschwindigkeit;
              //object_hit_P6 = Object_P6 / Flugbahn.Geschwindigkeit;
              //object_hit_P7 = Object_P7 / Flugbahn.Geschwindigkeit;
              //P0_P1 -= 20;
              //P0_P4 -= 20;
              //P0_P5 -= 20;
              //ship_hit_P1 = P0_P1 / TargetData.shotSpeed;
              //ship_hit_P4 = P0_P4 / TargetData.shotSpeed;
              //ship_hit_P5 = P0_P5 / TargetData.shotSpeed;
              //P1_hit_P1 = (int)(object_hit_P1 - ship_hit_P1);
              //P4_hit_P6 = (int)(object_hit_P6 - ship_hit_P4);
              //P5_hit_P7 = (int)(object_hit_P7 - ship_hit_P5);
    }
    public Flugbahn Flugbahn
    {
      get
      {
        if (cls_Flugbahn.Flugbahn_bekannt) return cls_Flugbahn;
        else return null;
      }
    }
    public double Speed { get { return cls_Flugbahn.Geschwindigkeit; } }
  }
  public class Asteroid_new
  {
    private Target_new cls_target;
    private int cls_type, cls_radius;
    private const int RADIUS_ASTEROID_GROSS = 40;
    private const int RADIUS_ASTEROID_MITTEL = 20;
    private const int RADIUS_ASTEROID_KLEIN = 8;
    public void set ( int x, int y, int type, int sf, int frameNumber, int asteroidNo )
    {
      cls_type = type;
      switch (sf)
      {
        case 0: cls_radius = RADIUS_ASTEROID_GROSS; break;
        case 15: cls_radius = RADIUS_ASTEROID_MITTEL; break;
        case 14: cls_radius = RADIUS_ASTEROID_KLEIN; break;
      }
      cls_target = new Target_new(x, y, frameNumber, FLUGOBJECT.Asteroid, cls_radius); //setzt start und now in Target_new
    }
    public void setParameter ( int new_x, int new_y, char frameNumber )
    {
      int newFrameNumber = ((int)frameNumber + 0);
      cls_target.MoveTarget(new_x, new_y, newFrameNumber);
      TargetData.NewTargetObjects.Add(TargetData.NewTargetObjects.Keys.Count, cls_target);
    }

  }
  public class Saucer_new
  {
    private Target_new cls_target;

    public void set ( int x, int y, int saucerSize, int frameNumber )
    {
      TargetData.SaucerObjects.Clear();
      int Radius = 0;
      switch (saucerSize)
      {
        case 15: Radius = 25; break;
        case 14: Radius = 10; break;
        default:
          Radius = 40;
          Console.WriteLine(string.Format("Unbekannte Saucer-Size: {0}", saucerSize));
          break;
      }
      cls_target = new Target_new(x, y, frameNumber, FLUGOBJECT.Saucer, Radius);
      TargetData.SaucerObjects.Add(1, cls_target);
    }
    public void setParameter ( int new_x, int new_y, char frameNumber )
    {
      cls_target.MoveTarget(new_x, new_y, frameNumber);
    }
  }
  public class Shot_new
  {
    private const int MAX_SHOTS = 8;
    private Punkt_new new_Position = null, help_Position = null;
    private int last_frame, actual_frame, delta_Frame;
    private Target_Shot[] cls_shots;
    private ArrayList tmpShots = new ArrayList(MAX_SHOTS);
    private Hashtable tmpHash = new Hashtable(MAX_SHOTS);
    public Shot_new ()
    {
      cls_shots = new Target_Shot[MAX_SHOTS];
      help_Position = new Punkt_new(0, 0);
      delta_Frame = 0;
      for (int i = 0; i < MAX_SHOTS; i++)
      {
        cls_shots[i] = new Target_Shot();
        cls_shots[i].is_active = false;
        cls_shots[i].Fluglinie = new Gerade_new(0, 0, 100, 0);
      }
      tmpHash.Clear();
    }
    public void set ( int x, int y, int frameNumber )
    {
      int hashKey, help_frame;
      if (actual_frame != frameNumber)
      {
        actual_frame = frameNumber;
        delta_Frame = actual_frame - last_frame;
        if (delta_Frame < 0) delta_Frame += 255;
      }
      //new_Position = new Punkt_new(x, y);
      hashKey = x * 1000 + y;
      if (!tmpHash.ContainsKey(hashKey)) tmpHash.Add(hashKey, new_Position);
      last_frame = actual_frame;
    }
    public void endSet ()
    {
      int tmpX, tmpY, XY_Key;
      double act_dist;
      bool shot_found;
      tmpShots.Clear();
      foreach (int key in tmpHash.Keys) tmpShots.Add(key);
      for (int i = 0; i < tmpShots.Count; i++)
      {
        shot_found = false;
        XY_Key = (int)tmpShots[i];
        tmpX = (int)(XY_Key / 1000);
        tmpY = XY_Key - (tmpX * 1000);
        help_Position.Set(tmpX, tmpY);
        for (int s = 0; s < MAX_SHOTS; s++)
        {
          if (cls_shots[s].last_Position != null)
          {
            act_dist = help_Position.Distance(cls_shots[s].last_Position);
            shot_found = ((act_dist / delta_Frame) < 12);
            if (shot_found)
            {
              setShotParameter(s, tmpX, tmpY);
              tmpShots[i] = -1;
              //if (cls_shots[s].saucer_shot)
              //    TargetData.ConsoleWriteLine("Nummer {4}({5}): {0} ({1}) ({2}) speed:{3:#.00}",
              //        XY_Key, act_dist, delta_Frame, cls_shots[s].speed, s, cls_shots[s].deltaFrames);
              break;
            }
          }
        }
      }
      for (int s = 0; s < MAX_SHOTS; s++)
      {
        if (cls_shots[s].is_active && cls_shots[s].actualframeNumber != actual_frame)
        {
          cls_shots[s].is_active = false;
        }
      }
      while (tmpShots.Count > 0)
      {
        if (((int)tmpShots[0]) == -1)
          tmpShots.RemoveAt(0);
        else
        {
          XY_Key = (int)tmpShots[0];
          tmpX = (int)(XY_Key / 1000);
          tmpY = XY_Key - (tmpX * 1000);
          for (int s = 0; s < MAX_SHOTS; s++)
          {
            if (!cls_shots[s].is_active)
            {
              resetShot(s, tmpX, tmpY);
              break;
              //resetShot(s,
            }
          }
          tmpShots.RemoveAt(0);
        }
      }
      tmpHash.Clear();
    }
    private void setShotParameter ( int shotNumber, int tmpX, int tmpY )
    {
      cls_shots[shotNumber].now_position.Set(tmpX, tmpY);
      cls_shots[shotNumber].actualframeNumber = actual_frame;
      cls_shots[shotNumber].is_active = true;
      cls_shots[shotNumber].deltaFrames += delta_Frame;
      cls_shots[shotNumber].speed =
          cls_shots[shotNumber].now_position.Distance(cls_shots[shotNumber].start_Position) / cls_shots[shotNumber].deltaFrames;
      if (cls_shots[shotNumber].saucer_shot)
      {
        cls_shots[shotNumber].Fluglinie.Set(cls_shots[shotNumber].start_Position, cls_shots[shotNumber].now_position);
        cls_shots[shotNumber].hit_ship =
            (cls_shots[shotNumber].Fluglinie.schneidet_Kreis(new Kreis(TargetData.shipPosition, 20)) >= 0);
        cls_shots[shotNumber].hit_frame = (int)((cls_shots[shotNumber].now_position.Distance(TargetData.shipPosition) - 27) / cls_shots[shotNumber].speed);
        if (cls_shots[shotNumber].hit_ship)
        {
          cls_shots[shotNumber].hit_ship =
          cls_shots[shotNumber].last_Position.Distance(TargetData.shipPosition) > cls_shots[shotNumber].now_position.Distance(TargetData.shipPosition);
          if (cls_shots[shotNumber].hit_ship && cls_shots[shotNumber].hit_frame < 15)
          {
            TargetData.ConsoleWriteLine("Achtung Aufschlag Distanz{0:#.0} hit_Frame({1})",
            cls_shots[shotNumber].now_position.Distance(TargetData.shipPosition), cls_shots[shotNumber].hit_frame);
          }
        }
      }
      cls_shots[shotNumber].last_Position.Set(tmpX, tmpY);
    }
    private void resetShot ( int shotNumber, int x, int y )
    {
      cls_shots[shotNumber].start_Position = new Punkt_new(x, y);
      cls_shots[shotNumber].last_Position = new Punkt_new(x, y);
      cls_shots[shotNumber].now_position = new Punkt_new(x, y);
      cls_shots[shotNumber].next_Position = null;
      cls_shots[shotNumber].speed = 0.0;
      cls_shots[shotNumber].is_active = true;
      cls_shots[shotNumber].flugbahn = null;
      cls_shots[shotNumber].deltaFrames = 0;
      cls_shots[shotNumber].actualframeNumber = actual_frame;
      cls_shots[shotNumber].saucer_shot =
          TargetData.saucerPresent && cls_shots[shotNumber].start_Position.Distance(TargetData.saucerPosition) < 30;

    }
    public Target_Shot[] shots { get { return cls_shots; } }
  }
  #endregion
  #region CLASSES Flugbahn, Asteroid, Gerade, Kreis, Punkt, Saucer, Shot
  public class Flugbahn
  {
    private Punkt_new cls_start, cls_now, cls_last, cls_tmp;
    private FLUGOBJECT cls_flugobject;
    private double cls_geschwindigkeit, cls_flugwinkel, cls_flugwinkel_alt = double.NaN, cls_Winkel_Delta, cls_flugdistanz;
    private Gerade_new cls_Flugroute = null;
    private int cls_flugzeit, cls_startFrame, cls_lastFrame, cls_nowFrame;
    private bool cls_flugbahn_bekannt, cls_flugbahn_initialisiert;
    public bool Sprung_erkannt = false;
    #region PUBLIC FUNCTIONS
    public Flugbahn ( int x, int y, int start_frame, FLUGOBJECT flugobject )
    {
      cls_flugobject = flugobject;
      cls_start = new Punkt_new(x, y);
      cls_now = new Punkt_new(x, y);
      cls_last = new Punkt_new(x, y);
      cls_tmp = new Punkt_new(x, y);
      cls_flugbahn_initialisiert = cls_flugbahn_bekannt = false;
      cls_flugzeit = 0;
      cls_startFrame = cls_lastFrame = cls_nowFrame = start_frame;
    }
    public void Flugposition ( int x, int y, int actual_Frame )
    {
      if (cls_flugbahn_initialisiert)
      {
        switch (cls_flugobject)
        {
          case FLUGOBJECT.Asteroid:
            cls_lastFrame = cls_nowFrame;
            cls_nowFrame = actual_Frame;
            cls_now.Set(x, y, ref cls_tmp);
            break;
          case FLUGOBJECT.Saucer:
            cls_startFrame = cls_lastFrame;
            cls_lastFrame = cls_nowFrame;
            cls_nowFrame = actual_Frame;
            cls_last.CopyToPoint(cls_start);
            cls_now.Set(x, y, ref cls_tmp);
            break;
          case FLUGOBJECT.Ship:
            cls_startFrame = cls_lastFrame;
            cls_lastFrame = cls_nowFrame;
            cls_nowFrame = actual_Frame;
            cls_last.CopyToPoint(cls_start);
            cls_now.Set(x, y, ref cls_tmp);
            break;
        }
        set_speed();
        cls_flugbahn_bekannt = true;
      }
      else
      {
        cls_nowFrame = actual_Frame;
        cls_flugbahn_initialisiert = true;
      }
    }
    #endregion
    #region PRIVATE FUNCTIONS
    private bool Positionssprung ()
    {
      bool returnValue = cls_now.Distance(cls_tmp) > 100;
      if (returnValue)
      {
        int dx = cls_now.x - cls_tmp.x;
        int dy = cls_now.y - cls_tmp.y;
        cls_last.Move(dx, dy);
        cls_start.Move(dx, dy);
        cls_last.CopyToPoint(cls_tmp);
      }
      else
      {
        cls_tmp.CopyToPoint(cls_last);
      }
      return returnValue;
    }
    private void set_speed ()
    {
      Sprung_erkannt = Positionssprung();
      if (!cls_flugbahn_bekannt)
      {
        cls_Flugroute = new Gerade_new(cls_start, cls_now);
      }
      else
      {
        cls_Flugroute.Set(cls_start, cls_now);
        switch (cls_flugobject)
        {
          case FLUGOBJECT.Asteroid:
            int delta_frame;
            delta_frame = cls_nowFrame - cls_lastFrame;
            if (delta_frame < 0) delta_frame += 255;
            cls_flugzeit += delta_frame;
            break;
          case FLUGOBJECT.Saucer:
            cls_flugzeit = cls_nowFrame - cls_startFrame;
            if (cls_flugzeit < 0) cls_flugzeit += 255;
            break;
          case FLUGOBJECT.Ship:
            cls_flugzeit = cls_nowFrame - cls_startFrame;
            if (cls_flugzeit < 0) cls_flugzeit += 255;
            break;
        }
        cls_geschwindigkeit = ((double)(cls_start.Distance(cls_now) / cls_flugzeit));
        cls_flugdistanz += cls_now.Distance(cls_last);
        cls_flugwinkel = TargetData.Winkel(cls_start, cls_now);
        //cls_Flugroute = new Gerade_new(cls_start, cls_now);
        if (cls_flugwinkel_alt != double.NaN)
        {
          cls_Winkel_Delta = Math.Abs(cls_flugwinkel_alt - cls_flugwinkel);
          //if (cls_Winkel_Delta > 0.5 &&
          //    cls_flugdistanz > 100)
          //{
          //    TargetData.ConsoleWriteLine("Winkel: {0:#.00} {1:#.00}  Distanz:{2:#.00}  Position:{3};{4}",
          //        cls_flugwinkel_alt, cls_flugwinkel, cls_flugdistanz, cls_now.x, cls_now.y);
          //}
        }
        cls_flugwinkel_alt = cls_flugwinkel;
      }
    }
    #endregion
    #region PROPERTIES
    public FLUGOBJECT Flugobject { get { return cls_flugobject; } }
    public bool Flugbahn_bekannt { get { return cls_flugbahn_bekannt; } }
    public double Geschwindigkeit { get { return cls_geschwindigkeit; } }
    public double Flugdistanz { get { return cls_flugdistanz; } }
    public double Flugwinkel { get { return cls_flugwinkel; } }
    public Gerade_new Flugroute { get { return cls_Flugroute; } }
    public Punkt_new Startposition { get { return cls_start; } }
    public Punkt_new Aktuelleposition { get { return cls_now; } }
    #endregion
  }
  public class Asteroid
  {
    #region VARIABLES
    public int asteroidNumber;
    public Target_new target;
    public Punkt start_Position, now_Position;
    public int x;    // Koordinaten des Mittelpunkts
    public int y;
    public int internalCounter = 1;
    public int type; // 1 ... 4, äußere Form
    public int sf;   // scale factor: 0 = groß, 15 = mittel, 14 = klein
    public int fn, fn1, fn2, dfn; //Frame counter für speed-Messung
    public int Radius = 0;
    public int shots_done = 0;
    private int x1, x2, y1, y2, ship_dx, ship_dy, collisionFrames;
    public double dx, dy, m, b;
    private double a_d, b_d, c_d, p, q, h; //für die Berrechnung des geringsten Abstands zum ship auf der Flugbahn des Asteroiden
    public int asteroid_speed_messure_counter;
    public double asteroid_speed, asteroid_speed2, ship_distance, last_ship_distance,
        closedDistance = 0.0, calculated_y = 0.0;
    public double asteroid_kumulate_speed_save, asteroid_kumulate_speed;
    private bool cls_directionDetected;
    private bool cls_collisionCourse;
    private bool cls_movingCloser;
    private const int RADIUS_ASTEROID_GROSS = 40;
    private const int RADIUS_ASTEROID_MITTEL = 20;
    private const int RADIUS_ASTEROID_KLEIN = 8;
    public DIRECTION asteroid_Direction = DIRECTION.UNKNOWN;
    #endregion
    public void set ( int x, int y, int type, int sf, int frameNumber, int asteroidNo )
    {
      x1 = this.x = x;
      y1 = this.y = y;
      start_Position = new Punkt(x, y);
      now_Position = new Punkt(x, y);
      asteroidNumber = asteroidNo;
      this.internalCounter = 1;
      this.type = type;
      this.sf = sf;
      this.cls_directionDetected = false;
      this.cls_collisionCourse = false;
      this.cls_movingCloser = false;
      this.dx = 0;
      this.dy = 0;
      asteroid_kumulate_speed_save = asteroid_kumulate_speed = 0.0;
      asteroid_speed2 = asteroid_speed = 0.0;
      collisionFrames = asteroid_speed_messure_counter = 0;
      ship_distance = last_ship_distance = 0.0;
      fn1 = fn = frameNumber;
      fn2 = dfn = 0;
      switch (sf)
      {
        case 0: Radius = RADIUS_ASTEROID_GROSS; break;
        case 15: Radius = RADIUS_ASTEROID_MITTEL; break;
        case 14: Radius = RADIUS_ASTEROID_KLEIN; break;
      }
      target = new Target_new(x, y, frameNumber, FLUGOBJECT.Asteroid, Radius);
      target.radius = Radius;
    }
    public void setParameter ( int new_x, int new_y, char frameNumber )
    {
      if (target == null) return;

      target.MoveTarget(new_x, new_y, frameNumber);
      TargetData.NewTargetObjects.Add(TargetData.NewTargetObjects.Keys.Count, target);
      // XY-Sprung wg. verlassen des Bildbereiches erkennen
      bool xy_jump_detected = false;
      dx += new_x - this.x;
      dy += new_y - this.y;
      now_Position.x_int = new_x;
      now_Position.y_int = new_y;

      if ((new_x - this.x) > 500)
      {
        //if (asteroidNumber == 0) Console.WriteLine(string.Format("{1} - {0}er - {2}: Asteroid verläßt linken BSR", Radius, m, asteroid_Direction));
        dx -= 1024; // Bildschirmsprung nach rechts ausgleichen
        xy_jump_detected = true;
      }
      else if ((new_x - this.x) < -500)
      {
        //if (asteroidNumber == 0) Console.WriteLine(string.Format("{1} - {0}er - {2}: Asteroid verläßt rechten BSR", Radius, m, asteroid_Direction));
        dx += 1024; // Bildschirmsprung nach links ausgleichen
        xy_jump_detected = true;
      }
      if ((new_y - this.y) > 350)
      {
        //if (asteroidNumber == 0) Console.WriteLine(string.Format("{1} - {0}er - {2}: Asteroid verläßt unteren BSR", Radius, m, asteroid_Direction));
        dy -= 768; // Bildschirmsprung nach oben ausgleichen
        xy_jump_detected = true;
      }
      else if ((new_y - this.y) < -350)
      {
        //if (asteroidNumber == 0) Console.WriteLine(string.Format("{1} - {0}er - {2}: Asteroid verläßt oberen BSR", Radius, m, asteroid_Direction));
        dy += 768; // Bildschirmsprung nach unten ausgleichen
        xy_jump_detected = true;
      }
      if (xy_jump_detected) //start_Position neu setzen 
      {
        start_Position.x_dbl = new_x;
        start_Position.y_dbl = new_y;
      }
      fn = 0 + frameNumber;
      dfn = fn - fn1;
      if (dfn < 0) dfn += 255;
      fn2 += dfn;
      fn1 = fn;
      if (dx == 0 && dy == 0) return;
      else if (dx == 0) m = double.NaN;
      else if (dy == 0) m = 0.0;
      else m = (double)dy / dx;
      internalCounter++;
      if (!cls_directionDetected && internalCounter > 5)
      {
        // UP=0x01 DOWN=0x02 RIGHT=0x04 LEFT=0x08
        asteroid_Direction = DIRECTION.UNKNOWN;
        if (dx > 0) asteroid_Direction += 0x08;
        else if (dx < 0) asteroid_Direction += 0x04;
        if (dy > 0) asteroid_Direction += 0x01;
        else if (dy < 0) asteroid_Direction += 0x02;
        cls_directionDetected = true;
      }

      asteroid_speed = Math.Sqrt(dx * dx + dy * dy) / fn2;
      asteroid_kumulate_speed += asteroid_speed;
      asteroid_speed2 = (double)asteroid_kumulate_speed / internalCounter++;
      b = (double)new_y - (m * new_x);
      x2 = this.x;
      y2 = this.y;
      this.x = new_x;
      this.y = new_y;

    }
    public void setTarget ()
    {
      if (!cls_directionDetected) return;
      Target target = new Target();
      target.object_x = this.x; target.object_y = this.y;
      target.object_speed = this.asteroid_speed;
      target.object_radius = this.Radius;
      target.object_direction = this.asteroid_Direction;
      target.object_m = this.m;
      target.object_b = this.b;
      target.asteroidObject = AsteroidObject.Asteroid;
      target.objectPosition_start = start_Position;
      target.objectPosition_now = now_Position;
      TargetData.setTargetData(ref target);
    }
  }
  public class Gerade
  {
    private double cls_m;
    private double cls_b;
    //bei Steigung m==0 wird der Wert cls_fxy gesetzt
    private double cls_fxy;
    private double cls_dx, cls_dy;
    private Punkt cls_startPoint, cls_endPoint;
    private bool parallele_X_Achse;
    private bool parallele_Y_Achse;
    public Gerade ( Punkt punkt1, Punkt punkt2 )
    {
      cls_startPoint = new Punkt(punkt1.x_dbl, punkt1.y_dbl);
      cls_endPoint = new Punkt(punkt2.x_dbl, punkt2.y_dbl);
      init_Gerade();
    }
    public Gerade ( Punkt_new punkt1, Punkt_new punkt2 )
    {
      double x1, y1, x2, y2;
      x1 = punkt1.x; x2 = punkt2.x;
      y1 = punkt1.y; y2 = punkt2.y;
      cls_dx = x2 - x1; cls_dy = y2 - y1;
      parallele_X_Achse = (cls_dx == 0);
      parallele_Y_Achse = (cls_dy == 0);
      if (parallele_X_Achse)
      {
        cls_fxy = y2;
      }
      else if (parallele_Y_Achse)
      {
        cls_fxy = x2;
      }
      else
      {
        cls_m = cls_dy / cls_dx;
        cls_b = y2 - (cls_m * x2);
      }
    }
    private void init_Gerade ()
    {
      double x1, y1, x2, y2;
      x1 = cls_startPoint.x_dbl; x2 = cls_endPoint.x_dbl;
      y1 = cls_startPoint.y_dbl; y2 = cls_endPoint.y_dbl;
      cls_dx = x2 - x1; cls_dy = y2 - y1;
      parallele_X_Achse = (cls_dx == 0);
      parallele_Y_Achse = (cls_dy == 0);
      if (parallele_X_Achse)
      {
        cls_fxy = y2;
      }
      else if (parallele_Y_Achse)
      {
        cls_fxy = x2;
      }
      else
      {
        cls_m = cls_dy / cls_dx;
        cls_b = y2 - (cls_m * x2);
      }
    }

    #region PUBLIC FUNCTIONS
    /// <summary>
    /// Prüft ob Gerade diesen Kreis schneidet
    /// </summary>
    /// <param name="kreis">Kreis mit Mittelpunkt(x;y) und Radius r</param>
    /// <returns>0==kein Schnittpunkt, 1==ein Schnittpunkt, 2==zwei Schnittpunkte</returns>
    public double schneidet_Kreis ( Kreis kreis )
    {
      return Diskriminante(this, kreis);
    }
    public static Punkt[] Schnittpunkte_Gerade_mit_Kreis ( Gerade gerade, Kreis kreis )
    {
      double b0, b2, m1, r2_m1, diskriminante, diskriminante_rad;
      Punkt[] returnValue = null;
      b0 = gerade.y(kreis.mittelpunkt.x_dbl) - kreis.mittelpunkt.y_dbl;
      b2 = b0 * b0;
      m1 = 1 + (gerade.m * gerade.m);
      r2_m1 = (kreis.radius * kreis.radius) * m1;
      diskriminante = r2_m1 - b2;
      if (diskriminante < 0) return null;
      double x1, y1, x2, y2;
      if (diskriminante == 0)
      {
        y1 = b0 / m1;
        x1 = -gerade.m * y1;
        x1 += kreis.mittelpunkt.x_dbl;
        y1 += kreis.mittelpunkt.y_dbl;
        returnValue = new Punkt[1];
        returnValue[0] = new Punkt(x1, y1);
      }
      else
      {
        diskriminante_rad = Math.Sqrt(diskriminante);
        x1 = (-gerade.m * b0 + diskriminante_rad) / m1;
        y1 = (b0 + gerade.m * diskriminante_rad) / m1;
        x2 = (-gerade.m * b0 - diskriminante_rad) / m1;
        y2 = (b0 - gerade.m * diskriminante_rad) / m1;
        x1 += kreis.mittelpunkt.x_dbl;
        y1 += kreis.mittelpunkt.y_dbl;
        x2 += kreis.mittelpunkt.x_dbl;
        y2 += kreis.mittelpunkt.y_dbl;
        returnValue = new Punkt[2];
        returnValue[0] = new Punkt(x1, y1);
        returnValue[1] = new Punkt(x2, y2);
      }
      return returnValue;

    }
    public bool Punkt_verlaengert_Gerade ( Punkt point )
    {
      bool returnValue;
      double dx_point, dy_point, dm_point;
      dx_point = point.x_dbl - cls_endPoint.x_dbl;
      dy_point = point.y_dbl - cls_endPoint.y_dbl;
      //dm_point = dy_point / dx_point;
      returnValue = (dx_point * cls_dx) >= 0 && (dy_point * cls_dy) >= 0;
      return returnValue;
    }
    public bool Punkt_auf_Gerade ( Punkt point )
    {
      bool returnValue;
      double dx_point, dy_point;
      dx_point = point.x_dbl - cls_startPoint.x_dbl;
      dy_point = point.y_dbl - cls_startPoint.y_dbl;
      returnValue = (dx_point * cls_dx) >= 0 && (dy_point * cls_dy) >= 0;
      return returnValue;
    }
    public Punkt schneidet_Gerade ( Gerade gerade )
    {
      return schneidet_Gerade(gerade, 0, 0);
    }
    public Punkt schneidet_Gerade ( Gerade gerade, int x_max, int y_max )
    {
      Punkt returnPoint;
      double schnittpunkt_x, schnittpunkt_y, delta_b, delta_m;
      delta_b = this.b - gerade.b;
      delta_m = gerade.m - this.m;
      if (delta_m == 0) return null; //Parallele
      schnittpunkt_x = (delta_b) / (delta_m);
      schnittpunkt_y = y(schnittpunkt_x);
      if (x_max != 0 && y_max != 0)
      {
        if (schnittpunkt_x < 0 || schnittpunkt_y < 0 ||
            schnittpunkt_x > x_max || schnittpunkt_y > y_max) return null;
      }
      returnPoint = new Punkt(schnittpunkt_x, schnittpunkt_y);
      return returnPoint;
    }
    #endregion
    #region PRIVATE FUNCTIONS
    /// <summary>
    /// Berechnen der Diskriminante
    /// </summary>
    /// <param name="kreis">Kreis mit Mittelpunkt(x;y) und Radius r</param>
    /// <returns>negativ==kein Schnittpunkt, 0==ein Schnittpunkt, positiv==zwei Schnittpunkte</returns>
    public static double Diskriminante ( Gerade gerade, Kreis kreis )
    {
      double b0, b2, m1, r2, r2_m1;
      double returnValue;
      b0 = gerade.y(kreis.mittelpunkt.x_dbl) - kreis.mittelpunkt.y_dbl;
      b2 = b0 * b0;
      m1 = 1 + (gerade.m * gerade.m);
      r2 = kreis.radius * kreis.radius;
      r2_m1 = r2 * m1;
      returnValue = r2_m1 - b2;
      return returnValue;
    }

    /// <summary>
    /// x-Wert an der Stelle y
    /// </summary>
    /// <param name="y"></param>
    /// <returns></returns>
    public double x ( int y )
    {
      double y_dbl = (double)y;
      return x(y_dbl);
    }
    /// <summary>
    /// x-Wert an der Stelle y
    /// </summary>
    /// <param name="y"></param>
    /// <returns></returns>
    public double x ( double y )
    {
      double fx_dbl;
      if (parallele_Y_Achse) return cls_fxy;
      fx_dbl = (double)(y - cls_b) / cls_m;
      return fx_dbl;
    }
    /// <summary>
    /// y-Wert an der Stelle x
    /// </summary>
    /// <param name="y"></param>
    /// <returns></returns>
    public double y ( int x )
    {
      double x_dbl = (double)x;
      return y(x_dbl);
    }
    /// <summary>
    /// y-Wert an der Stelle x
    /// </summary>
    /// <param name="y"></param>
    /// <returns></returns>
    public double y ( double x )
    {
      double fy_dbl;
      if (parallele_X_Achse) return cls_fxy;
      fy_dbl = (double)((x * cls_m) + cls_b);
      return fy_dbl;
    }
    #endregion

    #region PROPERTIES
    public double m { get { return cls_m; } }
    public double b { get { return cls_b; } }
    public double dx { get { return cls_dx; } }
    public double dy { get { return cls_dy; } }
    #endregion
  }
  public class Kreis
  {
    private Punkt cls_mittelpunkt;
    private double cls_radius;
    public Kreis ( Punkt new_mittelpunkt, double new_radius )
    {
      cls_mittelpunkt = new Punkt(new_mittelpunkt.x_dbl, new_mittelpunkt.y_dbl);
      cls_radius = new_radius;
    }
    public Kreis ( Punkt_new new_mittelpunkt, double new_radius )
    {
      cls_mittelpunkt = new Punkt(new_mittelpunkt.x_dbl, new_mittelpunkt.y_dbl);
      cls_radius = new_radius;
    }

    #region PROPERTIES
    public Punkt mittelpunkt
    {
      get { return cls_mittelpunkt; }
      set
      {
        cls_mittelpunkt.x_dbl = value.x_dbl;
        cls_mittelpunkt.y_dbl = value.y_dbl;
      }
    }
    public double Diskriminante ()
    {
      double returnValue = 0.0;

      return returnValue;
    }
    public double radius
    {
      get { return cls_radius; }
      set { cls_radius = value; }
    }
    #endregion
  }
  public class Punkt
  {
    private int cls_x_int, cls_y_int;
    private double cls_x_dbl, cls_y_dbl;
    #region CONSTRUCTORS
    public Punkt ( int x, int y )
    {
      x_int = x;
      y_int = y;
    }
    public Punkt ( double x, double y )
    {
      x_dbl = x;
      y_dbl = y;
    }
    #endregion

    #region FUNCTIONS
    public static double Distance ( Punkt point1, Punkt point2 )
    {
      double dx, dy;
      dx = point1.x_dbl - point2.x_dbl;
      dy = point1.y_dbl - point2.y_dbl;
      dx *= dx; dy *= dy;
      return Math.Sqrt(dx + dy);
    }
    public static Punkt DeltaPunkt ( Punkt StartPunkt, int delta_x, int delta_y )
    {
      return new Punkt((StartPunkt.x_dbl + delta_x), (StartPunkt.y_dbl + delta_y));
    }
    public static bool _PunkteInReihenfolge ( Punkt point1, Punkt point2, Punkt point3 )
    {
      bool dx12_positiv = (point2.x_dbl - point1.x_dbl) >= 0;
      bool dy12_positiv = (point2.y_dbl - point1.y_dbl) >= 0;
      bool dx23_positiv = (point3.x_dbl - point2.x_dbl) >= 0;
      bool dy23_positiv = (point3.y_dbl - point2.y_dbl) >= 0;
      return (dx12_positiv == dx23_positiv && dy12_positiv == dy23_positiv);
    }
    #endregion

    #region PROPERTIES
    public int x_int
    {
      get { return cls_x_int; }
      set
      {
        cls_x_int = value;
        cls_x_dbl = (double)cls_x_int;
      }
    }
    public int y_int
    {
      get { return cls_y_int; }
      set
      {
        cls_y_int = value;
        cls_y_dbl = (double)cls_y_int;
      }
    }
    public double x_dbl
    {
      get { return cls_x_dbl; }
      set
      {
        cls_x_dbl = value;
        cls_x_int = (int)cls_x_dbl;
      }
    }
    public double y_dbl
    {
      get { return cls_y_dbl; }
      set
      {
        cls_y_dbl = value;
        cls_y_int = (int)cls_y_dbl;
      }
    }
    #endregion
  }
  public class Saucer
  {
    public int x, x1, x2, dx, dx_new, Radius;
    public int y, y1, y2, dy, dy_new;
    public int fn, fn1, fn2, dfn, internalCounter = 0;
    public double m, b, determinate;
    public Punkt now_Position, start_Position;
    int ship_old_x, ship_old_y;
    public bool cls_directionDetected;
    public DIRECTION saucer_direction;
    public double saucer_speed;
    public void set ( int x, int y, int saucerSize, int frameNumber )
    {
      x1 = this.x = x;
      y1 = this.y = y;
      start_Position = new Punkt(x, y);
      now_Position = new Punkt(x, y);
      dx = dy = ship_old_x = ship_old_y = 0;
      fn1 = fn = frameNumber;
      dfn = fn2 = 0;
      saucer_speed = 0.0;
      b = m = 0.0;
      determinate = double.NaN;
      cls_directionDetected = false;
      switch (saucerSize)
      {
        case 0: Radius = 40; break;
        case 15: Radius = 40; break;
        case 14: Radius = 20; break;
      }
      saucer_direction = DIRECTION.UNKNOWN;
    }
    public void setParameter ( int new_x, int new_y, char frameNumber )
    {
      // XY-Sprung wg. verlassen des Bildbereiches erkennen
      bool xy_jump_detected = false;
      dx += new_x - this.x;
      dy += new_y - this.y;
      now_Position = new Punkt(new_x, new_y);
      //now_Position.x_int = new_x;
      //now_Position.y_int = new_y;

      if ((new_x - this.x) > 500)
      {
        //if (asteroidNumber == 0) Console.WriteLine(string.Format("{1} - {0}er - {2}: Asteroid verläßt linken BSR", Radius, m, asteroid_Direction));
        dx -= 1024; // Bildschirmsprung nach rechts ausgleichen
        xy_jump_detected = true;
      }
      else if ((new_x - this.x) < -500)
      {
        //if (asteroidNumber == 0) Console.WriteLine(string.Format("{1} - {0}er - {2}: Asteroid verläßt rechten BSR", Radius, m, asteroid_Direction));
        dx += 1024; // Bildschirmsprung nach links ausgleichen
        xy_jump_detected = true;
      }
      if ((new_y - this.y) > 350)
      {
        //if (asteroidNumber == 0) Console.WriteLine(string.Format("{1} - {0}er - {2}: Asteroid verläßt unteren BSR", Radius, m, asteroid_Direction));
        dy -= 768; // Bildschirmsprung nach oben ausgleichen
        xy_jump_detected = true;
      }
      else if ((new_y - this.y) < -350)
      {
        //if (asteroidNumber == 0) Console.WriteLine(string.Format("{1} - {0}er - {2}: Asteroid verläßt oberen BSR", Radius, m, asteroid_Direction));
        dy += 768; // Bildschirmsprung nach unten ausgleichen
        xy_jump_detected = true;
      }
      if (xy_jump_detected) //start_Position neu setzen 
      {
        if (start_Position == null)
        {
          //TESTEN!!!
        }
        else
        {
          start_Position.x_dbl = new_x;
          start_Position.y_dbl = new_y;
        }
      }
      fn = 0 + frameNumber;
      dfn = fn - fn1;
      if (dfn < 0) dfn += 255;
      fn2 += dfn;
      fn1 = fn;
      if (dx == 0 && dy == 0) return;
      else if (dx == 0) m = double.NaN;
      else if (dy == 0) m = 0.0;
      else m = (double)dy / dx;
      internalCounter++;
      if (!cls_directionDetected && internalCounter > 5)
      {
        // UP=0x01 DOWN=0x02 RIGHT=0x04 LEFT=0x08
        saucer_direction = DIRECTION.UNKNOWN;
        if (dx > 0) saucer_direction += 0x08;
        else if (dx < 0) saucer_direction += 0x04;
        if (dy > 0) saucer_direction += 0x01;
        else if (dy < 0) saucer_direction += 0x02;
        cls_directionDetected = true;
      }

      saucer_speed = Math.Sqrt(dx * dx + dy * dy) / fn2;
      //asteroid_kumulate_speed += saucer_speed;
      //asteroid_speed2 = (double)asteroid_kumulate_speed / internalCounter++;
      b = (double)new_y - (m * new_x);
      x2 = this.x;
      y2 = this.y;
      this.x = new_x;
      this.y = new_y;
      setTarget();
    }
    public void setTarget ()
    {
      if (!cls_directionDetected) return;
      Target target = new Target();
      target.object_x = this.x; target.object_y = this.y;
      target.object_speed = this.saucer_speed;
      target.object_radius = this.Radius;
      target.object_direction = this.saucer_direction;
      target.object_m = this.m;
      target.object_b = this.b;
      target.asteroidObject = AsteroidObject.Saucer;
      target.objectPosition_start = start_Position;
      target.objectPosition_now = now_Position;
      TargetData.setTargetData(ref target);
    }
    private bool directionChanged ()
    {
      bool returnValue = false;
      DIRECTION new_Saucer_Direction;
      if (dx_new < 0) new_Saucer_Direction = DIRECTION.RIGHT_TO_LEFT;
      else new_Saucer_Direction = DIRECTION.LEFT_TO_RIGHT;
      if (dy_new < 0) new_Saucer_Direction += 0x04;
      else if (dy_new > 0) new_Saucer_Direction += 0x02;
      returnValue = (saucer_direction != new_Saucer_Direction);
      if (returnValue)
      {
        saucer_direction = new_Saucer_Direction;
      }
      return returnValue;
    }
  }
  public class Shot
  {
    public int x, x1, x2, dx;
    public int y, y1, y2, dy;
    public int fn, fn1, fn2, dfn;
    public double speed = 0.0;

    public void set ( int x, int y )
    {
      this.x = x;
      this.y = y;
    }
    public void set ( int x, int y, int frameNumber )
    {
      x2 = x1 = this.x = x;
      y2 = y1 = this.y = y;
      fn1 = this.fn = frameNumber;
      fn2 = 0;
    }
    public void setParameter ( int x, int y, char frameNumber )
    {
      this.x = x; this.y = y;
      this.fn = 0 + frameNumber;
      dfn = fn - fn1;
      if (dfn < 0)
      {
        fn1 = this.fn = frameNumber;
        fn2 = 0;
        speed = 0.0;
        x2 = this.x; y2 = this.y;
      }
      else
      {
        dx = this.x - x1; dy = this.y - y1;
        if (dx * dx > 400 || dy * dy > 400) // mit Sicherheit ein neuer Schuss
        {
          speed = 0.0;
          fn2 = 0;
          x2 = this.x; y2 = this.y;
        }
        else
        {
          fn2 += dfn;
          dx = this.x - x2; dy = this.y - y2;
          speed = Math.Sqrt(dx * dx + dy * dy) / fn2;
        }
      }
      x1 = x; y1 = y; fn1 = this.fn;
    }
  }
  #endregion
  #region FRAME Auswertungsklassen
  public class GameStatus
  {
    public bool ship_present;  // Schiff sichtbar
    public int ship_x;         // Mittelpunkt des Schiffs
    public int ship_y;
    public int ship_dx;        // Blickrichtung des Schiffes
    public int ship_dy;
    public bool saucer_present;// UFO sichtbar
    public int saucer_x;       // Mittelpunkt des UFOs
    public int saucer_y;
    public int saucer_size;    // Größe: 15 = groß, 14 = klein
    public int nasteroids; // Anzahl Asteroiden
    public Asteroid[] asteroids = new Asteroid[100];
    //public Asteroid_new[] asteroids_new = new Asteroid_new[100];
    public int nshots, shot_count = 0;     // Anzahl Schüsse
    public Shot[] shots = new Shot[10];
    public Shot_new shots_new = new Shot_new();
    public Saucer_new[] saucer = new Saucer_new[1];
    public double shot_speed, delta_shot_speed;
    private double shot_speed_lastValue = 0.0, shot_absolute = 0.0;

    public void clear ()
    {
      ship_present = false;
      saucer_present = false;
      nasteroids = 0;
      nshots = 0;

      for (int i = 0; i < 100; i++)
      {
        asteroids[i] = new Asteroid();
        //asteroids_new[i] = new Asteroid_new();
      }

      for (int i = 0; i < 10; i++)
        shots[i] = new Shot();
      saucer[0] = new Saucer_new();
    }
    public void setShotSpeed ( double new_Shot_speed )
    {
      if (new_Shot_speed > 0)
      {
        shot_absolute += new_Shot_speed;
        shot_speed = (double)shot_absolute / ++shot_count;
        TargetData.shotSpeed = shot_speed;
        delta_shot_speed = shot_speed - shot_speed_lastValue;
        if (delta_shot_speed < 0) delta_shot_speed = -delta_shot_speed;
        shot_speed_lastValue = shot_speed;
      }
    }
  }
  public class FramePacket
  {
    public byte[] vectorram = new byte[1026];
    public UInt16[] vectorram2 = new UInt16[513];
    public char frameno;  // wird bei jedem Frame inkrementiert
    public char ping;     // Der Server schickt das letzte empfangene ping-Byte zurück

    public static FramePacket FromByteArray ( byte[] array )
    {
      FramePacket np = new FramePacket();

      for (int i = 0; i < 513; i++)
      {
        // Damit ich später nicht über einen Pointer auf das Vector-Ram zugreifen
        // muss, kopiere ich die Daten in ein ushort Array um.
        np.vectorram2[i] = (ushort)(array[2 * i] + array[(2 * i) + 1] * 256);
        np.vectorram[i] = array[i];
      }

      np.frameno = (char)array[1024];
      np.ping = (char)array[1025];

      return np;
    }
  }
  public class KeysPacket
  {
    const int KEY_HYPERSPACE = 1;
    const int KEY_FIRE = 2;
    const int KEY_THRUST = 4;
    const int KEY_RIGHT = 8;
    const int KEY_LEFT = 16;
    public int keys;

    public char ping;     // wird vom Server bei nächster Gelegenheit zurückgeschickt. Für Latenzmessung.

    public KeysPacket ()
    {
      keys = '@';
      ping = (char)0;
    }

    public byte[] ToByteArray ()
    {
      byte[] byts = new byte[8];

      byts[0] = (byte)'c';
      byts[1] = (byte)'t';
      byts[2] = (byte)'m';
      byts[3] = (byte)'a';
      byts[4] = (byte)'m';
      byts[5] = (byte)'e';
      byts[6] = (byte)keys;
      byts[7] = (byte)ping;

      return byts;
    }

    public void clear ()
    {
      keys = '@';
    }

    public void hyperspace ( bool b )
    {
      if (b)
        keys |= KEY_HYPERSPACE;
      else
        keys &= ~KEY_HYPERSPACE;
    }

    public void fire ( bool b )
    {
      if (b)
        keys |= KEY_FIRE;
      else
        keys &= ~KEY_FIRE;
    }

    public void thrust ( bool b )
    {
      if (b)
        keys |= KEY_THRUST;
      else
        keys &= ~KEY_THRUST;
    }

    public void left ( bool b )
    {
      if (b)
      {
        keys |= KEY_LEFT;
        right(false);
      }
      else
        keys &= ~KEY_LEFT;
    }

    public void right ( bool b )
    {
      if (b)
      {
        keys |= KEY_RIGHT;
        left(false);
      }
      else
        keys &= ~KEY_RIGHT;
    }
  }
  #endregion

  #region ENUMS
  public enum FLUGOBJECT
  {
    Ship = 1,
    Saucer = 2,
    Asteroid = 4,
    ShipShot = 8,
    SaucerShot = 16
  }
  public enum AsteroidObject
  {
    Asteroid = 1,
    Saucer = 2
  }
  public enum DIRECTION
  {
    UNKNOWN = 0x00,                // UP=0x01 DOWN=0x02 RIGHT=0x04 LEFT=0x08
    UP_DOWN = 0x01,
    DOWN_UP = 0x02,
    RIGHT_TO_LEFT = 0x04,
    RIGHT_LEFT_UP = 0x05,
    RIGHT_LEFT_DOWN = 0x06,
    LEFT_TO_RIGHT = 0x08,
    LEFT_RIGHT_UP = 0x09,
    LEFT_RIGHT_DOWN = 0x0A
  }
  #endregion

  #region STRUCTS
  public struct Target
  {
    public AsteroidObject asteroidObject;
    /// <summary>
    /// Verbleibende Frames bis Trefferposition erreicht 
    /// </summary>
    public int delta_hit_frame;
    public int delta_Drehung;
    /// <summary>
    /// Verbleibende Frames bis Schiff erreicht 
    /// </summary>
    public int ship_collision_frame;
    /// <summary>
    /// Drehrichtung des Schiffes für Objekttreffer 
    /// </summary>
    public Drehungen hit_drehung_ship;
    //public int ship_dx, ship_dy, ship_WinkelNumber;
    /// <summary>
    /// Object X-Position
    /// </summary>
    public int object_x;
    /// <summary>
    /// Object Y-Position
    /// </summary>
    public int object_y;
    /// <summary>
    /// Flugrichtung Objekt
    /// </summary>
    public Punkt objectPosition_start, objectPosition_now, hit_point;
    public DIRECTION object_direction;
    /// <summary>
    /// Object Radius
    /// </summary>
    public int object_radius;
    /// <summary>
    /// Object Geschwindigkeit - Wegstrecke pro Frame
    /// </summary>
    public double object_speed;
    /// <summary>
    /// Entfernung Objekt zum Schiff
    /// </summary>
    public double object_distance;
    /// <summary>
    /// Variable b der Flugbahn object_y = object_x * m + b;
    /// </summary>
    public double object_b;
    /// <summary>
    /// object_delta_y / object_delta_x
    /// </summary>
    public double object_m;
    /// <summary>
    /// Anzahl der auf Target abgegebenen Schüsse 
    /// </summary>
    public int shots_done;

    public int asteroid_erreicht_Ziel, shot_erreicht_Ziel;
  }
  public class Drehungen
  {
    public int dx, dy, Nummer;
    public double m_Drehung;
    public double Winkel;
    private int tmp_x1, tmp_y1, tmp_x2, tmp_y2;
    private Gerade_new cls_G1=null, cls_G2=null, cls_G1_Drehung, cls_G2_Drehung;
    public Gerade_new G1_Drehung { set { cls_G1_Drehung = value;} get { return cls_G1_Drehung; } }
    public Gerade_new G2_Drehung { set { cls_G2_Drehung = value;} get { return cls_G1_Drehung; }  }
    public Gerade_new G1
    {
      get
      {
        tmp_x1 = TargetData.shipPosition.x_int;
        tmp_y1 = TargetData.shipPosition.y_int;
        tmp_x2 = tmp_x1 + (int)G1_Drehung.dx;
        tmp_y2 = tmp_y1 + (int)G1_Drehung.dy;
        if (cls_G1 == null)
        {
          cls_G1 = new Gerade_new(tmp_x1, tmp_y1, tmp_x2, tmp_y2);
        }
        else
        {
          cls_G1.Set(tmp_x1, tmp_y1, tmp_x2, tmp_y2);
        }
        return cls_G1;
      }
    }
    public Gerade_new G2
    {
      get
      {
        tmp_x1 = TargetData.shipPosition.x_int;
        tmp_y1 = TargetData.shipPosition.y_int;
        tmp_x2 = tmp_x1 + (int)G2_Drehung.dx;
        tmp_y2 = tmp_y1 + (int)G2_Drehung.dy;
        if (cls_G2 == null)
        {
          cls_G2 = new Gerade_new(tmp_x1, tmp_y1, tmp_x2, tmp_y2);
        }
        else
        {
          cls_G2.Set(tmp_x1, tmp_y1, tmp_x2, tmp_y2);
        }
        return cls_G2;
      }
    }
  }
  public struct Target_Shot
  {
    public Punkt_new start_Position, last_Position, now_position, next_Position;
    public Drehungen drehung;
    public Flugbahn flugbahn;
    public Gerade_new Fluglinie;
    public double speed;
    public bool saucer_shot, is_active, hit_ship;
    public int actualframeNumber, deltaFrames, hit_frame;
  }
  public struct Drehung_Target
  {
    public int Drehung_Nummer;//Nummer der Drehung
    public double Winkel, Distance; //Zielwinkel des Schiffes
    public int P1_hit_P1;
    public int P4_hit_P6;
    public int P5_hit_P7;
    public int Zieldauer;
    public int Wartezeit;
    public bool Feuer_frei;
  }
  #endregion
    //  public void Run_old ()
    //{
    //  FramePacket frame = new FramePacket();
    //  KeysPacket keys = new KeysPacket();
    //  GameStatus game = new GameStatus();
    //  GameStatus game_Last = new GameStatus();
    //  Drehungen drehung; Target target; Target_new target_new;
    //  TargetData.init();
    //  CAsteroid asteroid;
    //  CShot shot;
    //  Punkt_new NullPunkt = new Punkt_new(524, 524);
    //  int SNR = -1, punktekonto = 0;
    //  int[,] Trefferquote = new int[65, 4];
    //  char prevframe = (char)0;
    //  int t = 0, tmpInt = 0, asteroid_distance, asteroid_serialnummer;
    //  double Kreuzprodukt = 0.0, m_Drehung = 0.0, b_Drehung, collission_time = 0.0, collission_time2 = 0.0;
    //  int fx, fy, fdx, fdy;
    //  //Hashtable drehung_ht = new Hashtable();
    //  StringBuilder sb = new StringBuilder();
    //  //Variablen für Angriffstaktik
    //  //int thrustValue = 500 * 500; // 400 * 400 default
    //  int fireSpeed = 2; // 2 default
    //  int anzahlAsteroidenNew = 0, anzahlAsteroidenOld = 0, collision_candidate = -1;
    //  int shot_speed_help_counter = 0, shot_speed_counter_limit = 100;
    //  bool asteroidsCalulated = false, fireActiv = false;
    //  bool collisionFound = false, targetFound = false, resetSaucer = true, saucerFound = false;
    //  bool shots_reseted = false;
    //  xml_WorkDoc = new XmlDocument();
    //  xml_WorkDoc.LoadXml("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><root/>");
    //  sb.Append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><root>");
    //  XmlElement docNode = xml_WorkDoc.DocumentElement;
    //  XmlElement gameNode = null, eNode = null, xNode = null, yNode = null, mNode = null;

    //  string xPath = "";
    //  string hashKey = "";
    //  int asteroidNumber = -1;
    //  for (; ; )
    //  {
    //    Thread.Sleep(1);
    //    ++t;         // Zeit
    //    ++keys.ping; // jedes gesendete Päckchen erhält eine individuelle Nummer zur Latenzmessung
    //    if (keys.ping > 255) keys.ping = (char)0;
    //    //Console.Write("{0:x}({1}) ", keys.ToByteArray()[6],t);
    //    SendPacket(keys);
    //    frame = ReceivePacket();
    //    if (frame == null) continue;

    //    //if (frame.frameno != ++prevframe || frame.ping != keys.ping)
    //    if (frame.frameno != ++prevframe || (keys.ping - frame.ping > 2))
    //    {
    //      //Console.WriteLine("Latenz " + (keys.ping - frame.ping).ToString() + ". " + (frame.frameno - prevframe).ToString() + " Frames verloren.\n");
    //      prevframe = frame.frameno;
    //    }

    //    InterpretScreen(frame, game); //Option resetSaucer immer auf TRUE bei <game>

    //    keys.clear();   // alle Tasten loslassen
    //    int min_dist = 0x7fffffff;
    //    int min_coll_dist = 0x7fffffff;
    //    int min_dx = 0;
    //    int min_dy = 0;
    //    double distance = 0.0;
    //    anzahlAsteroidenNew = game.nasteroids;
    //    //Console.WriteLine(string.Format("{0}: {1}", TargetData.shipWinkelNumber, TargetData.shipWinkel));
    //    TargetData.NewTargetObjects.Clear();
    //    if (anzahlAsteroidenNew != anzahlAsteroidenOld) //Asteroidenbewegung unbekannt (vorerst)
    //    {
    //      InterpretScreen(frame, game_Last);//Option resetSaucer immer auf FALSE bei <game_last>
    //      game_Last.saucer_present = false;
    //      //um die Position und Richtung nicht zu verlieren
    //      asteroidsCalulated = false;
    //    }
    //    else // Asteroidenbewegung berrechnen/checken
    //    {
    //      for (int i = 0; i < game.nasteroids; ++i)
    //      {
    //        game_Last.asteroids[i].setParameter(
    //            game.asteroids[i].x, game.asteroids[i].y, frame.frameno);
    //        //game_Last.asteroids_new[i].setParameter(
    //        //    game.asteroids[i].x, game.asteroids[i].y, frame.frameno);
    //      }
    //      if (TargetData.shotSpeed == 0) shot_speed_help_counter = 0;
    //      if (game.nshots > 0)
    //      {
    //        for (int i = 0; i < game.nshots; ++i)
    //        {
    //          game_Last.shots_new.set(game.shots[i].x, game.shots[i].y, frame.frameno);
    //        }
    //        game_Last.shots_new.endSet();
    //      }
    //      asteroidsCalulated = true;
    //    }
    //    collisionFound = false; targetFound = false;
    //    if (game.ship_present)
    //    {
    //      CTargets.setShip(game.ship_x, game.ship_y, game.ship_dx, game.ship_dy, frame.frameno);
    //      if (game.saucer_present)
    //      {
    //        CTargets.setSaucer(game.saucer_x, game.saucer_y, game.saucer_size, frame.frameno);
    //      }
    //      for (int i = 0; i < game.nshots; ++i)
    //      {
    //        CTargets.setShot(game.shots[i].x, game.shots[i].y, frame.frameno, i);
    //        if (false && i == 0)
    //        {
    //          if (((CShot)CTargets.Shots[i]).Flugbahn != null)
    //          {
    //            if (SNR != ((CShot)CTargets.Shots[i]).Serialnummer)
    //            {
    //              SNR = ((CShot)CTargets.Shots[i]).Serialnummer;
    //              TargetData.ConsoleWriteLine("--> Neue Serialnummer: ({0})", SNR);
    //            }
    //            TargetData.ConsoleWriteLine("SNR:({2}) S:{3} L:{4} A:{5} {0:#.00} -> {1:#.000}"
    //            , ((CShot)CTargets.Shots[i]).Fluggeschwindigkeit, ((CShot)CTargets.Shots[i]).Flugbahn.m,
    //            ((CShot)CTargets.Shots[i]).Serialnummer, ((CShot)CTargets.Shots[i]).Startposition,
    //            ((CShot)CTargets.Shots[i]).Letzteposition, ((CShot)CTargets.Shots[i]).Aktuelleposition);
    //          }
    //        }
    //      }
    //      CTargets.CleanUpShots(frame.frameno);
    //      foreach (CShot al_shot in CTargets.Shots)
    //      {
    //        if (al_shot.type == ShotType.SAUCER)
    //        {
    //          if (al_shot.HitShip > 0)
    //          {
    //            TargetData.ConsoleWriteLine("Beschuss: ({0})   Aufschlag in: {1}", al_shot.Serialnummer, al_shot.HitShip);
    //          }
    //        }
    //      }
    //      shots_reseted = false;
    //      //Console.WriteLine("Ship:x=({0}) y=({1})",game.ship_x, game.ship_y);
    //      TargetData.setShipPosition(game.ship_x, game.ship_y, frame.frameno);
    //      TargetData.setShipDirection(game.ship_dx, game.ship_dy);
    //      asteroidNumber = -1;
    //      for (int i = 0; i < game.nasteroids; ++i)
    //      {   // nächstgelegenen Asteroiden suchen
    //        CTargets.setAsteroid(game.asteroids[i].x, game.asteroids[i].y,
    //          frame.frameno, game.asteroids[i].sf, game.asteroids[i].type, i);
    //        if (i == 0)
    //        {
    //          asteroid = CTargets.Asteroids[i] as CAsteroid;
    //          if (asteroid.HitShip > 0)
    //          {
    //            TargetData.ConsoleWriteLine("Kollision Asteroid({0}) in Frame ({1})", asteroid.Serialnummer, asteroid.HitShip);
    //          }
    //          if (false && asteroid.Flugbahn != null)
    //          {
    //            if (SNR != asteroid.Serialnummer)
    //            {
    //              SNR = asteroid.Serialnummer;
    //              punktekonto = 0;
    //              foreach (CAsteroid al_asteroid in CTargets.Asteroids)
    //              {
    //                punktekonto += al_asteroid.Punktwert;
    //              }
    //              TargetData.ConsoleWriteLine("--> Neue Serialnummer: ({0})  Punkte:{1}", SNR, punktekonto);
    //            }
    //            // TargetData.ConsoleWriteLine("SNR:({2}) S:{3} L:{4} A:{5} {0:#.00} -> {1:#.000}"
    //            // , asteroid.Fluggeschwindigkeit, asteroid.Flugbahn.m,
    //            //asteroid.Serialnummer, asteroid.Startposition,
    //            // asteroid.Letzteposition, asteroid.Aktuelleposition);
    //          }
    //        }
    //        int dx = game.asteroids[i].x - game.ship_x;
    //        while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
    //        while (dx > 511) dx -= 1024;
    //        int dy = game.asteroids[i].y - game.ship_y;
    //        while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
    //        while (dy > 383) dy -= 768;
    //        int dist = dx * dx + dy * dy;  // Quadrat des Abstands zu diesem Asteroiden
    //        switch (game.asteroids[i].sf)
    //        {	// Abstand um den ungefähren Radius des Asteroiden korrigieren
    //          case 0:  // großer Asteroid
    //            dist -= 40 * 40;
    //            break;
    //          case 15: // mittlerer Asteroid
    //            dist -= 20 * 20;
    //            break;
    //          case 14: // kleiner Asteroid
    //            dist -= 8 * 8;
    //            break;
    //        }
    //        game_Last.asteroids[i].setTarget();
    //        //if (i == 0 && game_Last.asteroids[i].target != null && game_Last.asteroids[i].target.Flugbahn != null
    //        //  && (game_Last.asteroids[i].target.Flugbahn.Flugdistanz) > 20)
    //        //{
    //        //  TargetData.ConsoleWriteLine("Winkel Asteroid{0}:{1:#.00}", i,
    //        //    game_Last.asteroids[i].target.Flugbahn.Flugwinkel);
    //        //}
    //        if (dist < min_dist)
    //        {
    //          asteroidNumber = i;
    //          min_dist = dist;
    //          min_dx = dx;// +game_Last.asteroids[i].x_position(game.shot_speed);
    //          min_dy = dy;// +game_Last.asteroids[i].y_position(game.shot_speed);
    //        }
    //      }
    //      CTargets.CleanUpAsteroids(frame.frameno);
    //      asteroid_distance = 0x1FFF; SNR = -1;
    //      foreach (CAsteroid al_asteroid in CTargets.Asteroids)
    //      {
    //        tmpInt = al_asteroid.ShipDistance;
    //        if (tmpInt < asteroid_distance)
    //        {
    //          asteroid_distance = tmpInt;
    //          SNR = al_asteroid.Serialnummer;
    //        }
    //      }
    //      if (SNR > 0)
    //      {
    //        asteroid = CTargets.AsteroidsHash[SNR] as CAsteroid;
    //        //TargetData.ConsoleWriteLine("Nächster Asteroid ({0}) [{2}]: {1}",
    //        //  SNR, asteroid.Aktuelleposition, asteroid.ShipDistance);
    //      }
    //      TargetData.saucerPresent = game.saucer_present;
    //      if (game.saucer_present)
    //      {
    //        TargetData.saucerPosition.Set(game.saucer_x, game.saucer_y);
    //        if (game_Last.saucer_present)
    //        {
    //          game_Last.saucer[0].setParameter(game.saucer_x, game.saucer_y, frame.frameno);
    //        }
    //        else
    //        {
    //          game_Last.saucer[0].set(game.saucer_x, game.saucer_y, game.saucer_size, frame.frameno);
    //          game_Last.saucer_present = true;
    //        }
    //      }
    //      else
    //      {
    //        game_Last.saucer_present = game.saucer_present;
    //      }
    //      // Schiff in Richtung auf das nächstgelegene Objekt drehen
    //      // mathematisch wird hier das Kreuzprodukt aus den Vektoren 
    //      // ship_dx/y/0 und min_dx/y/0 berechnet
    //      saucerFound = false;
    //      if (TargetData.CollisionObjects.Keys.Count > 0)
    //      #region TargetData.CollisionObjects.Keys.Count > 0
    //      {
    //        collisionFound = true;
    //        int shortTime = 0xfffffff, delta_drehung, hashKeyValue = 0;
    //        foreach (int intKey in TargetData.CollisionObjects.Keys)
    //        {
    //          target = (Target)TargetData.CollisionObjects[intKey];
    //          if (shortTime > target.ship_collision_frame)
    //          {
    //            shortTime = target.ship_collision_frame;
    //            hashKeyValue = intKey;
    //          }
    //        }
    //        if (!TargetData.CollisionObjects.ContainsKey(hashKeyValue)) Console.WriteLine(string.Format("Fehler: Hashschlüsse {0} nicht gefunden?!", hashKeyValue));
    //        target = (Target)TargetData.CollisionObjects[hashKeyValue];
    //        drehung = (Drehungen)TargetData.DrehungHash[game.ship_dx.ToString() + " " + game.ship_dy.ToString()];
    //        delta_drehung = drehung.Nummer - target.hit_drehung_ship.Nummer;
    //        while (delta_drehung < -32) delta_drehung += 64;
    //        while (delta_drehung > 31) delta_drehung -= 64;
    //        if (delta_drehung < 0)
    //        {
    //          keys.right(true);
    //          keys.left(false);
    //        }
    //        else if (delta_drehung > 0)
    //        {
    //          keys.left(true);
    //          keys.right(false);
    //        }
    //        else
    //        {
    //          keys.left(false);
    //          keys.right(false);
    //        }
    //        fireActiv = false;
    //        if (delta_drehung == 0)
    //        {
    //          if (target.delta_hit_frame >= 0)
    //          {
    //            keys.left(true);
    //          }
    //          else
    //          {
    //            if (target.ship_collision_frame < 50)
    //              fireActiv = true;
    //            else if (target.ship_collision_frame < 100 && game.nshots < 4)
    //              fireActiv = true;
    //            else if (target.ship_collision_frame < 200 && game.nshots < 3)
    //              fireActiv = true;
    //            else if (target.ship_collision_frame < 300 && game.nshots < 2)
    //              fireActiv = true;
    //            else if (game.nshots < 1)
    //              fireActiv = true;
    //            else fireActiv = false;

    //          }
    //        }
    //      }
    //      #endregion
    //      else if (game.saucer_present && TargetData.SaucerObjects.Keys.Count > 0)
    //      #region game.saucer_present
    //      {
    //        //TargetData.ConsoleWriteLine("SAUCER");
    //        saucerFound = true;
    //        Drehung_Target drehung_target;
    //        int delta_drehung;
    //        if (TargetData.SaucerObjects.ContainsKey(1))
    //        {
    //          target_new = (Target_new)TargetData.SaucerObjects[1];
    //          if (target_new.Hitlist.Count > 0)
    //          {
    //            drehung = (Drehungen)TargetData.DrehungHash[game.ship_dx.ToString() + " " + game.ship_dy.ToString()];
    //            drehung_target = (Drehung_Target)target_new.Hitlist[0];
    //            delta_drehung = TargetData.shipWinkelNumber - drehung_target.Drehung_Nummer;
    //            while (delta_drehung < -32) delta_drehung += 64; // dx normalisieren auf -512 ... 511
    //            while (delta_drehung > 31) delta_drehung -= 64;
    //            if (delta_drehung < 0)
    //            {
    //              keys.right(true);
    //              keys.left(false);
    //            }
    //            else if (delta_drehung > 0)
    //            {
    //              keys.left(true);
    //              keys.right(false);
    //            }
    //            else
    //            {
    //              keys.left(false);
    //              keys.right(false);
    //            }
    //            fireActiv = false;
    //            if (delta_drehung >= -1 && delta_drehung <= 1)
    //            {
    //              fireActiv = drehung_target.Feuer_frei;
    //            }
    //          }
    //        }
    //      }
    //      #endregion
    //      else if (TargetData.NewTargetObjects.Keys.Count > 0)
    //      {
    //        targetFound = true;
    //        int delta_hit = 0x1FFFFF, trefferdauer = 0;
    //        int delta_drehung = 0x1FFFFF, min_delta_drehung = 0x1FFFFF;
    //        int Wartezeit = 0x1FFFFF, min_Wartezeit = 0x1FFFFF;
    //        int anzahl_targets = 0, max_anzahl_targets = 0;
    //        int target_distance = 0x1FFFFF;
    //        double min_distance = 1500;
    //        drehung = (Drehungen)TargetData.DrehungHash[game.ship_dx.ToString() + " " + game.ship_dy.ToString()];
    //        for (int i = 0; i < Trefferquote.GetLength(0); i++)
    //        {
    //          Trefferquote[i, 0] = 0;
    //          Trefferquote[i, 1] = Wartezeit;
    //          Trefferquote[i, 2] = trefferdauer;
    //          Trefferquote[i, 3] = target_distance;
    //        }
    //        foreach (int intKey in TargetData.NewTargetObjects.Keys)
    //        {
    //          target_new = (Target_new)TargetData.NewTargetObjects[intKey];
    //          foreach (Drehung_Target drehung_Target in target_new.Hitlist)
    //          {
    //            Trefferquote[drehung_Target.Drehung_Nummer, 0] += 1;
    //            Trefferquote[drehung_Target.Drehung_Nummer, 1] = drehung_Target.Wartezeit;
    //            Trefferquote[drehung_Target.Drehung_Nummer, 2] = drehung_Target.Zieldauer;
    //            Trefferquote[drehung_Target.Drehung_Nummer, 3] = (int)drehung_Target.Distance;
    //          }
    //        }
    //        for (int i = 1; i < Trefferquote.GetLength(0); i++)
    //        {
    //          anzahl_targets = Trefferquote[i, 0];
    //          Wartezeit = Trefferquote[i, 1];
    //          trefferdauer = Trefferquote[i, 2];
    //          if (anzahl_targets > 0) // Ziel gefunden
    //          {
    //            delta_drehung = drehung.Nummer - i;
    //            if (delta_drehung < -32) delta_drehung += 63;
    //            if (delta_drehung > 31) delta_drehung -= 63;
    //            trefferdauer = Trefferquote[i, 2];
    //            distance = Trefferquote[i, 3];
    //            if (distance < min_distance)
    //            {
    //              min_delta_drehung = delta_drehung;
    //              min_distance = distance;
    //            }
    //            //if (Math.Abs(delta_drehung) < trefferdauer + Wartezeit) // Ziel erreichbar
    //            //{
    //            //    if (Math.Abs(delta_drehung) < Math.Abs(min_delta_drehung) && Wartezeit < min_Wartezeit)
    //            //    {
    //            //        min_delta_drehung = delta_drehung;
    //            //        min_Wartezeit = Wartezeit;
    //            //    }
    //            //}
    //          }
    //        }
    //        if (min_delta_drehung < 0)
    //        {
    //          keys.right(true);
    //          keys.left(false);
    //        }
    //        else if (min_delta_drehung > 0)
    //        {
    //          keys.left(true);
    //          keys.right(false);
    //        }
    //        else
    //        {
    //          keys.left(false);
    //          keys.right(false);
    //        }
    //        if (delta_drehung == 0) //>= -1 && delta_drehung <= 1)
    //        {
    //          if (min_Wartezeit > 0)
    //          {

    //            //keys.left(true);
    //            //Console.Write(string.Format("."));
    //            //     "Zielframes: {0}", target.delta_hit_frame));
    //          }
    //          else
    //          {
    //            TargetData.ConsoleWriteLine("Feuerbefehl mit neuem Targetdingens");
    //            fireActiv = true;
    //          }
    //        }
    //        //Teste mal dauerfeuer
    //        fireActiv = true;
    //      }
    //      else if (TargetData.TargetObjects.Keys.Count > 0)
    //      #region TargetData.TargetObjects.Keys.Count > 0
    //      {
    //        targetFound = true;
    //        int shortTime = 0xfffffff, delta_drehung, hashKeyValue = 99999;
    //        foreach (int intKey in TargetData.TargetObjects.Keys)
    //        {
    //          target = (Target)TargetData.TargetObjects[intKey];
    //          drehung = (Drehungen)TargetData.DrehungHash[game.ship_dx.ToString() + " " + game.ship_dy.ToString()];
    //          delta_drehung = TargetData.shipWinkelNumber - target.hit_drehung_ship.Nummer;
    //          while (delta_drehung < -32) delta_drehung += 64;
    //          while (delta_drehung > 31) delta_drehung -= 64;
    //          if (shortTime > (int)(target.delta_hit_frame + (delta_drehung)))
    //          {
    //            shortTime = target.delta_hit_frame + (delta_drehung);
    //            hashKeyValue = intKey;
    //          }
    //        }
    //        if (!TargetData.TargetObjects.ContainsKey(hashKeyValue))
    //          Console.WriteLine(string.Format("Fehler: Hashschlüsse {0} nicht gefunden?!", hashKeyValue));
    //        target = (Target)TargetData.TargetObjects[hashKeyValue];
    //        drehung = (Drehungen)TargetData.DrehungHash[game.ship_dx.ToString() + " " + game.ship_dy.ToString()];
    //        delta_drehung = TargetData.shipWinkelNumber - target.hit_drehung_ship.Nummer;
    //        while (delta_drehung < -32) delta_drehung += 64; // dx normalisieren auf -512 ... 511
    //        while (delta_drehung > 31) delta_drehung -= 64;
    //        if (delta_drehung < 0)
    //        {
    //          keys.right(true);
    //          keys.left(false);
    //        }
    //        else if (delta_drehung > 0)
    //        {
    //          keys.left(true);
    //          keys.right(false);
    //        }
    //        else
    //        {
    //          keys.left(false);
    //          keys.right(false);
    //        }
    //        if (delta_drehung >= -1 && delta_drehung <= 1)
    //        {
    //          if (target.delta_hit_frame > 1)
    //          {
    //            //keys.left(true);
    //            //Console.Write(string.Format("."));
    //            //     "Zielframes: {0}", target.delta_hit_frame));
    //          }
    //          else
    //          {
    //            fireActiv = true;
    //          }
    //        }
    //      }
    //      #endregion
    //      else
    //      {
    //        Kreuzprodukt = game.ship_dx * min_dy - game.ship_dy * min_dx;
    //        hashKey = game.ship_dx.ToString() + " " + game.ship_dy.ToString();
    //        if (Kreuzprodukt > 0)
    //          keys.left(true);
    //        else
    //          keys.right(true);
    //      }
    //      game_Last.saucer_present = game.saucer_present;
    //      if (min_dist < 27 * 27)  // Flucht, wenn Kollision unausweichlich
    //        keys.hyperspace(true);

    //      //if (min_dist > thrustValue) // beschleunigen, wenn nichts in der Nähe
    //      //    keys.thrust(true);

    //      //if (game.saucer_present || collisionFound)
    //      if (t % fireSpeed == 0)  // Feuerknopf drücken, so schnell es geht
    //      {
    //        if (collisionFound)
    //        {
    //          //Console.Write("!");
    //          keys.fire(fireActiv);  // fireActiv); 
    //        }
    //        else if (saucerFound)
    //        {
    //          //keys.fire(false); //fireActiv);
    //          keys.fire(fireActiv);
    //        }
    //        else if (targetFound)
    //        {
    //          if (game.nasteroids > 0)
    //            keys.fire(fireActiv);  // fireActiv); 
    //        }
    //        else
    //        {
    //          if (game.nasteroids > 0)
    //            //Console.Write("?");
    //            keys.fire(true);
    //        }
    //      }

    //      Punkt_new ship_Position_now = new Punkt_new(TargetData.shipPosition.x_int, TargetData.shipPosition.y_int);
    //      double ship_null_distance = ship_Position_now.Distance(NullPunkt);
    //      if (ship_null_distance > 20)
    //      {
    //        double Beschleunigungsrate = 0.1;
    //        if (ship_null_distance > 196)
    //        {
    //          Beschleunigungsrate = 1.0;
    //        }
    //        else
    //        {
    //          Beschleunigungsrate = Math.Sqrt(ship_null_distance) / 14 * 1.0;
    //        }
    //        if (TargetData.shipSpeed < Beschleunigungsrate)
    //        {
    //          double SchubWinkel = TargetData.Winkel(ship_Position_now, NullPunkt);
    //          int Wunschrichtung = TargetData.getDrehung(SchubWinkel).Nummer;
    //          int delta_drehung = Wunschrichtung - TargetData.shipWinkelNumber;
    //          while (delta_drehung < -32) delta_drehung += 64;
    //          while (delta_drehung > 31) delta_drehung -= 64;
    //          if (Math.Abs(delta_drehung) < 2) keys.thrust(true);
    //        }
    //      }
    //      //Console.Write(game.ship_dx.ToString() + "-" + game.ship_dy.ToString() + " ");
    //      anzahlAsteroidenOld = anzahlAsteroidenNew;
    //      for (int i = 0; i < game_Last.shots_new.shots.GetLength(0); ++i)
    //      {
    //        if (game_Last.shots_new.shots[i].saucer_shot)
    //        {
    //          if (game_Last.shots_new.shots[i].hit_ship)
    //          {
    //            if (game_Last.shots_new.shots[i].hit_frame < 5 &&
    //                game_Last.shots_new.shots[i].hit_frame > -1)
    //            {
    //              Console.WriteLine("Hyperspazi!!!");
    //              keys.hyperspace(true);
    //              game_Last.shots_new.shots[i].saucer_shot = false;
    //              game_Last.shots_new.shots[i].hit_ship = false;
    //              game_Last.shots_new.shots[i].hit_frame = 1000;
    //            }
    //          }
    //        }
    //      }
    //    }
    //    //else
    //    //{
    //    //    if (!shots_reseted)
    //    //    {
    //    //        game_Last.clear();
    //    //        shots_reseted = true;
    //    //    }
    //    //    Console.Write("x");
    //    //}
    //  }
    //}

}
