#define DEBUG_OFF
using System;
using System.Collections.Generic;
using System.Text;
using System.Threading;
using System.Net;
using System.Net.Sockets;
using System.Xml;
using System.Collections;


namespace ct.Asteroid
{
  public class Player
  {
    Socket mySocket;
    IPAddress server_ip;
    XmlDocument xml_WorkDoc;

    public Player ( Socket sock, IPAddress server )
    {
      mySocket = sock;
      server_ip = server;
    }


    public void Run ()
    {
      FramePacket frame = new FramePacket();
      KeysPacket keys = new KeysPacket();
      KeysPacket keys_old = new KeysPacket();
      GameStatus game = new GameStatus();
      CDrehung Drehung = new CDrehung(1, 1);
      CAsteroid asteroid = null;
      CAsteroidTarget cAsteroidTarget;
      ArrayList asteroiden = new ArrayList(128);
      Hashtable shotTargetHash = new Hashtable();
      CSaucer saucer;
      CFlugobject flugobject;
      CPunkt NullPunkt = new CPunkt(524, 524), Drehpunkt;
      Hashtable shotHash = new Hashtable();
      int shothashCount, internal_counter = 0, abweichung = 1;
      int actualFrame, t = 0, tmpInt, asteroid_distance, SNR, PSNR = 0, PSNR_old = 0, delta_drehung, min_delta_drehung;
      int saucer_nshots = 0, ship_nshots = 0, shot_hit_ship;
      string tmp_str;
      bool PSNR_found = false;
      char prevframe = (char)0;
      bool fire = false, doHyperspace = false;
      Random rand = new Random();
      int gotoDrehung = rand.Next(0, 359);
      int shotTargetCounter;
      CDrehung targetDrehung = CDrehung.getDrehung(gotoDrehung);
#if DEBUG_ON
      int LAST_SNR = 0, last_distance = 0x1FFFFFF;
      StringBuilder sb = new StringBuilder();
      xml_WorkDoc = new XmlDocument();
      sb.Append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><root/>");
      xml_WorkDoc.LoadXml(sb.ToString());
      XmlElement docNode = xml_WorkDoc.DocumentElement;
      XmlElement eNode = docNode.AppendChild(xml_WorkDoc.CreateElement("asteroid")) as XmlElement;
      XmlElement tNode;
      tNode = xml_WorkDoc.CreateElement("Pos");
#endif


      for (; ; )
      {
        Thread.Sleep(1);
        ++t;         // Zeit
#if DEBUG_ON
        if (t % 10000 == 0)
        {
          xml_WorkDoc.Save("..\\..\\Dump.xml");
        }
#endif
        ++keys.ping; // jedes gesendete Päckchen erhält eine individuelle Nummer zur Latenzmessung
        if (keys.ping > 255) keys.ping = (char)0;
        SendPacket(keys);
        frame = ReceivePacket();
        if (frame == null)
        {
          //keys.clear();
          continue;
        }
        internal_counter++;
        CTargets.Internal_counter = internal_counter;
        if (frame.frameno != ++prevframe || (keys.ping - frame.ping > 2))
        {
          //Console.WriteLine("Latenz " + (keys.ping - frame.ping).ToString() + ". " + (frame.frameno - prevframe).ToString() + " Frames verloren.\n");
          prevframe = frame.frameno;
        }
        actualFrame = frame.frameno;
        InterpretScreen(frame, game); //Option resetSaucer immer auf TRUE bei <game>
        keys.clear();   // alle Tasten loslassen
        for (int i = 0; i < game.nasteroids; i++)
        {
          CTargets.setAsteroid(game.asteroids[i].x, game.asteroids[i].y, actualFrame,
            game.asteroids[i].sf, game.asteroids[i].type, i);
        }
        CTargets.CleanUpAsteroids(actualFrame);
        if (!game.ship_present) CTargets.clearHitlist();
        if (game.ship_present)
        {
          #region if (game.ship_present)
          CTargets.setShip(game.ship_x, game.ship_y, game.ship_dx, game.ship_dy, actualFrame);
          CTargets.Saucer.Saucer_Present = false;
          if (game.saucer_present)
          {
            CTargets.setSaucer(game.saucer_x, game.saucer_y, game.saucer_size, actualFrame);
            CTargets.Saucer.Saucer_Present = true;
          }
          for (int i = 0; i < game.nshots; i++)
          {
            CTargets.setShot(game.shots[i].x, game.shots[i].y, actualFrame, i);
          }
          CTargets.CleanUpShots(actualFrame);
          #endregion
          #region SCHUSS analsieren
          shotHash.Clear();
          foreach (CShot al_shot in CTargets.Shots)
          {
            if (al_shot.Hit_Serialnummer > 0 && CTargets.AsteroidsHash.ContainsKey(al_shot.Hit_Serialnummer))
            {
              asteroid = CTargets.AsteroidsHash[al_shot.Hit_Serialnummer] as CAsteroid;
              if (asteroid.groesse == AsteroidGroesse.GROSS) continue;

              if (!shotHash.ContainsKey(al_shot.Hit_Serialnummer))
              {
                shotHash.Add(al_shot.Hit_Serialnummer, 1);
              }
              else
              {
                shothashCount = (int)shotHash[al_shot.Hit_Serialnummer];
                shothashCount++;
                shotHash[al_shot.Hit_Serialnummer] = shothashCount;
              }
            }
          }
          saucer_nshots = ship_nshots = 0;
          bool shot_hyperspace = false;
          foreach (CShot al_shot in CTargets.Shots)
          {
            switch (al_shot.type)
            {
              case ShotType.SAUCER:
                saucer_nshots++;
                shot_hit_ship = al_shot.HitShip;
                if (shot_hit_ship >= 0)
                {
                  if (shot_hit_ship < 10)
                  {
                    double entf1, entf2, entf3;
                    entf1 = al_shot.Position.Entfernung_XY(CTargets.Ship.Position);
                    entf2 = al_shot.Berechneposition(1).Entfernung_XY(CTargets.Ship.Berechneposition(1));
                    entf3 = al_shot.Berechneposition(2).Entfernung_XY(CTargets.Ship.Berechneposition(2));
                    if ((entf1 < 40 || entf2 < 30) || entf3 < 20)
                    {
                      TargetData.ConsoleWriteLine("{5} [{3}] Hit:{4} Aktuell:{0:#.0} Next:{1:#.0} OverNext:{2:#.0} HYPERSPAZI!! ",
                        entf1, entf2, entf3, al_shot.Serialnummer, shot_hit_ship, internal_counter);
                      shot_hyperspace = true;
                    }
                    else
                    {
                      TargetData.ConsoleWriteLine("{5} [{3}] Hit:{4} Aktuell:{0:#.0} Next:{1:#.0} OverNext:{2:#.0}",
                        entf1, entf2, entf3, al_shot.Serialnummer, shot_hit_ship, internal_counter);
                    }
                  }
                  al_shot.AktuellerFrame = actualFrame - 1;
                }
                break;
              case ShotType.SHIP: ship_nshots++; break;
            }
          }
          if (shot_hyperspace)
          {
            TargetData.ConsoleWrite("{0}", keys.keys);
            keys.clear();
            keys.hyperspace(true);
            TargetData.ConsoleWriteLine("->{0}", keys.keys);
            continue;
          }
          #endregion
          asteroid_distance = 0x1fff; SNR = -1;
          CTargets.updateHitlist();
          if (CTargets.HitList.Count > 0)
          {
            if (CTargets.HitList[0] is CAsteroid)
            {
              asteroid = CTargets.HitList[0] as CAsteroid;
              targetDrehung = asteroid.HitDrehung;
              SNR = asteroid.Serialnummer;
            }
            else
            {
              saucer = CTargets.HitList[0] as CSaucer;
              targetDrehung = saucer.HitDrehung;
              SNR = -999;
            }
          }
          #region DREHEN und SCHIESSEN und MOVING
          bool shot_open = true;
          gotoDrehung = targetDrehung - CTargets.Ship.Drehung;
          if (gotoDrehung > 100)
          {
            gotoDrehung = 0;
            shot_open = false;
          }
          if (gotoDrehung > 0)
          {
            keys.right(true);
            fire = (gotoDrehung == abweichung);
          }
          else if (gotoDrehung < 0)
          {
            keys.left(true);
            fire = (gotoDrehung == -(abweichung));
          }
          else fire = true;
          if (internal_counter % 2 == 0 && ship_nshots <= CTargets.max_shots && SNR != -1) //CTargets.Asteroids.Count > 1 && 
          {
            CTargets.hitSerialnummer = SNR;
            keys.fire(fire && shot_open);
            if (internal_counter > 999999) internal_counter -= 999999;
          }
          CTargets.Ship.Move(ref keys, NullPunkt);
          #endregion
#if DEBUG_ON
          string shotStr = "";
          foreach (CShot al_shot in CTargets.Shots)
          {
            if (al_shot.type == ShotType.SHIP)
              shotStr += string.Format("[{0}]->{1} ", al_shot.Serialnummer, al_shot.Target_Serialnummer);
          }
          Console.WriteLine(shotStr);
#endif
          #region HYPERSPACE JA/NEIN
          int hyperspace_distance;
          if (!game.ship_present)
          {
            keys.clear();
          }
          else
          {
            if (doHyperspace)
            {
              doHyperspace = false;
            }
            else
            {
              doHyperspace = shot_hyperspace;
              if (!doHyperspace)
              {
                for (int i = 0; i < CTargets.Asteroids.Count && !doHyperspace; i++)
                {
                  asteroid = CTargets.Asteroids[i] as CAsteroid;
                  hyperspace_distance =
                    (int)asteroid.Berechneposition(1).Entfernung_XY(CTargets.Ship.Berechneposition(1));
                  switch (asteroid.groesse)
                  {
                    case AsteroidGroesse.GROSS: doHyperspace = (hyperspace_distance <= 50); break;
                    case AsteroidGroesse.MITTEL: doHyperspace = (hyperspace_distance <= 30); break;
                    case AsteroidGroesse.KLEIN: doHyperspace = (hyperspace_distance <= 25); break;
                  }
                  if (doHyperspace)
                  {
                    //TargetData.ConsoleWriteLine("Hyperspace: {0} {1}", hyperspace_distance, asteroid.groesse);
                    keys.clear();
                    keys.hyperspace(true);
                  }
                }
              }
              else
              {
                keys.clear();
                keys.hyperspace(true);
              }
            }
          }
          #endregion
        }
      }
    }
    public void Run_old ()
    {
      FramePacket frame = new FramePacket();
      KeysPacket keys = new KeysPacket();
      KeysPacket keys_old = new KeysPacket();
      GameStatus game = new GameStatus();
      CDrehung Drehung = new CDrehung(1, 1);
      CAsteroid asteroid = null;
      CAsteroidTarget cAsteroidTarget;
      ArrayList asteroiden = new ArrayList(128);
      Hashtable shotTargetHash = new Hashtable();
      CSaucer saucer;
      CFlugobject flugobject;
      CPunkt NullPunkt = new CPunkt(524, 524), Drehpunkt;
      Hashtable shotHash = new Hashtable();
      int shothashCount, internal_counter = 0, abweichung = 1;
      int actualFrame, t = 0, tmpInt, asteroid_distance, SNR, PSNR = 0, PSNR_old = 0, delta_drehung, min_delta_drehung;
      int saucer_nshots = 0, ship_nshots = 0, shot_hit_ship;
      string tmp_str;
      bool PSNR_found = false;
      char prevframe = (char)0;
      bool fire = false, doHyperspace = false;
      Random rand = new Random();
      int gotoDrehung = rand.Next(0, 359);
      int shotTargetCounter;
      CDrehung targetDrehung = CDrehung.getDrehung(gotoDrehung);
#if DEBUG_ON
      int LAST_SNR = 0, last_distance = 0x1FFFFFF;
      StringBuilder sb = new StringBuilder();
      xml_WorkDoc = new XmlDocument();
      sb.Append("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?><root/>");
      xml_WorkDoc.LoadXml(sb.ToString());
      XmlElement docNode = xml_WorkDoc.DocumentElement;
      XmlElement eNode = docNode.AppendChild(xml_WorkDoc.CreateElement("asteroid")) as XmlElement;
      XmlElement tNode;
      tNode = xml_WorkDoc.CreateElement("Pos");
#endif


      for (; ; )
      {
        Thread.Sleep(1);
        ++t;         // Zeit
#if DEBUG_ON
        if (t % 10000 == 0)
        {
          xml_WorkDoc.Save("..\\..\\Dump.xml");
        }
#endif
        ++keys.ping; // jedes gesendete Päckchen erhält eine individuelle Nummer zur Latenzmessung
        if (keys.ping > 255) keys.ping = (char)0;
        SendPacket(keys);
        frame = ReceivePacket();
        if (frame == null)
        {
          //keys.clear();
          continue;
        }
        internal_counter++;
        CTargets.Internal_counter = internal_counter;
        if (frame.frameno != ++prevframe || (keys.ping - frame.ping > 2))
        {
          //Console.WriteLine("Latenz " + (keys.ping - frame.ping).ToString() + ". " + (frame.frameno - prevframe).ToString() + " Frames verloren.\n");
          prevframe = frame.frameno;
        }
        actualFrame = frame.frameno;
        InterpretScreen(frame, game); //Option resetSaucer immer auf TRUE bei <game>
        keys.clear();   // alle Tasten loslassen
        for (int i = 0; i < game.nasteroids; i++)
        {
          CTargets.setAsteroid(game.asteroids[i].x, game.asteroids[i].y, actualFrame,
            game.asteroids[i].sf, game.asteroids[i].type, i);
        }
        CTargets.CleanUpAsteroids(actualFrame);
        if (!game.ship_present) CTargets.clearHitlist();
        if (game.ship_present)
        {
          #region if (game.ship_present)
          CTargets.setShip(game.ship_x, game.ship_y, game.ship_dx, game.ship_dy, actualFrame);
          CTargets.Saucer.Saucer_Present = false;
          if (game.saucer_present)
          {
            CTargets.setSaucer(game.saucer_x, game.saucer_y, game.saucer_size, actualFrame);
            CTargets.Saucer.Saucer_Present = true;
          }
          for (int i = 0; i < game.nshots; i++)
          {
            CTargets.setShot(game.shots[i].x, game.shots[i].y, actualFrame, i);
          }
          CTargets.CleanUpShots(actualFrame);
          #endregion
          #region SCHUSS analsieren
          shotHash.Clear();
          foreach (CShot al_shot in CTargets.Shots)
          {
            if (al_shot.Hit_Serialnummer > 0 && CTargets.AsteroidsHash.ContainsKey(al_shot.Hit_Serialnummer))
            {
              asteroid = CTargets.AsteroidsHash[al_shot.Hit_Serialnummer] as CAsteroid;
              if (asteroid.groesse == AsteroidGroesse.GROSS) continue;

              if (!shotHash.ContainsKey(al_shot.Hit_Serialnummer))
              {
                shotHash.Add(al_shot.Hit_Serialnummer, 1);
              }
              else
              {
                shothashCount = (int)shotHash[al_shot.Hit_Serialnummer];
                shothashCount++;
                shotHash[al_shot.Hit_Serialnummer] = shothashCount;
              }
            }
          }
          saucer_nshots = ship_nshots = 0;
          bool shot_hyperspace = false;
          foreach (CShot al_shot in CTargets.Shots)
          {
            switch (al_shot.type)
            {
              case ShotType.SAUCER:
                saucer_nshots++;
                shot_hit_ship = al_shot.HitShip;
                if (shot_hit_ship >= 0)
                {
                  if (shot_hit_ship < 10)
                  {
                    //double entf1, entf2, entf3;
                    //entf1 = al_shot.Position.Entfernung_XY(CTargets.Ship.Position);
                    //entf2 = al_shot.Berechneposition(1).Entfernung_XY(CTargets.Ship.Berechneposition(1));
                    //entf3 = al_shot.Berechneposition(2).Entfernung_XY(CTargets.Ship.Berechneposition(2));
                    //if ((entf1 < 40 || entf2 < 30) || entf3 < 20)
                    //{
                    //  TargetData.ConsoleWriteLine("{5} [{3}] Hit:{4} Aktuell:{0:#.0} Next:{1:#.0} OverNext:{2:#.0} HYPERSPAZI!! ",
                    //    entf1, entf2, entf3, al_shot.Serialnummer, shot_hit_ship, internal_counter);
                    //  shot_hyperspace = true;
                    //}
                    //else
                    //{
                    //  TargetData.ConsoleWriteLine("{5} [{3}] Hit:{4} Aktuell:{0:#.0} Next:{1:#.0} OverNext:{2:#.0}",
                    //    entf1, entf2, entf3, al_shot.Serialnummer, shot_hit_ship, internal_counter);
                    //}
                    shot_hyperspace = true;
                  }
                  //al_shot.AktuellerFrame = actualFrame - 1;
                }
                break;
              case ShotType.SHIP: ship_nshots++; break;
            }
          }
          if (shot_hyperspace)
          {
            TargetData.ConsoleWrite("{0}", keys.keys);
            keys.clear();
            keys.hyperspace(true);
            TargetData.ConsoleWriteLine("->{0}", keys.keys);
            continue;
          }
          #endregion
          asteroid_distance = 0x1fff; SNR = -1;
          bool collision_found = false;
          int collisionAsteroids = 0;
          asteroiden.Clear();
          #region ALT!! ASTEROIDEN AUF KOLLISIONSKURS
          //foreach (CAsteroid al_asteroid in CTargets.Asteroids)
          //{
          //  if (CTargets.Asteroids.Count > 4)
          //  {
          //    shotTargetCounter = 0;
          //    foreach (CShot al_shot in CTargets.Shots)
          //    {
          //      if (al_shot.type == ShotType.SHIP && al_shot.Target_Serialnummer == al_asteroid.Serialnummer)
          //        shotTargetCounter++;
          //    }
          //    if (shotTargetCounter >= 2 && al_asteroid.groesse == AsteroidGroesse.KLEIN) continue;
          //    if (shotTargetCounter >= 3 && al_asteroid.groesse == AsteroidGroesse.MITTEL) continue;
          //  }
          //  tmpInt = al_asteroid.HitShip;
          //  if (tmpInt > 0)
          //  {
          //    collisionAsteroids++;
          //    if (tmpInt < asteroid_distance)
          //    {
          //      asteroid_distance = tmpInt;
          //      collision_found = true;
          //      SNR = al_asteroid.Serialnummer;
          //      asteroiden.Add(SNR);
          //    }
          //  }
          //}
          #endregion
          CTargets.updateHitlist();
          asteroiden = CTargets.getCollisionObjects();
          if (CTargets.Saucer.Saucer_Present && CTargets.Saucer.Flugbahn != null)
          {
            if ((collision_found && asteroid_distance > 50) || !collision_found)
            {
              SNR = -999;
            }
          }
#if DEBUG_ON
          int xml_min_dist = 70;
          asteroid = null;
          foreach (CAsteroid al_asteroid in CTargets.Asteroids)
          {
            if (al_asteroid.Position.Entfernung_XY(CTargets.Ship.Position) < xml_min_dist)
            {
              xml_min_dist = (int) al_asteroid.Position.Entfernung_XY(CTargets.Ship.Position);
              asteroid = al_asteroid;
            }
          }
          if (asteroid != null)
          {
            if (LAST_SNR != asteroid.Serialnummer)
            {
              eNode = docNode.AppendChild(xml_WorkDoc.CreateElement("asteroid")) as XmlElement;
              eNode.SetAttribute("type", asteroid.type.ToString());
              eNode.SetAttribute("groesse", asteroid.groesse.ToString());
              eNode.SetAttribute("SNR", asteroid.Serialnummer.ToString());
              tNode = xml_WorkDoc.CreateElement("Pos");
              eNode.AppendChild(tNode);
              last_distance = 0x1FFFFF;
            }
            LAST_SNR = asteroid.Serialnummer;
            if (xml_min_dist < last_distance)
            {
              tNode.InnerText = string.Format("Distanz: {2:0000} Ship:{0} Asteroid: {1}",
                CTargets.Ship.Position, asteroid.Position, xml_min_dist);
              last_distance = xml_min_dist;
            }
          }
          else
          {
            LAST_SNR = 0;
          }
#endif
          #region (PSNR > 0)
          if (PSNR > 0)
          {
            PSNR_found = false;
            if (PSNR_old != PSNR)
            {
              TargetData.ConsoleWriteLine("PSNR:{0}", PSNR);
              PSNR_old = PSNR;
            }
            #region if (collision_found)
            if (collision_found)
            {
              asteroid = CTargets.AsteroidsHash[SNR] as CAsteroid;
              if (asteroid.Parentnummer != PSNR && asteroid.HitShip > 40)
              {
                foreach (CAsteroid al_asteroid in CTargets.Asteroids)
                {
                  if (!PSNR_found)
                  {
                    PSNR_found = (al_asteroid.Parentnummer == PSNR);
                    if (PSNR_found)
                    {
                      SNR = al_asteroid.Serialnummer;
                      asteroid_distance = al_asteroid.HitShip;
                    }
                  }
                  else if (al_asteroid.Parentnummer == PSNR && al_asteroid.HitShip < asteroid_distance)
                  {
                    SNR = al_asteroid.Serialnummer;
                    asteroid_distance = al_asteroid.HitShip;
                  }
                }
              }

              else
              {
                if (asteroid.groesse != AsteroidGroesse.KLEIN) PSNR = asteroid.Parentnummer;
                else PSNR = 0;
              }
            }
            #endregion
            #region else
            else
            {
              min_delta_drehung = 1000;
              foreach (CAsteroid al_asteroid in asteroiden)
              {
                if (!PSNR_found)
                {
                  PSNR_found = (al_asteroid.Parentnummer == PSNR);
                  if (PSNR_found)
                  {
                    cAsteroidTarget = al_asteroid.targetAsteroid;
                    delta_drehung = cAsteroidTarget.abs_delta_drehung;
                    min_delta_drehung = delta_drehung;
                    SNR = al_asteroid.Serialnummer;
                  }
                  else
                  {
                    cAsteroidTarget = al_asteroid.targetAsteroid;
                    delta_drehung = cAsteroidTarget.abs_delta_drehung;
                    if (delta_drehung < min_delta_drehung)
                    {
                      min_delta_drehung = delta_drehung;
                      SNR = al_asteroid.Serialnummer;
                    }
                  }
                }
              }
            }
            #endregion
            if (!PSNR_found) PSNR = 0;
          }
          #endregion
          #region SAUCER PRESENT
          #endregion
          #region SUCH DIR DEN NÄCHSTEN - SUBOTIMAL!!!
          if (SNR > 0)
          {
            asteroid = CTargets.AsteroidsHash[SNR] as CAsteroid;
            if (asteroiden.Count == 1 && asteroid.HitShip > 40) SNR = -1;
          }
          if (SNR == -1)
          {
            delta_drehung = 0; min_delta_drehung = 1000;
            asteroid_distance = 0x1fff;
            tmp_str = "";
            foreach (CAsteroid al_asteroid in CTargets.Asteroids)
            {
              if (CTargets.Asteroids.Count > 4)
              {
                if (shotHash.ContainsKey(al_asteroid.Serialnummer)) continue; // Möglichen Treffer erkannt
                shotTargetCounter = 0;
                foreach (CShot al_shot in CTargets.Shots)
                {
                  if (al_shot.type == ShotType.SHIP && al_shot.Target_Serialnummer == al_asteroid.Serialnummer)
                    shotTargetCounter++;
                }
                if (shotTargetCounter == 2 && al_asteroid.groesse == AsteroidGroesse.KLEIN) continue;
                else if (shotTargetCounter == 3 && al_asteroid.groesse == AsteroidGroesse.MITTEL) continue;
              }
              if (al_asteroid.HitDrehung != null)
              {

                cAsteroidTarget = al_asteroid.targetAsteroid;
                if (cAsteroidTarget.P1 != null)
                {
                  delta_drehung = cAsteroidTarget.abs_delta_drehung;
                  asteroid_distance = (int)cAsteroidTarget.P1.Entfernung(CTargets.Ship.Position);
                  delta_drehung += (int)(Math.Sqrt(asteroid_distance) / al_asteroid.Radius);
                  if (delta_drehung < min_delta_drehung)
                  {
                    min_delta_drehung = delta_drehung;
                    SNR = al_asteroid.Serialnummer;
                  }
                }
                else
                {
                  //TargetData.ConsoleWriteLine("{0}:{1} cAsteroidTarget.P1 != null", al_asteroid.Serialnummer, al_asteroid.Position);
                }
              }
            }
            if (SNR == -1)
            {
              delta_drehung = 0; min_delta_drehung = 100;
              asteroid_distance = 0x1fff;
              foreach (CAsteroid al_asteroid in CTargets.Asteroids)
              {
                if (CTargets.Asteroids.Count > 4)
                {
                  if (shotHash.ContainsKey(al_asteroid.Serialnummer)) continue; // Möglichen Treffer erkannt
                  shotTargetCounter = 0;
                  foreach (CShot al_shot in CTargets.Shots)
                  {
                    if (al_shot.type == ShotType.SHIP && al_shot.Target_Serialnummer == al_asteroid.Serialnummer)
                      shotTargetCounter++;
                  }
                  if (shotTargetCounter == 1 && al_asteroid.groesse == AsteroidGroesse.KLEIN) continue;
                  else if (shotTargetCounter == 2 && al_asteroid.groesse == AsteroidGroesse.MITTEL) continue;
                }
                Drehung = CTargets.Ship.Drehung;
                Drehpunkt = Drehung.Peilpunkt.geringsteEntfernung(Drehung.Drehlinie.Kreisschnittpunkt(CTargets.Ship.Shipgebiet));
                if (Drehpunkt == null)
                  tmpInt = (int)CTargets.Ship.Position.Entfernung_XY(al_asteroid.Position);
                else
                  tmpInt = (int)Drehpunkt.Entfernung_XY(al_asteroid.Position);
                tmpInt -= (int)(al_asteroid.groesse) * 4;
                if (tmpInt < asteroid_distance)
                {
                  asteroid_distance = tmpInt;
                  SNR = al_asteroid.Serialnummer;
                  //TargetData.ConsoleWriteLine("[{0}] Alte Methode", internal_counter);
                }
              }
            }
          }
          #endregion
          else PSNR = 0;

          #region ASTEROIDEN ANPEILEN
          abweichung = 1;

          if (SNR > 0)
          {
            asteroid = CTargets.AsteroidsHash[SNR] as CAsteroid;
            #region ABWEICHUNG
            //if (asteroid.ShipDistance < 50)
            //{
            //  switch (asteroid.groesse)
            //  {
            //    case AsteroidGroesse.KLEIN: abweichung = 2; break;
            //    case AsteroidGroesse.MITTEL: abweichung = 3; break;
            //    case AsteroidGroesse.GROSS: abweichung = 4; break;
            //  }
            //}
            //else if (asteroid.ShipDistance < 100)
            //{
            //  switch (asteroid.groesse)
            //  {
            //    case AsteroidGroesse.MITTEL: abweichung = 2; break;
            //    case AsteroidGroesse.GROSS: abweichung = 3; break;
            //  }
            //}
            //else if (asteroid.ShipDistance < 150)
            //{
            //  switch (asteroid.groesse)
            //  {
            //    case AsteroidGroesse.GROSS: abweichung = 2; break;
            //  }
            //}
            //if (abweichung > 2 )
            //  TargetData.ConsoleWriteLine("{1} Abweichung: {0}",abweichung,internal_counter);
            #endregion
            targetDrehung = asteroid.HitDrehung;
            //if (targetDrehung == null)
            //  targetDrehung = CDrehung.getDrehung(
            //    (int)CDrehung.berechneWinkel(CTargets.Ship.Aktuelleposition, asteroid.Position));
          }
          #endregion
          #region SAUCER ANPEILEN
          else if (SNR == -999)
          {
            saucer = CTargets.Saucer;
            targetDrehung = saucer.HitDrehung;
            //if (targetDrehung == null)
            //{
            //  targetDrehung = CDrehung.getDrehung(
            //    (int)CDrehung.berechneWinkel(CTargets.Ship.Aktuelleposition, saucer.Aktuelleposition));
            //}
          }
          #endregion
          if (CTargets.HitList.Count > 0)
          {
            tmp_str = "";
            collision_found = false;
            if (CTargets.HitList[0] is CAsteroid)
            {
              asteroid = CTargets.HitList[0] as CAsteroid;
              //TargetData.ConsoleWriteLine("Zielasteroid:[{0}]",asteroid.Serialnummer);
              targetDrehung = asteroid.HitDrehung;
              //if (targetDrehung == null)
              //{
              //  targetDrehung = CDrehung.getDrehung(
              //    (int)CDrehung.berechneWinkel(CTargets.Ship.Aktuelleposition, asteroid.Aktuelleposition));
              //}
            }
            else
            {
              saucer = CTargets.HitList[0] as CSaucer;
              targetDrehung = saucer.HitDrehung;
              //if (targetDrehung == null)
              //{
              //  targetDrehung = CDrehung.getDrehung(
              //    (int)CDrehung.berechneWinkel(CTargets.Ship.Aktuelleposition, saucer.Aktuelleposition));
              //}
            }
          }
          #region DREHEN und SCHIESSEN und MOVING
          bool shot_open = true;
          gotoDrehung = targetDrehung - CTargets.Ship.Drehung;
          if (gotoDrehung > 100)
          {
            gotoDrehung = 0;
            shot_open = false;
          }
          if (gotoDrehung > 0)
          {
            keys.right(true);
            fire = (gotoDrehung == abweichung);
          }
          else if (gotoDrehung < 0)
          {
            keys.left(true);
            fire = (gotoDrehung == -(abweichung));
          }
          else fire = true;
          if (internal_counter % 2 == 0 && ship_nshots <= CTargets.max_shots && SNR != -1) //CTargets.Asteroids.Count > 1 && 
          {
            CTargets.hitSerialnummer = SNR;
            keys.fire(fire && shot_open);
            if (internal_counter > 999999) internal_counter -= 999999;
          }
          CTargets.Ship.Move(ref keys, NullPunkt);
          #endregion
#if DEBUG_ON
          string shotStr = "";
          foreach (CShot al_shot in CTargets.Shots)
          {
            if (al_shot.type == ShotType.SHIP)
              shotStr += string.Format("[{0}]->{1} ", al_shot.Serialnummer, al_shot.Target_Serialnummer);
          }
          Console.WriteLine(shotStr);
#endif
          #region HYPERSPACE JA/NEIN
          int hyperspace_distance;
          if (!game.ship_present)
          {
            keys.clear();
          }
          else
          {
            if (doHyperspace)
            {
              doHyperspace = false;
            }
            else
            {
              doHyperspace = shot_hyperspace;
              if (!doHyperspace)
              {
                for (int i = 0; i < CTargets.Asteroids.Count && !doHyperspace; i++)
                {
                  asteroid = CTargets.Asteroids[i] as CAsteroid;
                  hyperspace_distance =
                    (int)asteroid.Berechneposition(1).Entfernung_XY(CTargets.Ship.Berechneposition(1));
                  switch (asteroid.groesse)
                  {
                    case AsteroidGroesse.GROSS: doHyperspace = (hyperspace_distance <= 50); break;
                    case AsteroidGroesse.MITTEL: doHyperspace = (hyperspace_distance <= 30); break;
                    case AsteroidGroesse.KLEIN: doHyperspace = (hyperspace_distance <= 25); break;
                  }
                  if (doHyperspace)
                  {
                    //TargetData.ConsoleWriteLine("Hyperspace: {0} {1}", hyperspace_distance, asteroid.groesse);
                    keys.clear();
                    keys.hyperspace(true);
                  }
                }
              }
              else
              {
                keys.clear();
                keys.hyperspace(true);
              }
            }
          }
          #endregion
        }
      }
    }
    unsafe void InterpretScreen ( FramePacket packet, GameStatus game )
    {
      ushort[] vector_ram = packet.vectorram2;
      int dx;
      int dy;
      int sf;
      int vx = 0;
      int vy = 0, vz = 0, vs = 0;
      int v1x = 0;
      int v1y = 0;
      int shipdetect = 0;
      int fn = 0 + packet.frameno;
      game.clear();
      if (packet.vectorram[1] != 0xe0 && packet.vectorram[1] != 0xe2)
        return; // sollte nicht vorkommen; erster Befehl ist immer ein JMPL

      int pc = 1;
      for (; pc < 513; )
      {
        int op = vector_ram[pc] >> 12; ;
        switch (op)
        {
          case 0xa: // LABS
            vy = vector_ram[pc] & 0x3ff;
            vx = vector_ram[pc + 1] & 0x3ff;
            vs = vector_ram[pc + 1] >> 12;
            break;
          case 0xb: // HALT
            return;
          case 0xc: // JSRL
            switch (vector_ram[pc] & 0xfff)
            {
              case 0x8f3:
                game.asteroids[game.nasteroids].set(vx, vy, 1, vs, fn, game.nasteroids);
                //game.asteroids_new[game.nasteroids].set(vx, vy, 1, vs, fn, game.nasteroids);
                game.nasteroids++;
                break;
              case 0x8ff:
                game.asteroids[game.nasteroids].set(vx, vy, 2, vs, fn, game.nasteroids);
                //game.asteroids_new[game.nasteroids].set(vx, vy, 2, vs, fn, game.nasteroids);
                game.nasteroids++;
                break;
              case 0x90d:
                game.asteroids[game.nasteroids].set(vx, vy, 3, vs, fn, game.nasteroids);
                //game.asteroids_new[game.nasteroids].set(vx, vy, 3, vs, fn, game.nasteroids);
                game.nasteroids++;
                break;
              case 0x91a:
                game.asteroids[game.nasteroids].set(vx, vy, 4, vs, fn, game.nasteroids);
                //game.asteroids_new[game.nasteroids].set(vx, vy, 4, vs, fn, game.nasteroids);
                game.nasteroids++;
                break;
              case 0x929:
                game.saucer_present = true;
                game.saucer_x = vx;
                game.saucer_y = vy;
                game.saucer_size = vs;
                break;
            }
            break;
          case 0xd: // RTSL
            return;
          case 0xe: // JMPL
            /*
            pc = vector_ram[pc] & 0xfff;
            break;
            */
            return;
          case 0xf: // SVEC
            /*
            dy = vector_ram[pc] & 0x300;
            if ((vector_ram[pc] & 0x400) != 0)
                dy = -dy;
            dx = (vector_ram[pc] & 3) << 8;
            if ((vector_ram[pc] & 4) != 0)
                dx = -dx;
            sf = (((vector_ram[pc] & 8) >> 2) | ((vector_ram[pc] & 0x800) >> 11)) + 2;
            vz = (vector_ram[pc] & 0xf0) >> 4;
            */
            break;
          default:
            dy = vector_ram[pc] & 0x3ff;
            if ((vector_ram[pc] & 0x400) != 0)
              dy = -dy;
            dx = vector_ram[pc + 1] & 0x3ff;
            if ((vector_ram[pc + 1] & 0x400) != 0)
              dx = -dx;
            sf = op;
            vz = vector_ram[pc + 1] >> 12;
            if (dx == 0 && dy == 0 && vz == 15)
            {
              game.shots[game.nshots++].set(vx, vy, fn);
            }
            if (op == 6 && vz == 12 && dx != 0 && dy != 0)
            {
              switch (shipdetect)
              {
                case 0:
                  v1x = dx;
                  v1y = dy;
                  ++shipdetect;
                  break;
                case 1:
                  game.ship_present = true;
                  game.ship_x = vx;
                  game.ship_y = vy;
                  game.ship_dx = v1x - dx;
                  game.ship_dy = v1y - dy;
                  ++shipdetect;
                  break;
              }
            }
            else if (shipdetect == 1)
              shipdetect = 0;

            break;
        }
        if (op <= 0xa)
          ++pc;
        if (op != 0xe) // JMPL
          ++pc;
      }

    }
    public FramePacket ReceivePacket ()
    {

      if (mySocket.Available == 0) return null;

      int received = 0;

      EndPoint myRemoteEndpoint = new IPEndPoint(server_ip, 1979);

      byte[] receiveBytes = new byte[mySocket.Available];

      try
      {
        received = mySocket.ReceiveFrom(receiveBytes, ref myRemoteEndpoint);
      }
      catch (Exception e)
      {
        Console.WriteLine("Exception in ReceivePacket():" + e.Message);

      }

      return FramePacket.FromByteArray(receiveBytes);
    }
    void SendPacket ( KeysPacket packet )
    {

      byte[] bytCommand = packet.ToByteArray();

      int pret = mySocket.SendTo(bytCommand, bytCommand.Length, SocketFlags.None, new IPEndPoint(server_ip, 1979));
    }
  }
}
