;;; -*- Mode: LISP; Syntax: COMMON-LISP; Package: WELTRAUMPUTZE; Base: 10 -*-

(in-package :weltraumputze)

;; Compares the elements of the two lists, trying to find
;; pairs of matching elements according to the supplied
;; matches-function. Invokes synchronize on all matching
;; pairs found.
(defun synchronize-lists  (l1 l2 matches synchronize)
  (when (or (null l1) (null l2))
    (return-from synchronize-lists))
  (let ((continue-with-compare '(0 0)))
    (dolist (compare '((0 0) (0 1) (1 0) (0 2) (2 0) (0 3) (3 0) (0 4) (4 0) (0 5) (5 0)))
      (when (and (< (first compare) (length l1)) (< (second compare) (length l2)))
        (if (funcall matches (nth (first compare) l1) (nth (second compare) l2))
            (progn
              (funcall synchronize (nth (first compare) l1) (nth (second compare) l2))
              (setf continue-with-compare compare)
              (return)))))
    (synchronize-lists (nthcdr (1+ (first continue-with-compare)) l1)
                       (nthcdr (1+ (second continue-with-compare)) l2)
                       matches synchronize)))

(defun matches-test (e1 e2)
  (eq (car e1) (car e2)))

(defun synchronize-test (e1 e2)
  (format t "Matching ~A ~A~%" e1 e2))

(defun synchronize-list-test (l1 l2)
  (format t "Synchronizing ~A with ~A~%" l1 l2)
  (synchronize-lists l1 l2 #'matches-test #'synchronize-test)
  (format t "~%"))