package de.curdreinert.asteroids.display;

import java.awt.BorderLayout;

import javax.swing.JFrame;
import javax.swing.JToggleButton;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;

import de.curdreinert.asteroids.intelligence.Analysis;

public class Window extends JFrame {

	private Display display;

	private DisplayThread displayThread;

	private JToggleButton autoPilot = createAutoPilotButton();

	private ControlListener listener;

	public Window(ControlListener listener) {
		this.listener = listener;
		setTitle("Asteroids analysis display");
		setResizable(true);
		setDefaultCloseOperation(EXIT_ON_CLOSE);
		setLayout(new BorderLayout());
		display = new Display();
		add(display, BorderLayout.CENTER);
		add(autoPilot, BorderLayout.SOUTH);
		setSize(1024, 840);
		setVisible(true);

		displayThread = new DisplayThread(display);
		displayThread.start();
	}

	private JToggleButton createAutoPilotButton() {
		final JToggleButton button = new JToggleButton("Autopilot");
		button.getModel().setSelected(true);
		button.addChangeListener(new ChangeListener() {

			public void stateChanged(ChangeEvent arg0) {
				listener.autoPilotChanged(button.getModel().isSelected());
			}

		});
		return button;
	}

	public void setAnalysis(Analysis analysis) {
		displayThread.setAnalysis(analysis);
	}
}
