package de.curdreinert.asteroids.geometry;


public class Approximation implements Comparable {

	private int frames;

	private Position one;

	private Position other;
	
	private double approximation;

	public Approximation(int frames, Position one, Position other) {
		this.frames = frames;
		this.one = one;
		this.other = other;
		approximation = one.distance(other);
	}

	public int getFrames() {
		return frames;
	}

	public Position getOne() {
		return one;
	}

	public Position getOther() {
		return other;
	}

	public double approximation() {
		return approximation;
	}

	public int compareTo(Object other) {
		if (!(other instanceof Approximation)) {
			throw new IllegalArgumentException("Cannot compare " + this
					+ " to " + other);
		}
		Approximation otherApproximation = (Approximation) other;
		return (int) (approximation() - otherApproximation.approximation());
	}
	
	public String toString() {
		return approximation + " in " + frames + " frames";
	}

}
