package de.curdreinert.asteroids.screenobject;

import de.curdreinert.asteroids.base.Size;

public class Asteroid extends ScreenObject {

	private int type;

	private Size size;

	public Asteroid(int x, int y, int type, int scale) {
		super(x, y);
		this.type = type;
		this.size = Size.forAsteroid(scale);
	}

	public int getType() {
		return type;
	}

	public boolean mayBeSame(Asteroid other) {
		if (other == null) {
			return false;
		}
		if (type != other.type) {
			return false;
		}
		if (size != other.size) {
			return false;
		}
		return true;
	}

	public String getName() {
		return "A " + size + " asteroid";
	}

	public Size getSize() {
		return size;
	}
}
