package de.curdreinert.asteroids;

import java.io.IOException;

import de.curdreinert.asteroids.base.PMeter;
import de.curdreinert.asteroids.display.ControlListener;
import de.curdreinert.asteroids.display.Window;
import de.curdreinert.asteroids.intelligence.Analysis;
import de.curdreinert.asteroids.intelligence.Analyzer;
import de.curdreinert.asteroids.intelligence.Screen;
import de.curdreinert.asteroids.net.Command;
import de.curdreinert.asteroids.net.PacketListener;
import de.curdreinert.asteroids.net.UdpConnector;

public class Asteroids {

	private String host = "localhost";

	private int port = 1979;

	private Window window = null;

	private boolean autoPilot = true;

	private UdpConnector connector;

	public static void main(String[] args) {
		final Asteroids main = new Asteroids();
		try {
			main.parseArguments(args);
		} catch (Exception e) {
			usage();
			return;
		}
		main.run();
	}

	private void parseArguments(String[] args) {
		int i = 0;
		while (i < args.length) {
			if ("-h".equals(args[i])) {
				host = args[i + 1];
				i += 2;
			} else if ("-p".equals(args[i])) {
				port = Integer.valueOf(args[i + 1]);
				i += 2;
			} else if ("-d".equals(args[i])) {
				window = new Window(new ControlListener() {

					public void autoPilotChanged(boolean autoPilot) {
						Asteroids.this.autoPilot = autoPilot;
						if (!autoPilot) {
							try {
								connector.send(new Command());
							} catch (IOException e) {
								// ignore
							}
						}
					}

				});
				i++;
			} else if ("-a".equals(args[i])) {
				autoPilot = false;
				i++;
			}
		}
	}

	private void run() {

		try {
			connector = new UdpConnector(host, port);
			connector.addListener(new PacketListener() {

				public Command packetReceived(byte[] data) {
					PMeter meter = new PMeter();
					Screen screen = new Screen(data);
					meter.measure("screen parsing");
					Command command = new Command();
					if (screen != null) {
						Analyzer analyzer = new Analyzer(screen);
						meter.measure("object creation");

						Analysis analysis = analyzer.analyze();
						command = analysis.getCommand();
						meter.measure("object analysis");

						if (window != null) {
							window.setAnalysis(analysis);
							meter.measure("deliver for display");
						}
					}
					if (autoPilot) {
						return command;
					} else {
						return null;
					}
				}

				public void packetDisorder(byte received, byte sent) {
				}

				public void frameLoss(byte received, byte expected) {

				}

			});
			connector.run();
		} catch (IOException e) {
			e.printStackTrace();
		}
	}

	private static void usage() {
		System.err.println("usage: Main [-h host] [-p port] [-d] [-c]");
	}

}
