package de.curdreinert.asteroids.base;

public class Parameter {

	public static int getScreenHistorySize() {
		// 40 frames is less than a second. With the fastest objects (shots)
		// travelling at 8 pixels/frame, they cannot travel more than 320 pixel
		// in history, so wrap-around-error shouldn't occur (384 pixel is half
		// of the vertical screen dimension)
		// return 40;

		return 5;
	}

	public static int getAsteroidForesight() {
		return 600;
	}

	public static int getShotForesight() {
		return 5;
	}

	public static double getAsteroidCollisionRange(Size size) {
		if (Size.LARGE.equals(size)) {
			return 46;
		}
		if (Size.MEDIUM.equals(size)) {
			return 31;
		}
		return 26;
	}

	public static double getShotCollisionRange() {
		return 20;
	}

	public static int getImmediateDanger() {
		return 60;
	}

	public static int getMoreDangerousThanSaucer(Size size) {
		if (Size.LARGE.equals(size)) {
			return 180;
		}
		return 120;
	}

	public static int getFrameRange() {
		return 200;
	}

	public static double getDeviation() {
		return 0.04;
	}

	public static double getShootingDegree() {
		return 0.03;
	}

	public static int getDeviationPredictionFrames() {
		return 50;
	}

	public static double getShotVelocity() {
		return 16.0;
	}

	public static double getMaxRange() {
		return 400;
	}

	public static double getMinRange() {
		return 80;
	}

	public static int getHyperspaceRange() {
		return 2;
	}

}
