package de.curdreinert.asteroids.geometry;

public class Position {

	private int x;

	private int y;

	public Position(int x, int y) {
		this.x = x;
		this.y = y;
	}

	public int getX() {
		return x;
	}

	public int getY() {
		return y;
	}

	public String toString() {
		return x + ", " + y;
	}

	public double distance(Position other) {
		return new Vector(other, this).getLength();
	}

	public Position add(Vector vector, int frames) {
		int newX = inRange(x + (int) (frames * vector.getX()), 0, 1023);
		int newY = inRange(y + (int) (frames * vector.getY()), 128, 895);
		return new Position(newX, newY);
	}

	private int inRange(int value, int min, int max) {
		int result = value;
		int loop = max - min + 1;
		while (result < min) {
			result += loop;
		}
		while (result > max) {
			result -= loop;
		}
		return result;
	}
}
