package de.curdreinert.asteroids.intelligence;

import java.util.ArrayList;
import java.util.List;

import de.curdreinert.asteroids.geometry.Position;
import de.curdreinert.asteroids.geometry.Vector;
import de.curdreinert.asteroids.net.Command;
import de.curdreinert.asteroids.screenobject.Asteroid;
import de.curdreinert.asteroids.screenobject.ScreenObject;
import de.curdreinert.asteroids.screenobject.Shot;

public class Analysis {

	private Screen screen;

	private ScreenObject target;

	private Command command;

	private String description;

	private Position[] targetTrajectory;

	private Position prospectedTargetPosition;

	private Vector targetVector;

	private List<Shot> dangerousShots = new ArrayList<Shot>();

	private List<Shot> harmlessShots = new ArrayList<Shot>();
	
	private List<Asteroid> dangerousAsteroids = new ArrayList<Asteroid>();

	private List<Asteroid> harmlessAsteroids = new ArrayList<Asteroid>();

	public Analysis() {
	}

	public Command getCommand() {
		return command;
	}

	public void setCommand(Command command) {
		this.command = command;
	}

	public Screen getScreen() {
		return screen;
	}

	public void setScreen(Screen screen) {
		this.screen = screen;
	}

	public ScreenObject getTarget() {
		return target;
	}

	public void setTarget(ScreenObject target) {
		this.target = target;
	}

	public String getDescription() {
		return description;
	}

	public void setDescription(String description) {
		this.description = description;
	}

	public void setTargetTrajectory(Position[] targetTrajectory) {
		this.targetTrajectory = targetTrajectory;
	}

	public Position[] getTargetTrajectory() {
		return targetTrajectory;
	}

	public void setProspectedTargetPosition(Position prospectedTargetPosition) {
		this.prospectedTargetPosition = prospectedTargetPosition;
	}

	public void setTargetVector(Vector targetVector) {
		this.targetVector = targetVector;
	}

	public Position getProspectedTargetPosition() {
		return prospectedTargetPosition;
	}

	public Vector getTargetVector() {
		return targetVector;
	}

	public void addDangerousShot(Shot shot) {
		dangerousShots.add(shot);
	}

	public void addHarmlessShot(Shot shot) {
		harmlessShots.add(shot);
	}

	public List<Shot> getDangerousShots() {
		return dangerousShots;
	}

	public List<Shot> getHarmlessShots() {
		return harmlessShots;
	}

	public void addDangerousAsteroid(Asteroid asteroid) {
		dangerousAsteroids.add(asteroid);
	}

	public void addHarmlessAsteroid(Asteroid asteroid) {
		harmlessAsteroids.add(asteroid);
	}

	public List<Asteroid> getDangerousAsteroids() {
		return dangerousAsteroids;
	}

	public List<Asteroid> getHarmlessAsteroids() {
		return harmlessAsteroids;
	}



}
