﻿using System;
using PlayerLogic;
using System.Threading;

namespace PlayAsteroids
{
    public class Program : FeedbackTarget
    {
        private bool stop = false;

        public string HyperSpaceReason 
        {
            set { Console.WriteLine("Hyperspace jump: {0}", value); }
        }

        public void UpdateView(GameStatus game) 
        {
        }

        public void AcknowledgeExit()
        {
            stop = true;
        }

        static void Main(string[] args)
        {
            Console.WriteLine("\nPlayAsteroids, c't-Wettbewerbsbeitrag von Steffen Schuemann");
            if (args.Length == 0)
            {
                Console.WriteLine("Usage: PlayAsteroids [options] [Server-ip]");
                Console.WriteLine("\nOptions: --behaviour [engine]");
                Console.WriteLine("         --time [minutes]");
                Console.WriteLine("         --loop");
            }
            else
            {
                bool loop = false;
                string behaviour = "Alpha";
                int time = 0;
                string server = "127.0.0.1";

                int i = 0;
                while(i < args.Length)
                {
                    switch (args[i])
                    {
                        case "--loop":
                            loop = true;
                            break;
                        case "--behaviour":
                            if (i + 1 < args.Length)
                            {
                                behaviour = args[++i];
                            }
                            break;
                        case "--time":
                            if (i + 1 < args.Length)
                            {
                                int t = 0;
                                if(int.TryParse(args[++i], out t))
                                {
                                    time = t*60*60;
                                }
                            }
                            break;
                        default:
                            server = args[i];
                            break;
                    }
                    i++;
                }

                Program instance = new Program();
                BehaviourManager behaviours = new BehaviourManager();
                PlayerWorker worker = new PlayerWorker(instance);
                Thread playerThread = new Thread(worker.Run);
                playerThread.Start();
                Console.WriteLine("connecting...");
                worker.Connect(server, 1979);
                worker.FrameLimit = time;
                worker.Loop = loop;
                worker.PlayerBehaviour = behaviours.CreateBehaviour(behaviour);
                while (!instance.stop)
                {
                    Thread.Sleep(1000);
                }
            }
        }

        public void DrawDebugLine(double x1, double y1, double x2, double y2)
        {
            throw new NotImplementedException();
        }
    }
}
