﻿using System;
using System.Collections.Generic;
using System.Text;

namespace PlayerLogic
{
    //public struct Point2D
    //{
    //    public double x;
    //    public double y;

    //    public Point2D(double x, double y)
    //    {
    //        this.x = x;
    //        this.y = y;
    //    }

    //    public double Length
    //    {
    //        get { return Math.Sqrt(x * x + y * y); }
    //    }

    //    public double Distance(Point2D other)
    //    {
    //        return Math.Sqrt((x - other.x) * (x - other.x) + (y - other.y) * (y - other.y));
    //    }
    //}

    public class Utility
    {
        public const double PI180 = 0.017453292519943295769236907684886;
        public const double PI128 = 0.024543692606170259675489401431871;

        private static int nextId = 0;
        public static int GetNewID()
        {
            return ++nextId;
        }

        public static int modulus(int a, int m)
        {
            int mod = a % m;
            return mod >= 0 ? mod : mod + m;
        }

        public static int normalizeX(int x)
        {
            while (x < -512) x += 1024; // x normalisieren auf -512 ... 511
            while (x > 511) x -= 1024;
            return x;
        }

        public static double normalizeX(double x)
        {
            while (x < -512) x += 1024; // x normalisieren auf -512 ... 511
            while (x > 511) x -= 1024;
            return x;
        }

        public static int normalizeY(int y)
        {
            while (y < -384) y += 768;  // y normalisieren auf -384 ... 383
            while (y > 383) y -= 768;
            return y;
        }

        public static double normalizeY(double y)
        {
            while (y < -384) y += 768;  // y normalisieren auf -384 ... 383
            while (y > 383) y -= 768;
            return y;
        }

        public static double Length(double dx, double dy)
        {
            return Math.Sqrt(dx*dx + dy*dy);
        }

        public static double Distance(double x1, double y1, double x2, double y2)
        {
            return Math.Sqrt((x1 - x2) * (x1 - x2) + (y1 - y2) * (y1 - y2));
        }

        public static double AngleFromVect(double dx, double dy)
        {
            return (Math.Atan2(dx, dy) * 180.0 / Math.PI - 90.0);
        }

        public static void DirectionFromAngleByte(byte angle, out double dx, out double dy)
        {
            double w = (double)(256 - angle) * 360.0 / 256.0 * Math.PI / 180.0;
            dx = Math.Cos(w);
            dy = Math.Sin(w);
        }

        public static bool IsInside(double x, double y, double radius)
        {
            return Math.Abs(x) / 2 <= radius / 2 &&
                   Math.Abs(y) / 2 <= radius / 2 &&
                   Math.Abs(x) / 2 + Math.Abs(y) / 2 <= radius * 3 / 4;
        }

        //public static void VecorFromAngle(double angle, out double dx, out double dy)
        //{

        //}
        
        // sctc
        // gaga
        // hhag
        public static double AngleBetween(double x1, double y1, double x2, double y2)
        {
            return Math.Acos((x1 * x2 + y1 * y2) / (Length(x1, y1) * Length(x2, y2)));
        }

        public static int NearestDistance(double x1, double y1, double dx1, double dy1, double x2, double y2, double dx2, double dy2, out double dist)
        {
            dist = 0;
            double d = ((dx1 - dx2) * (dx1 - dx2) + (dy1 - dy2) * (dy1 - dy2));
            if (d < 0.001)
                return -1;
            double t = -((dx1 - dx2) * (x1 - x2) + (dy1 - dy2) * (y1 - y2)) / d;
            if (t < 0)
                return -1;
            t = (int)(t + 0.5);
            dist = Distance(x1 + dx1 * t, y1 + dy1 * t, x2 + dx2 * t, y2 + dy2 * t);
            return (int)t;
        }

        public static void InterceptCorrection(GameStatus game, int targetX, int targetY, double targetSpeedX, double targetSpeedY, out int hitPointX, out int hitPointY, out int frames)
        {
            //            double framesToFire = Math.Sqrt(targetX * targetX + targetY * targetY) / GameStatus.BULLETSPEED;

            double framesToFire = CalcOptimalHitTime(game, targetX, targetY, targetSpeedX, targetSpeedY);
            hitPointX = targetX + (int)(targetSpeedX * framesToFire);
            hitPointY = targetY + (int)(targetSpeedY * framesToFire);

            double at = Distance(targetX, targetY, hitPointX, hitPointY) / Length(targetSpeedX, targetSpeedY);
            double bt = Length(hitPointX, hitPointY) / 8.0;
            frames = (int)(at - bt + 0.5);
        }

        public static void InterceptCorrection2(GameStatus game, int targetX, int targetY, double targetSpeedX, double targetSpeedY, out int hitPointX, out int hitPointY, out int frames)
        {
            double x = targetX;
            double y = targetY;
            double t = 2;
            for (int i = 0; i < 5; ++i)
            {
                t = Math.Sqrt(x*x + y*y) / 8.0 + game.latenz;
                x = targetX + targetSpeedX * t;
                y = targetY + targetSpeedY * t;
            }

            int w = (int)(Utility.AngleBetween((int)x, (int)y, game.shipEX, game.shipEY) / Utility.PI128 + 0.5);
            double w1 = (w / 3) * 3;
            double w2 = w1 + 3;
            if (game.shipEX * y - game.shipEY * x > 0)
            {
                // Angle is to the left
                w1 = -w1;
                w2 = -w2;
            }

            // Now fit hit point to one of the ship angles
            w1 = (double)(256 - (game.shipExpectedAngle + w1)) * Utility.PI128;
            double x1, y1;
            if (CalcIntersection(0,0, Math.Cos(w1) * 8 * 72, Math.Sin(w1) * 8 * 72, targetX, targetY, targetSpeedX * 1000, targetSpeedY * 1000, out x1, out y1))
            {

            }
            w2 = (double)(256 - (game.shipExpectedAngle + w2)) * Utility.PI128;
            double x2 = (float)Math.Cos(w2);
            double y2 = (float)Math.Sin(w2);


            hitPointX = (int)(x + 0.5);
            hitPointY = (int)(y + 0.5);
            frames = (int)(t + 0.1);
        }

        public static double CalcOptimalHitTime(GameStatus game, int px, int py, double dx, double dy)
        {
            double a = px, b = dx, c = py, d = dy;
            double f = game.shipAX * 8.0f + game.shipDX;
            double h = game.shipAY * 8.0f + game.shipDY;
            double temp = -(2 * a * b + 2 * c * d) * (2 * a * b + 2 * c * d) - 4 * (b * b + d * d - f * f - h * h) * (a * a + c * c);
            double t1 = (-2 * a * b - 2 * c * d -
                         Math.Sqrt(temp)) /
                        (2 * (b * b + d * d - f * f - h * h));
            double t2 = (-2 * a * b - 2 * c * d +
                         Math.Sqrt(temp)) /
                        (2 * (b * b + d * d - f * f - h * h));
            //            Console.WriteLine("HitTimes: {0} / {1} - ({2})", t1, t2, temp);
            return (t1 < 0 ? t2 : t1);
        }

        public static int CalcOptimalFireTime(GameStatus game, double tx, double ty, double tdx, double tdy, double bdx, double bdy)
        {
            double dist = 1024*1024;
            int t = 0;

            while (true)
            {
                double newDist = PointToLineDistance(0.0f, 0.0f, bdx, bdy, tx, ty);
                if (newDist >= dist)
                    break;
                dist = newDist;
                tx += tdx;
                ty += tdy;
                t++;
            }

            int bulletTime = (int)(Length(tx, ty) / 8.0 + 0.5f);
            if (dist < 8.0f && t > bulletTime)
            {
                return t - bulletTime;
            }
            return 0;
        }

        public static double CalculateNextCollisionDistance(double objectX, double objectY, double objectDX, double objectDY, double pointX, double pointY, double criticalDist)
        {
            double minDist = -1;
            double minTime = 10 * 60 * 60;
            for (int wx = -1; wx < 2; ++wx)
            {
                for (int wy = -1; wy < 2; ++wy)
                {
                    double tx = objectX + wx * 1024;
                    double ty = objectY + wy * 768;
                    double dist = PointToLineDistance(tx, ty, tx + objectDX, ty + objectDY, pointX, pointY);
                    if (dist < criticalDist)
                    {
                        double t = Utility.Distance(tx, ty, pointX, pointY) / Utility.Length(objectDX, objectDY);
                        if (t < minTime)
                        {
                            minTime = t;
                            minDist = dist;
                        }
                    }
                }
            }
            return minDist >= 0 ? minTime : -1;
        }

        public static double PointToLineDistance(double lineX0, double lineY0, double lineX1, double lineY1, double pointX, double pointY)
        {
            return Math.Abs((lineX1 - lineX0) * (lineY0 - pointY) - (lineX0 - pointX) * (lineY1 - lineY0)) /
                          Math.Sqrt(Math.Pow(lineX1 - lineX0, 2) + Math.Pow(lineY1 - lineY0, 2));
        }

        public static bool CalcIntersection(double x1, double y1, double x2, double y2, double x3, double y3, double x4, double y4, out double ix, out double iy)
        {
            bool intersecting = false;
            double div = (y4 - y3) * (x2 - x1) - (x4 - x3) * (y2 - y1);
            ix = 0.0f;
            iy = 0.0f;
            if (Math.Abs(div) < 0.00001)
            {
                // hmpf...
                if (PointToLineDistance(x3, y3, x4, y4, x1, y1) < 8.0f)
                {
                    ix = x1;
                    iy = y1;
                    intersecting = true;
                }
            }
            else
            {
                double i1 = ((x4 - x3) * (y1 - y3) - (y4 - y3) * (x1 - x3)) / div;
                double i2 = ((x2 - x1) * (y1 - y3) - (y2 - y1) * (x1 - x3)) / div;
                if (i1 > 0.0f && i1 <1.0f && i2>0.0f && i2<1.0f)
                {
                    ix = x1 + i1 * (x2 - x1);
                    iy = y1 + i1 * (y2 - y1);
                    intersecting = true;
                }
            }
            return intersecting;
        }

        public struct Interval
        {
            private byte left;
            private byte right;

            public Interval(byte l, byte r)
            {
                left = l;
                right = r;
            }

            public byte Value
            {
                get 
                {
                    if (left > right)
                    {
                        return (byte)(((ushort)left + (ushort)right + 256)>>1);
                    }
                    else
                    {
                        return (byte)((left + right) >> 1);
                    }
                }
            }

            public void Shift(int d)
            {
                left += (byte)(d&0xff);
                right += (byte)(d&0xff);
            }

            public void Intersect(Interval other)
            {
                while (left != right && !other.IsInside(left))
                        ++left;

                while (left != right && !other.IsInside(right))
                        --right;
                
                if(left == right && !other.IsInside(left))
                {
                    left = other.left;
                    right = other.right;
                }
            }

            private bool IsInside(byte i)
            {
                if (left > right)
                    return i >= left || i <= right;
                else
                    return i >= left && i <= right;
            }
        }

        private static Interval[] shipAngles = null;
        private static byte[] angleHelper = {
                                               7, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
                                               1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
                                               7, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 
                                               1, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4
                                           };


        public static Interval AngleIntervalFromShipRotation(double rx, double ry)
        {
            double w = Math.Atan2(rx, ry) * 180.0 / Math.PI - 90.0;
            while (w < 0)
                w += 360;
            int shipImage = (int)(w / 360.0 * 64.0 + 0.5);

            if (shipAngles == null)
            {
                shipAngles = new Interval[64];
                byte i = 253;
                int idx = 0;
                foreach (byte n in angleHelper)
                {
                    shipAngles[idx++] = new Interval(i, (byte)(i + n - 1));
                    i += n;
                }
            }

            return shipAngles[shipImage];
        }
    }
}
