﻿using System;
using System.IO;

namespace PlayerLogic
{
    [BehaviourAttribute("Checker")]
    public class Checker : Behaviour
    {
        StreamWriter file;

        public Checker()
        {
            file = new StreamWriter("astro_checker.log", true);
            file.AutoFlush = true;
            file.WriteLine("New Instance at {0}", DateTime.Now.ToString("yyyyMMdd-HHmm"));

        }

        public override byte AnalyzeFrame(GameStatus game, int frameFactor, FeedbackTarget feedback)
        {
            double w = Math.Atan2(game.shipRX, game.shipRY) * 180.0 / Math.PI - 90.0;
            while (w < 0)
                w += 360;
            file.WriteLine("Frame {0}: ShipRotation: {1:F3} / {2:F3} / {3:F1}° / {4:F1}°", game.frameNumber, game.shipRX, game.shipRY, w, 360.0*(((game.frameNumber-2)*3)&0xff)/256.0);
            return (game.frameNumber & 1) != 0 ? KEY_RIGHT : (byte)0;
        }
    }
}
