// interfaceplayer.h: Beispielspieler fr Asteroids
// Matthias Fuchs
#ifndef InterfacePlayerH
#define InterfacePlayerH

class KeysPacket;
class GameStatus;
class ExtGameStatus;

class InterfacePlayer
{
public:
	virtual void Prepare(const GameStatus& gamestate) = 0;
	virtual void MakeTurn(GameStatus& gamestate, KeysPacket &turn) = 0;
	virtual void Abort(const GameStatus& gamestate) = 0;
	virtual void GameOver(const GameStatus& gamestate) = 0;
	virtual const char* GetName(void) const = 0;
	virtual const char* GetToken(void) const = 0;
	virtual const ExtGameStatus* GetExtGameStatus(void) const = 0;
	
};

#endif
