// ObjectManager.h
// Verwaltung von GameObjects

#ifndef _OBJECTMANAGER_H
#define _OBJECTMANAGER_H

#include "gameobject.h"
#include <vector>

using std::vector;
using std::iterator;

class ObjectManager {
public:
	unsigned int count();
	void copyFrom(ObjectManager* source);
	
	ObjectManager();
	~ObjectManager();

	void AutoUpdate(int frames);
	bool Update(int x, int y, int type, int scaleFactor);
	
	void Add(GameObject* o);
	void Update(ObjectManager* gameObj);
	vector<GameObject*>* GetObjects();
	void ClearDelete();
	
	GameObject* operator[](const unsigned int i);	
private:
	void ResetFlags();

	vector<GameObject*>* m_objects;
	int m_objCount;
	int m_asteroidsCount;
	int m_saucerCount;
	int m_shotsCount;

	int m_updateCounter;
};

#endif // _OBJECTMANAGER_H
