#include "player.h"
#include "smartAsteroid.h"
#include "object_vector.h"
#include <vector>
#include "math.h"
#include "target.h"
#include "definitions.h"
#include "saucer.h"

using namespace std;

#pragma once

typedef vector<smartAsteroid> SmartAsteroidVector;

struct asteroid_list
{
	asteroid_list()
		:n_totalAsteroids(0)
		,n_explodedAsteroids(0)
		,n_livingAsteroids(0)
		{};
	//absolute number of asteroids (former nasteroids)
	int n_totalAsteroids;
	//number of exploded asteroids (type 5)
	int n_explodedAsteroids;
	//number of asteroids (types 1...4)
	int n_livingAsteroids;
	Asteroid asteroids[MAX_ASTEROIDS];
};

class ODAD
{
public:
	ODAD(void);
	~ODAD(void);

	asteroid_list* get_asteroid_buffer();
	void           update();
	void           get_closest_asteroid(object_vector &current_position, target& new_target);
	void           get_locked_asteroid(target& new_target);
	void getTargets(int& count, targetVector_t& targetVector);
   void           add_entry(int index);
   void           remove_entry(int index);
   int            get_index(void);
	int            peek_index(void);
	void           release_index (int idx);
   void           validate_saucer(bool exists);
   void           update_saucer(int new_x, int new_y, int sf);
   void           get_saucer(target &saucer);
   void           lock_target(target& target);

	BOOL           update_possible;
	asteroid_list  asteroids;
	SmartAsteroidVector asteroidVector;
   int            index_map[MAX_ASTEROIDS];

   int				n_total_smartAsteroids;
	int				n_exploded_smartAsteroids;
	int				n_living_smartAsteroids;

	int            largest_idx;
	std::list<int> index_list;

   alien          UFO;
   bool           has_saucer;
};
