#include "player.h"
#include "object_vector.h"

object_vector::object_vector(void):x(0),y (0)
{
}

object_vector::object_vector(const object_vector& original):x(original.x),y (original.y)
{
}

object_vector::object_vector(double new_x, double new_y)
{
	this->x = new_x;
	this->y = new_y;
}

object_vector::~object_vector(void)
{
}

double object_vector::get_length()
{
   return x*x+y*y;
}

double object_vector::get_distance (object_vector& to)
{
	return ((to.x - x)*(to.x - x)) + ((to.y - y)*(to.y - y));
}

double object_vector::get_boundless_distance (object_vector& to)
{
   double new_x = x - to.x;
   double new_y = y - to.y;

   while (new_x < -512) new_x += 1024;
   while (new_x > 511) new_x -= 1024;

   while (new_y < -384) new_y += 768;
   while (new_y > 383) new_y -= 768;


	return ((to.x - new_x)*(to.x - new_x)) + ((to.y - new_y)*(to.y - new_y));
}


object_vector object_vector::operator - (const object_vector& op2) const
{
   object_vector temp(*this);
	temp.x -= op2.x;
	temp.y -= op2.y;
	return temp;
}

object_vector object_vector::operator + (const object_vector& op2) const
{
   object_vector temp(*this);
	temp.x += op2.x;
	temp.y += op2.y;
	return temp;
}

object_vector object_vector::operator / (double val) const
{
   object_vector temp(*this);
	if(val != 0)
	{
		temp.x/=val;
		temp.y/=val;
	}
	return temp;
}

object_vector object_vector::operator * (double val) const
{
   object_vector temp(*this);
	temp.x *= val;
	temp.y *= val;
	return temp;
}

void object_vector::dump()
{
   printf("x = %f  y = %f", x, y);
}

bool object_vector::operator == (const object_vector& op2)const
{
	if ((x eq op2.x) and (y eq op2.y))
	{
		return true;
	}
	else
	{
		return false;
	}
}

object_vector& object_vector::operator = (const object_vector& op2)
{
	x = op2.x;
   y = op2.y;
   return *this;
}


double object_vector::operator * (object_vector &val)const
{
   double scalar = 0.0;
   scalar += this->x * val.x;
   scalar += this->y * val.y;
   return scalar;
}