#include "object_vector.h"
#include "definitions.h"
#include <stdio.h>

static object_vector check_objects[enm_obj_count];
static DWORD color_list[] = {0x000000ff, 0x000000ff, 0x0000ff00, 0x00ff0000, 0x00ff0000, 0x00ffff00, 0x00ffff00};
bool stop_thread = false;
HWND hwnd_target = NULL;
HDC hdc;

DWORD WINAPI targeter(LPVOID param);

int get_width_multiplier(int new_y, int first_x, int first_y, int delta_x, int delta_y)
{
   //x = x1 + ((y - y1)*(x2 - x1))/(y2 - y1)
   double expected_x = 0.0;

   if(delta_y not_eq 0)
   {
      expected_x = ((((double)new_y - (double)first_y) * (double)delta_x) / (double)delta_y ) + (double)first_x;
   }
   else
   {
      expected_x = first_x;
   }

   return ((int)expected_x) / DEF_SCREEN_WIDTH;
}

int get_height_multiplier(int new_x, int first_x, int first_y, int delta_x, int delta_y)
{
   //y = y1 + ((y2-y1)/(x2-x1))*(x - x1)
   double expected_y = 0.0;

   if(delta_x not_eq 0)
   {
      expected_y = first_y + (delta_y/delta_x)*(new_x - first_x);
   }
   else
   {
      expected_y = first_y;
   }

   return ((int)expected_y) / DEF_SCREEN_HEIGHT;
}

#ifdef _DEBUG
void ASSERT(bool x)
{
	if (false == x)
	{
		_asm int 3;
	}
}

void ASSERT(bool x, bool& var)
{
	if (false == x)
	{
		_asm int 3;
		var = false;
	}
}
#endif

void draw_dot(HDC hdc, DWORD x, DWORD y, DWORD color)
{
   SetPixel(hdc, x-1, y-1, color);
   SetPixel(hdc, x  , y-1, color);
   SetPixel(hdc, x+1, y-1, color);

   SetPixel(hdc, x-1, y  , color);
   SetPixel(hdc, x  , y  , color);
   SetPixel(hdc, x+1, y  , color);

   SetPixel(hdc, x-1, y+1, color);
   SetPixel(hdc, x  , y+1, color);
   SetPixel(hdc, x+1, y+1, color);
}

CRITICAL_SECTION MyCritSect;

void draw_line(HDC hdc, DWORD obj_x, DWORD obj_y, DWORD x, DWORD y, DWORD color)
{
#ifndef __HOLGER__
   EnterCriticalSection( &MyCritSect );
   MoveToEx(hdc, obj_x, obj_y, NULL);
   LineTo(hdc, x, y);
   LeaveCriticalSection( &MyCritSect );
#endif //__HOLGER__
}

DWORD start_time = 0;

void init_targeter()
{
   hwnd_target = FindWindowA("MAME","MAME: Asteroids (rev 2) [asteroid]");

   InitializeCriticalSection( &MyCritSect );   

   hdc = GetDC(hwnd_target);
   SelectObject(hdc, GetStockObject(WHITE_PEN));

   CreateThread(NULL,0,targeter, NULL, 0, NULL);
}

DWORD WINAPI targeter(LPVOID param)
{
   RECT rect;

   start_time = GetTickCount();

   GetClientRect(hwnd_target, &rect);
   DWORD width = rect.right - rect.left;
   DWORD height = rect.bottom - rect.top;
   DWORD screen_pos_x;
   DWORD screen_pos_y;
   DWORD screen_pos_x_dir;
   DWORD screen_pos_y_dir;
   int ret = 0;
   DWORD err=0;
   POINT point;
   POINT ul_pt;
   char text[13] = {0};
   int len = 0;

   memset(text, 0x20, sizeof(text)-1);

   while(false == stop_thread)
   {
      GetClientRect(hwnd_target, &rect);
      width = rect.right - rect.left;
      height = rect.bottom - rect.top;

      //draw the mouse cursor position in game coordinate onto the screen for object identification
      GetCursorPos(&point);
      ScreenToClient(hwnd_target, &point);

      screen_pos_x = point.x * ((double)1024/(double)width);
      screen_pos_y = 128 + ((height-point.y) * ((double)768/(double)height));

      len = sprintf(text,"%d, %d", screen_pos_x, screen_pos_y);
      //len = sprintf(text,"%d", 300000 - (GetTickCount() - start_time));

      TextOutA(hdc, 0, 0, text, len);

      for(int i = 0; 
         i < enm_obj_count; 
         ++i)
      {
         screen_pos_x = check_objects[i].x * ((double)width/(double)1024);
         screen_pos_y = height - ((check_objects[i].y - 128.0) * ((double)height/(double)768));

         switch(i)
         {
         case enm_obj_target_dir:
            screen_pos_x_dir = check_objects[enm_obj_target].x * ((double)width/(double)1024);
            screen_pos_y_dir = height - ((check_objects[enm_obj_target].y - 128.0) * ((double)height/(double)768));

            draw_line(hdc, screen_pos_x_dir, screen_pos_y_dir , screen_pos_x, screen_pos_y, color_list[i]);
            break;
         case enm_obj_ship_dir:
            screen_pos_x_dir = check_objects[enm_obj_ship].x * ((double)width/(double)1024);
            screen_pos_y_dir = height - ((check_objects[enm_obj_ship].y - 128.0) * ((double)height/(double)768));

            draw_line(hdc, screen_pos_x_dir, screen_pos_y_dir , screen_pos_x, screen_pos_y, color_list[i]);
            break;
         case enm_obj_closest_dir:
            screen_pos_x_dir = check_objects[enm_obj_closest].x * ((double)width/(double)1024);
            screen_pos_y_dir = height - ((check_objects[enm_obj_closest].y - 128.0) * ((double)height/(double)768));

            draw_line(hdc, screen_pos_x_dir, screen_pos_y_dir , screen_pos_x, screen_pos_y, color_list[i]);
            break;

         default:
            draw_dot(hdc, screen_pos_x, screen_pos_y, color_list[i]);
            break;
         }
      }

      Sleep(0);
   }
   return 0;
}

void schedule_pos(check_object_types type, object_vector& pos)
{
   check_objects[type] = pos;
   return;
}
