#include "ODAD.h"
#include "log.h"


ODAD::ODAD(void)
:update_possible(false)
,asteroidVector(MAX_ASTEROIDS)
,n_total_smartAsteroids(0)
,n_exploded_smartAsteroids(0)
,n_living_smartAsteroids(0)
,largest_idx(0)
, has_saucer(false)
{
	ZeroMemory(&asteroids,sizeof(asteroids));
}

ODAD::~ODAD(void)
{
}

asteroid_list* ODAD::get_asteroid_buffer()
{
	asteroids.n_totalAsteroids = 0;
	asteroids.n_explodedAsteroids = 0;
	asteroids.n_livingAsteroids = 0;
	return &asteroids;
}

/*object_vector* ODAD::get_shot_buffer()
{
	shots.n_totalAsteroids = 0;
	asteroids.n_explodedAsteroids = 0;
	asteroids.n_livingAsteroids = 0;
	return &(shots[0]);
}*/



void ODAD::update()
{
   int i = 0;
   asteroid_list &current_list = asteroids;
   int n_more_asteroids = (current_list.n_totalAsteroids > n_total_smartAsteroids)?current_list.n_totalAsteroids:n_total_smartAsteroids;

   //make both lists have the same number of entries
   for(i = n_total_smartAsteroids; i < current_list.n_totalAsteroids; ++i)
   {
      int index = get_index();
      add_entry(index);
   }

   //find any object that needs to be removed
   //e.g. expired explosion
   for(i = 0; i < n_more_asteroids; ++i)
   {
      //it is safe to assume that the number of asteroids of asteroidVector 
      //matches at least n_more_asteroids; also note the boundary check for the 
      //current_list.
      if(asteroidVector[index_map[i]].type == 5
         &&
         (current_list.n_totalAsteroids < i
            ||
          (current_list.asteroids[i].type != 5 
            ||
          asteroidVector[index_map[i]].size != current_list.asteroids[i].sf)
         )
        )
      {
         //The element at this index doesn't exist anymore
         //remove it.
         this->remove_entry(i);

         if(n_total_smartAsteroids < current_list.n_totalAsteroids)
         {
            int index = get_index();
            add_entry(index);
         }
         else
         {
            // DO NOTHING HERE
         }
      }
      else
      {
      }
   }

   //update the asteroids
   for(i = 0; i < current_list.n_totalAsteroids; ++i)
   {
		int x = current_list.asteroids[i].x;
		int y = current_list.asteroids[i].y;
		scale_factor_t sf = static_cast <scale_factor_t> (current_list.asteroids[i].sf);
		int type = current_list.asteroids[i].type;

      if(asteroidVector[index_map[i]].initiated)
      {
         asteroidVector[index_map[i]].update(x, y, sf, type);
      }
      else
      {
         asteroidVector[index_map[i]].initialize(x, y, sf, type);
      }
   }

#if _DEBUG
   //dump to file
	char buffer[256];
   for(unsigned int i = 0; i < n_total_smartAsteroids; i++)
   {
      _snprintf_s(buffer, sizeof(buffer),"%d value %d", i, index_map[i]);
		log_type_text("index map", buffer);
   }
	log_newline();
	for(unsigned int i = 0; i < asteroidVector.size(); i++)
	{
		if (!asteroidVector[i].is_free)
		{
			_snprintf_s(buffer, sizeof(buffer),"%02x\tx: %6.2f  y: %6.2f  type: %d  size: %d  dx: %6.2f  dy: %6.2f", i, asteroidVector[i].act_pos.x, asteroidVector[i].act_pos.y, asteroidVector[i].type, asteroidVector[i].size,asteroidVector[i].speed.x, asteroidVector[i].speed.y);
			log_type_text("smart asteroid",buffer);
		}
	}
	log_newline();
	log_newline();
#endif
}

void ODAD::remove_entry(int index)
{
#if _DEBUG
   char text[128];
   sprintf(text,"%d  map value %d",index, index_map[ index ]);
   log_type_text("removed index", text);
#endif
   asteroidVector[ index_map[ index ] ].erase();


   for(int k = index; k < n_total_smartAsteroids - 1;k++)
   {
      index_map[k] = index_map[k + 1];
   }
   n_total_smartAsteroids--;

   release_index(index);
}

void ODAD::add_entry(int index)
{
   int help = 0;
   n_total_smartAsteroids++;

   asteroidVector[index].is_free = false;
   asteroidVector[index].initiated = false;
#if _DEBUG
   char text[128];
   sprintf(text,"%d  map value %d",index, index_map[ index ]);
   log_type_text("inserted index", text);
#endif

   for(int k = 0; k < n_total_smartAsteroids - 1;k++)
   {
      if(index < index_map[k])
      {
         help = index_map[k];
         index_map[k] = index;
         index = help;
      }
   }
   index_map[n_total_smartAsteroids - 1] = index;
}

void ODAD::get_locked_asteroid(target& new_target)
{
	smartAsteroid* p_locked_asteroid = NULL;
	int size = asteroidVector.size();

	if(0 != size)
	{
		for(int index = 0; index < size; index++)
		{
			if((false eq (asteroidVector[index].is_free)) and (asteroidVector[index].is_locked()))
			{
				p_locked_asteroid = &(asteroidVector[index]);
				break;
			}
		}

		if (p_locked_asteroid not_eq NULL)
		{
      new_target.pos = p_locked_asteroid->act_pos;
      p_locked_asteroid->get_speed(new_target.speed);
      new_target.size = p_locked_asteroid->size;
			p_locked_asteroid->recalc_rect();
      new_target.rect = p_locked_asteroid->rect;
      new_target.valid = true;
		}
		else
		{
			new_target.valid = false;
		}
	}
	else
	{
		// DO NOTHING HERE
	}

}


void ODAD::get_closest_asteroid(object_vector &current_position, target& new_target)
{
   smartAsteroid *p_nearest_asteroid = NULL;
	double last_dist = 1000000.0;
	int index=0;

	int size = this->n_total_smartAsteroids;

	if(0 != size)
	{
      object_vector speed_vector;
      p_nearest_asteroid = &asteroidVector[index_map[0]];

      for(index = 0; index < n_total_smartAsteroids; index++)
		{
			if((!(asteroidVector[index_map[index]].is_free))
			     &&
			     (5 != asteroidVector[index_map[index]].type))
			{
            asteroidVector[index_map[index]].get_speed(speed_vector);
				double dx = (asteroidVector[index_map[index]].act_pos.x/* + speed_vector.x * 100.0*/)
                        - current_position.x;
				while (dx < -512) dx += 1024; // dx normalisieren auf -512 ... 511
				while (dx > 511) dx -= 1024;

				double dy = (asteroidVector[index_map[index]].act_pos.y /*+ speed_vector.y * 100.0*/)
                        - current_position.y;
				while (dy < -384) dy += 768;  // dy normalisieren auf -384 ... 383
				while (dy > 383) dy -= 768;

				double dist = dx*dx+dy*dy;  // Quadrat des Abstands zu diesem Asteroiden
				if(last_dist > dist)
				{
					last_dist =  dist;
					p_nearest_asteroid = &asteroidVector[index_map[index]];
				}
			}
			else
			{
				//DO NOTHING HERE
			}
		}

      schedule_pos(enm_obj_closest, p_nearest_asteroid->act_pos);
      schedule_pos(enm_obj_closest_dir,(p_nearest_asteroid->act_pos + 
                                       (p_nearest_asteroid->speed / sqrt(p_nearest_asteroid->speed.get_length())) * 50.0)
                                       );

      new_target.pos = p_nearest_asteroid->act_pos;
      p_nearest_asteroid->get_speed(new_target.speed);
      new_target.size = p_nearest_asteroid->size;
		p_nearest_asteroid->recalc_rect();
      new_target.rect = p_nearest_asteroid->rect;
      new_target.valid = true;
	}
	else
	{
		// DO NOTHING HERE
	}

	//if(NULL != p_nearest_asteroid)
	//	printf("%d\ttype: %d  x: %f   y:%f  distance: %f  speed_x: %f  speed_y: %f  speed: %f\n", 
	//	index, 
	//	p_nearest_asteroid->type, 
	//	p_nearest_asteroid->act_pos.x, 
	//	p_nearest_asteroid->act_pos.y , 
	//	last_dist, p_nearest_asteroid->speed.x,
	//	p_nearest_asteroid->speed.y,
	//	sqrt(p_nearest_asteroid->speed.get_length()));

}

int ODAD::get_index(void)
{
	int ret_val = INT_MAX;
   
   largest_idx = 0;

   while (asteroidVector[largest_idx].is_free eq false)
	{
		largest_idx++;
		ASSERT(largest_idx <= 26);
	}

	ret_val = largest_idx;
   /*
   if(index_list.empty())
	{
		while (asteroidVector[largest_idx].is_free eq false)
		{
			largest_idx++;
			ASSERT(largest_idx <= 26);
		}
		ret_val = largest_idx;
		largest_idx++;
		ASSERT(largest_idx <= 26);
	}
	else
	{
		ret_val = index_list.front();
		index_list.pop_front();
	}*/

	return ret_val;
}

int ODAD::peek_index(void)
{
	int ret_val = INT_MAX;
	if(index_list.empty())
	{
		ret_val = largest_idx;
	}
	else
	{
		ret_val = index_list.front();
	}

	return ret_val;
}

void ODAD::release_index (int idx)
{
	//index_list.push_back (idx);
}

void ODAD::getTargets(int &count, targetVector_t& targetVector)
{
	int size = this->n_total_smartAsteroids;
	smartAsteroid *p_asteroid = NULL;
	int index=0;

	//this is for sure...
	count = 0;

	if(0 != size)
	{
		p_asteroid = &asteroidVector[index_map[0]];

		for(index = 0; index < n_total_smartAsteroids; index++)
		{
			if((!(asteroidVector[index_map[index]].is_free))
				&&
				(5 != asteroidVector[index_map[index]].type))
			{
				p_asteroid = &asteroidVector[index_map[index]];

				targetVector[count].pos = p_asteroid->act_pos;
				p_asteroid->get_speed(targetVector[count].speed);
				targetVector[count].size = p_asteroid->size;
				p_asteroid->recalc_rect();
				targetVector[count].rect = p_asteroid->rect;
				targetVector[count].valid = true;

				count++;
			}
		}//for
	}//0 != size
}

void ODAD::lock_target(target& target)
{
	smartAsteroid comp;
	for(int i = 0; i < n_total_smartAsteroids; i++)
	{
		comp = asteroidVector[index_map[i]];
		if ((comp.size eq target.size)		and
			(comp.act_pos eq target.pos))
		{
			asteroidVector[index_map[i]].set_lock();
		}
	}
}

void ODAD::validate_saucer(bool exists)
{
   if((!exists) && (has_saucer))
   {
      has_saucer = false;
      //saucer is on the screen (either destroyed or hasn't occurred yet)
   }
   else
   {
      //DO NOTHING HERE
   }
}

void ODAD::update_saucer(int new_x, int new_y, int sf)
{
   has_saucer = true;
   UFO.update(new_x, new_y, sf);
}

void ODAD::get_saucer(target &saucer)
{
   if(has_saucer)
   {
      UFO.get_position(saucer.pos);
      UFO.get_direction(saucer.dir);
      UFO.get_speed(saucer.speed);
      saucer.valid = true;
   }
   else
   {
      saucer.valid = false;
   }
}
