#include "player.h"
#include "operatoren.h"
#include "ODAD.h"
#include "ship.h"
#include "math.h"
#include "target.h"
#pragma once

#define MAKE_DX(IN_DX) (( ((~IN_DX) & 0x200 ) - 0x200) | (IN_DX & 0x1ff))

#define PI 3.1415926535897932384626433832795
#define NUM_SECTORS 8
const int wbTable[] = {0,9,28,36,55,72,82,101,110,127,139,155,165,184,193,212,225,234,252,266,281,295,306,328,335,347,367,378,392,406,417,438,450,462,483,494,508,522,533,553,565,572,594,605,619,634,647,666,675,688,707,716,735,745,761,773,790,799,818,828,845,864,872,891,900,919,928,945,955,972,989,1001,1018,1027,1047,1055,1073,1084,1102,1112,1134,1141,1153,1173,1181,1202,1214,1228,1242,1256,1267,1278,1300,1311,1325,1338,1350,1361,1383,1394,1408,1422,1433,1453,1465,1479,1498,1510,1519,1539,1550,1566,1579,1588,1607,1618,1636,1645,1663,1673,1692,1701,1718,1728,1743,1766,1773,1791,1800,1819,1829,1844,1855,1872,1889,1899,1915,1927,1945,1956,1973,1982,2003,2012,2030,2041,2050,2069,2081,2097,2110,2121,2142,2154,2166,2178,2200,2210,2225,2238,2250,2262,2275,2289,2300,2322,2333,2346,2359,2378,2390,2403,2419,2431,2451,2459,2470,2488,2498,2518,2527,2545,2555,2573,2584,2601,2611,2628,2645,2656,2673,2681,2700,2709,2727,2736,2755,2772,2782,2799,2808,2827,2837,2855,2865,2882,2893,2912,2921,2934,2950,2961,2981,2990,3002,3022,3035,3047,3067,3078,3092,3106,3117,3138,3150,3162,3175,3189,3200,3222,3233,3245,3258,3272,3286,3298,3319,3327,3347,3359,3366,3388,3398,3416,3427,3445,3453,3472,3482,3499,3511,3528,3545,3555,3572,3581};

class pilot
{
typedef enum key_t {c_undef=0,c_left,c_right}dir_t;
public:
	pilot (KeysPacket& keys, ODAD& radar, ship& theShip, GameStatus& theWorldAroundMe);
	void set_new_course (void);
	void set (unsigned char frame_no);
	void set_ping(unsigned char in_ping);
	unsigned char get_ping(void);

private:
	KeysPacket& m_keys;
	ODAD& m_yRadar;
	ship& m_yShip;
	GameStatus& m_yWorld;
	targetVector_t m_targetVector;
	int m_closeAsteroids;
	int m_target_count;
	int m_sector_cnt[NUM_SECTORS];
	struct frame_t
	{
		unsigned char last;
		unsigned char act;
		unsigned char gone;
	}frame;

	struct ping_t
	{
		dir_t key;
		unsigned char ping;
	}key_packet[5];

	unsigned char ping_back;
	unsigned char ping_byte;
	
	double m_shipAngle_byWB;

protected:
	int get_saucer_scale(target& item);
	int get_distance_scale(target& item);
	int get_angle_scale(target& item);
	int get_sector_scale(target& item);
   int get_target_collision_scale(target &item);
	void get_sectors(void);
	double get_ship_angle(void);
	double get_target_angle_related_to_ship(target& item);
	bool collision_alert(target& item);
};