#include "saucer.h"

alien::alien(void):
  current_index(-1)
, samples(0)
{
}

alien::~alien(void)
{
}

void alien::update(int new_x, int new_y, int sf)
{
   ++samples;
   ++current_index;
   current_index %= DEF_SAMPLE_RATE;

   pos[current_index].x = new_x;
   pos[current_index].y = new_y;
   sample_time[current_index] = GetTickCount();
}

void alien::get_position(object_vector& saucer)
{
   saucer = pos[current_index];
}

void alien::get_direction(object_vector& direction)
{
   int first_index = (samples - 1) % DEF_SAMPLE_RATE;
   direction = pos[current_index] - pos[first_index];
}

void alien::get_speed(object_vector& speed)
{
   int first_index = (samples - current_index) % DEF_SAMPLE_RATE;
   speed = pos[current_index] - pos[first_index];
   speed = speed / (sample_time[current_index] - sample_time[first_index]);

}
