#include "object_vector.h"
#include <list>
#include <windows.h>
#include "operatoren.h"

using namespace std;

#pragma once


#define MAX_LOCK_TIME 350

enum scale_factor_t
{
	c_smallSized = 14,
	c_mediumSized = 15,
	c_bigSized = 0
};


typedef unsigned int asteroid_type;

#define _STEPS_ 8

class smartAsteroid
{
public:
	smartAsteroid(void);
	smartAsteroid(int in_x1, int in_y1, int in_x2, int in_y2, scale_factor_t in_size, asteroid_type tp);
	~smartAsteroid(void);
	bool evaluatePosition (int x, int y);
	void recalc_rect (void);
	void update(int new_x, int new_y, scale_factor_t sf, asteroid_type new_type);
	bool initiated;
   bool update_able;
	void initialize (int x, int y, scale_factor_t sf, asteroid_type tp);
	bool check_position (object_vector& new_position);
	void erase (void);
	void get_speed(object_vector& obj_speed);
	void get_dir(object_vector& dir);

	//debug methods
	void dump();

	object_vector act_pos;
	object_vector fst_pos;
	DWORD fst_tick;
	DWORD last_tick;

	scale_factor_t size;

	bool has_position;
	bool is_free;
	RECT rect;
	asteroid_type type;
	object_vector speed;

	void set_lock (void);
	bool is_locked(void);

private:
	bool pilot_lock;
	DWORD lock_time;
};
