﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.Net;
using System.Net.Sockets;
using System.Threading;

namespace AKTGR_Asteroids
{
    public partial class Form1 : Form
    {
        public IPAddress serverIp;
        public int serverPort;
        public Player1 player;
        public Connection connection;
        public string name;
        public Thread playerThread;
        public Graphics g;
        public VectorMachine vm;
        delegate void SetTextCallback(string pText);
        delegate void SetTextCallback2(string pFrameNo, string pLatency, string pDrop);
        delegate void SetTextCallback3(string pFrameNo);
        delegate void SetTextCallback4(string pAngle);


        public Form1()
        {
            InitializeComponent();
        }


        private void buttonConnect_Click(object sender, EventArgs e)
        {
            buttonConnect.Enabled = false;
            buttonDisconnect.Enabled = true;
            listBox.Items.Clear();
            g = this.pictureBox.CreateGraphics();
            //g.Dispose();
            name = textPlayer.Text;
            serverPort = Convert.ToInt32(textPort.Text);
            try
            {
                //check if IP address is numerical
                serverIp = IPAddress.Parse(textServer.Text);
            }
            catch (System.FormatException)
            {
                try
                {
                    //resolve name using DNS
                    IPHostEntry server = Dns.GetHostEntry(textServer.Text);
                    serverIp = IPAddress.Parse(server.AddressList[1].ToString());
                }
                catch
                {

                }
            }
            connection = new Connection(serverIp, serverPort);
            player = new Player1(connection, name, this.g, this);
            playerThread = new Thread(new ThreadStart(player.Run));
            playerThread.IsBackground = true;
            playerThread.Start();
        }

        private void buttonDisconnect_Click(object sender, EventArgs e)
        {
            playerThread.Abort();
            playerThread = null;
            player = null;
            connection.Disconnect();
            connection = null;
            buttonConnect.Enabled = true;
            buttonDisconnect.Enabled = false;

        }


        private void Form1_Load(object sender, EventArgs e)
        {

        }

        private void pictureBox_Click(object sender, EventArgs e)
        {
            g = this.pictureBox.CreateGraphics();
            vm = new VectorMachine(g);

        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {

        }

        public void addText(string pText)
        {
            if (this.listBox.InvokeRequired)
            {
                SetTextCallback d = new SetTextCallback(addText);
                this.Invoke(d, new object[] { pText });
            }
            else
            {
                this.listBox.Items.Add(pText);
            }
        }

        public void actText(string pFrameNo)
        {
            if (this.textBoxActFrame.InvokeRequired)
            {
                SetTextCallback3 d = new SetTextCallback3(actText);
                this.Invoke(d, new object[] { pFrameNo });
            }
            else
            {
                this.textBoxActFrame.Text = pFrameNo;
            }
        }


        public void actText(string pFrameNo, string pLatency, string pDrop)
        {
            if (this.textBoxProblemFrame.InvokeRequired)
            {
                SetTextCallback2 d = new SetTextCallback2(actText);
                this.Invoke(d, new object[] { pFrameNo, pLatency, pDrop });
            }
            else
            {
                this.textBoxProblemFrame.Text = pFrameNo;
            }
            if (this.textBoxLatency.InvokeRequired)
            {
                SetTextCallback2 d = new SetTextCallback2(actText);
                this.Invoke(d, new object[] { pFrameNo, pLatency, pDrop });
            }
            else
            {
                this.textBoxLatency.Text = pLatency;
            }
            if (this.textBoxDropped.InvokeRequired)
            {
                SetTextCallback2 d = new SetTextCallback2(actText);
                this.Invoke(d, new object[] { pFrameNo, pLatency, pDrop });
            }
            else
            {
                this.textBoxDropped.Text = pDrop;
            }

        }

        public void actAngle(string pAngle)
        {
            if (this.textBoxSAng.InvokeRequired)
            {
                SetTextCallback4 d = new SetTextCallback4(actAngle);
                this.Invoke(d, new object[] { pAngle });
            }
            else
            {
                this.textBoxSAng.Text = pAngle;
            }
        }

        public void actBooleans(ref Boolean doGraphics,
                                ref Boolean doVectors,
                                ref Boolean doText,
                                ref Boolean doKeys,
                                ref Boolean doTarget)
        {
            doGraphics = this.checkBoxGraphics.Checked;
            doVectors = this.checkBoxVectors.Checked;
            doText = this.checkBoxText.Checked;
            doKeys = this.checkBoxKeys.Checked;
            doTarget = this.checkBoxTarget.Checked;
        }
    }
}
