﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

namespace AKTGR_Asteroids
{
    public class KeysPacket
    {
        const int KEY_HYPERSPACE = 1;
        const int KEY_FIRE = 2;
        const int KEY_THRUST = 4;
        const int KEY_RIGHT = 8;
        const int KEY_LEFT = 16;
        public int keys;

        public char ping;     // wird vom Server bei nächster Gelegenheit zurückgeschickt. Für Latenzmessung.

        public KeysPacket()
        {
            keys = '@';
            ping = (char)0;
        }

        public byte[] ToByteArray()
        {
            byte[] byts = new byte[8];

            byts[0] = (byte)'c';
            byts[1] = (byte)'t';
            byts[2] = (byte)'m';
            byts[3] = (byte)'a';
            byts[4] = (byte)'m';
            byts[5] = (byte)'e';
            byts[6] = (byte)keys;
            byts[7] = (byte)ping;

            return byts;
        }

        public void clear()
        {
            keys = '@';
        }


        public void hyperspace(bool b)
        {
            if (b)
                keys |= KEY_HYPERSPACE;
            else
                keys &= ~KEY_HYPERSPACE;
        }

        public void fire(bool b)
        {
            if (b)
                keys |= KEY_FIRE;
            else
                keys &= ~KEY_FIRE;
        }

        public void thrust(bool b)
        {
            if (b)
                keys |= KEY_THRUST;
            else
                keys &= ~KEY_THRUST;
        }

        public void left(bool b)
        {
            if (b)
            {
                keys |= KEY_LEFT;
                right(false);
            }
            else
                keys &= ~KEY_LEFT;
        }

        public void right(bool b)
        {
            if (b)
            {
                keys |= KEY_RIGHT;
                left(false);
            }
            else
                keys &= ~KEY_RIGHT;
        }
    }
}
