/// this methode connecto to the local server (original code)

#include <stdio.h>
#include <math.h>
#include "netcom.h"
#include "framescanner.h"
#include "tools.h"
#include "sandbox.h"
#include "planhit.h"
#include "control.h"

void speedTest()
{
	timeFrameC frame;

	{
		vecT<float> h;
		for (int a=0;a<100;a++)
		for (int i=0;i<1000000;i++)
		{			
			vecT<float> f(i*10,i+1*10);
			float len=f.len();
			h=h+f+f+f*len;
		}
	}
	long t1=frame.runTime(1);

	{	vecT<float> h;
		for (int a=0;a<100;a++)
		for (int i=0;i<1000000;i++)
		{
			vecT<float> f(i*10,i+1*10);
			float len=f.len();
			h=h+f+f+f*len;

		}
	}
	long t2=frame.runTime(1);

	printLog("%d %d\n",t1,t2);
}

void circleTest()
{


	vecDblC m(10,10);
	vecDblC p0(9,8);
	vecDblC d0(2,1);

	vecDblC a1,a2;
	
	intersectLineCircle(p0,d0,m,4,a1,a2);

	float f1,f2;
	intersectLineCircle(p0,d0,m,4,f1,f2);

	float resArray[10];
	int    resCount;
	intersectWrapLinePoint(p0,d0,m,4,100000,2,&resCount,resArray);

	vecDblC ph1=p0+d0*resArray[0];
	vecScreenPositionMap(ph1);
	float   t1=(ph1-m).len();
	vecDblC ph2=p0+d0*resArray[1];
	vecScreenPositionMap(ph2);
	float   t2=(ph2-m).len();

	printLog(".");
}

void testLargeKill()
{

	intersectWrapLineLineWaitFireS test;
	test.startWaitTime=00;
	test.startFlyTime=0;
	test.endWaitTime=100;
	test.endFlyTime=100;
	test.limitFlyTime(3,70);

	unsigned int fire,fly;
	test.calcFireTime(46,fire,fly);
	

	int i=0;
	// for (int i=1;i<20;i++)
	{
		/* to test 
		vecDblC p0(0,0);
		vecDblC d0(4,0);
		

		vecDblC p1(10,2);
		vecDblC d1(-5,-1);
		*/
		/*
		vecDblC p1(0,0);
		vecDblC d1(1,0);
		vecDblC p0(0,2);
		vecDblC d0(10,-1);
		*/

		/*
		vecDblC p1(0,2.5);
		vecDblC d1(0.5,0);
		

		vecDblC p0(18,0);
		vecDblC d0(-10,2);
		*/
		
		
/*
		vecDblC p1(0,5);
		vecDblC d1(0.5,0);
		

		vecDblC p0(10,0);
		vecDblC d0(-1,1);
*/

		/* head to head
		vecDblC p0(0,0);
		vecDblC d0(2,0);
		

		vecDblC p1(10,0);
		vecDblC d1(-1,0);
		*/

		/*
		vecDblC p0(1000,5);
		vecDblC d0(10,0);
		

		vecDblC p1(10,0);
		vecDblC d1(0,1);
*/
		
		
		vecDblC p0(0,0);
		vecDblC d0(2,0);
		

		vecDblC p1(10,0);
		vecDblC d1(-1,0);
		
		int    resCount=0;

		intersectWrapLineLineWaitFireS hits[2];

		if (intersectWrapLineLineWaitFire(p0,d0,p1,d1,2,2000,hits))
		{
			vecDblC p1h=p0+d0*(hits[0].startFlyTime);
			vecDblC p2h=p1+d1*(hits[0].startWaitTime+hits[0].startFlyTime);		

			vecScreenPositionMap(p1h);
			vecScreenPositionMap(p2h);

			float len=(p2h-p1h).len();

			p1h=p0+d0*(hits[0].endFlyTime);
			p2h=p1+d1*(hits[0].endWaitTime+hits[0].endFlyTime);		
			len=(p2h-p1h).len();
			printLog("%d %g %g %g %g\n",i,hits[0].startWaitTime,hits[0].startFlyTime,hits[0].endWaitTime,hits[0].endFlyTime);

			float wait=0;
			float fire=0;
			p1h=p0+d0*fire;
			p2h=p1+d1*(wait+fire);		
			len=(p2h-p1h).len();

			printLog(".\n");


		}
	}
}

void linelinetime()
{
	
	
	
	for (int i=0;i<360;i++)
	{

			vecDblC p0(10,40);
			vecDblC d0(cos(float(i)/180*PI)*8,sin(float(i)/180*PI)*8);
			// d0=d0.norm(8);

			vecDblC p1(0,5);
			vecDblC d1(2,0);
/*	
			float a,b;
			if (intersectLineLine(p0,d0,p1,d1,2,a,b)==1)
			{														
					vecDblC p1h=p0+d0*a;
					vecDblC p2h=p1+d1*b;
					vecScreenPositionMap(p1h);
					vecScreenPositionMap(p2h);
					float len=(p2h-p1h).len();

					printLog("%d %g\n",i,len);
			}

			float hits[8];
			int    resCount=0;
			if (intersectWrapLineLineHit(p0,d0,p1,d1,2,1000,2,&resCount,hits))
			{
				vecDblC p1h=p0+d0*hits[0];
				vecDblC p2h=p1+d1*hits[1];
				vecScreenPositionMap(p1h);
				vecScreenPositionMap(p2h);
				float len=(p2h-p1h).len();
				printLog(".");
			}

*/

			float rad=9;
			intersectWrapLineLineWaitFireS hits1[4];
			if (intersectWrapLineLineWaitFire(p0,d0,p1,d1,rad,2000,hits1))
			{
				/*
				for (int i=0;i<40;i++)
				{
					intersectWrapLineLineWaitFire(p0,d0,p1+d1*float(i*5),d1,rad,2000,hits1+1);
					printf("%d %g %g %g %g\n",i*5,hits1[1].startWaitTime,hits1[1].startFlyTime,hits1[1].endWaitTime,hits1[1].endFlyTime);
				}
				*/
				// if (hits1[0].limitFlyTime(0,100))
				/*
				{
					unsigned int fire,fly;
					double time=(hits1[0].startWaitTime+hits1[0].endWaitTime)/2.0;
					hits1[0].calcFireTime(time,fire,fly);
					vecDblC p1h=p0+d0*(fly);
					vecDblC p2h=p1+d1*(fire+fly);				

					vecScreenPositionNormalize<float>(p1h,p2h);
					vecScreenPositionMap(p1h,p2h);
					

					float len=(p2h-p1h).len();
					if (len>rad+1e-2)
					{
						fatalError("dist");
					}
				}
				*/


				{
					
					
					vecDblC p1h=p0+d0*(hits1[0].startFlyTime);
					vecDblC p2h=p1+d1*(hits1[0].startWaitTime+hits1[0].startFlyTime);				

					vecScreenPositionNormalize<float>(p1h,p2h);
					vecScreenPositionMap(p1h,p2h);
					

					float len=(p2h-p1h).len();

					if (len>rad+1e-2)
					{						
						printLog("*(%g)",fabs(len-rad));
						// fatalError("dist");
					}

					printLog("%d %g %g ,",i,hits1[0].startWaitTime,hits1[0].startFlyTime);

					p1h=p0+d0*(hits1[0].endFlyTime);
					p2h=p1+d1*(hits1[0].endWaitTime+hits1[0].endFlyTime);				

					vecScreenPositionNormalize<float>(p1h,p2h);
					// vecScreenPositionMap(p2h);

					len=(p2h-p1h).len();
					printLog("%g %g\n",hits1[0].endWaitTime,hits1[0].endFlyTime);

					if (len>rad+1e-2)
						fatalError("dist");


					printLog("_");
				}

			}
			

		
	 }	
}

void linelinetimint()
{
	/*
	vecDblC p0(512,512);
	vecDblC d0(0,-1);
	// d0=d0.norm(8);

	vecDblC p1(512,2);
	vecDblC d1(2,0);

	float hits[4];
	int resCount;
	intersectWrapLineLineHit(p0,d0,p1,d1,2000,2,&resCount,hits);

	vecDblC p1h=p0+d0*hits[0];
	vecDblC p2h=p1+d1*hits[1];
	vecScreenPositionMap(p1h);
	vecScreenPositionMap(p2h);
	float len=(p2h-p1h).len();
	printLog(".");
	
		for (int i=270;i<360;i++)
		{

			vecDblC p0(5,0);
			vecDblC d0(cos(float(i)/180*PI),sin(float(i)/180*PI));
			// d0=d0.norm(8);

			vecDblC p1(0,5);
			vecDblC d1(1,0);

			vecDblC pOut;
			float hits[10];
			int retHit;

			int t0=0;
			int t1=1;
			int t2=0;
			int t3=1;

			if (intersectWrapLineLineTiming(p0,d0,p1,d1,1000,7000,1,1,&retHit,hits))
			{
			
				vecDblC p1h=p1+d1*(hits[0]+hits[1]);
				vecDblC p2h=p0+d0*hits[1];
				vecScreenPositionMap(p1h);
				vecScreenPositionMap(p2h);
				float len=(p2h-p1h).len();

				
				printLog("%d %g %g %g\n",i,hits[0],hits[1],len);

				if (len>100)
				{
					printLog(".");
				}
			}
	}
	
	*/
}

void testWinkel()
{
	for (int i=0;i<86;i++)
	{
		float w=360.0/(256.0/3)/180.0*PI*float(i);
		float dx=cos(w);
		float dy=sin(w);
		printLog("%d %d\n",int(dx*1536.0),int(dy*1536.0));
	}
}

int main(int argc, char* argv[])
{
	
	getHeadDiff(0,0);
	getHeadDiff(0,255);
	getHeadDiff(255,0);
	getHeadDiff(10,250);
	getHeadDiff(250,10);
	getHeadDiff(10,20);
	getHeadDiff(20,10);
	{
		// speedTest();
		// testLargeKill();
		// return 0;
	/*
		circleTest();

		linelinetime();
		return 0;
	 */

	}
	
	{
		constFlowArrayT<4,int> flow;
		printLog("%d\n",flow.count());
		flow.add(1);
		flow.add(2);
		printLog("%d\n",flow.count());
		flow.add(3);
		flow.add(4);
		flow.add(5);
		printLog("%d\n",flow.count());
		printLog("%d\n",flow.first());
		printLog("%d\n",flow.last());
	}
	gameCtrlC * ctrl=new gameCtrlC(argv[1]);
	ctrl->start();
	delete ctrl;
	exit(0);

}
