#include "planhit.h"

void planHitC::markKillItems(int currentTime,gameObjListC & list)
{
	int redo;

	do
	{
		redo=0;
		for (int i=0;i<list.count();i++)
		{

			gameObjC & objI=list[i];

			if (!objI.predict(currentTime))
				continue;

			const gameObjTimePointsC & sPoints=list[i];

			vecDblC sp0=sPoints.getP1();
			vecDblC sd0=sPoints.getDir();
			
			const gameObjPropS & sObjProp=gameObjProp[objI.getType()];

			unsigned int sRestTime=objI.getLiveTime(currentTime);
			if (sRestTime>sObjProp.maxPredictTime)
				continue;
			
			sRestTime=sObjProp.maxPredictTime-sRestTime;

			
			for (int a=i+1;a<list.count();a++)
			{
				gameObjC & objA=list[a];
				// alive and can we do calcs on this object ?
				if (!objA.predict(currentTime))
					continue;

				const gameObjPropS & tObjProp=gameObjProp[objA.getType()];
				// see if i can kill a .. 
				if ((sObjProp.bit & tObjProp.killBits)==0)
					continue;

				unsigned int tRestTime=objA.getLiveTime(currentTime);
				if (tRestTime>tObjProp.maxPredictTime)
					continue;
				tRestTime=tObjProp.maxPredictTime-tRestTime;
				
				// we take the smaller predict time because one is away after this time
				unsigned int restTime=tRestTime<sRestTime?tRestTime:sRestTime;
												
				// now see what will be hit from our shoot ..

				const gameObjTimePointsC & tPoints=objA;

				vecDblC tp0=tPoints.getP1();
				vecDblC td0=tPoints.getDir();
				
				
				int retResult;
				float retTime[2];
				intersectWrapLineLineTime(
					sp0,sd0,
					tp0,td0,				
					restTime,
					tObjProp.radius+sObjProp.radius,
					1,
					&retResult,
					retTime);
				

				if (retResult)
				{ 
					// if we use here +1 we get the kills alomost exact
					unsigned int killTime=round(retTime[0])+1;
					if (retTime[0]<0)
						fatalError("invalid ret time");
		
					printLog("Frame=%4d|type %d %d -> key=%d %d -> hit %d |",currentTime,objI.getType(),objA.getType(),objI.getKey(),objA.getKey(),killTime);
				
					unsigned int free1,free2;
					if (objA.setKillTime(currentTime,tPoints.getT1()+killTime,objI,free1,free2))
					{					
						
						if (free1!=0)
						{	// remove the kill point and id from killer
							int pos=list.getByKey(free1);
							fatalAssert(pos!=-1,"wrong key");
							list[pos].delKiller();								
							printLog("redo key=%d",list[pos].getKey());
							redo=1;
						}

						if (free2!=0)
						{	// remove the kill point and id from killer
							int pos=list.getByKey(free2);
							fatalAssert(pos!=-1,"wrong key");
							list[pos].delKiller();								
							printLog("redo key=%d",list[pos].getKey());
							redo=1;
						}
						
						
						printLog("~\n");						
						break;
					}
					else
						printLog("*\n");
					
				} // eof "hit found"

			} // eof list[a] loop
		} // eof list[i] loop
	} while(redo);
}

void planHitC::markKillShip(int currentTime,const runtimeSpaceShipC & ship,gameObjListC & list)
{
	vecDblC position=convVec(ship.getPosition());

	int redo=0;

	int killers=0;

	for (int i=0;i<list.count();i++)
	{
		gameObjC & objI=list[i];
		if (!objI.predict(currentTime))
			continue;

		const gameObjTimePointsC & sPoints=objI;

		vecDblC sp0=sPoints.getP1();
		vecDblC sd0=sPoints.getDir();
		
		const gameObjPropS & sObjProp=gameObjProp[objI.getType()];

		unsigned int sRestTime=objI.getLiveTime(currentTime);
		if (sRestTime>sObjProp.maxPredictTime)
			continue;
		
		sRestTime=sObjProp.maxPredictTime-sRestTime;
	
		unsigned int limit=1000;
		
		// see if this hits my ship .. and when
		int resultCount=0;
		float resultArray[10];

		int rad=(sObjProp.radius+gameObjProp[objTypeShip].radius);
		
		if (intersectWrapLinePoint(sp0,sd0,position,rad,500,1,&resultCount,resultArray))
		{
			int time=round(resultArray[0]);
			unsigned int free;
			if (objI.setKillTime(currentTime,objI.getT1()+time,0,TIME_INFINITE,free))			
			{
				vecDblC pos=objI.getPredictPos(objI.getT1()+resultArray[0]);	
				vecScreenPositionNormalize<float>(position,pos);

				printLog("frame %4d|Kill Ship by %d in %d dist=%g\n",currentTime,objI.getKey(),time,(pos-position).len());
								
				killers++;
				
				if (free)
				{
					// remove the kill point and id from killer
					int pos=list.getByKey(free);
					assert(pos!=-1);					
					printLog("redo key=%d\n",free);
					redo=1;
				}					
			}
		}
	} // eof obj loop

	if (redo)
		markKillItems(currentTime,list);
}

/// read the data from scanner and prepare internal structure ...
void planHitC::update(unsigned int time,const spaceShipC & ship,int sc,const gameObjListC & global)
{
	score=sc;

	updateTime=time;
	// take basic ship information
	spaceShip.set(ship);

	// create local list for working ..
	
	if (updateObjectList.count()==0 && global.count() && global.count()==global.countTypes(objTypeAstroidLarge))
	{
		//printf("Frame %5d|enter first generation mode on\n",time);
		firstGenerationMode=global.getHighKey();

	}

	if (firstGenerationMode && global.countTypes(objTypeAstroidLarge)==0)
	{ // printf("Frame %5d|enter first generation mode off 1\n",time);
		firstGenerationMode=0;
	}

	updateObjectList=global;


			

	
	
	
	
	if (updateObjectList.count()<=6)
	{				
		int orgCount=updateObjectList.count();
		for (int i=0;i<orgCount;i++)
		{
			// create virtual objects
			if (updateObjectList[i].getType()==objTypeAstroidLarge) 
			{	updateObjectList.add(updateObjectList[i]);updateObjectList.last().setType(objTypeAstroidLarge);updateObjectList.last().setKey(updateObjectList[i].getKey()+32000);			  
			  updateObjectList.add(updateObjectList[i]);updateObjectList.last().setType(objTypeAstroidLarge);updateObjectList.last().setKey(updateObjectList[i].getKey()+32000);			  
				// updateObjectList.add(updateObjectList[i]);updateObjectList.last().setType(objTypeAstroidLarge);updateObjectList.last().setKey(updateObjectList[i].getKey()+32000);			  
			  // lst.add(lst[i]);lst.last().setType(objTypeAstroidLarge);lst.last().setKey(lst[i].getKey()+32000);			  
			}
			
			else if (updateObjectList[i].getType()==objTypeAstroidMed)
			{	updateObjectList.add(updateObjectList[i]);updateObjectList.last().setType(objTypeAstroidMed);updateObjectList.last().setKey(updateObjectList[i].getKey()+32000);
			  updateObjectList.add(updateObjectList[i]);updateObjectList.last().setType(objTypeAstroidMed);updateObjectList.last().setKey(updateObjectList[i].getKey()+32000);
				// updateObjectList.add(updateObjectList[i]);updateObjectList.last().setType(objTypeAstroidMed);updateObjectList.last().setKey(updateObjectList[i].getKey()+32000);
			  // lst.add(lst[i]);lst.last().setType(objTypeAstroidMed);lst.last().setKey(lst[i].getKey()+32000);
			}
			
		}				
	}
	
	
	
													
	markKillItems(time,updateObjectList);
	markKillShip(time,spaceShip,updateObjectList);
	calcShotOffsetTime(time,updateObjectList);

	nextModelChange=TIME_INFINITE;
		
	// first make the negative scan .. we will speedup this later	
	{
	  
		for (int i=0;i<updateObjectList.count();i++)
		{
			gameObjC & objI=updateObjectList[i];

			int found=0;
			for (int a=0;a<objects.count();a++)
			{
				hitObjC & objA=objects[a];
				if (objA.getKey()==objI.getKey() && objA.getUpdateTime()!=time)
				{
					found=1;
					objA.update(time,objI);
					break;
					// no break because a virtual object maybe here break;
				}
			} // eof inner loop
			
			// a new one ?
			if (!found)
			{
				// only put objects in list which we can really kill .. so shoots are not important e.g.
				if (gameObjProp[objI.getType()].killBits & gameObjProp[objTypeShot].bit)
				{
					hitObjC & hit=objects.add();
					hit.update(time,objI);					
				}
			}
		}
	} // eof update loop ..
	

	
	{ // scan for no longer here and also update astro count ..
		
		astroFullCount=0;
		
		for (int i=objects.count()-1;i>=0;i--)
			if (objects[i].getUpdateTime()!=time)
			{				
				// debug output timing dif ..
				/*
				unsigned int tx=objects[i].getObj().getTX();
				if (tx!=TIME_INFINITE)					
					printf("diff=%d\n",int(time)-int(tx));
				*/
				objects.del(i);			
			}
			else
			{				
				// we have a object here ..
				gameObjTypeE type=objects[i].getObj().getType();

				printLog("obj key=%d typ=%d pos(%d,%d) head(%g,%g) Speed=%g tx=%d\n",objects[i].getKey(),type,
					int(objects[i].getObj().getPredictPos(time).x()),int(objects[i].getObj().getPredictPos(time).y()),
					objects[i].getObj().getDir().x(),objects[i].getObj().getDir().y(),
					objects[i].getObj().getSpeed(),
					objects[i].getObj().getTX());

				
				switch (type) {
					case objTypeAstroidLarge:						
					case objTypeAstroidMed:					
						if (objects[i].getKey()<32000)
						{ astroFullCount++;
							if (objects[i].getObj().getTX()!=TIME_INFINITE)
							{ if (objects[i].getObj().getTX()<nextModelChange)
									nextModelChange=objects[i].getObj().getTX();
								astroFullCount++;
							}
						}
					  break;
					case objTypeAstroidSmall:astroFullCount++;
						break;
				}
				
				

			}		
		

		// remove the virtual objects
		
	}

	
	printLog("count obj %d\n",objects.count());

	// the hit list is done .. 
	
}

/// return the next target from the given position
int planHitC::getNextTargetI(
		const searchOptionS & option,
		unsigned int time,
		const vecIntC & pos,
		int head,
		int direction,
		const workListT & workIds,
		int					 condObjListNumber,		
		unsigned int condObjTime,
		int          & objListPos,
		unsigned int & returnTime,
		unsigned int & returnFlyTime,
		int          & returnHead
		)
{

	int maxRot=86/2;

	int bestHead=0;
	int bestPos=0;
	int bestFly=0;
	unsigned int bestTime=TIME_INFINITE;
	unsigned int limit=TIME_INFINITE;
	for (int i=0;i<workIds.count();i++)
	{		
		
		unsigned int retFireTime;
		unsigned int retFlyTime;
		int          retHead;
		int					 bestLimit;

		int id=workIds[i];


		if (objects[id].requestNextHit(option,time,pos,head,maxRot,direction,retHead,retFireTime,retFlyTime,bestLimit))
		{				

			printLog("found target -> %d %d %d %d\n",objects[id].getKey(),retFireTime,retHead,retFlyTime);
			unsigned int test=bestLimit;
			
			// we found one
			if (test<limit || (test==limit && abs(getHeadDiff(retHead,head))<abs(getHeadDiff(bestHead,head))))
			{
				if (condObjListNumber>=0)
				{					
					
					unsigned int condRetFire,condRetFlyTime;
					int  condRetHead;
				  int  condLimit;
					if (!objects[condObjListNumber].requestNextHit(option,retFireTime,pos,retHead,maxRot,0,condRetHead,condRetFire,condRetFlyTime,condLimit))
						continue;
					if (condRetFire>condObjTime)
						continue;
					printLog("found inlay shot\n");
				}
				limit=test;
				bestTime=retFireTime;
				bestHead=retHead;
				bestPos=i;
				bestFly=retFlyTime;
			/*	
				// because we need one time for each rotate the best hit must be closer than the given time				
				int diffTime=limit-time;
				if (diffTime<maxRot)
					maxRot=diffTime;
			*/				
			}			
		}
	}	

	if (bestTime!=TIME_INFINITE)
	{
		printLog("next target -> %d %d %d %d\n",objects[workIds[bestPos]].getKey(),bestTime,bestHead,bestFly);
		returnTime=bestTime;
		returnHead=bestHead;
		returnFlyTime=bestFly;
		objListPos=bestPos;
		return 1;
	}

	return 0;

}

/// return the next target from the given position
int planHitC::getFarTarget(
		const searchOptionS & option,
		unsigned int time,
		const vecIntC & pos,
		int head,
		int direction,
		const workListT & workIds,
		int					 condObjListNumber,		
		unsigned int condObjTime,
		int          & objListPos,
		unsigned int & returnTime,
		unsigned int & returnFlyTime,
		int          & returnHead
		)
{

	int maxRot=86/2;

	int limit=0;
	int bestHead=0;
	int bestPos=0;
	int bestFly=0;
	unsigned int bestTime=0;
	
	for (int i=0;i<workIds.count();i++)
	{		
		
		unsigned int retFireTime;
		unsigned int retFlyTime;
		int          retHead;
		int          bestLimit;

		int id=workIds[i];
				
		if (objects[id].requestNextHit(option,time,pos,head,maxRot,direction,retHead,retFireTime,retFlyTime,bestLimit))
		{				

			printLog("found target -> %d %d %d %d\n",objects[id].getKey(),retFireTime,retHead,retFlyTime);
			unsigned int test=bestLimit;
			
			// we found one
			if (test>limit)
			{
				if (condObjListNumber>=0)
				{					
					
					unsigned int condRetFire,condRetFlyTime;
					int  condRetHead;
					int  condLimit;

					if (!objects[condObjListNumber].requestNextHit(option,retFireTime,pos,retHead,maxRot,0,condRetHead,condRetFire,condRetFlyTime,condLimit))
						continue;
					if (condRetFire>condObjTime)
						continue;
					printLog("found inlay shot\n");
				}
				limit=test;
				bestTime=retFireTime;
				bestHead=retHead;
				bestPos=i;
				bestFly=retFlyTime;
			/*	
				// because we need one time for each rotate the best hit must be closer than the given time				
				int diffTime=limit-time;
				if (diffTime<maxRot)
					maxRot=diffTime;
			*/				
			}			
		}
	}	

	if (bestTime!=0)
	{
		printLog("next target -> %d %d %d %d\n",objects[workIds[bestPos]].getKey(),bestTime,bestHead,bestFly);
		returnTime=bestTime;
		returnHead=bestHead;
		returnFlyTime=bestFly;
		objListPos=bestPos;
		return 1;
	}

	return 0;

}

int planHitC::addUfo(unsigned int time,workListT & workIds)
{
	for (int i=0;i<objects.count();i++)
	{
		hitObjC & objI=objects[i];

		// we only work on saucer here
		if (!(objI.getObj().getType()==objTypeSaucerSmall || objI.getObj().getType()==objTypeSaucerLarge))
			continue;

		// we just fire to this object
		if (objI.getFiredTimeDiff()<6)
			continue;
		unsigned int killId,killTime;
		if (objI.getObj().getKillData(killId,killTime))
		{ // there is a killer available for this target
			continue;
		}
		
		workIds.add(i);
	}
	return workIds.count();
}

int planHitC::getNextKiller(unsigned int time,workListT & workIds)
{		
	// check how many .. the fastest asteroid we found take 6 Frames per second .. to be able to rotate to target
			
	for (int i=0;i<objects.count();i++)
	{
		hitObjC & objI=objects[i];

		// i already fired at them ..
		if (objI.getFiredTimeDiff()<6)
			continue;

		// see if it still get killed
		unsigned int killId;
		unsigned int killTime;
		if (objI.getObj().getKillData(killId,killTime))
		{
			// this if this object still kills our ship
			if (killId!=0)
				continue;

			unsigned int minTime=objI.getObj().getSpeed()*86;
		
			// yes it will so put in into todo list
			unsigned int diff=killTime-time;

			if (diff>minTime)
				continue;
			
			workIds.add(i);
		}
		
	}

	return workIds.count();
}

int planHitC::optNFull(
		const searchOptionS & option, // options is a bit set of the search OptionE
		unsigned int maxTime,unsigned int time,
		int						* methods,
		int             methodeCount,
		runtimeSpaceShipC ship,
		const workListT & workIds,		
		unsigned int & bestTime,
		recursiveFirePositionsT firePositions)
{
	int maxRot=86/2;

	// are we ready ?
	if (firePositions.count()>recursiveFirePositions.count() ||
		 (firePositions.count()==recursiveFirePositions.count() && time<bestTime))
	{
		this->recursiveFirePositions=firePositions;
		
		bestTime=time;		
		if (workIds.count()==0)
			return 1;
	}

	if (time>bestTime || time>maxTime)
		return 0;

	
	for (int m=0;m<methodeCount;m++)
	{
		searchOptionS local=option;
		for (int i=0;i<workIds.count();i++)
		{		
			
			unsigned int retFireTime;
			unsigned int retFlyTime;
			int          retHead;
			int          bestLimit;

			local.method=methods[m];
			
			int id=workIds[i];

							
			if (objects[id].requestNextHit(local,time,ship.getPosition(),ship.getRotationIndex(),maxRot,0,retHead,retFireTime,retFlyTime,bestLimit))
			{	
				
				
				recursiveFirePositionsT nextFirePos=firePositions;

				recursiveResultS add;
				add.fireTime=retFireTime;
				add.flyTime=retFlyTime;
				add.head=retHead;
				add.listId=id;
				nextFirePos.add(add);

				runtimeSpaceShipC nextShip=ship;
				nextShip.updateExt(retFireTime,ship.getPosition(),retHead);
				nextShip.incShot(retFireTime,retFlyTime,objects[id].getKey());			
				
				searchOptionS nextOption=local;
				nextOption.waitShotTime=nextShip.nextFireTime(retFireTime)-retFireTime;

				workListT nextWorkList=workIds;
				nextWorkList.del(i);

				optNFull(nextOption,maxTime,retFireTime,methods,methodeCount,nextShip,nextWorkList,bestTime,nextFirePos);
			}
			else
			{ // not possible to hit this item
			}
		}
	}

	return 1;
}

int planHitC::optN2Full(
		int maxDeep,
		const searchOptionS & option, // options is a bit set of the search OptionE
		unsigned int time0,unsigned int time,
		int						* methods,
		int             methodCount,
		runtimeSpaceShipC ship,
		const workListT & workIds,		
		unsigned int & bestTime,
		recursiveFirePositionsT firePositions)
{
	
	int maxRot=86/2;

	unsigned int testTime=/*time+ship.nextFireTime(time)-*/time;

	// are we ready ?
	if (firePositions.count()>recursiveFirePositions.count() ||
		 (firePositions.count()==recursiveFirePositions.count() && testTime<bestTime))
	{
		this->recursiveFirePositions=firePositions;
		
		bestTime=testTime;				
	}

	if (workIds.count()==0)
			return 1;

	if (testTime>bestTime)
		return 0;

	if (time>time0)
		return 0;

	if (maxDeep==0)
		return 1;
					
	unsigned int retFireTime;
	unsigned int retFlyTime;
	int          retHead;
	int          listPos;

	// one side ..				

	{
		for (int m=0;m<methodCount;m++)
		{
			searchOptionS local=option;
			local.method=methods[m];
					
			if (getNextTargetI(local,time,ship.getPosition(),ship.getRotationIndex(),1,workIds,-1,0,listPos,retFireTime,retFlyTime,retHead))
			{	
							
				int id=workIds[listPos];
				recursiveFirePositionsT nextFirePos=firePositions;

				recursiveResultS add;
				add.fireTime=retFireTime;
				add.flyTime=retFlyTime;
				add.head=retHead;
				add.listId=id;
				add.method=local.method;
				nextFirePos.add(add);

				runtimeSpaceShipC nextShip=ship;
				nextShip.updateExt(retFireTime,ship.getPosition(),retHead);
				nextShip.incShot(retFireTime,retFlyTime,objects[id].getKey());			
				
				searchOptionS nextOption=local;
				nextOption.waitShotTime=nextShip.nextFireTime(retFireTime)-retFireTime;

				workListT nextWorkList=workIds;
				nextWorkList.del(listPos);

				optN2Full(maxDeep-1,nextOption,time0,retFireTime,methods,methodCount,nextShip,nextWorkList,bestTime,nextFirePos);
			}
		}
	}
	{
		for (int m=0;m<1;m++)
		{
			searchOptionS local=option;
			switch (m) {
					case 0:local.method=searchMinHitTime;break;
					case 1:local.method=searchMinFireTime;break;				
					case 2:local.method=searchMinFlyWait;break;
					// case 2:local.method=searchMinWaitTime;break;
					default:fatalError("do not come to this point");
				}
			// other side ..				
			int listPos;
			if (getNextTargetI(local,time,ship.getPosition(),ship.getRotationIndex(),-1,workIds,-1,0,listPos,retFireTime,retFlyTime,retHead))
			{	
				int id=workIds[listPos];
							
				recursiveFirePositionsT nextFirePos=firePositions;

				recursiveResultS add;
				add.fireTime=retFireTime;
				add.flyTime=retFlyTime;
				add.head=retHead;
				add.listId=id;
				add.method=local.method;
				nextFirePos.add(add);

				runtimeSpaceShipC nextShip=ship;
				nextShip.updateExt(retFireTime,ship.getPosition(),retHead);
				nextShip.incShot(retFireTime,retFlyTime,objects[id].getKey());			
				
				searchOptionS nextOption=local;
				nextOption.waitShotTime=nextShip.nextFireTime(retFireTime)-retFireTime;

				workListT nextWorkList=workIds;
				nextWorkList.del(listPos);

				optN2Full(maxDeep-1,nextOption,time0,retFireTime,methods,methodCount,nextShip,nextWorkList,bestTime,nextFirePos);
			}
		}
	}
					
	return 1;
}


int planHitC::calcDensityField(const searchOptionS & option,unsigned int time,workListT & workIds,int & retHead)
{
	// first scan negative range ..
	float scoreNeg=0;
	float scorePos=0;
	

	int side=1;

	int head=spaceShip.getRotationIndex();

	int foundPos=0;
	int foundNeg=0;

	
				
	for (int a=0;a<workIds.count();a++)
	{				
		int id=workIds[a];

	  unsigned int retFireTime,retFlyTime;
		int retHead,bestLimit;
		if (objects[id].requestNextHit(option,time,spaceShip.getPosition(),spaceShip.getRotationIndex(),86/2,0,retHead,retFireTime,retFlyTime,bestLimit))		
		{ 
			if (getHeadDiff(spaceShip.getRotationIndex(),retHead)<0)
			{
				foundNeg++;
				scoreNeg+=retFlyTime/retHead;		
			}
			else if (getHeadDiff(spaceShip.getRotationIndex(),retHead)>0)
			{
				foundPos++;
				scorePos+=retFlyTime/retHead;		
			}

		  
			
		}
		
	}

	if (foundPos>foundNeg*2)
		retHead=1;
	else if (foundNeg>foundPos*2)
		retHead=-1;
	else
		retHead=0;

	/*
  
	float calcNeg=scorePos/(foundPos?foundPos:1);
	float calcPos=scoreNeg/(foundNeg?foundNeg:1);
	
	if (calcNeg>calcPos && calcNeg/calcPos>10.0/8.0)
		retHead= 1;
	else if (calcPos>calcNeg && calcPos/calcNeg>10.0/8.0)
		retHead=-1;
	else
		retHead=0;
	*/
	
	// printf("%6d,%6d\n",foundNeg,foundPos);

	return retHead;
}

int planHitC::inFireLine(const searchOptionS & option,unsigned int time,workListT & workIds,int & listPos,unsigned int & retFireTime,unsigned int & retFlyTime)
{

	for (int i=0;i<workIds.count();i++)
	{				
		int id=workIds[i];

		if (objects[id].requestNowHit(option,time,spaceShip.getPosition(),spaceShip.getRotationIndex(),retFireTime,retFlyTime))
		{	
			listPos=id;
			return 1;
		}
	}		

	return 0;
}

void planHitC::getOptimalKill(unsigned int time,int & headChange,unsigned int & fireTime,int & panic)
{	
	spaceShip.adjustTX(time);
	fireTime=0;
	headChange=0;
	panic=0;

	// 0 obejcts .. but still a shot that may hit us ..
	if (objects.count()==0)
	{ panic=testPanic(time);
		return;
	}

	// get offset data from setup
	searchOptionS option;
	
	option.waitShotTime=spaceShip.nextFireTime(time)-time;
	
	printLog("Frame=%4d|Head %d, Shoots left: %d next fire %d \n",time,spaceShip.getRotationIndex(),spaceShip.leftShots(),option.waitShotTime);
		

	// see that happens with our target
	if (currentTarget.key!=0 && option.waitShotTime==0)
	{
		if (time==currentTarget.fireTime && spaceShip.getRotationIndex()==currentTarget.fireHead)
		{
			// just see if the data is still what we need
			int pos=getObjectByKey(currentTarget.key);
			if (pos!=-1)
			{
				unsigned int retFireTime,retFlyTime;
				if (objects[pos].requestNowHit(option,time,spaceShip.getPosition(),currentTarget.fireHead,retFireTime,retFlyTime))
				{
					// ok we will hit it now .. setup all data for this object
					fireTime=retFireTime+retFlyTime;
					// because this works so good we mark this object and the methode can go to the next ..
					spaceShip.incShot(retFireTime,fireTime,currentTarget.key);
					objects[pos].setFire(retFireTime);
					// adapted next shot offset time
					option.waitShotTime=spaceShip.nextFireTime(time)-time;										
					// printf("*");
					printLog("Frame %4d|Exec Fire|Keys=%d Fire=%d\n",time,currentTarget.key,fireTime);
				}
			}
		}
	}

	// we will calculate this now ..
	currentTarget.reset();
	
	// unsigned int retWaitTime,retFlyTime;
	// int retHead;

	workListT workList,workListFull;

	// eval killer list
	getNextKiller(time,workList);
	// add ufo to special list
	// addUfo(time,workList);

	int special=workList.count();

	if (special && firstGenerationMode)
	{ // printf("Frame %06d|enter first generation mode off 2\n",time);
		firstGenerationMode=0;
	}
		
	int countMedAstro=updateObjectList.countTypes(objTypeAstroidMed);
	int countLargeAstro=updateObjectList.countTypes(objTypeAstroidLarge);
	{ // fill list with objects
		for (int i=0;i<objects.count();i++)
		{
			// we just fire to object dont do it again .. later the object will be marked with the tx code
			
			if (objects[i].getFiredTimeDiff()<5)
					continue;				
						
			const gameObjC & obj=objects[i].getObj();
			
			/* idee had no positv effect
			if (firstGenerationMode && obj.getKey()>firstGenerationMode)
				continue;
			*/

			/* idee had no positv effect .. try to filter small, medium,large items bevor other hits 
			if (obj.getType()==objTypeAstroidSmall && (countMedAstro || countLargeAstro))
				continue;
			*/
																					
			
			/*
			// this code will avoid hits on objects that can not more split
			// maximal possible are	 26 if we kill one we need two places. 
			if (astroFullCount>=26 && (obj.getType()==objTypeAstroidMed || obj.getType()==objTypeAstroidLarge))
			{   
				continue;
			}	
			*/
			
			
																			
			// we accepted the item up to this point .. see if we really should ..			
			workListFull.add(i);
			
		}
	}

	
	if (workList.count()==0)
		workList=workListFull;

	unsigned int bestTime=-1;
	int          bestHead=0;
	unsigned int bestFly=0;
	int          listPos=-1;

	if (special)
		targetHead=0;
							
	
	
	{		
 
		int dir=0;
		
		
		
		if (special || objects.count()<=4) // if we are on special run .. tkae the next position
			option.method=searchMinHitTime;
		else
			// option.method=searchMinHitTime | searchWait0; // keep here searchWait to control the additonal wait time
			option.method=searchRot | searchWait0 | searchFly; // keep here searchWait to control the additonal wait time
			 									
		/*
		if (!special && objects.count()>11 && !targetHead)
		{
			
			if (calcDensityField(option,time,workListFull,targetHead))
				printf("calc field %d\n",targetHead);
		}
		*/
		
		

		/*
		// if only small asteroids are left use the min fire mode to speedup fire sequence
		if (this->updateObjectList.countTypes(objTypeAstroidMed)==0 && this->updateObjectList.countTypes(objTypeAstroidLarge)==0)
		{ 
			option.method=searchMinFireTime;
		}
		*/

		
		
		if (objects.count()>4)
			getNextTarget(option,time,spaceShip.getPosition(),spaceShip.getRotationIndex(),targetHead,workList,-1,0,listPos,bestTime,bestFly,bestHead);								
		else
		
		{
			unsigned int bestCallTime=TIME_INFINITE;
			recursiveFirePositionsT firePositions;
				
			unsigned int maxTime=TIME_INFINITE;//nextModelChange;

			int deep=workList.count();
			if (deep>4)
				deep=4;

			int methods[2]={searchMinHitTime,searchMinFireTime};			
			recursiveFirePositions.clear();
			// optN2Full(deep,option,maxTime,time,methods,1,spaceShip,workList,bestCallTime,firePositions);
			optNFull(option,maxTime,time,methods,2,spaceShip,workList,bestCallTime,firePositions);
			
															
			// if we are done we get the result in local structure
			if (recursiveFirePositions.count())
			{
				// printf("*");
				bestTime   =recursiveFirePositions[0].fireTime;
				bestFly    =recursiveFirePositions[0].flyTime;
				bestHead   =recursiveFirePositions[0].head;
				listPos    =recursiveFirePositions[0].listId;
				// that good until now but we may get some targes inbetween			
				printLog("next full n target -> %d %d %d %d %d\n",objects[listPos].getKey(),bestTime,bestHead,bestFly,recursiveFirePositions[0].method);				
			}
			else
				getNextTarget(option,time,spaceShip.getPosition(),spaceShip.getRotationIndex(),0,workList,-1,0,listPos,bestTime,bestFly,bestHead);								

		}
		
		
		
		
		
						 
		if (special && spaceShip.leftShots()>=1)
		// if (workList.count()<=4)
		// if (bestTime==TIME_INFINITE || special)		
		{	
			option.method=searchMinFireTime;
			
			int condPos=listPos;
			unsigned int condTime=bestTime;
			getNextTarget(option,time,spaceShip.getPosition(),spaceShip.getRotationIndex(),dir,workListFull,condPos,condTime,listPos,bestTime,bestFly,bestHead);								
		}	
		

	}

	if (bestTime==-1)
	{
		// nothing to do
		if (testPanic(time))
			panic=1;
		return;
	}
	
	int headDiff=getHeadDiff(spaceShip.getRotationIndex(),bestHead);
	
	headChange=headDiff!=0?(headDiff>0?1:-1):0;	

	if (headDiff==0 && bestTime==time)
		fireTime=bestTime+bestFly;
	
	
	if (option.waitShotTime==0 && !fireTime)
	{
		unsigned int retFireTime,retFlyTime;
		int      retListPos;
		if (this->inFireLine(option,time,workListFull,retListPos,retFireTime,retFlyTime))
		{
			// it is possible to fire here .. are we able to hit the original goal also ?
			spaceShip.incShot(time,retFireTime+retFlyTime,objects[retListPos].getKey());
			unsigned int nextTime=spaceShip.nextFireTime(time);
			if (nextTime<=bestTime)
			{
				bestTime=retFireTime;
				bestHead=spaceShip.getRotationIndex();
				bestFly=retFlyTime;
				fireTime=bestTime+bestFly;
				listPos=retListPos;
				printf(".");
				
				if (retFireTime!=time)
					fatalError("wrong state");					
			}

		}
	}
	
	

	
	printLog("Frame %4d|Keys=%d Fire=%d\n",time,headChange,fireTime);
	
	if (fireTime && headDiff==0 && bestTime==time)
	{ 				
		objects[listPos].setFire(time);
	}
	else
	{
		if (listPos>=0)
		{
			// we do not fire this round .. so target keeps for us
			currentTarget.key=objects[listPos].getKey();
			currentTarget.fireHead=bestHead;
			currentTarget.fireTime=bestTime;
			currentTarget.flyTime=bestFly;
		}
	}

	if (fireTime)
		targetHead=0;
	

	if (testPanic(time))
    panic=1;
	
}

int planHitC::testPanic(unsigned int time)
{
	// check panic ..
	
	{
		for (int i=0;i<updateObjectList.count();i++)
		{

			unsigned int id,hitTime;
			if (updateObjectList[i].getKillData(id,hitTime))
			{
				if (id!=0)
					continue;
				
				// if there is a shot incomming and the ufo is the only rest jump now to avoid restart time on crash
				if (updateObjectList[i].getType()==objTypeShot && objects.count()==1 && (objects.item(0).getObj().getType()==objTypeSaucerSmall || objects.item(0).getObj().getType()==objTypeSaucerLarge))
				{
					printf("early panic\n");
					return 1;
				}
				if ((hitTime>time && hitTime-time<=4) ||
					  (hitTime<=time))
				{
				
					printf("panic\n");
					return 1;
				}
			}			
		}
	}
	
	// only one object left but this has a tx coding
	if (score>10000 && objects.count()==1 && objects.item(0).getObj().getTX()!=TIME_INFINITE)
	{
		// this is a test to bring us erly in right position
		vecDblC vec( convVec(spaceShip.getPosition())-vecDblC(524,396));
		if (vec.len()<250)
			return 1;
	}
	
	return 0;
}

int planHitC::hitTableC::getHitData(const searchOptionS & option,unsigned int updateTime,unsigned int time,const vecIntC & p0,int head,const gameObjC & obj,unsigned int & fireTime,unsigned int & flyTime)
{	
	head=getHeadIdx(head);

	if (calcHitData(option,updateTime,p0,head,obj))
	{
		
		
		unsigned int fire,fly;
		if (data[head].calcFireTime(time,fire,fly))
		{
			
			fireTime=fire;
			flyTime=fly;
							
			if (obj.predict(fireTime+flyTime))
				return 1;
		}
	}

	return 0;

}

int planHitC::hitTableC::calcHitData(const searchOptionS & option,unsigned int updateTime,const vecIntC & p0,int head,const gameObjC & obj)
{
	head=getHeadIdx(head);

	hitDataS & hitData=data[head];

	if (hitData.updateTime==updateTime)
	{		
		return hitData.startFlyTime!=0;
	}
	
		
	hitData.updateTime=updateTime;
	hitData.startFlyTime=0;
			
	// .. do a short calc ..
	vecDblC p1=obj.getPredictPos(updateTime);
	vecDblC d1=obj.getDir();

	gameObjPropS & prop=gameObjProp[obj.getType()];
	int minDist=prop.radius;
		
	float a=rotationData[head].angDegree/180.0*PI;
	
	vecDblC p0Dbl(convVec(p0));
	// see articel "http://www.heise.de/ct/foren/S-Re-Schuss-Startposition/forum-135513/msg-14833918/read/"
	float bx = 95.0/8.0 * cos(a);
	float by = 95.0/8.0 * sin(a);

	p0Dbl=p0Dbl+vecDblC(bx,by);

	// direction of shot
	float xv=cos(a);
	float yv=sin(a);
	// taken from wiki side ..
	if (xv>=0) xv*=63.0/8.0;
	else xv*=64.0/8.0;
	if (yv>=0) yv*=63.0/8.0;
	else yv*=64.0/8.0;
	vecDblC d0(xv,yv);
	
	intersectWrapLineLineWaitFireS resArray;
	// maximal calc down to 3 complete rotations (86*3)
	if (intersectWrapLineLineWaitFire(p0Dbl,d0,p1,d1,float(prop.radius)*2.0/3.0,86*3,&resArray))
	{
		// see if we can reach it somehow .. (-1 here because we already do the first step with the offset)
		
		// it is too near with the wrong direction
		if (resArray.startFlyTime<1 && d0.skalar(p1-p0Dbl)<0)
		  return 0;	
		if (resArray.limitFlyTime(1,gameObjProp[objTypeShot].maxTime-2))
		{			
			// firt move it in the right time context
			resArray.offset(updateTime);
			// put data in cache for later usage
			data[head].set(updateTime,resArray);
			return 1;
		}
	}

	return 0;

}

int planHitC::hitTableC::requestNowHit(
			const searchOptionS &  option,
			unsigned int updateTime,
			unsigned int time,
			const vecIntC & p0,int head,           // the fire object
			const gameObjC & obj,									 // the target object
			unsigned int & retFireTime,unsigned int & retFlyTime
			)
{		
	unsigned int fireTime;
	unsigned int flyTime;
	if(getHitData(option,updateTime,time,p0,head,obj,fireTime,flyTime))
	{
		if (fireTime<=time)
		{
			retFireTime=fireTime;
			retFlyTime=flyTime;
			return 1;
		}
	}

	return 0;
}


int planHitC::hitTableC::requestNextHit(
			const searchOptionS &  option,
			unsigned int updateTime,
			unsigned int time,
			const vecIntC & p0,int head,           // the fire object
			const gameObjC & obj,									 // the target object
			int maxRot,
			int direction,
			int & retHead,unsigned int & retFireTime,unsigned int & retFlyTime,int & bestLimit)
{
	
	int side=1;

	unsigned int limit=TIME_INFINITE;
	unsigned int bestFireTime=10000000;
	unsigned int bestFlyTime =10000000;
	int bestHead;
	
	int timeStartOffset=option.waitShotTime;
	
	for (int i=0;i<maxRot;)
	{
		int h=getHeadIdx(head+i*side);		
		// get line data on "h"
		
		unsigned int fireTime;
		unsigned int flyTime;

		int currentOffTime=timeStartOffset-i;
		if (currentOffTime<0) 
			currentOffTime=0;
		
		unsigned int useTime=time+i+currentOffTime;

		if(getHitData(option,updateTime,useTime,p0,h,obj,fireTime,flyTime))
		{	
			unsigned int wait=fireTime-useTime;

			int test=0;
			int count=0;
																
			if ((option.method & searchRot)==searchRot)  
			{ count++;
				test+=i;
			}
			if ((option.method & searchWait)==searchWait) 
			{ count++;
				test+=wait;
			}
			if ((option.method & searchFly)==searchFly)  
			{ count++;
				test+=flyTime;
			}
			if ((option.method & searchWait2)==searchWait2)
				test+=wait*2;
			if ((option.method & searchWaitQ)==searchWaitQ)
				test+=wait*wait;
			if ((option.method & searchRot2)==searchRot2)
				test+=i+i;
			if ((option.method & searchRotQ)==searchRotQ)
				test+=i*i;

			if ((option.method & searchFly2)==searchFly2)
				test+=flyTime*2;

			if (count==0)
				count=1;

			test/=count;

			if ((option.method & searchFlyS)==searchFlyS)
				test+=sqrt(float(flyTime));

			if ((option.method & searchWait0)==searchWait0 && wait>0)
				test+=1000;
			

			test+=time;
			
			// take if it is better or equal but near to my position
			if (test<limit || (test==limit && i<abs(getHeadDiff(bestHead,head))))
			{
				limit=test;
				bestHead=h;
				bestFireTime=fireTime;					
				bestFlyTime =flyTime;					
			}						
		}

		// go to next i
		switch (direction) {
			case  0:side*=-1;if (side==-1)	i++;break;
			case  1:i++;break;
			case -1:side=-1;i++;break;
		}
		
	}

	if (bestFireTime!=10000000)
	{
		retFireTime=bestFireTime;
		retFlyTime =bestFlyTime;
		retHead=bestHead;
		bestLimit=limit;
		// printLog("best: head %d fire %d\n",bestHead,bestFireTime);
		return 1;
	}
	return 0;
}

/** this methode will check the existing data to find out if we can shot or not ... */
void planHitC::calcShotOffsetTime(unsigned int time,const gameObjListC  & lst)
{
	// we have to fill the shot data with the current information

	// get list of shots that should be away
	

	// int left=spaceShip.leftShots();

	spaceShip.clearShots();

	int shotFound=0;
	for (int i=0;i<lst.count();i++)
	{
			gameObjC & objI=lst[i];
			if (objI.isGood() && objI.getType()==objTypeShot)
			{
				unsigned int rest=objI.getLiveTime(time);
				if (rest!=TIME_INFINITE)
					rest+=time;

				
				// the "-1" is because we see the item one frame later than we fire .. so the startTime is wrong
				spaceShip.incShot(objI.getStartime(),rest,objI.getKey());				
			}
	}

	// if (left!=spaceShip.leftShots())
	//	printf(".");

	// we have a shot left and we jsut fire befor .. add a virtual shot to list
	if (spaceShip.leftShots()>0 && time<spaceShip.getLastFireTime())
		 spaceShip.incShot(spaceShip.getLastFireTime(),time+35,0);
	
	// spaceShip.updateExt(time+1,spaceShip.getPosition(),spaceShip.getRotationIndex());

/*
	if (spaceShip.leftShots()==0)
		shotOffsetTime=1;
	else
		shotOffsetTime=0;
*/

	
	
			
	// return shotOffsetTime;

}

unsigned int planHitC::runtimeSpaceShipC::nextFireTime(unsigned int time)
{
 #define ALIGN_FRAME(x) (x)

	if (shots.count()==0)
		return time;

	// last fired shoot
	unsigned int lastT0=0;
	// smallest ready time
	unsigned int minTime=TIME_INFINITE;

	for (int i=0;i<shots.count();i++)
	{
		if (shots[i].t0>lastT0)
			lastT0=shots[i].t0;
		if (shots[i].tx<minTime)
			minTime=shots[i].tx;
	}

	// we have not 4 shots
	if (shots.count()!=4)
	{
		unsigned int diff=time-lastT0;
		if (diff<2)
			return ALIGN_FRAME(time+2-diff);
		return ALIGN_FRAME(time);
	}

	// 4 shots are on the way .. the early shot is after the next tx+1
	minTime++;
	// check related to last shot
	unsigned int diff=minTime-lastT0;
	if (diff<2)	
		return ALIGN_FRAME(minTime+2-diff);
	return ALIGN_FRAME(minTime);
}

