#include "sandbox.h"
#include <fstream>



int sandBoxC::uniqueKey=1;

void sandBoxC::removeOld()
{
	for (int i=objects.count()-1;i>=0;i--)
	{
		if (!objects[i].alive(updateTime))
			objects.del(i);
	}
}

std::ofstream of("out.cub");

void sandBoxC::update(const gameStatusC & stateIn)
{
		
	// update our timer ..		

	unsigned int idx=stateIn.frameindex+128;
	unsigned int oldTime=updateTime;
	

	if (updateTime==-1)
	{
		updateTime=idx;
	}
	else
	{		
		if (idx<frameIndex)
			updateTime+=(idx+256)-frameIndex;
		else
			updateTime+=idx-frameIndex;
	}

	if (oldTime!=-1 && oldTime+1!=updateTime)
	{
		printf("frame lost\n");
	}
	
	frameIndex=idx;

	// some cleanup
	removeOld();

	// start with detection
	score=stateIn.points;
	
	gameStatusC workState=stateIn;
	

	// first take all known objects and use there predication to detect 

	// some coutner for our statistic ..
	int countNew  =0;
	int countCatch=0;
	int countTack =0;
	int countDel  =0;

	// debug out all frame objects in a deep buffer
/*
	for (int f=0;f<workState.objects.count();f++)
	{
		of << workState.objects[f].getPos().x() << "," <<  workState.objects[f].getPos().y() << "," << "0" << ",0,0,0\n";
	}

	of.flush();
	*/
	

	if (stateIn.ship_present)
	{		
		if (gameStartTime==TIME_INFINITE)
		{ lastObjectCount=0;
			gameStartTime=updateTime;
		}
		spaceShip.update(updateTime,vecIntC(stateIn.ship_x,stateIn.ship_y),vecIntC(stateIn.ship_dx,stateIn.ship_dy),0);		
		shipPresent=1;
	}
	else
	{
		shipPresent=0;
	}

	
	{ // first loop will only try to detect prediction objects
		// to do this we use existing data to forecast a new postion
					
		for (int i=0;i<objects.count();i++)
		{
			gameObjC & obj=objects[i];

			if (!obj.predict(updateTime))
				continue;

			int    bestNr =-1;
			float bestLen=1e10;

			int   bestSec =-1;
			float bestSecLen=1e10;
			
			// obj is alive at this time
			vecDblC objPos =obj.getPredictPos(updateTime);

			for (int s=0;s<workState.objects.count();s++)
			{
				const gameObjBaseC & work=workState.objects[s];					
				vecDblC workPos=convVec(work.getStartPos());
				

				// is correct type ..
				if (work.getType()!=obj.getType())
					continue;
														
				// bring on same screen ..
				vecScreenPositionNormalize<float>(objPos,workPos);

				float len=(objPos-workPos).len();
					
				if (len<bestLen)
				{
					bestLen=len;
					bestNr=s;				
				}	

			} // eof loop	state loop

			// check for best
			if (bestNr!=-1)
			{				
				if (bestLen<=3.0)
				{
					countCatch++;
					obj.update(updateTime,workState.objects[bestNr].getStartPos());												
					/*
					static float maxSpeed=0;
					if (obj.getType()==objTypeAstroidSmall && obj.getSpeed()>maxSpeed)				
					{
						maxSpeed=obj.getSpeed();
						printf("%g\n",maxSpeed);
					}
					*/
					/*
					if (obj.getType()==objTypeSaucerLarge || obj.getType()==objTypeShot || obj.getType()==objTypeSaucerSmall)				
					// if (obj.getKey()==95)
					{
						printLog("Key=%d Type=%d Speed=%g Err=%g head=%g,%g\n",obj.getKey(),obj.getType(),obj.getSpeed(),bestLen,obj.getHead().x(),obj.getHead().y());
						of << workState.objects[bestNr].getStartPos().x() << "," <<  workState.objects[bestNr].getStartPos().y() << ",0,1,0,0\n";
						// of << workState.objects[bestNr].getPos().x() << "," <<  workState.objects[bestNr].getPos().y() << "," << 50 << ",0,0,1\n";
						of << workState.objects[bestNr].getStartPos().x() << "," <<  workState.objects[bestNr].getStartPos().y() << "," << bestLen*50 << ",0,1,0\n";					
						of << workState.objects[bestNr].getStartPos().x() << "," <<  workState.objects[bestNr].getStartPos().y() << "," << 3*50 << ",1,1,0\n";					
						of << workState.objects[bestNr].getStartPos().x() << "," <<  workState.objects[bestNr].getStartPos().y() << "," << -obj.getSpeed()*5 << ",0,0,1\n";					

						// if (updateTime>1000)
						// 	fatalError("test end");
						vecDblC pos=obj.getPredictPos(1000);

						vecScreenPositionMap(pos);

						of << pos.x() << "," <<  pos.y() << "," << -5 << ",0,1,1\n";					

						of.flush();

						
					}
					*/
																																									
					workState.objects.del(bestNr);				
				}
				else // len does not fit ..
				{ 
					if (objects[i].getType()==objTypeSaucerSmall || objects[i].getType()==objTypeSaucerLarge)
					{
						// if ufo .. and we know there is only one accept changes anyway
						countCatch++;
						obj.resetTrack(updateTime,workState.objects[bestNr].getStartPos());						
					  workState.objects.del(bestNr);
					}
				}
			}						
		}	// eof object loop

	} // eof predication eval
	

	{ 
		// now see what is with items that are not predicted ..
		// we try to find them with the next object methode and update our records
		for (int s=workState.objects.count()-1;s>=0;s--)
		{
			int best=-1;
			float bestLen=1e10;

			const gameObjBaseC & work=workState.objects[s];
				
			for (int i=0;i<objects.count();i++)
			{
				gameObjC & obj=objects[i];

				if (obj.getTrackCount()!=0)
					continue;

				gameObjTypeE type=obj.getType();										
				// type does not fit ..
				if (work.getType()!=type)
					continue;

				vecIntC objPos=obj.getStartPos();
				vecIntC workPos=work.getStartPos();

				vecScreenPositionNormalize<int>(objPos,workPos);

				float len=(convVec(workPos-objPos)).len();
				float rad=OBJ_MAX_SPEED;
				
				// are we in range of this object (0 len is not possible because objects are moving ..)
				if (len<=rad*3 && len>1e-5)
				{					
					if (len<bestLen)
					{
						best=i;
						bestLen=len;
					}
				}
			}		
			//
			if (best!=-1)
			{
				objects[best].update(updateTime,work.getStartPos());
				workState.objects.del(s);
				countTack++;

				// test if we understand the value wrong
				if (objects[best].getType()==objTypeShot && objects[best].isGood() &&
					(work.getStartPos()-objects[best].getStartPos()).skalar(work.getStartPos()-spaceShip.getPosition())<0)
				{
					objects[best].setBad();					
				}
					  
			}						
		}	
	} // eof next object method

	
	{ // if we still have objects in list this must be new ones..
		for (int i=0;i<workState.objects.count();i++)
		{
			objects.add().set(updateTime,getNextKey(),workState.objects[i]);
			if (shipPresent && (objects.last().getType()==objTypeShot))
			{ float len=(workState.objects[i].getStartPos()-spaceShip.getPosition()).len();
				if (len<32)
				{
					objects.last().setGood();
					levelShots++;
				}
			}
			countNew++;

			if (objects.last().getType()==objTypeSaucerSmall || objects.last().getType()==objTypeSaucerLarge)
			{
				// printf("ufo found=%d\n",updateTime);
			}
		}
	} // eof new objects
	
	{	// all object which are not updated in this round are out
		for (int i=objects.count()-1;i>=0;i--)
		{
			gameObjC & objI=objects[i];
			if (!objI.isUsed(updateTime))
			{ countDel++;	
			  /*
				if (objects[i].getType()==objTypeShot)
					printLog("%d.",objects[i].getTrackCount());
				*/

				
				printLog("Frame=%4d|kill: key=%d Type=%d TL=%d POS(%d,%d)\n",
					updateTime,objI.getKey(),objI.getType(),updateTime-objI.getStartime(),
					(int)objI.getP1().x(),(int)objI.getP1().y());
				

				
			
				
				if (objects[i].getType()==objTypeShot && objects[i].isGood())
				{	/*
					static double speed=0.0;
					static int count=0;
					count++;
					speed+=objects[i].getSpeed();
					printf("%g %g %g\n",objects[i].getSpeed(),angle(vecDblC(1,0),objects[i].getHead())*180/PI,speed/double(count));
					*/
					

					/*
					static int all=0;
					static int hit=0;

					all++;
					if (objects[i].getTrackCount()<68)
						hit++;
					else
						printf("diff = %d %d\n",all,hit);
						*/

				}	
				
				
				objects.del(i);
			}
		}
	} // eof "you are out" loop

	// test some global states
	if (objects.countTargets()==0)
	{		
		// level is maybe at end
		if (levelScore)
		{
			int localScore=score-levelScore;
			printf("End F:%6d Lvl:%2d S:%6d LS:%6d LT:%4d Sh:%3d FK:%d KR:%g\n",updateTime-gameStartTime,level,score,localScore,updateTime-levelStartTime,levelShots,levelFire,float(localScore)/float(updateTime-levelStartTime));		
			levelScore=0;
			levelShots=0;
			levelFire=0;
		}
	}
	else // we found something
	{
		// last frame nothing now we have something
		if (!lastObjectCount)
		{ // befor was nothing .. a level starts ..
			level++;			
			levelStartTime=updateTime;											
			levelScore=score;
			// see how many objects appear here ..
			int targets=objects.countTargets();
			printf("max Shoots %d\n",targets+targets*2+targets*4);
			printf("Beg F:%6d Lvl:%2d S:%6d\n",updateTime-gameStartTime,level,score);		
		}		
	}

	

	lastObjectCount=objects.countTargets();
	
	if ((updateTime-gameStartTime) % 1000==0)
	{
		printf("Frame %4d|Score%6d\n",updateTime-gameStartTime,score);
	}
		
	printLog("Frame %4d|New=%4d Track=%4d Catch=%4d Del=%4d\n",updateTime,countNew,countTack,countCatch,countDel);
 /*
	if (updateTime % 180==0)
	{ int localScore=score-levelScore;
		printf("%6d %6d %6d %6d %g\n",level,score,localScore,updateTime-levelStartTime,float(localScore)/float(updateTime-levelStartTime));						
	}
 */

}