// ----------------------------------------------------------------------------
// 'The Sniper'  -  c't Asteroids bot  -  Thorsten Denhard, 2008
// ----------------------------------------------------------------------------

#include <winsock2.h>
#include <windows.h>

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <time.h>

#include "player.h"

int main(int argc, char *argv[])
{  
  bool hiPrio    = false;
  bool exitFive  = false;
  bool exitTen   = false;
  bool batchFive = false;
  bool batchTen  = false;
  bool verbose   = false;

  printf ("----------------------------------------------------\n");
  printf ("--- c't Asteroids bot  -  Thorsten Denhard, 2008 ---\n");
  printf ("----------------------------------------------------\n");
  printf ("\n");
  printf ("Usage: asteroids <ip-address> [options]\n");
  printf ("\n"); 
  printf ("Options (DO NOT USE FOR CONTEST):\n");
  printf ("\n");
  printf ("  --hi-prio    : Set above-normal process priority\n");
  printf ("  --exit-five  : Exit after 5  minute game\n");
  printf ("  --exit-ten   : Exit after 10 minute game\n");
  printf ("  --batch-five : Batch-mode, 5  minute game\n");
  printf ("  --batch-ten  : Batch-mode, 10 minute game\n");
  printf ("  --verbose    : Display some diagnostics\n");
  printf ("\n");
  printf ("\n");
   
  // --------------------------------------------------------------------------
  // Parse commandline
  // --------------------------------------------------------------------------

  // IP address as first param
    
	unsigned long server_ip = inet_addr(argv[1]);

  if (server_ip == INADDR_NONE)
	{
    printf ("? IP address missing or invalid: defaulting to localhost\n");

    server_ip = inet_addr("127.0.0.1");

    if (server_ip == INADDR_NONE)
    {
      printf("! Error: server not found\n");
      exit(1);
    }
	}
  
  // Additional params

  int i = 0;

  for (i=1; i<argc; ++i)
  {
    if (0 == strcmp (argv[i], "--hi-prio"))
    {
      hiPrio = true;
    }
    if (0 == strcmp (argv[i], "--exit-five"))
    {
      exitFive = true;
    }
    if (0 == strcmp (argv[i], "--exit-ten"))
    {
      exitTen = true;
    }
    if (0 == strcmp (argv[i], "--batch-five"))
    {
      batchFive = true;
    }
    if (0 == strcmp (argv[i], "--batch-ten"))
    {
      batchTen = true;
    }
    if (0 == strcmp (argv[i], "--verbose"))
    {
      verbose = true;
    }
  }

  if (true == hiPrio)
  {
    printf ("> Setting above-normal process priority\n");

    SetPriorityClass (GetCurrentProcess (), ABOVE_NORMAL_PRIORITY_CLASS);
  }
  
  if (true == batchFive ||
      true == batchTen)
  {
    printf ("> Batch mode: Take screenshot, exit bot and kill mame after game\n");

    srand (int (time (0)));
    double sleepTime = 15000.0f * double (rand ()) / double (RAND_MAX);  
    Sleep (5000 + int (sleepTime));
  }
 
  exitFive |= batchFive;
  exitTen  |= batchTen;
  
  // --------------------------------------------------------------------------
  // Connect to server
  // --------------------------------------------------------------------------

	WSADATA wsadata;
	if (WSAStartup(MAKEWORD(2,2), &wsadata))
	{
		printf ("! Error: init Winsock\n");
		exit(2);
	}

	SOCKET sd;
	sd = socket(AF_INET, SOCK_DGRAM, 0);
	if (sd == INVALID_SOCKET)
	{
		printf ("! Error: socket (%d)\n", WSAGetLastError());
		exit(2);
	}

	unsigned long enable_nonblocking = 1;
	if (ioctlsocket(sd, FIONBIO, &enable_nonblocking))
	{
		printf ("! Error: set socket to nonblocking (%d)\n", WSAGetLastError());
		exit(1);
	}

	sockaddr_in sa;
	memset (&sa, 0, sizeof sa);
	sa.sin_family      = AF_INET;
	sa.sin_addr.s_addr = 0;
	sa.sin_port        = 0;

	if (bind (sd, (struct sockaddr*) &sa, sizeof sa))
	{
		printf ("! Error: bind (%d)\n", WSAGetLastError ());
		exit(2);
	}

  // --------------------------------------------------------------------------
  // Run (forever)
  // --------------------------------------------------------------------------

  if (true == verbose)
  {
    printf ("> Verbose mode\n");
  }
  
  if (true == exitFive)
  {
    printf ("> Running five minute game...\n");
  }
  else if (true == exitTen)
  {
    printf ("> Running ten minute game...\n");
  }
  else
  {
    printf ("> Running forever...\n");
  }  

  Player (sd, server_ip, exitFive, exitTen, batchFive|batchTen, verbose).run ();
  
  return 0;
}

