// ----------------------------------------------------------------------------
// 'The Sniper'  -  c't Asteroids bot  -  Thorsten Denhard, 2008
// ----------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <winsock2.h>

#include "framestatus.h"

FrameStatus::FrameStatus () :
  mSceneObjects     (),
  mSceneObjectCount (0),
  mShipPresent      (false),
	mShipX            (0),
	mShipY            (0),
	mShipDX           (0),
	mShipDY           (0),
  mShipVelocityX    (0.0f),
  mShipVelocityY    (0.0f),
  mTime             (0.0f),
  mFullFrameNumber  (0)
{
}
  
int
FrameStatus::findObjects (int type, int* indexListRet) const
{
  int i     = 0;
  int count = 0;

  for (i=0; i<MAX_SCENE_OBJECTS; ++i)
  {
    if (mSceneObjects[i].mType != type)
    {
      continue;
    }
    
    if (indexListRet != NULL)
    {
      indexListRet[count] = i;
    }

    ++count;
  }  

  return count;
}

int
FrameStatus::findSaucerIndex () const
{
  int i = 0;

  for (i=0; i<MAX_SCENE_OBJECTS; ++i)
  {
    if (mSceneObjects[i].mType == TYPE_SAUCER)
    {
      return i;
    }
  }  

  return -1;
}

void 
FrameStatus::clear ()
{
  int i = 0;

  for (i=0; i<MAX_SCENE_OBJECTS; ++i)
  {
    mSceneObjects[i].clear ();
  }
  
  mShipPresent      = false;
	mShipX            = 0;
	mShipY            = 0;
	mShipDX           = 0;
	mShipDY           = 0;
  mShipVelocityX    = 0.0f;
  mShipVelocityY    = 0.0f;  
  mSceneObjectCount = 0;
  mTime             = -1.0f;
  mFullFrameNumber  = 0;
}

