// ----------------------------------------------------------------------------
// 'The Sniper'  -  c't Asteroids bot  -  Thorsten Denhard, 2008
// ----------------------------------------------------------------------------

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <time.h>
#include <math.h>
#include <winsock2.h>

#include "keyspacket.h"

KeysPacket::KeysPacket ()
{
  mSignature[0] = 'c';
  mSignature[1] = 't';
  mSignature[2] = 'm';
  mSignature[3] = 'a';
  mSignature[4] = 'm';
  mSignature[5] = 'e';

  mKeys = '@';
  mPing = 0;
}

KeysPacket::KeysPacket (const KeysPacket& other)
{
  mKeys = other.mKeys;
}

KeysPacket& 
KeysPacket::operator= (const KeysPacket& other)
{
  mKeys = other.mKeys;

  return (*this);
}

void 
KeysPacket::clear ()
{
  mKeys = '@';
}

void 
KeysPacket::hyperspace (bool b)
{
  if (b)
  {
    mKeys |= KEY_HYPERSPACE;
  }
  else
  {
    mKeys &= ~KEY_HYPERSPACE;
  }
}

void 
KeysPacket::fire (bool b)
{
  if (b)
  {
    mKeys |= KEY_FIRE;
  }
  else
  {
    mKeys &= ~KEY_FIRE;
  }
}

void 
KeysPacket::thrust (bool b)
{
  if (b)
  {
    mKeys |= KEY_THRUST;
  }
  else
  {
    mKeys &= ~KEY_THRUST;
  }
}

void 
KeysPacket::left (bool b)
{
  if (b)
  {
    mKeys |= KEY_LEFT;
    this->right(false);
  }
  else
  {
    mKeys &= ~KEY_LEFT;
  }
}

void 
KeysPacket::right (bool b)
{
  if (b)
  {
    mKeys |= KEY_RIGHT;
    this->left (false);
  }
  else
  {
    mKeys &= ~KEY_RIGHT;
  }
}

bool 
KeysPacket::isHyperspace () const
{
  return (0 != (mKeys & KEY_HYPERSPACE));
}

bool 
KeysPacket::isFire () const
{
  return (0 != (mKeys & KEY_FIRE));
}

bool 
KeysPacket::isThrust () const
{
  return (0 != (mKeys & KEY_THRUST));
}

bool 
KeysPacket::isRight () const
{
  return (0 != (mKeys & KEY_RIGHT));
}

bool 
KeysPacket::isLeft () const
{
  return (0 != (mKeys & KEY_LEFT));
}

KeysPacket 
KeysPacket::HYPERSPACE ()
{
  KeysPacket packet;
  {
    packet.hyperspace ();
  }
  return packet;
}

KeysPacket 
KeysPacket::NOP ()
{
  return KeysPacket ();
}

KeysPacket 
KeysPacket::FIRE ()
{
  KeysPacket packet;
  {
    packet.fire ();
  }
  return packet;
}

KeysPacket 
KeysPacket::THRUST (bool alsoFire)
{
  KeysPacket packet;
  {
    packet.thrust ();

    if (alsoFire)
    {
      packet.fire ();
    }
  }
  return packet;
}

KeysPacket 
KeysPacket::LEFT (bool alsoFire)
{
  KeysPacket packet;
  {
    packet.left ();

    if (alsoFire)
    {
      packet.fire ();
    }
  }
  return packet;
}

KeysPacket 
KeysPacket::RIGHT (bool alsoFire)
{
  KeysPacket packet;
  {
    packet.right ();

    if (alsoFire)
    {
      packet.fire ();
    }
  }
  return packet;
}

KeysPacket 
KeysPacket::START ()
{
  KeysPacket packet;
  {
    packet.mKeys |= KEY_START;
  }
  return packet;
}

