// ----------------------------------------------------------------------------
// 'The Sniper'  -  c't Asteroids bot  -  Thorsten Denhard, 2008
// ----------------------------------------------------------------------------

#ifndef __AST_KEYSPACKET_H
#define __AST_KEYSPACKET_H

#include "defines.h"

#pragma pack(1)
class KeysPacket
{
public:
	static const char KEY_HYPERSPACE = 0x01;
	static const char KEY_FIRE       = 0x02;
	static const char KEY_THRUST     = 0x04;
	static const char KEY_RIGHT      = 0x08;
	static const char KEY_LEFT       = 0x10;
	static const char KEY_START      = 0x20;

public:
	KeysPacket ();
	KeysPacket (const KeysPacket& other);
	KeysPacket& operator= (const KeysPacket& other);
    
public:
	void clear      ();
	void hyperspace (bool b = true);
	void fire       (bool b = true);
	void thrust     (bool b = true);
	void right      (bool b = true);
	void left       (bool b = true);
  
public:
  bool isHyperspace () const;
  bool isFire       () const;
  bool isThrust     () const;
  bool isRight      () const;
  bool isLeft       () const;
  
public:
	char          mSignature[6];
	char          mKeys;
	unsigned char mPing; 

public:
  static KeysPacket NOP        ();
  static KeysPacket HYPERSPACE ();
  static KeysPacket FIRE       ();
  static KeysPacket THRUST     (bool alsoFire = false);
  static KeysPacket RIGHT      (bool alsoFire = false);
  static KeysPacket LEFT       (bool alsoFire = false);
  static KeysPacket START      ();
};
#pragma pack()

#endif

