// ----------------------------------------------------------------------------
// 'The Sniper'  -  c't Asteroids bot  -  Thorsten Denhard, 2008
// ----------------------------------------------------------------------------

#ifndef __AST_PLAYER_H
#define __AST_PLAYER_H

#include "defines.h"
#include "viewer.h"

class Player :
  public Viewer
{
public:
    Player (SOCKET socket, ADDRESS serverIP, bool exitFive, bool exitTen, bool batch, bool verbose);
    virtual ~Player ();
    
protected:
  virtual void updateAction ();  

private:
  void reset ();

private:
  double getCollisionTime   (int sceneObjectIndex, 
                             double posX, double posY, 
                             double voffX = 0.0, double voffY = 0.0,
                             double roff = 0.0, double toff = 0.0);
  
  int    getCollisionObject (double& collisionTimeRet,
                             double posX, double posY, 
                             double voffX = 0.0, double voffY = 0.0,
                             bool allowShots = false,
                             double roff = 0.0, double toff = 0.0);

private:
  bool getDestructInfo (int index, int maxF, int& rotateCountRet, int& waitCountRet, int& flyCountRet);
  
private:
  bool checkShipNotPresent ();
  bool processCalibration  ();
  bool checkViewDirection  ();
  bool bailoutCheck        ();
  bool checkTargets        ();
  
private:
  bool              mExitFive;
  bool              mExitTen;
  unsigned long int mDestructActionFinishedFFN;
  bool              mDestructActionWasUrgent;
  unsigned long int mDestructActionID;
  int               mHyperspaceFlag;
  unsigned long int mLastZeroObjectsFrame;
  unsigned long int mFirstFrame;
  bool              mVerbose;
  int               mCalibrationFlag;
  double            mCalibrationAngleSum;
  double            mCalibrationAngleCount;
};

#endif

