#ifndef SHIP_UPDATEVELOCITY_H
#define SHIP_UPDATEVELOCITY_H

#include "Ship.h"

class Ship;

/**
 *  Ship velocity is computed explicitly, based on keystrokes
 *  and events.
 */
inline
void Ship::updateVelocity() {

        /// The initial guess is fetched from the previous
        /// ship. After restart or hyperjump, the previous
        /// frame does not contain a ship, and the initial
        /// speed is zero.
        Ship* lastShip;
        if (! (lastShip = frame->listPrev->ship)) {
            u = 0;
            v = 0;
        } else {
            u = lastShip->getu();
            v = lastShip->getv();

            const double dec = exp(SHIP_DEC);

            /// If the previous frame is even, and the
            /// pre-previous keys had thruster activated,
            /// the ship accelerates.
            if (FrameStatus *past = frame->listPrev)
            if (FrameStatus *ppast = past->listPrev) 
            if (past->even && ppast->keys.getThrust()) {
                u += Ship::shotUVel[lastShip->step]/60.;
                v += Ship::shotVVel[lastShip->step]/60.;
                u = limit480(u);
                v = limit480(v);
            }

            u *= 255./256.;
            v *= 255./256.;

        }

        /// A velocity error might accumulate. To encounter this,
        /// we integrate the path of the ship, and its velocity,
        /// over some frames. From the difference, a velocity
        /// error is deduced.
        /// First, the number of available previous object data
        /// is counted, up to a maximum number.
        double ix=0;
        double iy=0;
        int nprev = 0;
        const int maxprev = 20;
        MovingObject* prev = this;
        while (nprev<maxprev && prev->listPrev) {
            prev = prev->listPrev;
            nprev++;
            ix += prev->getu()/60.;
            iy += prev->getv()/60.;
        }
        if (nprev) {
            int dx = x-prev->getx();
            int dy = y-prev->gety();
            FrameStatus::normalize(dx,dy);
            double du = (dx-ix)/nprev*60.;
            double dv = (dy-iy)/nprev*60.;
            double corr = sqrt(du*du+dv*dv);
            if (fabs(corr)>1) {
                //printf("Corr: %10.5f\n",corr);
                nprev = 0;
                prev = this;
                while (nprev<maxprev && prev) {
                    prev->u += du;
                    prev->v += dv;
                    prev = prev->listPrev;
                    nprev++;
                }
            }
        }
        speed = sqrt(u*u+v*v);
    }


#endif
