// player.cpp: Beispielspieler f�r Asteroids
// Harald B�geholz / c't

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#if defined(WINDOWS)
#include <winsock2.h>
#else
// 2 Includes f�r socket()
#include <sys/types.h>
#include <sys/socket.h>
// 2 Includes f�r inet_addr()
#include <netinet/in.h>
#include <arpa/inet.h>
// 2 Includes f�r fcntl()
#include <unistd.h>
#include <fcntl.h>
// f�r memset()
#define INVALID_SOCKET -1
#define WSAGetLastError() errno
#endif

#include "player.h"
#include "MovingObjects/Collision.h"
#include "MovingObjects/MovingObject_getPos_shotBy.h"
#include "FrameStatus/FrameStatus.h"
#include "FrameStatus/FrameStatus_aimForTargets.h"
#include "FrameStatus/FrameStatus_evasionMeasures.h"
#include "MovingObjects/Ship_FictiveShot.h"


template<> int LinkedClass<FrameStatus>::listCount = 0;
template<> FrameStatus* LinkedClass<FrameStatus>::listFirst = 0;
template<> FrameStatus* LinkedClass<FrameStatus>::listLast = 0;

int Ship::lastStep = 0;
int FrameStatus::shipShots = 0;

/// List of dx values for a given step index.
const int Ship::stepDX[] = {
  1536,   1536,   1528,   1504,   1472,   1472,   1416,   1360,   1280,
  1280,   1192,   1088,    976,    976,    856,    720,    584,
   584,    440,    296,    152,    152,   -152,   -296,   -296,
  -440,   -584,   -720,   -720,   -856,   -976,  -1088,  -1088,
 -1192,  -1280,  -1360,  -1360,  -1416,  -1472,  -1504,  -1504,
 -1528,  -1536,  -1536,  -1528,  -1528,  -1504,  -1472,  -1416,
 -1416,  -1360,  -1280,  -1192,  -1192,  -1088,   -976,   -856,
  -856,   -720,   -584,   -440,   -440,   -296,   -152,      0,
   152,    296,    440,    440,    584,    720,    856,    856,
   976,   1088,   1192,   1192,   1280,   1360,   1416,   1416,
  1472,   1504,   1528,   1528,   1536,   1536,   1528,   1504,
  1504,   1472,   1416,   1360,   1360,   1280,   1192,   1088,
  1088,    976,    856,    720,    720,    584,    440,    296,
   296,    152,   -152,   -152,   -296,   -440,   -584,   -584,
  -720,   -856,   -976,   -976,  -1088,  -1192,  -1280,  -1280,
 -1360,  -1416,  -1472,  -1472,  -1504,  -1528,  -1536,  -1536,
 -1536,  -1528,  -1504,  -1472,  -1472,  -1416,  -1360,  -1280,
 -1280,  -1192,  -1088,   -976,   -976,   -856,   -720,   -584,
  -584,   -440,   -296,   -152,   -152,    152,    296,    296,
   440,    584,    720,    720,    856,    976,   1088,   1088,
  1192,   1280,   1360,   1360,   1416,   1472,   1504,   1504,
  1528,   1536,   1536,   1528,   1528,   1504,   1472,   1416,
  1416,   1360,   1280,   1192,   1192,   1088,    976,    856,
   856,    720,    584,    440,    440,    296,    152,      0,
  -152,   -296,   -440,   -440,   -584,   -720,   -856,   -856,
  -976,  -1088,  -1192,  -1192,  -1280,  -1360,  -1416,  -1416,
 -1472,  -1504,  -1528,  -1528,  -1536,  -1536,  -1528,  -1504,
 -1504,  -1472,  -1416,  -1360,  -1360,  -1280,  -1192,  -1088,
 -1088,   -976,   -856,   -720,   -720,   -584,   -440,   -296,
  -296,   -152,    152,    152,    296,    440,    584,    584,
   720,    856,    976,    976,   1088,   1192,   1280,   1280,
  1360,   1416,   1472,   1472,   1504,   1528,   1536
};

/// List of dy values for a given step index.
const int Ship::stepDY[] = {
     0,      0,    152,    296,    440,    440,    584,    720,    856,
   856,    976,   1088,   1192,   1192,   1280,   1360,   1416,
  1416,   1472,   1504,   1528,   1528,   1528,   1504,   1504,
  1472,   1416,   1360,   1360,   1280,   1192,   1088,   1088,
   976,    856,    720,    720,    584,    440,    296,    296,
   152,      0,      0,   -152,   -152,   -296,   -440,   -584,
  -584,   -720,   -856,   -976,   -976,  -1088,  -1192,  -1280,
 -1280,  -1360,  -1416,  -1472,  -1472,  -1504,  -1528,  -1536,
 -1528,  -1504,  -1472,  -1472,  -1416,  -1360,  -1280,  -1280,
 -1192,  -1088,   -976,   -976,   -856,   -720,   -584,   -584,
  -440,   -296,   -152,   -152,      0,      0,    152,    296,
   296,    440,    584,    720,    720,    856,    976,   1088,
  1088,   1192,   1280,   1360,   1360,   1416,   1472,   1504,
  1504,   1528,   1528,   1528,   1504,   1472,   1416,   1416,
  1360,   1280,   1192,   1192,   1088,    976,    856,    856,
   720,    584,    440,    440,    296,    152,      0,      0,
     0,   -152,   -296,   -440,   -440,   -584,   -720,   -856,
  -856,   -976,  -1088,  -1192,  -1192,  -1280,  -1360,  -1416,
 -1416,  -1472,  -1504,  -1528,  -1528,  -1528,  -1504,  -1504,
 -1472,  -1416,  -1360,  -1360,  -1280,  -1192,  -1088,  -1088,
  -976,   -856,   -720,   -720,   -584,   -440,   -296,   -296,
  -152,      0,      0,    152,    152,    296,    440,    584,
   584,    720,    856,    976,    976,   1088,   1192,   1280,
  1280,   1360,   1416,   1472,   1472,   1504,   1528,   1536,
  1528,   1504,   1472,   1472,   1416,   1360,   1280,   1280,
  1192,   1088,    976,    976,    856,    720,    584,    584,
   440,    296,    152,    152,      0,      0,   -152,   -296,
  -296,   -440,   -584,   -720,   -720,   -856,   -976,  -1088,
 -1088,  -1192,  -1280,  -1360,  -1360,  -1416,  -1472,  -1504,
 -1504,  -1528,  -1528,  -1528,  -1504,  -1472,  -1416,  -1416,
 -1360,  -1280,  -1192,  -1192,  -1088,   -976,   -856,   -856,
  -720,   -584,   -440,   -440,   -296,   -152,      0
};


const int Ship::shotYOffs[] = {
  0,   1,   2,   4,   5,   7,   8,   9,
 10,  12,  13,  14,  15,  16,  16,  17,
 18,  18,  19,  19,  19,  19,  19,  19,
 19,  19,  18,  18,  17,  16,  15,  15,
 14,  12,  11,  10,   9,   7,   6,   5,
  3,   2,   0,  -1,  -2,  -4,  -5,  -7,
 -8, -10, -11, -12, -13, -14, -15, -16,
-17, -18, -19, -19, -20, -20, -20, -20,
-20, -20, -20, -20, -20, -19, -19, -18,
-17, -16, -15, -14, -13, -12, -11, -10,
 -8,  -7,  -5,  -4,  -2,  -1,   0,   2,
  3,   5,   6,   7,   9,  10,  11,  12,
 14,  15,  15,  16,  17,  18,  18,  19,
 19,  19,  19,  19,  19,  19,  19,  18,
 18,  17,  16,  16,  15,  14,  13,  12,
 10,   9,   8,   7,   5,   4,   2,   1,
  0,  -2,  -4,  -5,  -6,  -8,  -9, -10,
-12, -13, -14, -15, -16, -17, -18, -18,
-19, -20, -20, -20, -20, -20, -20, -20,
-20, -20, -19, -19, -18, -17, -16, -15,
-15, -14, -12, -11, -10,  -9,  -7,  -6,
 -5,  -3,  -1,   0,   1,   3,   4,   6,
  7,   8,  10,  11,  12,  13,  14,  15,
 16,  17,  17,  18,  19,  19,  19,  19,
 19,  19,  19,  19,  19,  18,  17,  17,
 16,  15,  14,  13,  12,  11,  10,   8,
  7,   6,   4,   3,   1,   0,  -1,  -3,
 -5,  -6,  -7,  -9, -10, -11, -12, -14,
-15, -15, -16, -17, -18, -19, -19, -20,
-20, -20, -20, -20, -20, -20, -20, -20,
-19, -18, -18, -17, -16, -15, -14, -13,
-12, -10,  -9,  -8,  -6,  -5,  -4,  -2
};

const int Ship::shotXOffs[] = {
 19,  19,  19,  19,  19,  18,  17,  17,
 16,  15,  14,  13,  12,  11,  10,   8,
  7,   6,   4,   3,   1,   0,  -1,  -3,
 -5,  -6,  -7,  -9, -10, -11, -12, -14,
-15, -15, -16, -17, -18, -19, -19, -20,
-20, -20, -20, -20, -20, -20, -20, -20,
-19, -18, -18, -17, -16, -15, -14, -13,
-12, -10,  -9,  -8,  -6,  -5,  -4,  -2,
  0,   1,   2,   4,   5,   7,   8,   9,
 10,  12,  13,  14,  15,  16,  16,  17,
 18,  18,  19,  19,  19,  19,  19,  19,
 19,  19,  18,  18,  17,  16,  15,  15,
 14,  12,  11,  10,   9,   7,   6,   5,
  3,   2,   0,  -1,  -2,  -4,  -5,  -7,
 -8, -10, -11, -12, -13, -14, -15, -16,
-17, -18, -19, -19, -20, -20, -20, -20,
-20, -20, -20, -20, -20, -19, -19, -18,
-17, -16, -15, -14, -13, -12, -11, -10,
 -8,  -7,  -5,  -4,  -2,  -1,   0,   2,
  3,   5,   6,   7,   9,  10,  11,  12,
 14,  15,  15,  16,  17,  18,  18,  19,
 19,  19,  19,  19,  19,  19,  19,  18,
 18,  17,  16,  16,  15,  14,  13,  12,
 10,   9,   8,   7,   5,   4,   2,   1,
  0,  -2,  -4,  -5,  -6,  -8,  -9, -10,
-12, -13, -14, -15, -16, -17, -18, -18,
-19, -20, -20, -20, -20, -20, -20, -20,
-20, -20, -19, -19, -18, -17, -16, -15,
-15, -14, -12, -11, -10,  -9,  -7,  -6,
 -5,  -3,  -1,   0,   1,   3,   4,   6,
  7,   8,  10,  11,  12,  13,  14,  15,
 16,  17,  17,  18,  19,  19,  19,  19
};

const double Ship::shotVVel[] = {
    0.00,    29.27,    68.00,   105.33,   134.63,   172.68,   201.95,   232.68,
  263.41,   292.68,   314.67,   345.33,   366.67,   389.27,   405.37,   420.00,
  434.63,   450.73,   456.59,   465.37,   472.68,   472.68,   472.68,   472.68,
  465.37,   456.59,   450.73,   434.63,   420.00,   397.33,   382.67,   360.00,
  336.59,   307.32,   285.37,   254.63,   225.33,   187.32,   158.05,   127.32,
   90.67,    60.00,    23.41,   -14.63,   -45.37,   -81.95,  -120.00,  -149.27,
 -193.17,  -216.59,  -247.32,  -277.33,  -307.32,  -330.73,  -352.68,  -374.63,
 -398.05,  -420.00,  -434.63,  -442.67,  -457.33,  -465.37,  -472.68,  -480.00,
 -480.00,  -480.00,  -473.33,  -465.37,  -456.59,  -442.67,  -434.63,  -420.00,
 -397.33,  -374.63,  -352.68,  -330.73,  -307.32,  -278.05,  -246.67,  -216.59,
 -187.32,  -149.33,  -120.00,   -81.95,   -45.33,   -14.63,    23.41,    60.00,
   90.73,   126.67,   157.33,   187.32,   225.33,   254.67,   285.37,   308.00,
  336.59,   360.00,   382.67,   398.05,   420.00,   434.63,   450.73,   456.59,
  465.37,   472.68,   472.68,   472.68,   472.68,   465.37,   456.59,   450.73,
  434.63,   420.00,   405.37,   389.27,   376.10,   352.68,   321.95,   298.54,
  269.27,   232.68,   201.95,   172.68,   134.63,   105.37,    67.32,    29.27,
    0.00,   -38.05,   -74.63,  -106.83,  -146.34,  -172.68,  -201.95,  -240.00,
 -269.27,  -292.68,  -321.95,  -345.37,  -367.32,  -389.27,  -412.00,  -427.32,
 -441.95,  -456.59,  -475.61,  -472.68,  -473.33,  -491.71,  -491.71,  -473.33,
 -473.33,  -456.59,  -450.67,  -434.63,  -420.00,  -405.37,  -383.41,  -360.00,
 -336.59,  -314.63,  -285.37,  -254.63,  -225.37,  -194.63,  -165.37,  -127.32,
  -96.59,   -60.00,   -23.41,     6.67,    45.37,    82.67,   113.33,   149.27,
  180.00,   210.73,   240.00,   269.33,   300.00,   330.73,   352.68,   374.67,
  398.05,   412.68,   427.32,   441.95,   456.59,   465.37,   472.68,   472.68,
  472.68,   472.68,   472.68,   465.37,   456.59,   441.95,   427.32,   412.68,
  398.05,   374.63,   352.68,   330.73,   300.00,   269.27,   240.00,   210.73,
  180.00,   149.33,   112.68,    81.95,    45.37,     7.32,   -23.41,   -60.00,
  -96.59,  -127.32,  -165.37,  -194.63,  -225.37,  -254.63,  -285.37,  -314.63,
 -336.59,  -360.00,  -382.67,  -405.33,  -420.00,  -434.67,  -450.67,  -457.33,
 -473.33,  -472.68,  -480.00,  -480.00,  -472.68,  -472.68,  -465.37,  -457.33,
 -441.95,  -427.32,  -412.00,  -389.33,  -366.67,  -345.33,  -322.67,  -292.00,
 -269.33,  -240.00,  -202.67,  -172.00,  -142.67,  -105.33,   -74.67,   -37.33
};

const double Ship::shotUVel[] = {
  472.68,   472.68,   473.33,   465.33,   456.59,   441.95,   427.32,   412.68,
  398.05,   374.63,   353.33,   330.67,   300.00,   269.27,   240.00,   210.73,
  180.00,   149.27,   112.68,    81.95,    45.37,     7.32,   -23.41,   -60.00,
  -96.59,  -127.32,  -165.37,  -194.63,  -225.37,  -254.67,  -285.33,  -314.63,
 -336.59,  -360.00,  -383.41,  -405.37,  -420.00,  -434.63,  -450.73,  -456.59,
 -473.33,  -472.68,  -480.00,  -480.00,  -472.68,  -472.68,  -465.37,  -456.59,
 -453.66,  -427.32,  -412.68,  -389.33,  -367.32,  -345.37,  -321.95,  -292.68,
 -269.27,  -240.00,  -201.95,  -172.00,  -142.67,  -105.37,   -74.63,   -37.33,
    0.00,    29.33,    68.00,   105.37,   134.63,   172.00,   201.95,   232.68,
  262.67,   292.68,   314.63,   345.37,   367.32,   389.27,   405.33,   420.00,
  434.63,   450.67,   456.59,   465.37,   473.33,   472.68,   472.68,   473.33,
  465.37,   457.33,   450.67,   434.63,   420.00,   397.33,   383.41,   360.00,
  336.59,   307.32,   285.33,   254.63,   225.37,   187.32,   158.05,   127.32,
   90.73,    60.00,    23.41,   -14.63,   -45.37,   -81.95,  -120.00,  -149.27,
 -187.32,  -216.59,  -247.32,  -278.05,  -316.10,  -338.05,  -361.46,  -384.88,
 -406.83,  -420.00,  -434.63,  -441.95,  -456.59,  -465.37,  -472.68,  -480.00,
 -480.00,  -480.00,  -472.68,  -475.61,  -468.29,  -441.95,  -434.63,  -420.00,
 -398.05,  -374.63,  -352.68,  -330.73,  -307.32,  -278.05,  -246.67,  -216.59,
 -187.32,  -149.27,  -122.93,   -81.95,   -45.33,   -16.10,    23.41,    60.00,
   90.67,   127.32,   157.33,   187.32,   225.37,   254.63,   285.37,   307.32,
  336.59,   360.00,   383.41,   398.05,   420.00,   434.63,   450.73,   456.59,
  465.37,   472.68,   472.68,   473.33,   472.68,   465.33,   457.33,   450.73,
  434.63,   420.00,   405.37,   389.33,   367.32,   345.37,   314.63,   292.00,
  263.41,   232.68,   201.95,   172.68,   134.63,   105.37,    67.32,    29.27,
    0.00,   -38.05,   -74.63,  -105.37,  -143.41,  -172.68,  -201.95,  -240.00,
 -269.27,  -292.68,  -321.95,  -345.37,  -367.32,  -389.27,  -412.68,  -427.32,
 -442.67,  -457.33,  -465.37,  -472.68,  -472.68,  -480.00,  -480.00,  -472.68,
 -472.68,  -456.59,  -450.73,  -434.63,  -420.00,  -405.37,  -383.41,  -360.00,
 -336.59,  -314.63,  -285.33,  -254.67,  -225.33,  -194.67,  -165.33,  -126.67,
  -97.33,   -60.00,   -23.41,     7.32,    45.37,    81.95,   112.68,   149.33,
  180.00,   210.73,   240.00,   269.33,   300.00,   330.67,   353.33,   374.67,
  397.33,   412.00,   428.00,   442.67,   457.33,   465.33,   473.33,   473.33
};


const double Ship::stepAngle[] = {
  90.0000,   85.7813,   81.5625,   77.3438,   73.1250,   68.9063,   64.6875,   60.4688,
  56.2500,   52.0313,   47.8125,   43.5938,   39.3750,   35.1563,   30.9375,   26.7188,
  22.5000,   18.2813,   14.0625,    9.8438,    5.6250,    1.4063,   -2.8125,   -7.0313,
 -11.2500,  -15.4688,  -19.6875,  -23.9063,  -28.1250,  -32.3438,  -36.5625,  -40.7813,
 -45.0000,  -49.2188,  -53.4375,  -57.6563,  -61.8750,  -66.0938,  -70.3125,  -74.5313,
 -78.7500,  -82.9688,  -87.1875,  -91.4063,  -95.6250,  -99.8438, -104.0625, -108.2813,
-112.5000, -116.7188, -120.9375, -125.1563, -129.3750, -133.5938, -137.8125, -142.0313,
-146.2500, -150.4688, -154.6875, -158.9063, -163.1250, -167.3438, -171.5625, -175.7813,
-180.0000,  175.7813,  171.5625,  167.3438,  163.1250,  158.9063,  154.6875,  150.4688,
 146.2500,  142.0313,  137.8125,  133.5938,  129.3750,  125.1563,  120.9375,  116.7188,
 112.5000,  108.2813,  104.0625,   99.8438,   95.6250,   91.4063,   87.1875,   82.9688,
  78.7500,   74.5313,   70.3125,   66.0938,   61.8750,   57.6563,   53.4375,   49.2188,
  45.0000,   40.7813,   36.5625,   32.3438,   28.1250,   23.9063,   19.6875,   15.4688,
  11.2500,    7.0313,    2.8125,   -1.4063,   -5.6250,   -9.8438,  -14.0625,  -18.2813,
 -22.5000,  -26.7188,  -30.9375,  -35.1563,  -39.3750,  -43.5938,  -47.8125,  -52.0313,
 -56.2500,  -60.4688,  -64.6875,  -68.9063,  -73.1250,  -77.3438,  -81.5625,  -85.7813,
 -90.0000,  -94.2188,  -98.4375, -102.6563, -106.8750, -111.0938, -115.3125, -119.5313,
-123.7500, -127.9688, -132.1875, -136.4063, -140.6250, -144.8438, -149.0625, -153.2813,
-157.5000, -161.7188, -165.9375, -170.1563, -174.3750, -178.5938,  177.1875,  172.9688,
 168.7500,  164.5313,  160.3125,  156.0938,  151.8750,  147.6563,  143.4375,  139.2188,
 135.0000,  130.7813,  126.5625,  122.3438,  118.1250,  113.9063,  109.6875,  105.4688,
 101.2500,   97.0313,   92.8125,   88.5938,   84.3750,   80.1563,   75.9375,   71.7188,
  67.5000,   63.2813,   59.0625,   54.8438,   50.6250,   46.4063,   42.1875,   37.9688,
  33.7500,   29.5313,   25.3125,   21.0938,   16.8750,   12.6563,    8.4375,    4.2188,
   0.0000,   -4.2188,   -8.4375,  -12.6563,  -16.8750,  -21.0938,  -25.3125,  -29.5313,
 -33.7500,  -37.9688,  -42.1875,  -46.4063,  -50.6250,  -54.8438,  -59.0625,  -63.2813,
 -67.5000,  -71.7188,  -75.9375,  -80.1563,  -84.3750,  -88.5938,  -92.8125,  -97.0313,
-101.2500, -105.4688, -109.6875, -113.9063, -118.1250, -122.3438, -126.5625, -130.7813,
-135.0000, -139.2188, -143.4375, -147.6563, -151.8750, -156.0938, -160.3125, -164.5313,
-168.7500, -172.9688, -177.1875,  178.5938,  174.3750,  170.1563,  165.9375,  161.7188,
 157.5000,  153.2813,  149.0625,  144.8438,  140.6250,  136.4063,  132.1875,  127.9688,
 123.7500,  119.5313,  115.3125,  111.0938,  106.8750,  102.6563,   98.4375,   94.2188
};


const double Ship::stepSin[] = {
   1.0000,    0.9973,    0.9892,    0.9757,    0.9569,    0.9330,    0.9040,    0.8701,
   0.8315,    0.7883,    0.7410,    0.6895,    0.6344,    0.5758,    0.5141,    0.4496,
   0.3827,    0.3137,    0.2430,    0.1710,    0.0980,    0.0245,   -0.0491,   -0.1224,
  -0.1951,   -0.2667,   -0.3369,   -0.4052,   -0.4714,   -0.5350,   -0.5957,   -0.6532,
  -0.7071,   -0.7572,   -0.8032,   -0.8449,   -0.8819,   -0.9142,   -0.9415,   -0.9638,
  -0.9808,   -0.9925,   -0.9988,   -0.9997,   -0.9952,   -0.9853,   -0.9700,   -0.9495,
  -0.9239,   -0.8932,   -0.8577,   -0.8176,   -0.7730,   -0.7242,   -0.6716,   -0.6152,
  -0.5556,   -0.4929,   -0.4276,   -0.3599,   -0.2903,   -0.2191,   -0.1467,   -0.0736,
  -0.0000,    0.0736,    0.1467,    0.2191,    0.2903,    0.3599,    0.4276,    0.4929,
   0.5556,    0.6152,    0.6716,    0.7242,    0.7730,    0.8176,    0.8577,    0.8932,
   0.9239,    0.9495,    0.9700,    0.9853,    0.9952,    0.9997,    0.9988,    0.9925,
   0.9808,    0.9638,    0.9415,    0.9142,    0.8819,    0.8449,    0.8032,    0.7572,
   0.7071,    0.6532,    0.5957,    0.5350,    0.4714,    0.4052,    0.3369,    0.2667,
   0.1951,    0.1224,    0.0491,   -0.0245,   -0.0980,   -0.1710,   -0.2430,   -0.3137,
  -0.3827,   -0.4496,   -0.5141,   -0.5758,   -0.6344,   -0.6895,   -0.7410,   -0.7883,
  -0.8315,   -0.8701,   -0.9040,   -0.9330,   -0.9569,   -0.9757,   -0.9892,   -0.9973,
  -1.0000,   -0.9973,   -0.9892,   -0.9757,   -0.9569,   -0.9330,   -0.9040,   -0.8701,
  -0.8315,   -0.7883,   -0.7410,   -0.6895,   -0.6344,   -0.5758,   -0.5141,   -0.4496,
  -0.3827,   -0.3137,   -0.2430,   -0.1710,   -0.0980,   -0.0245,    0.0491,    0.1224,
   0.1951,    0.2667,    0.3369,    0.4052,    0.4714,    0.5350,    0.5957,    0.6532,
   0.7071,    0.7572,    0.8032,    0.8449,    0.8819,    0.9142,    0.9415,    0.9638,
   0.9808,    0.9925,    0.9988,    0.9997,    0.9952,    0.9853,    0.9700,    0.9495,
   0.9239,    0.8932,    0.8577,    0.8176,    0.7730,    0.7242,    0.6716,    0.6152,
   0.5556,    0.4929,    0.4276,    0.3599,    0.2903,    0.2191,    0.1467,    0.0736,
   0.0000,   -0.0736,   -0.1467,   -0.2191,   -0.2903,   -0.3599,   -0.4276,   -0.4929,
  -0.5556,   -0.6152,   -0.6716,   -0.7242,   -0.7730,   -0.8176,   -0.8577,   -0.8932,
  -0.9239,   -0.9495,   -0.9700,   -0.9853,   -0.9952,   -0.9997,   -0.9988,   -0.9925,
  -0.9808,   -0.9638,   -0.9415,   -0.9142,   -0.8819,   -0.8449,   -0.8032,   -0.7572,
  -0.7071,   -0.6532,   -0.5957,   -0.5350,   -0.4714,   -0.4052,   -0.3369,   -0.2667,
  -0.1951,   -0.1224,   -0.0491,    0.0245,    0.0980,    0.1710,    0.2430,    0.3137,
   0.3827,    0.4496,    0.5141,    0.5758,    0.6344,    0.6895,    0.7410,    0.7883,
   0.8315,    0.8701,    0.9040,    0.9330,    0.9569,    0.9757,    0.9892,    0.9973
};

const double Ship::stepCos[] = {
   0.0000,    0.0736,    0.1467,    0.2191,    0.2903,    0.3599,    0.4276,    0.4929,
   0.5556,    0.6152,    0.6716,    0.7242,    0.7730,    0.8176,    0.8577,    0.8932,
   0.9239,    0.9495,    0.9700,    0.9853,    0.9952,    0.9997,    0.9988,    0.9925,
   0.9808,    0.9638,    0.9415,    0.9142,    0.8819,    0.8449,    0.8032,    0.7572,
   0.7071,    0.6532,    0.5957,    0.5350,    0.4714,    0.4052,    0.3369,    0.2667,
   0.1951,    0.1224,    0.0491,   -0.0245,   -0.0980,   -0.1710,   -0.2430,   -0.3137,
  -0.3827,   -0.4496,   -0.5141,   -0.5758,   -0.6344,   -0.6895,   -0.7410,   -0.7883,
  -0.8315,   -0.8701,   -0.9040,   -0.9330,   -0.9569,   -0.9757,   -0.9892,   -0.9973,
  -1.0000,   -0.9973,   -0.9892,   -0.9757,   -0.9569,   -0.9330,   -0.9040,   -0.8701,
  -0.8315,   -0.7883,   -0.7410,   -0.6895,   -0.6344,   -0.5758,   -0.5141,   -0.4496,
  -0.3827,   -0.3137,   -0.2430,   -0.1710,   -0.0980,   -0.0245,    0.0491,    0.1224,
   0.1951,    0.2667,    0.3369,    0.4052,    0.4714,    0.5350,    0.5957,    0.6532,
   0.7071,    0.7572,    0.8032,    0.8449,    0.8819,    0.9142,    0.9415,    0.9638,
   0.9808,    0.9925,    0.9988,    0.9997,    0.9952,    0.9853,    0.9700,    0.9495,
   0.9239,    0.8932,    0.8577,    0.8176,    0.7730,    0.7242,    0.6716,    0.6152,
   0.5556,    0.4929,    0.4276,    0.3599,    0.2903,    0.2191,    0.1467,    0.0736,
   0.0000,   -0.0736,   -0.1467,   -0.2191,   -0.2903,   -0.3599,   -0.4276,   -0.4929,
  -0.5556,   -0.6152,   -0.6716,   -0.7242,   -0.7730,   -0.8176,   -0.8577,   -0.8932,
  -0.9239,   -0.9495,   -0.9700,   -0.9853,   -0.9952,   -0.9997,   -0.9988,   -0.9925,
  -0.9808,   -0.9638,   -0.9415,   -0.9142,   -0.8819,   -0.8449,   -0.8032,   -0.7572,
  -0.7071,   -0.6532,   -0.5957,   -0.5350,   -0.4714,   -0.4052,   -0.3369,   -0.2667,
  -0.1951,   -0.1224,   -0.0491,    0.0245,    0.0980,    0.1710,    0.2430,    0.3137,
   0.3827,    0.4496,    0.5141,    0.5758,    0.6344,    0.6895,    0.7410,    0.7883,
   0.8315,    0.8701,    0.9040,    0.9330,    0.9569,    0.9757,    0.9892,    0.9973,
   1.0000,    0.9973,    0.9892,    0.9757,    0.9569,    0.9330,    0.9040,    0.8701,
   0.8315,    0.7883,    0.7410,    0.6895,    0.6344,    0.5758,    0.5141,    0.4496,
   0.3827,    0.3137,    0.2430,    0.1710,    0.0980,    0.0245,   -0.0491,   -0.1224,
  -0.1951,   -0.2667,   -0.3369,   -0.4052,   -0.4714,   -0.5350,   -0.5957,   -0.6532,
  -0.7071,   -0.7572,   -0.8032,   -0.8449,   -0.8819,   -0.9142,   -0.9415,   -0.9638,
  -0.9808,   -0.9925,   -0.9988,   -0.9997,   -0.9952,   -0.9853,   -0.9700,   -0.9495,
  -0.9239,   -0.8932,   -0.8577,   -0.8176,   -0.7730,   -0.7242,   -0.6716,   -0.6152,
  -0.5556,   -0.4929,   -0.4276,   -0.3599,   -0.2903,   -0.2191,   -0.1467,   -0.0736
};


void Player::Run(void)
{
    FramePacket frame;
    KeysPacket keys;
    char prevframe = 0;
    int t = 0;

    bool shotlast = false;

    int cf_Cycle = 0;

    int count = 0;

    int thisLatency = 0;

    for (;;)
    {
        ++t;         // Zeit
        ++keys.ping; // jedes gesendete P�ckchen erh�lt eine individuelle Nummer zur Latenzmessung
        SendPacket(keys);

/* nachtr�gliche, optionale Protokollerweiterung: Einmalig den Spielernamen schicken
   Bringt die urspr�ngliche MAME-Version zum Abbruch; ist zum Spielen �bers Internet gegen
   den Server asteroids.heise.de gedacht.
*/
/*        if (t == 10)
            SendPlayerName();
*/
        ReceivePacket(frame);

        thisLatency = keys.ping - frame.ping;
        int thisDrop    = frame.frameno - (++prevframe);

        if (thisDrop || thisLatency)
        {
            fprintf(stderr,"Latenz %d. %d Frames verloren.\n", thisLatency, thisDrop);
            prevframe = frame.frameno;
        }


//        InterpretScreen(frame, game);
        try {
            new FrameStatus(frame,keys,thisLatency);
        }
        catch (FrameStatus::FrameException *e) {
            printf("Exc: %s\n",e->msg.c_str());
            delete e;
        };

        keys.clear();   // alle Tasten loslassen
        double min_dist = 1e6;

        Ship* ship = FrameStatus::listLast->ship;
        if (ship)
        {

            FrameStatus::Aim aim = FrameStatus::listLast->aimForTargets();

            std::vector<Asteroid*>* asteroids = &(FrameStatus::listLast->asteroids);
            int nasteroids = asteroids->size();
            Ufo* ufo = FrameStatus::listLast->ufo;

            // Schiff in Richtung auf das n�chstgelegene Objekt drehen
            // mathematisch wird hier das Kreuzprodukt aus den Vektoren 
            // ship_dx/y/0 und min_dx/y/0 berechnet


            if (aim.target) {
                if (ship->dx * aim.dy - ship->dy * aim.dx > 0)
                    keys.left(true);
                else
                    keys.right(true);
            };


            if (ufo || nasteroids)
            if (!aim.target || FrameStatus::listLast->freeRadius>100)
            if (ship->speed < FrameStatus::listLast->freeRadius/2)
            if (ship->speed < 300)
                keys.thrust(true);


            MovingObject* target;


            // shot not only target, but anything that it is the line.
            // no more than 2 shots per target.
            if (shotlast) shotlast = false;
            else {
                bool shootnow = false;
                for (int i=0; i<nasteroids; ++i)
                {

                    /// save shots if target is 'final'
                    //if ((*asteroids)[i]->sf == 14) 
                    {
                    /// If there are many asteroids, do not
                    /// shoot at a target that was already shot for.
                    if (nasteroids>2) {
                        int prevShots = 0;
                        for (int j=0;j<4;j++)
                            if ((*asteroids)[i]->underfire[j]<MAX_SHOT_AGE) prevShots++;
                        if (prevShots>=MAX_SHOT_CNT) continue;
                    }
                    }

                    target = (*asteroids)[i];
                    Collision thisCollision(*(ship->fictiveShot),*target);
                    if (  (thisCollision.time < 1.)
                        &&(  (thisCollision.offs < target->diameter()-4)
                           ||(  (thisCollision.offs < target->diameter())
                              &&(nasteroids<=1))
                          ))
                    {
                        shootnow = true;
                        target->setShotRound(thisCollision.time*65);

                        int dx = target->getx() - ship->getx();
                        int dy = target->gety() - ship->gety();
                        FrameStatus::normalize(dx,dy);
                        int dd = dx*dx+dy*dy;

                    }

                    if (shootnow) break;
                }

                if (ufo && !shootnow) {
                    target = ufo;
                    Collision thisCollision(*(ship->fictiveShot),*target);
                    if (  (thisCollision.time < MAX_SHOT_DIST/8./60.)
                        &&(thisCollision.offs < 0.5*target->diameter()))
                        shootnow = true;
                }

                if (shootnow) {
                    keys.fire(true);
                    shotlast = true;
                }
            }


            ///  Check if collisions might occur in the near future.
            FrameStatus::listLast->evasionMeasures(keys);


            /// If no targets, ufos etc. present, move to center position,
            /// in order to avoid collisions with new next-level asteroids.
            if (!nasteroids && !ufo) {

                double dx = 524-ship->getx();
                double dy = 524-ship->gety();

                /// First, accelerate towards destination.
                /// (This will be overruled later by a break maneuver, if necessary).
                double  da = Ship::stepAngle[ship->step]/180.*M_PI - atan2(dx,dy);
                FrameStatus::normalize(da);
                double turns = da/SHIP_ROT;
                if (turns>0.5) keys.left(true); else
                if (turns<0.5) keys.right(true);
                keys.thrust(true);


                double su = ship->getu();
                double sv = ship->getv();
                double uu = su*su+sv*sv;

                /// Consider breaking only if ship has some velocity.
                if (fabs(uu)>10) {

                    /// Before breaking, we have to turn around. The time
                    /// for this needs to beconsidered.
                    double  da = Ship::stepAngle[ship->step]/180.*M_PI - atan2(-ship->getu(),-ship->getv());
                    double turns = da/SHIP_ROT;
                    /// The other time component to consider is
                    /// the time-to-standstill. Both together yield
                    /// the total time for the break maneuver.
                    double breaktime = fabs(turns)/60.+sqrt(uu)/SHIP_ACCEL;
                    /// The time required to break is compared to the time
                    /// required to reach the level of the destination.
                    double reachtime = (dx*su+dy*sv)/uu;

                    //printf("bt, rt: %10.5f %10.5f\n",breaktime, reachtime);

                    if (breaktime > reachtime) {
                        if (turns>0.5) keys.left(true); else
                        if (turns<0.5) keys.right(true);
                        if (fabs(turns)<=1) keys.thrust(true); else
                        keys.thrust(false);
                    }
                }
            }


/*
            Ship::Move move;
            FrameStatus* relFrame = FrameStatus::listLast;
            if (count==0) {
                int tarx = 200;
                int tary = 300;
                int dx = tarx-ship->getx();
                int dy = tary-ship->gety();
                FrameStatus::normalize(dx,dy);
                if ((abs(dx)<15) && (abs(dy)<15)) count++;
                move = relFrame->ship->moveTo(dx,dy);
            }
            else if (count==1) {
                int tarx = 800;
                int tary = 300;
                int dx = tarx-ship->getx();
                int dy = tary-ship->gety();
                FrameStatus::normalize(dx,dy);
                if ((abs(dx)<15) && (abs(dy)<15)) count++;
                move = relFrame->ship->moveTo(dx,dy);
            }
            else {
                int tarx = 500;
                int tary = 500;
                int dx = tarx-ship->getx();
                int dy = tary-ship->gety();
                FrameStatus::normalize(dx,dy);
                if ((abs(dx)<15) && (abs(dy)<15)) count=0;
                move = relFrame->ship->moveTo(dx,dy);
            }

            move.applyToKeys(keys);
*/



/*            keys.clear();
            count++;
            if (count<5) {}
            else {
                if (FrameStatus::listLast->even) keys.thrust(true);
                if (count==41) keys.hyperspace(true);
            }
*/


/*            const int wait = 25;
            const int startCount = 0;
            count++;
            keys.clear();
            if (count<5) {}
            else if (count<startCount) keys.left(true);
            else {
                int c = count-startCount;
                if (c%wait==0) keys.left(true);
                if (c%wait==5) keys.fire(true);
            }
*/
        //keys.fire(false);

/*        printf("t:%d c:%d s:%d x:%d y:%d u:%10.5f v:%10.5f %s\n",
            t,count,ship->step,ship->getx(),ship->gety(),
            ship->getu(),ship->getv(),
            keys.toString().c_str());
*/
        }
    }
}


void Player::ReceivePacket(FramePacket &packet)
{
    sockaddr_in sender;
    int sender_size = sizeof sender;
    fd_set readfds, writefds, exceptfds;

    do
    {
        FD_ZERO(&readfds);
        FD_ZERO(&writefds);
        FD_ZERO(&exceptfds);
        FD_SET(sd, &readfds);
        FD_SET(sd, &exceptfds);
        select(sd+1, &readfds, &writefds, &exceptfds, NULL);
        int bytes_received = recv(sd, (char *)&packet, sizeof packet, 0);
        if (bytes_received != sizeof packet)
        {
            int err = WSAGetLastError();
            fprintf(stderr, "Fehler %d bei recvfrom().\n", err);
            exit(1);
        }
        FD_ZERO(&readfds);
        FD_ZERO(&writefds);
        FD_ZERO(&exceptfds);
        FD_SET(sd, &readfds);
        timeval zero;
        zero.tv_sec = zero.tv_usec = 0;
        select(sd+1, &readfds, &writefds, &exceptfds, &zero);
    } while(FD_ISSET(sd, &readfds));
}

void Player::SendPacket(KeysPacket &packet)
{
    sockaddr_in server;
    memset(&server, 0, sizeof server);
    server.sin_family = AF_INET;
    server.sin_port = htons(1979);
    server.sin_addr.s_addr = server_ip;
    if (sizeof packet != sendto(sd, (char *)&packet, sizeof packet, 0, (sockaddr*)&server, sizeof server))
    {
#if defined(WINDOWS)
        int err = WSAGetLastError();
        if (err != WSAEWOULDBLOCK)
        {
            fprintf(stderr, "Fehler %d bei sendto().\n", err);
            exit(1);
        }
#else
        if (errno != EAGAIN)
        {
            perror("Fehler bei sendto()");
            exit(1);
        }
#endif
    }
}


void Player::SendPlayerName()
{
    static char player_name[38] = "ctnamecfuchs\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0";

    sockaddr_in server;
    memset(&server, 0, sizeof server);
    server.sin_family = AF_INET;
    server.sin_port = htons(1979);
    server.sin_addr.s_addr = server_ip;
    if (38 != sendto(sd, player_name, 38, 0, (sockaddr*)&server, sizeof server))
    {
#if defined(WINDOWS)
        int err = WSAGetLastError();
        if (err != WSAEWOULDBLOCK)
        {
            fprintf(stderr, "Fehler %d bei sendto().\n", err);
            exit(1);
        }
#else
        if (errno != EAGAIN)
        {
            perror("Fehler bei sendto()");
            exit(1);
        }
#endif
    }
}
