#pragma once

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Windows::Forms;
using namespace System::Data;
using namespace System::Drawing;

#include "game.h"

#define SCREEN_Y_OFFSET	127

namespace asteroid {
	/// <summary>
	/// Zusammenfassung fr GUI
	///
	/// Warnung: Wenn Sie den Namen dieser Klasse ndern, mssen Sie auch
	///          die Ressourcendateiname-Eigenschaft fr das Tool zur Kompilierung verwalteter Ressourcen ndern,
	///          das allen RESX-Dateien zugewiesen ist, von denen diese Klasse abhngt.
	///          Anderenfalls knnen die Designer nicht korrekt mit den lokalisierten Ressourcen
	///          arbeiten, die diesem Formular zugewiesen sind.
	/// </summary>
	public ref class GUI : public System::Windows::Forms::Form
	{
	public:
		GUI(void)
		{
			InitializeComponent();
			//
			game = new GameStatus();
			game->init();
			//
		}

		void UpdateGameState(GameStatus &curGame) 
		{ 
			game->copy(curGame); 
			this->Invalidate(); 
		}

	protected:
		/// <summary>
		/// Verwendete Ressourcen bereinigen.
		/// </summary>
		~GUI()
		{
			if (components)
			{
				delete components;
			}

			delete game;
		}

	private:
		/// <summary>
		/// Erforderliche Designervariable.
		/// </summary>
		System::ComponentModel::Container ^components;
		GameStatus* game;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Erforderliche Methode fr die Designeruntersttzung.
		/// Der Inhalt der Methode darf nicht mit dem Code-Editor gendert werden.
		/// </summary>
		void InitializeComponent(void)
		{
			this->SuspendLayout();
			// 
			// GUI
			// 
			this->AutoScaleDimensions = System::Drawing::SizeF(6, 13);
			this->AutoScaleMode = System::Windows::Forms::AutoScaleMode::Font;
			this->ClientSize = System::Drawing::Size(527, 389);
			this->Name = L"GUI";
			this->Text = L"GUI";
			this->Paint += gcnew System::Windows::Forms::PaintEventHandler(this, &GUI::GUI_Paint);
			this->ResumeLayout(false);

		}
#pragma endregion
	private: System::Void GUI_Paint(System::Object^  sender, System::Windows::Forms::PaintEventArgs^  e) {
				 int i;
				 if(game->ship.present)
				 {
					 int x = game->ship.x;
					 int y = game->ship.y - SCREEN_Y_OFFSET;
					 int r = game->ship.getRadius();
					 int dx = game->ship.dx;
					 int dy = game->ship.dy;
					 float d = sqrt((float)(dx*dx + dy*dy));

					 e->Graphics->DrawEllipse(System::Drawing::Pens::Purple, x-r+0.5f,y-r+0.5f,r*2.f,r*2.f);
					 e->Graphics->DrawLine(System::Drawing::Pens::Purple, (float)x,(float)y, x+dx*r/d, y+dy*r/d);
					 if(game->ship.nTracked>0)
					 {
						 float vx = game->ship.vx;
						 float vy = game->ship.vy;
						 float v = game->ship.getSpeed();
						 e->Graphics->DrawLine(System::Drawing::Pens::Green, (float)x,(float)y, x+vx*r/v, y+vy*r/v);
					 }
					 else
					 {
						 e->Graphics->DrawEllipse(System::Drawing::Pens::Red, x-2+0.5f,y-2+0.5f,2*2.f,2*2.f);
					 }
				 }
				 if(game->saucer.present)
				 {
					 int x = game->saucer.x;
					 int y = game->saucer.y - SCREEN_Y_OFFSET;
					 int r = game->saucer.getRadius();
					 e->Graphics->DrawEllipse(System::Drawing::Pens::DarkBlue, x-r+0.5f,y-r+0.5f,r*2.f,r*2.f);
					 if(game->saucer.nTracked>0)
					 {
						 float vx = game->saucer.vx;
						 float vy = game->saucer.vy;
						 float v = game->saucer.getSpeed();
						 e->Graphics->DrawLine(System::Drawing::Pens::Green, (float)x,(float)y, x+vx*r/v, y+vy*r/v);
					 }
					 else
					 {
						 e->Graphics->DrawEllipse(System::Drawing::Pens::Red, x-2+0.5f,y-2+0.5f,2*2.f,2*2.f);
					 }
				 }
				 for(i=0; i<game->nasteroids; i++)
				 {
					 int x = game->asteroids[i].x;
					 int y = game->asteroids[i].y - SCREEN_Y_OFFSET;
					 int r = game->asteroids[i].getRadius();
					 e->Graphics->DrawEllipse(System::Drawing::Pens::Black, x-r+0.5f,y-r+0.5f,r*2.f,r*2.f);
					 if(game->asteroids[i].nTracked>0)
					 {
						 float vx = game->asteroids[i].vx;
						 float vy = game->asteroids[i].vy;
						 float v = game->asteroids[i].getSpeed();
						 e->Graphics->DrawLine(System::Drawing::Pens::Green, (float)x,(float)y, x+vx*r/v, y+vy*r/v);
					 }
					 else
					 {
						 e->Graphics->DrawEllipse(System::Drawing::Pens::Red, x-2+0.5f,y-2+0.5f,2*2.f,2*2.f);
					 }
				 }
				 for(i=0; i<game->nshots; i++)
				 {
					 int x = game->shots[i].x;
					 int y = game->shots[i].y - SCREEN_Y_OFFSET;
					 int r = game->shots[i].getRadius();
					 e->Graphics->DrawEllipse(System::Drawing::Pens::Blue, x-r+0.5f,y-r+0.5f,r*2.f,r*2.f);
					 if(game->shots[i].nTracked>0)
					 {
						 float vx = game->shots[i].vx;
						 float vy = game->shots[i].vy;
						 float v = game->shots[i].getSpeed();
						 e->Graphics->DrawLine(System::Drawing::Pens::Green, (float)x,(float)y, x+vx*r/v, y+vy*r/v);
					 }
					 else
					 {
						 e->Graphics->DrawEllipse(System::Drawing::Pens::Red, x-2+0.5f,y-2+0.5f,2*2.f,2*2.f);
					 }
				 }

				 if(game->focusedObj)
				 {
					 int x = game->focusedObj->x;
					 int y = game->focusedObj->y - SCREEN_Y_OFFSET;
					 int r = game->focusedObj->getRadius()+3;
					 e->Graphics->DrawEllipse(System::Drawing::Pens::Red, x-r+0.5f,y-r+0.5f,r*2.f,r*2.f);
				 }
			 }
	};
}
