// game.cpp

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>

#include "game.h"
#include <math.h>

void Asteroid::set(int x, int y, int type, int sf)
{
	this->nTracked = 0;
	this->tTracked = 0;
	this->x = x;
	this->y = y;
	this->type = type;
	this->sf = sf;
	this->vx = SPEED_UNKNOWN;
	this->vy = SPEED_UNKNOWN;
}

void GameObject::setSpeed(speed_t vx, speed_t vy)
{
	this->vx = vx;
	this->vy = vy;
}

void Saucer::set(int x, int y, int size)
{
	this->nTracked = 0;
	this->tTracked = 0;
	this->x = x;
	this->y = y;
	this->size = size;
	this->vx = SPEED_UNKNOWN;
	this->vy = SPEED_UNKNOWN;
}

void Ship::set(int x, int y, int dx, int dy)
{
	this->nTracked = 0;
	this->tTracked = 0;
	this->x = x;
	this->y = y;
	this->dx = dx;
	this->dy = dy;
	this->vx = SPEED_UNKNOWN;
	this->vy = SPEED_UNKNOWN;
}

void Shot::set(int x, int y)
{
	this->nTracked = 0;
	this->tTracked = 0;
	this->x = x;
	this->y = y;
	this->vx = SPEED_UNKNOWN;
	this->vy = SPEED_UNKNOWN;
}

void GameStatus::init(void)
{
	clear();

	ship.hist.clear();
	saucer.hist.clear();

#ifdef STATE
	level = 0;
#endif
}

void GameStatus::clear(void)
{
	dt = 0;
	maxId = 0;
	fired = false;
	frameno = 0;
	latency = 0;
	framesLost = 0;
	dx = dy = 0;
	ship.present = false;
	saucer.present = false;
	nasteroids = 0;
	nshots = 0;
	focusedObj = NULL;
#ifdef STATE
	state = unknown;
	score = 0;
	lifes = 0;
#endif
}

void GameStatus::copy(const GameStatus &game)
{
	int i;

	maxId = game.maxId;
	fired = game.fired;
	frameno = game.frameno;
	latency = game.latency;
	framesLost = game.framesLost;
	dx = game.dx;
	dy = game.dy;
	ship = game.ship;
	saucer = game.saucer;
	nasteroids = game.nasteroids;
#ifdef STATE
	state = game.state;
	score = game.score;
	lifes = game.lifes;
	level = game.level;
#endif
	for(i=0; i<nasteroids; i++)
		asteroids[i] = game.asteroids[i];
	nshots = game.nshots;
	for(i=0; i<nshots; i++)
		shots[i] = game.shots[i];
	focusedObj = game.focusedObj;
}
