package hek.de.hinni.hek.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;

import javax.swing.text.html.HTMLDocument.HTMLReader.IsindexAction;

import org.apache.log4j.Logger;

import com.sun.org.apache.bcel.internal.generic.INSTANCEOF;

//computes and describes a collision between 2 MyObjects 
public class Collision implements Comparable<Collision> {
	
//	public static final Logger logger = Logger.getLogger(Collision.class);
	
	public static final Color COLOR = Color.red;
	//known objects
	public static final float INNERHITPROBABILITY = 0.99f;
	public static final float OUTERHITPROBABILITY = 0f;
	public static final float BETWEENHITPROBABILITY = 0.1f;
	//prob. objects
	public static final float PROB_OBJ_PROBABILITY_DECREASE = 1f/20; // in 1/frame
	// appxox p= p0 - m * 1/t  (nimmt mit 1/t * faktor ab) 
	
	//		G    = Gesamte Flche
	//		T	 = Gesamtes Zeitintervall
	//		B(t) = innere Flche bekanntes Objekt
	//		B'(t) = uere Flche bekanntes Objekt
	//		U(t) = innere Flche ubekanntes Objekt
	//		U'(t) = uere Flche ubekanntes Objekt
	//	    pB(x,y,t) = INNERHITPROBABILITY falls xy \in B(t)
	//	    pB(x,y,t) = BETWEENHITPROBABILITY falls xy \in B'(t) und nicht in B(t)
	//	    pB(x,y,t) = OUTERHITPROBABILITY falls xy nicht \in B'(t)
	//
	//		p(x,y,t)  = pM(x,y,t)*pN(x,y,t) 
	//		p(treff)  = int_GT p(x,y,t)
	//
	//		x(t) = mt + n  (Objektbewegung, Radius r)
	//		B(t) = {(x,y) \in G :  ||(x,y)-x(t)||<=r }
    //
	//		A(r) = pi r
	//		t = zeit vom letzten sicheren Aufenthaltsort
	//      r_max(t) = r + t*MAXASTEROIDSPEED
	//
	//		pU(x,y,t) = 0					falls xy nicht in U(t)
	//      pU(x,y,t) = |U(0)|/|U(t)| 		falls xy in U(t)
	//				  = A(r) / A(r_max(t))  falls xy in U(t)
	//                = [r / (r+t*MAXASTEROIDSPEED)] t>=0
	
	// Fr zwei bekannte objekte:   
	// p(treff) = INNERHITPROBABILITY falls sich die inneren objektkreise zu irgend einem zeitpunkt t schneiden
	// p(treff) = BETWEENHITPROBABILITY falls sich die ueren objektkreise zu irgend einem zeitpunkt t schneiden
	// p(treff) = OUTERHITPROBABILITY falls sich die ueren objektkreise zu keinem zeitpunkt t schneiden
	//
	//
	// Fr ein bekanntes (rb) und ein unbekanntes(ru) objekt: (inner outer hier ignoriert, da marginal)
	//
	// p(treff) = p(treff_enter)+p(t_reff_leave)+p(treff_inner)
	//
	// p(treff_enter) und p(treff_leave) sind bei p(treff_inner)* bereits enthalten, da die mittelpunktszeiten des eintretens und verlassens verwendet werden, anstelle der exacten innenzeiten, fehler vernachlssigbar, da bekanntes Bullet sehr klein
	//
	// p(treff_inner)*  = int_T 
	//						int_G { pu(x,y,t)*pb(x,y,t) }
	// 					= int_tin^tout 
	//					    { pu(x,y,t) |B(t)|*INNERHITPROBABILITY }
	// 					= int_tin^tout 
	//					    {  pu(x,y,t) }
	//							|B|*INNERHITPROBABILITY
	//					= int_tin^tout
	//						{ [ru / (ru+t*MAXASTEROIDSPEED)]}
	//							|B|*INNERHITPROBABILITY
	//					= ru/m * [1/(ru+tin*MAXASTEROIDSPEED) - 1/(ru+tout*MAXASTEROIDSPEED)]
	//						pi rb * INNERHITPROBABILITY
	
	
	
	
	
	private MyObject object1; //contains reference time
	private MyObject object2;
	
	//absolute 
	private int hitTimeInner = Integer.MIN_VALUE;  
	private int hitTimeOuter = Integer.MIN_VALUE; 
	//time from hitTimeInner start to hitTimeInner end
	private int collisionDurationInner;

	private float hitProbability = 0; //NAN iff error
	
	
	private String drawString;
	private Color drawColor;
	
	
	public void setDrawString(String drawString) {
		this.drawString = drawString;
	}
	public void setDrawColor(Color drawColor) {
		this.drawColor = drawColor;
	}
	public Color getDrawColor() {
		return drawColor;
	}
	public String getDrawString()
	{
		return drawString;
	}
	
	

	/**
	 * Checks, if the objects will hit each other, 
	 * AFTER time t
	 * @param time	time, after which the must hit.
	 * @return	true, if they hit after time t
	 */
	public boolean willOccurAfter(int time){
		return  hitTimeOuter>=time && isConsistent();
	}
	
	public boolean willOccurBefore(int time){
		return  hitTimeOuter<=time && isConsistent();
	}
	
	public boolean isConsistent()
	{
		boolean b = (!Float.isNaN(hitProbability))  
		&& hitProbability>0
		&& object1!=null
		&& object2!=null
		&& object1.isAliveAndCertainAt(hitTimeOuter) 
		&& object2.isAliveAndCertainAt(hitTimeOuter);
		return b;
	}
	


	
	
	
	//arbeitsvariablen
	private static float t,tmp,p,q;
	private static int t1,t2,dmx,dmy,dnx,dny,maxDist;
	private static Position p1,p2;
	

	private void computeCollisionParams(int referenceTime)
	{	
		MyObject a=object1;
		MyObject b=object2;
		
		Vector ma = a.getBewegung();
		Vector mb = b.getBewegung();
		Position na = a.estimatePosition(referenceTime);
		Position nb = b.estimatePosition(referenceTime);
	
		//error
		if (na==null || nb==null || ma==null || mb==null
				|| na.getZeitpunkt()!=referenceTime	//fehler in der estimate position berechnung
				|| nb.getZeitpunkt()!=referenceTime)  //fehler in der estimate position berechnung
		{
//			logger.debug("No Collision, Reason: pos/mov at time="+referenceTime+" uncomputable (na="+na+" ma="+ma+" nb="+nb+" mb="+mb+")   a:"+a+"   b:"+b);
			hitProbability=Float.NaN;
			return;
		}
		
		dmx = ma.getX()-mb.getX(); //bew diff
		dmy = ma.getY()-mb.getY(); //bew diff
		dnx = na.getX()-nb.getX(); //pos diff
		dny = na.getY()-nb.getY(); //pos diff
		
		//berechne aussen
		maxDist = a.getRadius_outer() + b.getRadius_outer();
		hitTimeOuter = MyObject.hitTest(dmx, dmy, dnx, dny,0, maxDist);

		//keine loesung fr aussenradius -> dann auch keine fuer innen
		if (hitTimeOuter == Integer.MIN_VALUE)
		{
			setHitProbability();
			return;
		}

		//to absolute time
		hitTimeOuter += referenceTime;
		
		if (maxDist<=a.getRadius_inner() + b.getRadius_inner())
		{
//			logger.warn("ahh");
		}
		
		//berechne innen
		maxDist = a.getRadius_inner() + b.getRadius_inner();
		hitTimeInner = MyObject.hitTest(dmx, dmy, dnx, dny,0, maxDist);
		
		//keine loesung fr innenradius
		if (hitTimeInner == Integer.MIN_VALUE)
		{
			setHitProbability();
			return;
		}
		
		//to absolute time
		hitTimeInner += referenceTime;
		
		//is ok, since hitTest chooses the closest point of time to 0! If the sign flips, beween inner and outer, they are not right anymore
		if (hitTimeOuter>hitTimeInner && hitTimeOuter*hitTimeInner<0)
		{
//			logger.debug("Hittimes changed!: outer="+hitTimeOuter+" innerOld="+hitTimeInner+" innerNew="+(hitTimeInner+MyShip.getInterSectionTime()));
			hitTimeInner += MyShip.getInterSectionTime();
		}
			
		
		setHitProbability();
	}
	
	private void computeCollisionParamsProbabilistic(int referenceTime)
	{	
//		logger.warn("aaah");
		if(true)return;
		MyAsteroid a= getProbabilisticObject();
		MyObject b= getOtherObject(a);
		
		Vector ma = a.getBewegung();
		Vector mb = b.getBewegung();
		
		Position na = a.estimatePosition(referenceTime);
		Position nb = b.estimatePosition(referenceTime);
	
		//error
		if (na==null || nb==null || ma==null || mb==null
				|| na.getZeitpunkt()!=referenceTime	//fehler in der estimate position berechnung
				|| nb.getZeitpunkt()!=referenceTime)  //fehler in der estimate position berechnung
		{
//			logger.debug("No Collision, Reason: pos/mov at time="+referenceTime+" uncomputable (na="+na+" ma="+ma+" nb="+nb+" mb="+mb+")   a:"+a+"   b:"+b);
			hitProbability=Float.NaN;
			return;
		}
		
		dmx = ma.getX()-mb.getX(); //bew diff
		dmy = ma.getY()-mb.getY(); //bew diff
		dnx = na.getX()-nb.getX(); //pos diff
		dny = na.getY()-nb.getY(); //pos diff
		
		//TODO: wann radius wie gro -> offset (zurck) versetzen -> PROBLEM geht eigentlich nicht, da neg=pos radius
		//keine aussenberechnung
		//TODO:berechne innen (mit veraendertem hittest - verg. radius) 
//		hitTimeInner = MyObject.hitTest(dmx, dmy, dnx, dny, MyAsteroid.MAXASTEROIDSPEED, a.getRadius_inner() + b.getRadius_inner());

		//alter hittest
		hitTimeInner = MyObject.hitTest(dmx, dmy, dnx, dny, 0, a.getRadius_inner() + b.getRadius_inner());
		collisionDurationInner = MyObject.getInterSectionTime();
		//if no error make absolute time
		hitTimeInner = hitTimeInner == Integer.MIN_VALUE 
						? hitTimeInner 
						: hitTimeInner+referenceTime;
		//no outer computation
		hitTimeOuter = hitTimeInner;
		
		setHitProbability();
//		logger.debug("collprob:"+hitProbability);
		
	}
	
	/**
	 * @return There is exactly one prob. object return it. 
	 * If none return null, 
	 * If two set error and return null.
	 */
	private MyAsteroid getProbabilisticObject()
	{
		boolean pa=false;
		if (object1 instanceof MyAsteroid) {
			pa = ((MyAsteroid) object1).isProbabilistic();
		}
		boolean pb=false;
		if (object2 instanceof MyAsteroid) {
			pb = ((MyAsteroid) object2).isProbabilistic();
		}
		
		if (pa && !pb) return (MyAsteroid) object1;
		if (!pa && pb) return (MyAsteroid) object2;
		if (pa && pb) //error  
		{
			hitProbability=Float.NaN;
			return null;
		}
		return null;
		
	}

	
	
	public Collision(MyObject obj1, MyObject obj2){

		//error
		if (obj1==null || obj2==null)
		{
			hitProbability = Float.NaN;
			return;
		}

		
		this.object1 = obj1;
		this.object2 = obj2;
		
		int t_reference = Math.max(obj1.getCurrentTime(), obj2.getCurrentTime());

		
		computeCollisionParams(t_reference);
		
//		if (getProbabilisticObject()!=null) //TODO:
//			computeCollisionParamsProbabilistic(t_reference);
//		else
//			computeCollisionParams(t_reference);
		
	
		setDrawColor(COLOR);
		
	}


	public MyObject getObject1() {
		return object1;
	}


	public MyObject getObject2() {
		return object2;
	}


	public float getHitProbability() {
		return hitProbability;
	}
	
	public Position getHitPositionInner(int obj)
	{
		if (hitTimeInner==Integer.MIN_VALUE) return null;
		if (obj==1) return object1.estimatePosition(hitTimeInner);
		if (obj==2) return object2.estimatePosition(hitTimeInner);
		return null;
	}

	
	public Position getHitPositionOuter(int obj)
	{
		if (hitTimeOuter==Integer.MIN_VALUE) return null;
		if (obj==1) return object1.estimatePosition(hitTimeOuter);
		if (obj==2) return object2.estimatePosition(hitTimeOuter);
		return null;
	}
	
	public String toString()
	{
		Position p1 = object1!=null?object1.estimatePosition(hitTimeInner):null;
		Position p2 = object2!=null?object2.estimatePosition(hitTimeInner):null;
		if (p1==null || p2==null)
			return "Collision(ti="+(hitTimeInner)+
			", to="+(hitTimeOuter)+
			",d="+(Position.distance(p1,p2))+
			",p="+hitProbability+
			") at inner 1:"+p1+" 2:"+p2+
			"    "+object1+"   "+object2;
		return "Collision(dti="+(hitTimeInner-object1.getCurrentTime())+
				", dto="+(hitTimeOuter-object1.getCurrentTime())+
				",d="+(Position.distance(p1,p2))+
				",p="+hitProbability+
				")    o1pos:"+p1.toStringMyObject()+"    o2pos:"+p2.toStringMyObject()+
				"    "+object1+"   "+object2;
	}

	
	
	
	public void draw(Graphics2D g)
	{
		int drawTime = World.getTick();
		
		if (!this.willOccurAfter(drawTime))
		{
			g.setColor(Color.yellow);
			g.drawLine(
					object1.getPosition().getXforDrawing(),
					object1.getPosition().getYforDrawing(),
					object2.getPosition().getXforDrawing(),
					object2.getPosition().getYforDrawing()
					);
			return;
			
		}
		
		g.setColor(COLOR);
		
		Position hit1;
		Position curr;
		//object1 (target)
		hit1 = getHitPositionInner(1);
		hit1 = hit1==null ? getHitPositionOuter(1):hit1;
		curr = object1.estimatePosition(drawTime);
		if (curr!=null && hit1!=null){
			
			if (object1.isAliveAndCertainAt(drawTime))
			{
			g.drawLine(curr.getXforDrawing(),
					   curr.getYforDrawing(),
					   hit1.getXforDrawing(),
					   hit1.getYforDrawing());
			}
			g.drawOval(hit1.getXforDrawing()-object1.getRadiusForDrawing(),
					   hit1.getYforDrawing()-object1.getRadiusForDrawing(),
					   object1.getRadiusForDrawing()*2,
					   object1.getRadiusForDrawing()*2);
		}
		
		//draw hit probability
		g.drawString("p"+hitProbability,
				   hit1.getXforDrawing()+object1.getRadiusForDrawing(),
				   hit1.getYforDrawing()-object1.getRadiusForDrawing());

		//draw hit time
		g.drawString("t"+(hitTimeInner-drawTime)+"/"+(hitTimeOuter-drawTime),
				   hit1.getXforDrawing()+object1.getRadiusForDrawing(),
				   hit1.getYforDrawing()+object1.getRadiusForDrawing());

		

		
		//object2 (bullet)
		hit1 = getHitPositionInner(2);
		hit1 = hit1==null ? getHitPositionOuter(2):hit1;

		curr = object2.estimatePosition(drawTime); 
		if (curr!=null && hit1!=null){
			
			
			if (object2.isAliveAndCertainAt(drawTime))
			{
			g.drawLine(curr.getXforDrawing(),
					   curr.getYforDrawing(),
					   hit1.getXforDrawing(),
					   hit1.getYforDrawing());
			}
			g.drawOval(hit1.getXforDrawing()-object2.getRadiusForDrawing(),
					   hit1.getYforDrawing()-object2.getRadiusForDrawing(),
					   object2.getRadiusForDrawing()*2,
					   object2.getRadiusForDrawing()*2);
		}
		

		
		
		
	
	}

	public int getHitTimeInner() {
		return hitTimeInner;
	}


	public int getHitTimeOuter() {
		return hitTimeOuter;
	}
	
	
	private void setHitProbability()
	{
		//if error
		if (Float.isNaN(hitProbability)) return;

		//nicht getroffen
		if (hitTimeOuter==Integer.MIN_VALUE) 
		{
			hitProbability = OUTERHITPROBABILITY;
			return;
		}

		float pHitO1,phito2;
		
		//zwischen
		if (hitTimeInner==Integer.MIN_VALUE &&
				hitTimeOuter !=Integer.MIN_VALUE) 
		{
			pHitO1 = object1.getPositionProbability(hitTimeOuter);
			phito2 = object2.getPositionProbability(hitTimeOuter);

			hitProbability = BETWEENHITPROBABILITY*pHitO1*phito2;
			return;
		}
		
		//voll getroffen
		if (hitTimeInner!=Integer.MIN_VALUE) 
		{
			pHitO1 = object1.getPositionProbability(hitTimeInner);
			phito2 = object2.getPositionProbability(hitTimeInner);

			//rechnung_korrekt * ortssicherheit1*ortssicherheit2
			//p(treffen)*p(o1 dort)*p(o2 dort)
			hitProbability = INNERHITPROBABILITY*pHitO1*phito2;
			return;
		}
		
		//sonst fehler
//		logger.warn("error");
		hitProbability = Float.NaN;
		
	}
	
	private MyObject getOtherObject(MyObject a)
	{
		if (Float.isNaN(hitProbability)) return null;
		if (a==object1) return object2;
		if (a==object2) return object1;
		return null;
	}
	
	/**
	 * Compares with respect to firetime
	 * @param f
	 * @return	-1 if firetime<f.firetime 
	 * 			0 if firetime==f.firetime
	 * 			1 if firetime>f.firetime || f==null
	 */
	public int compareTo(Collision f)
	{
		if (f==null) return 1;
		if (getHitTimeOuter()==f.getHitTimeOuter()) return 0;
		return getHitTimeOuter()<f.getHitTimeOuter()?-1:1;
	}
	
	
	
}
