package hek.de.hinni.hek.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;

//import org.apache.log4j.Logger;


public class GameState implements Comparable<GameState> {

//	public static final Logger logger = Logger.getLogger(GameState.class);
	
	public final static float MINGAMESTATEUNCERTAINTY = 0.5f;
	public final static float ALLOWEDSHIPHITPROBABILITY = 0f;
	public final static float MINTARGETALIVEPROB = 0.2f;
	public final static Color COLOR = Color.pink;
	public final static int maxTreeWidth = 15;
	//solution-tree
	private static List<TreeSet<GameState>> tree;
	private static int lastCompleteTreeLevel=-1; 
	private static float initTargetCount=-1;
	private static int initTime; //initial time
	
	private static int counter = 0;
	
	private float probKillCount;
	
	private int id;
	
	//fuzzy-presence (its not active/or killed -> has prob)
	//must not contain null
	private List<MyObject> targets = new LinkedList<MyObject>();;
	
	
	//all active bullets, ordered by time
	private TreeSet<FireSolution> bullets = new TreeSet<FireSolution>();
	
	//preceding state
	private GameState parent = null;
	
	//contains ship and time! will be added to bullets if the next state is created
	private FireSolution stateCreator = null;
	
	
	

	private void setID(){id = counter++;}
	private int getID(){return id;}
	
	/**
	 * Init - Konstruktor - use only once, creates root node in the start-case
	 * 
	 * @param targets
	 */
	private GameState(MyShip myShip,MySaucer mySaucer, List<MyAsteroid> myAsteroids, TreeSet<FireSolution> pendingFS)
	{
		
		
		setID();
		//startcase, dummy firesolution
		stateCreator = new FireSolution(myShip,null);

		probKillCount = 0;

		
		if(mySaucer!=null) 
			targets.add(mySaucer);
		
		for(MyAsteroid a:myAsteroids)
			targets.add((MyObject)a);
	
		
		int killC=0;
		int replC=0;
		int errC=0;
		//zerstre die targets in zeitlicher reihenfolge
		for(FireSolution f:pendingFS)
		{

			//replace unkilled target by a killed one incl. childs
			if (killTarget(f))
			{
//				killC++;
//				
//				MyObject t = f.getTarget();
//				
//				//if saucer -> dann kein ersetzen
//				if (t instanceof MySaucer) {
////					logger.debug("sauc not kill, error");
//					continue;
//				}
//				
//				MyAsteroid p = (MyAsteroid) (((MyAsteroid) t).getParent());
//				
//				//is not a child, nothing to do
//				if (p==null)
//				{
//					//logger.debug("error");
//					continue;
//				}
//				
//				MyAsteroid oo=null;
//				for(MyObject o:targets)
//					if (o instanceof MyAsteroid) 
//					{
//						oo = (MyAsteroid) o;
//						// kind mit gleichem parent?
//						if (oo.getParent()!=null &&
//								oo.getParent().getId()==p.getId())
//							break;
//					}
//				
//				if (oo==null)
//				{
//					logger.warn("corresponding Child not found!");
//					errC++;
//					continue;
//				}
//				
//				//ersetze das kind durch das alte
//				targets.remove((MyObject)oo);
//				targets.add(t);
//				replC++;
//				logger.debug("replacing child "+t+"  by  "+oo);
			
				logger.warn("killed init target "+ f.getTarget().getId());
				
			}else
			{
				logger.warn("couldnt Kill target! "+f.getTarget());
				//killTarget(f);
			}
			
			bullets.add(f);
		}
		
		if (pendingFS!=null && pendingFS.size()!=0)
			logger.debug("pendingFS(tot="+pendingFS.size()+",added"+bullets.size()+"): replacedChilds="+replC+" killedAst="+killC+" replErr="+errC);

		
		//problem elternFS_targetID != reale target ID, weil auch auf nichtexistierende kinder geschossen werden kann / oder targets schon tot sind
		//-nicht targets veraenndern!
		//erzeuge kinder
		//toete eltern
		//fuege hinz
		
		//achtung, es gibt fS_targets, die nichtexistierende kinder sind!
		//	- nimm diese einfach als kinder an, falls sie nicht
		//    in targets zu finden sind, erzeuge neue kinder
		
	}

	

	
	//copy constructor (shallow copy!) 
	private GameState(GameState g)
	{
		parent = g.parent;
		targets.addAll(g.targets);
		bullets.addAll(g.bullets);
		stateCreator = g.stateCreator;
		id = g.id;
		probKillCount = g.probKillCount;
	}

	
	/**
	 * Computes all possible GameStates from the 
	 * current GameState
	 * and inserts them in the given sorted list
	 * 
	 * @param nextList	pending (unchecked) next gamestateList
	 */
	private void generateNextPossibleGameStates(
			TreeSet<GameState> nextList)
	{

		int ct = getCurrentTime();
		
		
		//get a firesolution for each asteroid and evolve gamestate accordingly
		TreeSet<GameState> tmpGS = new TreeSet<GameState>();
		GameState tmp;
		FireSolution tmpFS;
		
		
		int es = getEarliestShotTime();
		if (es!=ct)
			logger.debug("getEarliestShotTime()="+es+"  ct="+ct);

		
		
		//remove dead targets TODO: or killed 
		int i1=0;
		MyObject tmpo;
		for(int i=0;i<targets.size();i++)
		{
			tmpo = targets.get(i); 
			if (!tmpo.willBeAliveAndCetrainAfter(ct) || getLastKillScore(tmpo.getId())>0)
			{
				i1++;
				logger.debug("removing:"+tmpo);
				targets.remove(tmpo);
				
			}
		}
		logger.debug("Removed "+i1+" dead Targets(time="+ct+").");

		//remove past bullets
		updateBulletList();
		

		
		for(MyObject a:targets)
		{
			
			//compute firesolution
			tmpFS = stateCreator.getFireState().getFireSolution(a,true,1d,es);
			
			//valid?
			if (tmpFS==null)
			{
				//logger.debug("ERROR: no FS for "+a);
				continue; 
			}
			
			//create gamestate
			tmp = generateNewGameState(tmpFS);

		
			//check validity & add
			if(tmp!=null) 
			{
				tmpGS.add(tmp);
//				logger.debug("("+this.getID()+")got "+tmp);
			} else
			{
				logger.debug("ERROR: not gamestate for "+a);
			}
		}
		
		
		logger.debug("Adding "+tmpGS.size()+" Gamestates to list");
		//insert all gamestates into the sorted list of valid gamestates
		nextList.addAll(tmpGS);

	}
	
	
	
	
	private static void removeBadGameStates(TreeSet<GameState> gsList)
	{

		//discard bad gamestates (best alternative path)

		//get best current gamestate
		GameState bestState = null;
		MyObject currTarget; //current target
		FireSolution bestFS; //alternative Firesolution
		GameState g;
		int bestTime;  
		//states to be deleted
		List<GameState> bad = new LinkedList<GameState>();

		Iterator<GameState> gsListIter = gsList.descendingIterator();
		
		//check all solutions
		while(gsListIter.hasNext())
		{
			g = gsListIter.next();
			
			//remove uncertain states
			if (g.getUncertainty()<MINGAMESTATEUNCERTAINTY)
			{
				bad.add(g);
				logger.debug("remove GameState: too uncertain "+g);
				continue;
			}
			
			//store best state
			if (bestState==null)
			{
				bestState = g;
				continue;
			}

			currTarget = g.getLastKilledAsteroid();

			//kill current asteroid in the best state
			bestFS = bestState.stateCreator.getFireState().getFireSolution(currTarget); 

			//if there is a fire-solution
			if (bestFS!=null)
			{
				//compute additional rotational time after firing in best state
				//rottime = bestFS.getFireState().getTurnTime(g.stateCreator.getFireState().angleIndexByte); 

				bestTime = bestFS.getFireTime(); //+rottime;

				//if best can kill in less time remove gamestate 
				if (bestTime<=g.getCurrentTime())
				{
					logger.debug("remove state(tb"+bestTime+"<"+g.getCurrentTime()+"tc) "+g+" best:"+bestState);
					bad.add(g);
				}
			}
			else
			{
				logger.debug("could not finde FireSolution from Beststate "+bestState+" for "+currTarget);
			}


		}
		logger.warn("Remove "+bad.size()+"/"+gsList.size()+" bad Score Asteroids,   best:"+bestState);
		//entferne die schlechten aus liste
		gsList.removeAll(bad);
	}

	//uncertain and maxwidth
	private static void removeBadGameStatesFixed(TreeSet<GameState> gsList)
	{

		 
		int maxWidth = maxTreeWidth;
		GameState g;
		//states to be deleted
		List<GameState> bad = new LinkedList<GameState>();

		Iterator<GameState> gsListIter = gsList.descendingIterator();
		
		//check all solutions
		while(gsListIter.hasNext())
		{
			
			g = gsListIter.next();
			
			//remove uncertain states
			if (g.getUncertainty()<MINGAMESTATEUNCERTAINTY ||
					maxWidth--<=0)
			{
				bad.add(g); //will be removed separately
				//logger.debug("remove "+g);
			} 
		
		}
			
		
		logger.debug("Remove "+bad.size()+" of "+gsList.size()+" GameStates");
		//entferne die schlechten aus liste
		gsList.removeAll(bad);
		

		
	}
	
	private int getCurrentTime(){
		return stateCreator.getFireTime();}
	
	private MyObject getLastKilledAsteroid(){
		return stateCreator.getTarget();}

	/**
	 * Checks the number of bullets, so that fireTime can be
	 * executed.
	 *  
	 * @param fireTime		FireSolution to be executed
	 * @return				True if FireSolution-execution 
	 * 						will not exceed the max bullet count.
	 */
	private boolean checkBulletCountFor(FireSolution fs)
	{
		if (bullets.size()==0) return true;
		
		int count = 0;
		int time = fs.getFireTime();
		int ft=Integer.MIN_VALUE;
		
		//count number of active bullets at time
		for(FireSolution f:bullets)  
		{
			
			//must be at least 2 frames apart
			if (Math.abs(f.getFireTime()-ft)<2)
			{
				logger.debug("bullets to close: "+fs+"    "+f);
				return false;
			}
			
			
			ft = f.getFireTime();
			
			//count bullet
			if (f.willEndConsistentlyAfter(time) &&
				ft<time)
				count++;
			
//			//must be at least 2 frames apart
//			if (Math.abs(fs.getFireTime()-f.getFireTime())<2)
//			{
//			}
		}
		
		return count<MyShip.MAXBULLETS;
	}
	
	private int getEarliestShotTime()
	{
		//no limit
		if (bullets.size()<MyShip.MAXBULLETS) 
			return getCurrentTime();

		//gehe MyShip.MAXBULLETS zurck in der sortierten liste
		
		FireSolution f=null;
		Iterator<FireSolution> dec = bullets.descendingIterator();
		StringBuffer b = new StringBuffer("Bullets at(ct="+getCurrentTime()+"):");
		
		for(int j=0;j<MyShip.MAXBULLETS && dec.hasNext();j++)
		{
			f = dec.next();
			b.append("st="+f.getFireTime()+"->ht="+f.getHitTimeInner()+"(A"+f.getTarget().getId()+") ");

		}
		logger.debug(b.toString()+ " earliestShottime="+f.getHitTimeInner());
			
		return f.getHitTimeInner();
	}
	
	
	/**
	 * Generates a NEW gameStateObject, which did execute 
	 * the given FireSolution and moved forward in time 
	 * to FireTime.
	 * 
	 * @param f		FireSolution to be executed. (can be null or invalid or violate bulletnumberlimit -> in these cases null will be returned
	 * @return		Gamestate in which the target is killed.
	 * 				Returns null if gamestate 
	 * 					f = null or invalid
	 * 					too much bullets on the way,
	 * 					new gamestate is too uncertain, 
	 * 					ship is hit (collision),
	 */
	private GameState generateNewGameState(FireSolution f)
	{
		//not valid firesolution
		if (f==null ||
		   !f.canBeExecuted(stateCreator.getFireState()))
		{
			logger.debug("could not generate new gamestate:"+f);
			return null;
		}
		

		//generate next state (as a child of this one)
		GameState g = new GameState(this);

		//set id
		g.setID();
		
		//make this parent
		g.parent = this; 

		//set creation event & new state time
		g.stateCreator=f;
		
		
		//replace unkilled target by a killed one incl. childs
		if (!g.killTarget(f))
		{
			logger.debug("ERROR: could not kill "+f);
			return null;
		}
		
		//add to active bullets
		g.bullets.add(f);

		
		//move ship forward in time by checking collision with ship
		float shipHitProb = g.getShipCollisionProb(getCurrentTime());

		//logger.fatal("p(hit, t="+getCurrentTime()+".."+g.getCurrentTime()+", A"+f.getTarget().getId()+")="+shipHitProb+"  node:"+g);
		
		
		if (shipHitProb>ALLOWEDSHIPHITPROBABILITY)
		{
			logger.fatal("p(hit, t="+getCurrentTime()+".."+g.getCurrentTime()+", A"+f.getTarget().getId()+")="+shipHitProb+"  node:"+g);
			return null;
		}
		

		return g;
	}
	
	/**
	 * Replaces target in 
	 * targets by a killed one. replaces children if necessary
	 *  
	 * @param fs
	 */
	private boolean killTarget(FireSolution fs)
	{
		//too much bullets in the air
		if (!checkBulletCountFor(fs))
		{
			logger.debug("Cannot kill target"+fs.getTarget().getId()+": too much/close bullets   "+bullets);
			return false;
		}
		
		//do not use: not can be executed!
		if (!fs.isConsistent())
		{
			logger.warn("FS cannot be executed"+ fs);
			return false;
		}
		
		//get doomed Object
		MyObject killed = fs.getTarget();
		
		if (!targets.contains(killed))
		{
			//frher getroffen, oder auf kind geschossen
			logger.debug("Target not contained in targetlist, kannot kill!");
			return false;
		}
		
		MyAsteroid child;
		boolean debug1=false;
		
		//clone & kill & add object to list (cloning because objects are changed) 
		if (killed instanceof MySaucer)
		{

			MySaucer s = (MySaucer)killed;
			//clone old
			s = new MySaucer(s);
			//kill saucer
			if (!s.killObject(fs))
			{
				logger.debug("Cannot kill target"+fs.getTarget().getId()+": firesolution not valid,");
				return false;
			}
			
			//replace
			targets.remove(killed); //because killed will be changed!
			targets.add(s); 

			debug1=true;
		} 
		
		//clone & kill & add object to list (cloning because objects are changed) 
		if (killed instanceof MyAsteroid)
		{

			MyAsteroid a = (MyAsteroid) killed;
			
			
			//clone Asteroid
			a = new MyAsteroid(a);
		
			//kill Asteroid
			if (!a.killObject(fs)) 
			{
				logger.debug("Cannot kill target"+fs.getTarget().getId()+": firesolution not valid,");
				return false;
			}
			//a.setNewID();

			//remove OLD children from list (for multiple shots) 
			//		remove them after remove because it could fail
			//	not necessary, if only fired once on one asteroid -> no TODO
	
			targets.remove(killed); //because killed will be changed!
			targets.add(a);

			//add new children
			child = a.makeChild(fs,false);
			if (child!=null)
			{
				targets.add(child);
				child = a.makeChild(fs,false);
				if (child!=null) targets.add(child);
				else logger.warn("aahh");
			}
			

			
			
			
			debug1=true;

		} 
	
		
		
		if (!debug1)
		{
			logger.warn("Error, could not kill: "+killed);
			return false;
		}

		
		
//		if (parent==null)
//		{
//			//war noch nie abgeschossen
//			probKillCount+=fs.getHitProbability();
//			
//		}else
//		{
//			 //schaut, ob er schon mal gettet wurde und zieht den letzten score ab
//			probKillCount+=fs.getHitProbability()-parent.getLastKillScore(killed.getId());
//			
//		}
		probKillCount+=fs.getHitProbability();
		
		
		return true;
		
	}
	
	private float getLastKillScore(int id) 
	{
		if (parent==null) return 0f;
		if (stateCreator.getTarget().getId()==id) return stateCreator.getHitProbability();
		return parent.getLastKillScore(id); 
	}
	
	/**
	 * Asumes, that the bullets are dead at hittime.
	 */
	private void updateBulletList()
	{
		int t = getCurrentTime(); 
		
		TreeSet<FireSolution> n = new TreeSet<FireSolution>();
		
		//update bullet list
		for(FireSolution fs:bullets)
			if (fs.willEndConsistentlyAfter(t))
				n.add(fs);
		
		bullets = n;
	}
	
	
	/**
	 * Checks, if there is a collision with the ship, up to the
	 * current time with the targets. (and after timeFrom)
	 * 
	 * @return probability, that the ship collides with the targets
	 * 			within the given time intervall.
	 */
	public float getShipCollisionProb(int timeStart)
	{
	
		int timeEnd = getCurrentTime();
		
		MyShip s = stateCreator.getFireState();
		Collision c;
		float notHitProb = 1;
		int hitCount=0;
		
		
		for(MyObject tt:targets)
		{
			c = new Collision(s,tt);
			
			
			if (c.willOccurBefore(timeEnd))
			{
				//TODO: er bekommt fr abgeschossene die selbe hitprob!
				logger.warn("*collision at "+c.getHitTimeInner()+" with "+tt+"    col:"+c);
				if (stateCreator.getTarget().getId()==tt.getId())
				{
					logger.warn("id"+tt.getId());
					killTarget(new FireSolution(stateCreator.getFireState(),tt));
					c = s.getCollisionWith(tt,timeStart,timeEnd);
					
				}
						
				notHitProb*=(1-c.getHitProbability());
				hitCount++;
			}else
			{
//				logger.debug("no collision (from "+timeStart+" to "+timeEnd+") with "+tt);
			}
		}
		
		return 1-notHitProb;
	}
	
	

	
	
	/**
	 * Initialize the GameState-tree and resets all lists.
	 * Aktualisiert Root (falls gegeben) mit den 
	 * 
	 * @param root		Start Gamestate
	 */
	public static void initGameStateTree(MyShip myShip,MySaucer mySaucer, List<MyAsteroid> myAsteroids,TreeSet<FireSolution> pendingFS, GameState root)
	{

		if (root==null || (!root.stateCreator.canBeExecuted(myShip)))
		{
			counter=0;
			if (root!=null && !root.stateCreator.canBeExecuted(myShip))
				logger.warn("state creator cannot be executed "+root+ "  "+ root.stateCreator);
			root = new GameState(myShip,mySaucer,myAsteroids,pendingFS);

		}else
		{
			//add to be executed fs
			pendingFS.add(root.stateCreator);
			//add new time and ship angle
			myShip = root.stateCreator.getFireState();
			
			FireSolution oldStateCreator = root.stateCreator;
			//create new root
			root = new GameState(myShip,mySaucer,myAsteroids,pendingFS);
			root.stateCreator = oldStateCreator;
			
			if (root.bullets.size()==0)
				logger.warn("Warning, rootstate has 0 bullets! "+root+"   stateCreator:"+oldStateCreator);
			if (!oldStateCreator.willEndConsistentlyAfter(myShip.getCurrentTime()))
				logger.warn("Warning, statecreator not valid in "+root+"   stateCreator:"+oldStateCreator);
		}

		// create linked lists for each depth
		tree = new ArrayList<TreeSet<GameState>>((int)Math.ceil(root.getProbTargetCount())+1);

		//init root-level
		tree.add(0, new TreeSet<GameState>());
		tree.get(0).add(root);

		
		lastCompleteTreeLevel=0;

		initTargetCount = root.getProbTargetCount()+1; //+1 is necessary (so no equal elements occur)!
		initTime = root.getCurrentTime()-1; //-1 damit keine Infinities auftreten
		
		logger.debug("initTargetCount("+root.targets.size()+"):"+initTargetCount+"   "+root.targets);
	}
	
	
	private float getProbTargetCount()
	{
		float c=0;
		int t = getCurrentTime();
		MyAsteroid b;
		
		for(MyObject a:targets)
			{
				if (!a.willBeAliveAndCetrainAfter(t))
				{
					//kann am anfang auftreten, wenn die bewegung noch nicht klar ist
					logger.warn("error("+t+"):"+a+"     "+targets);
					a.willBeAliveAndCetrainAfter(t);
					continue;
				}
				
				if (a instanceof MySaucer) {
					c+=a.getPositionProbability(t);
					continue;
				}
				
				if (a instanceof MyAsteroid) {
					b = (MyAsteroid) a;

					if (b.getParent()==null)
					{
						switch(b.getGroesseID())
						{
							case 1: c+=a.getPositionProbability(t); continue;
							case 2: c+=a.getPositionProbability(t)+2; continue;
							case 3: c+=a.getPositionProbability(t)+6; continue;
							default: logger.warn("error");
						} 
					} else
					{
						switch(b.getGroesseID())
						{
						case 1: c+=a.getPositionProbability(t)-1; continue;
						case 2: c+=a.getPositionProbability(t)-1; continue;
						case 3: c+=a.getPositionProbability(t)-1; continue;
						default: logger.warn("error");
						}
					}
				}
			}
		return c;
				
		
	}
	
	public int getNumberOfInvalidTargetsAt()
	{
		int t=getCurrentTime();
		int count=0;
		for(MyObject a:targets)
			if (!a.willBeAliveAndCetrainAfter(t))
			{
				count++;
				logger.warn("error("+t+"):"+a+"     "+targets);
				a.willBeAliveAndCetrainAfter(t);
			}
		return count;

	}
	
	/**
	 * Extends the gamestate-tree with another numOfGameStates
	 * nodes. (the tree must be initialized prior to update)
	 * 
	 * @param incTreeLevel	number of nodes to add to the gamestate tree
	 */
	public static void extendGameStateTree(int incTreeLevel)
	{
		//next incomplete tree level height
		
		logger.debug("Extending Tree by "+incTreeLevel+"(currLevel)="+lastCompleteTreeLevel);
		int nl; 

		//current node index
		int cni;
		
		
		GameState g;
		TreeSet<GameState> toBeContinued;
		Iterator<GameState> sourceStates;
		
		StringBuffer out = new StringBuffer("TREE:");
		
		for(int i=0;i<lastCompleteTreeLevel;i++)
			out.append("["+tree.get(i).size()+"]");

		//add nodes
		while (0<incTreeLevel--)
		{
			nl = lastCompleteTreeLevel+1;
			
			out.append("["+tree.get(nl-1).size()+"]");
			//lazy init
			if (tree.size()<=nl)
				tree.add(nl, new TreeSet<GameState>());
			
			//tree level to be filled
			toBeContinued = tree.get(nl);
			
			//tree level which is filled 
			sourceStates = tree.get(nl-1).iterator();
			
			
			cni=0;//debug
			
			//iterate over old gamestates 
			while(sourceStates.hasNext())
			{
				g = sourceStates.next();

//				logger.debug("lost childs: "+g.getLostChildCount()+"  in  "+g);
				//g.updateLostChilds();
				
				g.generateNextPossibleGameStates(toBeContinued);

//				logger.debug("lost childse: "+g.getLostChildCount()+"  in  "+g);
				
				logger.debug(out+"{"+(cni+1)+"/"+(tree.get(nl-1).size())+"}");
				cni++;
			}
			
			if (toBeContinued.size()==0) break;

			removeBadGameStatesFixed(toBeContinued);
			lastCompleteTreeLevel=nl;
		}
		


	}
	
	public static String getGameTreeStats()
	{
		StringBuffer b = new StringBuffer("TREE:");
		
		for(int i=0;i<tree.size();i++)
			b.append("["+tree.get(i).size()+"]");
		
		GameState g = getBestCurrentGameState();
		if (g==null)
		{
			b.append(" best: "+g);
		}else
		{
			b.append(" best(R"+g.getParentOnLevel(0).getID()+"): "+g);
		}
		
		
		
		return b.toString();
		
	}

	/**
	 * Returns the i-th parent
	 * @param i	absolute height of the tree (i=0 = root)
	 * @return Parent on absoute tree level i
	 */
	public GameState getParentOnLevel(int i) 
	{
		int h = getCurrentNodeHeight();
		
		if (h<i)
		{
			logger.warn("parent cannot be returned: "+h+" "+i);
			return null;
		}
		
		GameState p=this;
		
		while(h-->i) p = p.parent;
		
		return p;
	}
	
	private int getCurrentNodeHeight()
	{
		GameState c = this;
		int h=0;
		
		while(c.parent!=null) 
		{
			c = c.parent;
			h++;
		}
		return h;
	}

	
 
	
	public static GameState getBestCurrentGameState()
	{
		//tree not inited yet
		if (lastCompleteTreeLevel==-1)
		{
			logger.debug("tree not inited! abort");
			return null;
		}
		if (lastCompleteTreeLevel==0)
		{
			logger.debug("root is not a valid BestState");
			return null;
		}
		if (tree.get(lastCompleteTreeLevel).size()==0)
		{
			logger.warn("tree inconsistent"+ lastCompleteTreeLevel);
			return null;
		}
		
		return tree.get(lastCompleteTreeLevel).last();
		
	}
	
	//deletes all nodes in the tree, which dont have the grandparent newRoot
	//shifts all too the left
	public static void setNewTreeRoot(GameState newRoot)
	{
		if (!tree.get(1).contains(newRoot))
		{
			logger.debug("new root not on level 1");
			return;
		}
		
		
		//logger.warn("old tree"+GameState.getGameTreeStats());
		//set as root node
		newRoot.parent=null;
		
		//set new root
		tree.set(0,new TreeSet<GameState>());
		tree.get(0).add(newRoot);
		
		//remove all nodes which dont have the root node
		//and shifting them left
		TreeSet<GameState> dest;
		
		for(int i=2;i<tree.size();i++)
		{
			dest = new TreeSet<GameState>();
			
			for(GameState g:tree.get(i))
				if (g.hasTheRoot(newRoot))
					dest.add(g);
			
			tree.set(i-1,dest);
			
		}
		tree.set(tree.size()-1,new TreeSet<GameState>());
		
		
		//set global vars
		lastCompleteTreeLevel--;

		initTargetCount = newRoot.getProbTargetCount()+1; //+1 is necessary (so no equal elements occur)!
		initTime = newRoot.getCurrentTime();
		
		if (tree.get(lastCompleteTreeLevel).size()==0){
			logger.warn("Error:setting new treelevel: "+lastCompleteTreeLevel+" - with size:"+tree.get(lastCompleteTreeLevel).size()+" (oldsize="+tree.get(lastCompleteTreeLevel+1).size()+")");
			logger.warn("new tree"+GameState.getGameTreeStats());
		}
		
		logger.debug("root: given "+newRoot.getID()+" set:"+tree.get(0).last().getID()+" roosize="+tree.get(0).size());
	

		
	}
	
	public static Stack<GameState> getBestCurrentExecutionQueue()
	{
		Stack<GameState> queue = new Stack<GameState>();
		
		GameState g = getBestCurrentGameState();
		if (g==null)
		{
			logger.debug("no best current gamestate ");
			return queue;
		}
		
		while(g.parent!=null) 
		{
			queue.push(g);
			g = g.parent;
		}
		return queue;
	}
	
	private final boolean isRoot(){return parent==null;}
	/**
	 * Compares two GameStates wrt efficiency of killing
	 * targets. That means it compares the number of killed
	 * Objects per frame of each GameState.
	 * 
	 *  @return -1 if this GameState is not as efficient as the other
	 *  		0 if  this GameState is as efficient as the other
	 *   		1 if this GameState is more efficient as the other
	 */
	@Override
	public int compareTo(GameState arg0) 
	{
		//this always better than null
		if (arg0==null) return 1; 
		//if they are the same (id's are always different)
		if (this==arg0 || this.getID()==arg0.getID()) return 0;
		
		//score this
		float s1 = getScore();
		//score arg0
		float s2 = arg0.getScore();
		
//		if (s1==s2)
//		{
//				logger.warn("ERROR, same score!:"+this.getID()+"    "+arg0.getID());
//				return 1;
//		}
		
		return s1<s2 ? -1 : 1; 
	}
	
	/**
	 * @return  The better the GameState,
	 * 			 the higher the score.
	 * 			i.e. Number Of killed objects / frame
	 */
	public final float getScore()
	{
		return probKillCount/(getCurrentTime()-initTime);
	}
	/**
	 * Uses {@link #compareTo(GameState)} for comparison.
	 * @return true, if the current GameState was 
	 * as efficient as the other in killing targets.
	 */
	@Override
	public boolean equals(Object obj) {
		
		if (this == obj) return true;
		
		if (obj == null) return false;
		
		if (obj instanceof GameState) 
		{
			return compareTo((GameState) obj)==0;
		} 
		else
		{
			return false;
		}

	}
	

	/**
	 * Computes the mean of all uncertainties of all targets.
	 * @return	0..1 (0=very certain, 1 = very uncertain)  
	 * 		
	 */
	private float getUncertainty()
	{
		float u=0;
		int t = getCurrentTime();
		
		for(MyObject o:targets)
			u+=o.getUncertainty(t);
		 
		return u/targets.size();
	}
	
	public void draw(Graphics2D g)
	{
		if (isRoot()) return;

		g.setColor(COLOR);

		int invTreeHeight=0; //root hat hoehe 0
		GameState d = this;
		Position p1=null;
		Position p2=null;
		
		
		while(!d.isRoot())
		{
			
			p2 = d.stateCreator.getTarget().estimatePosition(
					d.stateCreator.getHitTimeInner());
			
			if (p2!=null && p1!=null)
			{
				g.drawLine(p1.getXforDrawing(), 
						p1.getYforDrawing(),
						p2.getXforDrawing(),
						p2.getYforDrawing());
			}
			if (p2!=null)
			{
				g.drawString(""+d.stateCreator.getTarget().getId()+"("+(lastCompleteTreeLevel-invTreeHeight)+")",
						p2.getXforDrawing()+5, 
						p2.getYforDrawing()+5);
				//draw score
				if (invTreeHeight==0)

					g.drawString("S:"+getScore()+"["+(probKillCount)+"/"+(getCurrentTime()-initTime)+"]",
							p2.getXforDrawing()-5, 
							p2.getYforDrawing()-5);
					
			}
			
			p1=p2;
			d = d.parent;
			invTreeHeight++;
			
		}
		g.drawString("T",
				p2.getXforDrawing()-5, 
				p2.getYforDrawing()+5);

		
	}

	
	public static TreeSet<GameState> getTreeLevel(int i)
	{
		if (i<0) return null;
		if (tree==null || i>=tree.size()) return null;
		return tree.get(i);
	}

	
	@Override
	public String toString()
	{
		StringBuffer f = new StringBuffer(""+id+"_GameState[");
		
		f.append("score="+getScore()+", ");
		f.append("time="+getCurrentTime()+", ");
		f.append("#kill="+probKillCount+", ");
		if (targets!=null) f.append("t#="+targets.size()+", ");
		if (bullets!=null) f.append("b#="+bullets.size()+", ");
		f.append(toStringKillOrder());
		f.append("]");
		
		return f.toString();
	}
	
	private String toStringKillOrder()
	{
		int id = this.stateCreator.getTarget()==null?-1:this.stateCreator.getTarget().getId();
		if (parent==null) return "ROOT"+this.getID()+"(A"+id+") ";
		return parent.toStringKillOrder() +"-> "+this.getID()+"(A"+id+") ";
	}
	
	public FireSolution getStateCreator()
	{
		return stateCreator;
	}
	
	public static int getCurrentBestLevel()
	{
		return lastCompleteTreeLevel;
	}
	
	
	
	private boolean hasTheRoot(GameState g)
	{
		if (parent==null) return false;
		if (parent.getID()==g.getID()) return true;
		return parent.hasTheRoot(g);
	}
	
	public TreeSet<FireSolution> getBullets()
	{
		return bullets;
	}

}

