package hek.de.hinni.hek.asteroids;

import java.awt.Color;
import java.awt.Graphics2D;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

import org.apache.log4j.Logger;

//1.emulator neu starten (start winkel 0)
//2.player starten
//3.bei tod einfach spiel erneut starten
//4.java wird beendet, wenn fertig
//ausgabe: bullet bei schusszeit+2: "{dx,dy,posx,posy},"
public class WinkelMessung extends Strategie {
	
	private static final Logger logger = Logger.getLogger(WinkelMessung.class);
	
	private int currAngle=0;
	private Shot firstMeasurement;
	private int firstMeasurementTime;
	private int firstMeasurementAngle;
	private int fireTime;
	private boolean measurementComplete = true;
	private boolean clearShots = false;
	private int lastFrameNumber = -1;
	private LinkedList<MyShot> l = new LinkedList<MyShot>();
	private int currentTime;
	private double lastAngle=0;
	private FileOutputStream fos;
	private BufferedOutputStream bos;
	private static int NUMBEROFMEASUREMENTFRAMES = 32; // durch 8 teilbar!
	private String outFile = "."+File.separator+"shotAngles.txt";
	private boolean gefeuert=false;
	
	private static final int max = 259;
	private int[][] data = new int[max][6];

	public WinkelMessung(){
		
		
		FileOutputStream fos;
		
		byte[] b;
		try { // bergebene Dateien ffnen
		fos = new FileOutputStream(outFile);
		} catch (FileNotFoundException ex) {
		throw new Error("File not found");
		}
		// Dateien umlenken auf Puffer
		bos = new BufferedOutputStream(fos);
	}
	
	
	public TastenTyp getEingabe(WorldObjects objects, StatusFlags status, int aktTick) {
		
		currentTime = aktTick;
		
		
		List<Shot> currShots = World.gameStatus.shots;
		
		int time = World.getTick();
	
		if (lastFrameNumber+1!=time && lastFrameNumber!=-1)
		{
			System.out.println("frame-lost(last="+lastFrameNumber+", current="+time);
			lastFrameNumber=time;
			//System.exit(0);
		}
		
		
		//System.out.println("time="+time);
		
		//if (time%2==1) 
		//	return TastenTyp.NICHTS;

		
		
		if (status.ueberpruefe(StatusFlags.SAUCER_EXISTS))
		{
			clearShots = true;
			World.keys.clear();
			return TastenTyp.NICHTS;
		}
		
		if (clearShots && !currShots.isEmpty())
		{
			World.keys.clear();
			return TastenTyp.NICHTS;
		}

		if (!status.ueberpruefe(StatusFlags.ASTEROIDS_EXIST))
		{
			World.keys.restart(true);
			return TastenTyp.NEUSTART;
		}
	
		if (!status.ueberpruefe(StatusFlags.SHIP_EXISTS))
		{
			
			World.keys.restart(true);
			return TastenTyp.NEUSTART;
		}


		//finished
		if (currAngle==max)
		{
			String s = ""+(max-1)+" done(time="+time+") - last "+(max-256)+" entrys are (debug)duplicates -> remove";
			
			//schreibe in text datei
			try { 
				bos.write(s.getBytes());
				bos.close();
			} catch (IOException e) {
				System.out.println("konnte winkel nicht in datei schreiben!");
			}
			System.out.println(s);
			
			System.exit(0);
			return TastenTyp.NICHTS;
		}

	
		
		
		
		//beginne neue iteration
		if (currShots.isEmpty())
		{
			if (gefeuert) 
				{ 			
				World.keys.clear();
				return TastenTyp.NICHTS;
				}
			gefeuert = true;

			fireTime = time;
			
			//clean up for measurement
			firstMeasurement = null;
			firstMeasurementTime =-100;
			
			clearShots = false;
			
			World.keys.fire(true);
			return TastenTyp.FEUER;
			
		} else
		{
			gefeuert = false;
			
			//zeiche erste position auf
			if (firstMeasurement==null)
			{
				firstMeasurement=currShots.iterator().next();
				firstMeasurementTime = time;
				
				World.keys.clear();
				return TastenTyp.NICHTS;
			}

			//wenn g�ltige messung -> ausgabe;
			if (firstMeasurementTime+NUMBEROFMEASUREMENTFRAMES==time) 
			{
				Shot lastMeasurement = currShots.iterator().next();

				int dt = NUMBEROFMEASUREMENTFRAMES/8;
				int ft = fireTime - firstMeasurementTime;

				if (ft!=-2) 
				{
					System.out.println("error, ft was "+ft);
					//System.exit(0);
					
				}
				
				int dx = (lastMeasurement.getX() - firstMeasurement.getX())/dt;
				int dy = (lastMeasurement.getY() - firstMeasurement.getY())/dt;

				//logger.debug(" dx/dt="+(lastMeasurement.getX() - firstMeasurement.getX())+"/"+dt+"   dy/dt="+(lastMeasurement.getY() - firstMeasurement.getY())+"/"+dt);
				
				double dx_double= ((double)(lastMeasurement.getX() - firstMeasurement.getX()))/(double)dt;
				double dy_double= ((double)(lastMeasurement.getY() - firstMeasurement.getY()))/(double)dt;

				if (((double)dx)!=dx_double)
				{
					logger.warn("fehler: dx="+dx+" dx_double="+dx_double);
				}
				
				if (((double)dy)!=dy_double)
				{
					logger.warn("fehler: dy="+dx+" dy_double="+dx_double);
				}

				int shipx = World.gameStatus.ship.getX();
				int shipy = World.gameStatus.ship.getY();
				
				//relative to ship position
				int px = firstMeasurement.getX()-shipx;
				int py = firstMeasurement.getY()-shipy;

				px*=Position.FAKTOR;
				py*=Position.FAKTOR;

				
				data[currAngle][0]=dx;
				data[currAngle][1]=dy;
				data[currAngle][2]=px;
				data[currAngle][3]=py;
				data[currAngle][4]=dt;
				
				
				double angle = Math.atan2(dy,dx);
				String s= "{"+dx+","+dy+","+px+","+py+","+World.gameStatus.ship.orientation.getX()+","+World.gameStatus.ship.orientation.getY()+"},\n";
				System.out.print(s);
				
				//schreibe in text datei
				try { bos.write(s.getBytes());		
				} catch (IOException e) {
					System.out.println("konnte winkel nicht in datei schreiben!");
				}
				
				//l.add(objects.getMyShip().shootNow());
				
				lastAngle=angle;
				clearShots=true;
				currAngle++;
				
				World.keys.left(true);
				return TastenTyp.LINKS;

			} 
		}
		//tue nix w�hrend und nach der messung
		World.keys.clear();
		return TastenTyp.NICHTS;


	}			
		
				
	public void draw(Graphics2D g)
	{
		if(true)return;
		int x1,y1,x2,y2;
		
		g.setColor(Color.green);
		
		for (int i=0;i<currAngle;i++)
		{
			
			x1 = (int)(data[i][0]*data[i][4]+data[i][2])+524;
			y1 = Position.screenSizeY-(int)(data[i][1]*data[i][4]+data[i][3]+524)+Position.offsetY;
			x2 = (int)(data[i][2])+524;
			y2 = Position.screenSizeY-(int)(data[i][3])-524+Position.offsetY;
			
			g.drawLine(x1,y1,x2,y2);
		}
	
		for(MyShot s:l)
		{
			s.estimatePosition(currentTime);
			s.draw(g);
		}
	}

		
	
}
